/*============================================================
File name: protect.h

Originator: XXW THU

Description: define the functions related with protection

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/

#ifndef _PROTECT_H_
#define _PROTECT_H_

#include "C28x_FPU_FastRTS.h"


struct FaultState_BITS  {        // bits   description
   Uint16 	OvervoltUdc:1;     // 0
   Uint16 	UndervoltUdc:1;   // 1
   Uint16 	OvercurIac:1;        // 2
   Uint16 	OvercurIdc:1;       // 3
   Uint16 	Overtemp1:1;          // 4
   Uint16 	Undertemp1:1;    		// 5
   Uint16 	Overtemp2:1;    		// 6
   Uint16 	Undertemp2:1;   	 // 7
   Uint16 	Faultstate:1;  	     // 8
   Uint16 	Null0:1; 				// 9
   Uint16 	Null1:1;   				// 10
   Uint16 	Null2:1; 				// 11
   Uint16 	Null3:1;  				// 12
   Uint16 	Null4:1;  				// 13
   Uint16 	Null5:1;  				// 14
   Uint16 	Null6:1;     			// 15
};

union FaultState_REGS{
   Uint16             all;
   struct FaultState_BITS bit;
};


typedef struct{
				float		Udc1;
				float		Udc2;
				float		Udcmax;
				float		Udcmin;
				float		Ia;
				float		Ib;
				float		Ic;
				float		Iu;
				float		Iv;
				float		Iw;
				float		Iacmax;
				float		Idc;
				float		Idcmax;
				float		Temp1_1;
				float		Temp1_2;
				float		Temp2;
				float		Temp1max;
				float		Temp1min;
				float		Temp2max;
				float		Temp2min;
				unsigned int	OverCURRENTAC_Count;
				unsigned int	OverCURRENTDC_Count;
				unsigned int	OverVOLTAGE_Count;
				unsigned int	UnderVOLTAGE_Count;
				unsigned int	OverTEMP1_Count;
				unsigned int	UnderTEMP1_Count;
				unsigned int	OverTEMP2_Count;
				unsigned int	UnderTEMP2_Count;
				unsigned int	OVERCURRENT_SHOOT;
				unsigned int	OVERVOLTAGE_SHOOT;
				unsigned int	OVERTEMP_SHOOT;
				unsigned int	Fault_Count;
				union	FaultState_REGS	FaultState;
				void	(*calc)();
}Protect;

typedef Protect  *Protect_handle;
/*-----------------------------------------------------------
Default initalizer for the Protect object
-----------------------------------------------------------*/
#define Protect_DEFAULTS {0,0,0,0,\
							0,0,0,0,0,0,0,0,0,\
							0,0,0,0,0,0,0,\
							0,0,0,0,0,0,0,0,0,0,0,0,\
							0x0000,\
							(void (*)(Uint32))Protect_calc }


void Protect_calc(Protect_handle);

#endif

//==============================================================
//End of file.
//==============================================================
