/*============================================================
File name: ADC_volt_current_get.c

Originator: XXW THU

Description: define the functions related with ADC

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/

#include "DSP28x_Project.h" 
#include "DSP2833x_Adc.h"
#include "C28x_FPU_FastRTS.h"
#include "math.h"
#include "float.h"
#include "ADC_volt_current_get.h"


#define ADC_CHANNELS 8
#define  PI    3.141592654
//ADݴ
#define gain_Udc1  1.66666667	//ADݴϵ1.66666667=5/3
#define gain_Udc2  1.66666667	//ADݴϵ
#define gain_Idc  1.66666667	//ADݴϵ
#define gain_Ia  1.66666667	//ADݴϵ
#define gain_Ib  1.66666667	//ADݴϵ
#define gain_Ic  1.66666667	//ADݴϵ
//#define gain_Iu  1.66666667	//ADݴϵ1.66666667=5/3
//#define gain_Iv  1.66666667	//ADݴϵ
//#define gain_Iw  1.66666667	//ADݴϵ
#define gain_ACCEL  1.66666667	//ADݴϵ
#define gain_BRAKE  1.66666667	//ADݴϵ
#define gain_TEMP1_1 1.66666667	//ADݴϵ
#define gain_TEMP1_2  1.66666667	//ADݴϵ
#define gain_TEMP2  1.66666667	//ADݴϵ
#define gain_VDC 7.5	//ADݴϵ
//#define gain_Ia  50	//ADݴϵ
//#define gain_Ib  50	//ADݴϵ
//#define gain_Ic  50	//ADݴϵ
#define gain_COS  1.339286	//ADݴϵ,1.5ƫ
#define gain_SIN  1.339286	//ADݴϵ,1.5ƫ

#define offset_Udc1  0	//ADݴƫ
#define offset_Udc2  -2.5	//ADݴƫ
#define offset_Idc  -2.5	//ADݴƫ
//#define offset_Ia  -2.5	//ADݴƫ
//#define offset_Ib  0	//ADݴƫ
//#define offset_Ic  0	//ADݴƫ
//#define offset_Iu  0	//ADݴƫ
//#define offset_Iv  -2.5	//ADݴƫ
//#define offset_Iw  -2.5	//ADݴƫ
#define offset_ACCEL  -2.5	//ADݴƫ
#define offset_BRAKE  0	//ADݴƫ
#define offset_TEMP1_1  0	//ADݴƫ
#define offset_TEMP1_2  0	//ADݴƫ
#define offset_TEMP2  0	//ADݴƫ
#define offset_VDC  0	//ADݴƫ
#define offset_Ia  0	//ADݴƫ
#define offset_Ib  0	//ADݴƫ
#define offset_Ic  0	//ADݴƫ
#define offset_COS  0	//ADݴƫ
#define offset_SIN  0	//ADݴƫ

#define offset_A0 0//ADƫ
#define offset_A1 1.225//ADƫ
#define offset_A2 1.225//ADƫ
#define offset_A3 1.225//ADƫ
#define offset_A4 1.225//ADƫ
#define offset_A5 1.225//ADƫ
#define offset_A6 1.225//ADƫ
#define offset_A7 0.025//ADƫ
#define offset_B0 0.025//ADƫ
#define offset_B1 0.020//ADƫ
#define offset_B2 0.015//ADƫ
#define offset_B3 0.030//ADƫ
#define offset_B4 0.020//ADƫ
#define offset_B5 0.020//ADƫ
#define offset_B6 0.017//ADƫ
#define offset_B7 0.035//ADƫ

volatile int i=0;
//volatile float buffer[5000];
#pragma CODE_SECTION(ADC_volt_current_get_Calc,"ramfuncs");

//======== Definations for functions ===========================
//**********************************
/*
  @ Description:
  @ Param
  @ Return
 */
//**********************************
void ADC_volt_current_get_Init()
{

    EALLOW;
#if (CPU_FRQ_150MHZ)     // Default - 150 MHz SYSCLKOUT
#define ADC_MODCLK 0x3 // HSPCLK = SYSCLKOUT/2*ADC_MODCLK2 = 150/(2*3)   = 25.0 MHz
#endif
#if (CPU_FRQ_100MHZ)
#define ADC_MODCLK 0x2 // HSPCLK = SYSCLKOUT/2*ADC_MODCLK2 = 100/(2*2)   = 25.0 MHz
#endif
    EDIS;

    InitAdc();//this function can be found in DSP2833x_Adc.c

    //configure ADC
    EALLOW;
    SysCtrlRegs.HISPCP.all = ADC_MODCLK;	// HSPCLK = SYSCLKOUT/ADC_MODCLK
    EDIS;

    AdcRegs.ADCTRL1.bit.ACQ_PS =0x1;//Ŀ
    AdcRegs.ADCTRL3.bit.ADCCLKPS = 0x0;//òòƵ

    AdcRegs.ADCMAXCONV.bit.MAX_CONV1= ADC_CHANNELS-1;       // Setup n+1 conv's on SEQ1
    AdcRegs.ADCTRL1.bit.SEQ_CASC = 1;          // 1  Cascaded mode; 0: depart mode
    AdcRegs.ADCTRL3.bit.SMODE_SEL = 0;   // ˳ģʽ
    AdcRegs.ADCTRL1.bit.CONT_RUN = 0;   // 0ͣģʽ1ģʽ
    AdcRegs.ADCTRL1.bit.SEQ_OVRD = 0;   // 0зǹܣ1
    AdcRegs.ADCTRL2.bit.RST_SEQ1=1;      //λSEQ1
    AdcRegs.ADCTRL2.bit.EPWM_SOCA_SEQ1 = 1;  // enable ePWMx_SOCA tigger signal
    AdcRegs.ADCTRL2.bit.INT_ENA_SEQ1=1;      //ʹSEQ1תж
    AdcRegs.ADCTRL2.bit.INT_MOD_SEQ1=0;  //SEQ1ÿתж1

    AdcRegs.ADCCHSELSEQ1.bit.CONV00=0x0;//ADCINA0
    AdcRegs.ADCCHSELSEQ1.bit.CONV01=0x1;//ADCINA1
    AdcRegs.ADCCHSELSEQ1.bit.CONV02=0x2;//ADCINA2
    AdcRegs.ADCCHSELSEQ1.bit.CONV03=0x3;//ADCINA3
    AdcRegs.ADCCHSELSEQ2.bit.CONV04=0x4;//ADCINA4
    AdcRegs.ADCCHSELSEQ2.bit.CONV05=0x5;//ADCINA5
    AdcRegs.ADCCHSELSEQ2.bit.CONV06=0x6;//ADCINA6
    AdcRegs.ADCCHSELSEQ2.bit.CONV07=0x7;//ADCINA7
    AdcRegs.ADCCHSELSEQ3.bit.CONV08=0x8;//ADCINB0
    AdcRegs.ADCCHSELSEQ3.bit.CONV09=0x9;//ADCINB1
    AdcRegs.ADCCHSELSEQ3.bit.CONV10=0xa;//ADCINB2
    AdcRegs.ADCCHSELSEQ3.bit.CONV11=0xb;//ADCINB3
    AdcRegs.ADCCHSELSEQ4.bit.CONV12=0xc;//ADCINB4
    AdcRegs.ADCCHSELSEQ4.bit.CONV13=0xd;//ADCINB5
    AdcRegs.ADCCHSELSEQ4.bit.CONV14=0xe;//ADCINB6
    AdcRegs.ADCCHSELSEQ4.bit.CONV15=0xf;//ADCINB7

}



//**********************************
/*
  @ Description:
  @ Param
  @ Return
 */
//**********************************
void ADC_volt_current_get_Calc(ADC_VOLT_CURRENT_GET *p)
{

    //  AdcRegs.ADCTRL2.bit.SOC_SEQ1=1;//if it is not continuous run , this is neccesory
    //  while (AdcRegs.ADCST.bit.INT_SEQ1== 0); // Wait for the process is over
    while (AdcRegs.ADCST.bit.SEQ1_BSY == 1);


    //Output:DSP Aͨ8ܽϵĵѹֵ
    p->Volt_channelA0= 3.0 * (AdcRegs.ADCRESULT0>>4)/4095.0 - offset_A0;
    p->Volt_channelA1= 3.0 * (AdcRegs.ADCRESULT1>>4)/4095.0 - offset_A1;
    p->Volt_channelA2= 3.0 * (AdcRegs.ADCRESULT2>>4)/4095.0 - offset_A2;
    p->Volt_channelA3= 3.0 * (AdcRegs.ADCRESULT3>>4)/4095.0 - offset_A3;
    p->Volt_channelA4= 3.0 * (AdcRegs.ADCRESULT4>>4)/4095.0 - offset_A4;
    p->Volt_channelA5= 3.0 * (AdcRegs.ADCRESULT5>>4)/4095.0 - offset_A5;
    p->Volt_channelA6= 3.0 * (AdcRegs.ADCRESULT6>>4)/4095.0 - offset_A6;
    p->Volt_channelA7= 3.0 * (AdcRegs.ADCRESULT7>>4)/4095.0 - offset_A7;

    //Output:DSP Bͨ8ܽϵĵѹֵ
    p->Volt_channelB0= 3.0 * (AdcRegs.ADCRESULT8 >>4)/4095.0 - offset_B0;
    p->Volt_channelB1= 3.0 * (AdcRegs.ADCRESULT9 >>4)/4095.0 - offset_B1;
    p->Volt_channelB2= 3.0 * (AdcRegs.ADCRESULT10>>4)/4095.0 - offset_B2;
    p->Volt_channelB3= 3.0 * (AdcRegs.ADCRESULT11>>4)/4095.0 - offset_B3;
    p->Volt_channelB4= 3.0 * (AdcRegs.ADCRESULT12>>4)/4095.0 - offset_B4;
    p->Volt_channelB5= 3.0 * (AdcRegs.ADCRESULT13>>4)/4095.0 - offset_B5;
    p->Volt_channelB6= 3.0 * (AdcRegs.ADCRESULT14>>4)/4095.0 - offset_B6;
    p->Volt_channelB7= 3.0 * (AdcRegs.ADCRESULT15>>4)/4095.0 - offset_B7;

    //ADݴ
    p->COS = gain_COS * p->Volt_channelA5 + offset_COS;	//
    p->SIN = gain_SIN * p->Volt_channelA4 + offset_SIN;	//
    p->VDC = gain_VDC * p->Volt_channelA0 - offset_VDC;	//Output:  ֱ
    p->Ia = gain_Ia * p->Volt_channelA3 - offset_Ia;	//Output:  A
    p->Ib = gain_Ib * p->Volt_channelA6 - offset_Ib;	//Output:  B
    p->Ic = gain_Ic * p->Volt_channelA1 - offset_Ic;	//Output:  C


    p->theta_mech_pre = p->theta_mech;	//Output: һʱ̻еλ
    p->theta_elec_pre = p->theta_elec;	//Output:  һʱ̵λ

    p->theta_mech = atan2(p->SIN,p->COS);	//Output:  еǶ
    p->theta_elec = p->np * p->theta_mech;	//Output:  Ƕ
    if(p->theta_elec>=PI)
        p->theta_elec -= 2*PI;
    else if (p->theta_elec<=-PI)
        p->theta_elec += 2*PI;
    else
        ;

    if ((p->theta_mech - p->theta_mech_pre>=0) || (p->theta_mech<0 && p->theta_mech_pre>0))
    {
        p->direction = 1;
        if  (p->theta_mech<0 && p->theta_mech_pre>0)
            p->speed_mech = (p->theta_mech + 2*PI - p->theta_mech_pre) * 5000;  //Output:  еٶ
        else
            p->speed_mech = (p->theta_mech - p->theta_mech_pre) * 5000;  //Output:  еٶ
    }
    else if ((p->theta_mech - p->theta_mech_pre<0) || (p->theta_mech>0 && p->theta_mech_pre<0))
    {
        p->direction = 0;
        if (p->theta_mech>0 && p->theta_mech_pre<0)
            p->speed_mech = (p->theta_mech_pre + 2*PI - p->theta_mech) * 5000;  //Output:  еٶ
        else
            p->speed_mech = (p->theta_mech_pre - p->theta_mech) * 5000;  //Output:  еٶ
    }
    p->speed_elec = p->np * p->speed_mech;  //Output:  еٶ
    p->rpm = p->speed_mech * 60/2/PI;

    p->speed_mech = 2*i*PI*0.0002;
    if (i==9999)
        i=0;
    else
        i++;
    //	buffer[i] = p->speed_mech;
    AdcRegs.ADCTRL2.bit.RST_SEQ1=1;
    AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;// clear the mark of IN_SEQ1

}




//==============================================================
//End of file.
//==============================================================



