/*============================================================
File name: PID.c

Originator: XXW THU

Description: define the functions related with PID

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#include "DSP28x_Project.h" 
#include "C28x_FPU_FastRTS.h"
#include <math.h>
#include "PID.h"

#pragma CODE_SECTION(PID_calc,"ramfuncs");

//======== ===========================
//**********************************
/*
  @ Description:
  @ Param
  @ Return
 */
//**********************************

void PID_init(PID_FUNC *p)
{
	p->Ek = p->Give- p->Feedback;
	// a0a1a2ֵ
	p->a0 = p->Kp*(1 + p->Ki * p->Ts + p->Kd/p->Ts);
	p->a1 = p->Kp*(1 + 2*p->Kd/p->Ts);
	p->a2 = p->Kp*p->Kd/p->Ts;

}


void PID_calc(PID_FUNC *p)
{	

	//PID
	p->Output = p->LastOutput + p->a0*p->Ek - p->a1*p->Ek_1 + p->a2*p->Ek_2;

	//޷
	if(p->Output > p->OutMax) p->Output = p->OutMax;
	if(p->Output < p->OutMin) p->Output = p->OutMin;

	//һڵֵ
	p->LastOutput = p->Output;
	p->Ek_1 = p->Ek;
	p->Ek_2 = p->Ek_1;

}

//==============================================================
//End of file.
//==============================================================
