/*============================================================
File name: SCI.c

Originator: XXW THU

Description: define the functions related with SCI

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#include "DSP28x_Project.h" 
#include "C28x_FPU_FastRTS.h"
#include "SCI.h"


//======== Definations for functions ===========================
//**********************************
/*
  @ Description:
  @ Param
  @ Return
*/
//**********************************
void sci_init(Uint16 channel)
{
 //init SCIA
 if(channel==SCIA)
   {
     InitSciaGpio();
     SciaRegs.SCICCR.all=0x07;// 1 stop bit, No loopback, No parity, 
                              // 8 char bit, async mode, idle-line protocol
     SciaRegs.SCICTL1.all=0x03;//enable TX, RX, internal SCICLK, Disable RX ERR SLEEP TXWAKE
     
     #if(CPU_FRQ_150MHZ)
       SciaRegs.SCIHBAUD=0x0001;//9600 baud @ LSPCLK=37.5MHZ
	   SciaRegs.SCILBAUD=0x00E7;
 	 #endif
 	 #if(CPU_FRQ_100MHZ)
       SciaRegs.SCIHBAUD=0x0001;//9600 baud @ LSPCLK=20MHZ
	   SciaRegs.SCILBAUD=0x0044;
     #endif
    
	SciaRegs.SCICTL2.bit.RXBKINTENA=1;
	SciaRegs.SCICTL2.bit.TXINTENA=1;
	//SciaRegs.SCICCR.bit.LOOPBKENA=1;//Enable loopback
	SciaRegs.SCICTL1.bit.SWRESET=1;
   }

 //init SCIB
 if(channel==SCIB)
   {
    InitScibGpio();
     ScibRegs.SCICCR.all=0x07;// 1 stop bit, No loopback, No parity, 
                              // 8 char bit, async mode, idle-line protocol
     ScibRegs.SCICTL1.all=0x03;//enable TX, RX, internal SCICLK, Disable RX ERR SLEEP TXWAKE
     
     #if(CPU_FRQ_150MHZ)
       ScibRegs.SCIHBAUD=0x0001;//9600 baud @ LSPCLK=37.5MHZ
	   ScibRegs.SCILBAUD=0x00E7;
 	 #endif
 	 #if(CPU_FRQ_100MHZ)
       ScibRegs.SCIHBAUD=0x0001;//9600 baud @ LSPCLK=20MHZ
	   ScibRegs.SCILBAUD=0x0044;
     #endif
    
	ScibRegs.SCICTL2.bit.RXBKINTENA=1;
	ScibRegs.SCICTL2.bit.TXINTENA=1;
	//ScibRegs.SCICCR.bit.LOOPBKENA=1;//Enable loopback
	ScibRegs.SCICTL1.bit.SWRESET=1;
   }

 //init SCIC
 if(channel==SCIC)
   {
    InitScicGpio();
     ScicRegs.SCICCR.all=0x07;// 1 stop bit, No loopback, No parity, 
                              // 8 char bit, async mode, idle-line protocol
     ScicRegs.SCICTL1.all=0x03;//enable TX, RX, internal SCICLK, Disable RX ERR SLEEP TXWAKE
     
     #if(CPU_FRQ_150MHZ)
       ScicRegs.SCIHBAUD=0x0001;//9600 baud @ LSPCLK=37.5MHZ
	   ScicRegs.SCILBAUD=0x00E7;
 	 #endif
 	 #if(CPU_FRQ_100MHZ)
       ScicRegs.SCIHBAUD=0x0001;//9600 baud @ LSPCLK=20MHZ
	   ScicRegs.SCILBAUD=0x0044;
     #endif
    
	ScicRegs.SCICTL2.bit.RXBKINTENA=1;
	ScicRegs.SCICTL2.bit.TXINTENA=1;
//	ScicRegs.SCICCR.bit.LOOPBKENA=1;//Enable loopback
	ScicRegs.SCICTL1.bit.SWRESET=1;
   }
}

//**********************************
/*
  @ Description:
  @ Param
  @ Return
*/
//**********************************
void sci_sendonechar(Uint16 channel, Uint16 data)
{
 //use SCIA
 if(channel==SCIA)
   {
     SciaRegs.SCITXBUF= data;
	 while(SciaRegs.SCICTL2.bit.TXRDY==0);//Wait until all bits are send
   }

 //use SCIB
 if(channel==SCIB)
   {
     ScibRegs.SCITXBUF= data;
	 while(ScibRegs.SCICTL2.bit.TXRDY==0);
   }

 //use SCIC
 if(channel==SCIC)
   {
     ScicRegs.SCITXBUF= data;
	 while(ScicRegs.SCICTL2.bit.TXRDY==0);
   }
}


//**********************************
/*
  @ Description:
  @ Param
  @ Return
*/
//**********************************
void sci_sendlistchar(Uint16 channel,char *listchar)
{
 Uint16 i;
 i=0;

 //use SCIA
 if(channel==SCIA)
   {
     SciaRegs.SCICTL2.bit.TXINTENA=0;//رշжϣȷַʱж
     while(listchar[i]!='\0')
      {
        sci_sendonechar(SCIA,listchar[i]);
        i++;
      }
	 SciaRegs.SCICTL2.bit.TXINTENA=1;//¿ж
   }

 //use SCIB
 if(channel==SCIB)
   {
     ScibRegs.SCICTL2.bit.TXINTENA=0;
     while(listchar[i]!='\0')
      {
        sci_sendonechar(SCIB,listchar[i]);
        i++;
      }
	 ScibRegs.SCICTL2.bit.TXINTENA=1;
   }

 //use SCIC
 if(channel==SCIC)
   {
     ScicRegs.SCICTL2.bit.TXINTENA=0;
     while(listchar[i]!='\0')
      {
        sci_sendonechar(SCIC,listchar[i]);
        i++;
      }
     ScicRegs.SCICTL2.bit.TXINTENA=1;
   }
}

//**********************************
/*
  @ Description:
  @ Param
  @ Return
*/
//**********************************
Uint16 sci_recvonechar( Uint16 channel)
{
 Uint16 data;

 //use SCIA
 if(channel==SCIA)
   {data=SciaRegs.SCIRXBUF.all;}

 //use SCIB
 if(channel==SCIB)
   {data=ScibRegs.SCIRXBUF.all;}

 //use SCIC
 if(channel==SCIC)
   {data=ScicRegs.SCIRXBUF.all;}

 return data;
}


//==============================================================
//End of file.
//==============================================================



