/*============================================================
File name: SetGpio.c

Originator: XXW THU

Description: define the functions related with SetGpio

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-20 Version 1.0
------------------------------------------------------------*/


#include "DSP28x_Project.h" 
#include "C28x_FPU_FastRTS.h"
#include <math.h>
#include "SetGpio.h"


//======== Definations for functions ===========================
//**********************************
/*
  @ Description:
  @ Param
  @ Return
*/
//**********************************
void gpioset(void)
{
	EALLOW;
	// GPIO24252627ֱΪź

    GpioCtrlRegs.GPAPUD.bit.GPIO24 = 0;    // ʹGPIO24 ڲ
    GpioCtrlRegs.GPAPUD.bit.GPIO25 = 0;    // ʹGPIO25 ڲ
    GpioCtrlRegs.GPAPUD.bit.GPIO26 = 0;    // ʹGPIO26 ڲ
    GpioCtrlRegs.GPAPUD.bit.GPIO27 = 0;    // ʹGPIO27 ڲ

    /* ͨI/OѡĴͨI/O*/

    GpioCtrlRegs.GPAMUX2.bit.GPIO24 = 0;   // GPIO24ΪͨI/O
    GpioCtrlRegs.GPAMUX2.bit.GPIO25 = 0;   // GPIO25ΪͨI/O
    GpioCtrlRegs.GPAMUX2.bit.GPIO26 = 0;   // GPIO26ΪͨI/O
    GpioCtrlRegs.GPAMUX2.bit.GPIO27 = 0;   // GPIO27ΪͨI/O

    //I/OΪ
    GpioCtrlRegs.GPADIR.bit.GPIO24 = 0;   // GPIO24Ϊ
    GpioCtrlRegs.GPADIR.bit.GPIO25 = 0;   // GPIO25Ϊ
    GpioCtrlRegs.GPADIR.bit.GPIO26 = 0;   // GPIO26Ϊ
    GpioCtrlRegs.GPADIR.bit.GPIO27 = 0;   // GPIO27Ϊ

    //޶
    GpioCtrlRegs.GPAQSEL2.bit.GPIO24= 2;    // GPIO23ϵͳʱSYSCLKOUT ͬ6βĲ
    GpioCtrlRegs.GPAQSEL2.bit.GPIO25= 2;    // GPIO24ϵͳʱSYSCLKOUT ͬ6βĲ
    GpioCtrlRegs.GPAQSEL2.bit.GPIO26= 2;    // GPIO25ϵͳʱSYSCLKOUT ͬ6βĲ
    GpioCtrlRegs.GPAQSEL2.bit.GPIO27= 2;    // GPIO26ϵͳʱSYSCLKOUT ͬ6βĲ



//   // ⲿж
//   GpioIntRegs.GPIOXINT1SEL.bit.GPIOSEL = 24;   // XINT1 is GPIO24
//   GpioIntRegs.GPIOXINT2SEL.bit.GPIOSEL = 25;   // XINT2 is GPIO25
//   GpioIntRegs.GPIOXINT1SEL.bit.GPIOSEL = 24;   // XINT1 is GPIO24
//   GpioIntRegs.GPIOXINT2SEL.bit.GPIOSEL = 25;   // XINT2 is GPIO25
//
//   XIntruptRegs.XINT1CR.bit.POLARITY = 1;      // Rising edge interrupt
//   XIntruptRegs.XINT1CR.bit.ENABLE = 1;        // Enable XINT2
//
//   XIntruptRegs.XINT2CR.bit.POLARITY = 1;      // Rising edge interrupt
//   XIntruptRegs.XINT2CR.bit.ENABLE = 1;        // Enable XINT2
//
//   XIntruptRegs.XINT1CR.bit.POLARITY = 1;      // Rising edge interrupt
//   XIntruptRegs.XINT1CR.bit.ENABLE = 1;        // Enable XINT2
//
//   XIntruptRegs.XINT1CR.bit.POLARITY = 1;      // Rising edge interrupt
//   XIntruptRegs.XINT1CR.bit.ENABLE = 1;        // Enable XINT2

   // GPIO3339Ϊ
   GpioCtrlRegs.GPBPUD.bit.GPIO33 = 0;  // Enable pullup on GPIO33
   GpioDataRegs.GPBSET.bit.GPIO33= 1;  // Load output latch
   GpioCtrlRegs.GPBMUX1.bit.GPIO33 = 0; // GPIO33 = GPIO33
   GpioCtrlRegs.GPBDIR.bit.GPIO33= 1;  // GPIO33 = output

   GpioDataRegs.GPBSET.bit.GPIO36= 1;  // Load output latch
   GpioCtrlRegs.GPBMUX1.bit.GPIO36 = 0; // GPIO36 = GPIO36
   GpioCtrlRegs.GPBDIR.bit.GPIO36= 1;  // GPIO36 = output

   GpioCtrlRegs.GPBPUD.bit.GPIO39 = 0;  // Enable pullup on GPIO39
   GpioDataRegs.GPBSET.bit.GPIO39= 1;  // Load output latch
   GpioCtrlRegs.GPBMUX1.bit.GPIO39 = 0; // GPIO39 = GPIO39
   GpioCtrlRegs.GPBDIR.bit.GPIO39= 1;  // GPIO39 = output

   EDIS;
}



//==============================================================
//End of file.
//==============================================================

