/*============================================================
File name: clarke.c

Originator: XXW THU

Description: define the functions related with clarke

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#include "DSP28x_Project.h" 
#include "C28x_FPU_FastRTS.h"
#include <math.h>
#include "clarke.h"

#pragma CODE_SECTION(clarke_calc,"ramfuncs");

//======== Definations for functions ===========================
//**********************************
/*
  @ Description:
  @ Param
  @ Return
 */
//**********************************
void clarke_calc(CLARKE *v)
{	
	v->Alpha1 = 0.81649658*(v->As - 0.5*(v->Bs + v->Cs));   //2/3)=0.81649658
	v->Beta1  = 0.70710678*(v->Bs - v->Cs);
	v->Alpha2 = 0.81649658*(v->Us - 0.5*(v->Vs + v->Ws));   //(2/3)=0.81649658
	v->Beta2  = 0.70710678*(v->Vs - v->Ws);
}



//==============================================================
//End of file.
//==============================================================

