/*============================================================
File name: ePWMs.c

Originator: XXW THU

Description: define the functions related with ePWMs

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/



#include "DSP28x_Project.h" 
#include "C28x_FPU_FastRTS.h"
#include <math.h>
#include "ePWMs.h"

#define PWM1_INT_ENABLE  1
#define PWM2_INT_ENABLE  1
#define PWM3_INT_ENABLE  1
#define PWM4_INT_ENABLE  1
#define PWM5_INT_ENABLE  1
#define PWM6_INT_ENABLE  1   

#define DBTIME_FED  500 //500*6.67ns when TBCLK=SYSCLKOUT
#define DBTIME_RED  500


//======== Definations for functions ===========================
//**********************************
/*
  @ Description:
  @ Param
  @ Return
 */
//**********************************
void ePWMs_Init(EPWMS *p)
{
	//-------------------
	//initialize ePWM1
	//-------------------
	InitEPwm1Gpio();
	//set TBCLK
	EPwm1Regs.TBPRD=p->PeriodMax; //(the period is PeriodMax * 2 * TBCLK)
	EPwm1Regs.TBPHS.half.TBPHS=0x0000;//phase is 0
	EPwm1Regs.TBCTR=0x0000; // clear the counter

	//set the compare value
	EPwm1Regs.CMPA.half.CMPA=p->PeriodMax;//set compare A
	EPwm1Regs.CMPB=0;// set compare B

	// set counter mode
	EPwm1Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;// up and down counter
	EPwm1Regs.TBCTL.bit.PHSEN=TB_DISABLE;// enable phase
	EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_CTR_ZERO;//CTR=0ʱͬź
	EPwm1Regs.TBCTL.bit.HSPCLKDIV=0;//1/clock ratio to SYSCLKOUT
	EPwm1Regs.TBCTL.bit.CLKDIV=0;// TBCLK = SYSCLKOUT/(CLKDIV*HSPCLKDIV)

	//setup shadowing
	EPwm1Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//enable shadow CMPA
	EPwm1Regs.CMPCTL.bit.SHDWBMODE=CC_SHADOW;//enable shadow CMPB
	EPwm1Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO;//load on zero
	EPwm1Regs.CMPCTL.bit.LOADBMODE=CC_CTR_ZERO;

	//set actions
	EPwm1Regs.AQCTLA.bit.CAU=AQ_SET;//set PWM1A on event A, up count
	EPwm1Regs.AQCTLA.bit.CAD=AQ_CLEAR;//clear PWM1A on event A, down count

	// EPwm1Regs.AQCTLA.bit.CAU=AQ_CLEAR;//set PWM1A on event A, up count
	// EPwm1Regs.AQCTLA.bit.CAD=AQ_SET;//clear PWM1A on event A, down count

	EPwm1Regs.AQCTLB.bit.CBU=AQ_CLEAR;// clear PWM1B on event B, up count
	EPwm1Regs.AQCTLB.bit.CBD=AQ_SET;// set PWM1B on event B, down count

	// Setup Deadband
	EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;//both epwmA and epwmB are enbale
	//EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;// A is A and B is inversed.
	EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_LOC;// A is A and B is inversed.
	EPwm1Regs.DBCTL.bit.IN_MODE = DBA_ALL;// ePWMA is the source for both falling and rising delay
	EPwm1Regs.DBRED = DBTIME_FED;// Rising edge delay time
	EPwm1Regs.DBFED = DBTIME_FED;// Falling edge delay time

	// ePWM1ģжϹ
	EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO; // ѡֵ=0Ϊж¼
	EPwm1Regs.ETSEL.bit.INTEN = 1; //ʹӦж
	EPwm1Regs.ETPS.bit.INTPRD = ET_1ST; //ÿж¼ʱһж
	EPwm1Regs.ETCLR.bit.INT = 1; //жϱ־λ

	// Setup ePWM1_SOCA ADC trigger signal
	EPwm1Regs.ETSEL.bit.SOCAEN = 1;	// Enable SOC on A group
	EPwm1Regs.ETSEL.bit.SOCASEL = ET_CTR_ZERO;	// Select SOC from CTR=ZERO
	EPwm1Regs.ETPS.bit.SOCAPRD = ET_1ST;	// Generate pulse on 1st event
	EPwm1Regs.ETCLR.bit.SOCA = 1;	// Clear SOCA flag

	EPwm1Regs.TZSEL.bit.OSHT1 = 1;
	EPwm1Regs.TZCTL.bit.TZA = TZ_FORCE_HI;
	EPwm1Regs.TZCTL.bit.TZB = TZ_FORCE_HI;


	//-------------------
	//initialize ePWM2
	//-------------------
	InitEPwm2Gpio();
	//set TBCLK
	EPwm2Regs.TBPRD=p->PeriodMax; //(the period is PeriodMax * 2 * TBCLK)
	EPwm2Regs.TBPHS.half.TBPHS=0x0000;//phase is 0
	EPwm2Regs.TBCTR=0x0000;// clear the counter

	//set the compare value
	EPwm2Regs.CMPA.half.CMPA=p->PeriodMax;//set compare A
	EPwm2Regs.CMPB=0;// set compare B

	// set counter mode
	EPwm2Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;// up and down counter
	EPwm2Regs.TBCTL.bit.PHSEN=TB_ENABLE;// enable phase
	EPwm2Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;//ϸģͬź
	EPwm2Regs.TBCTL.bit.HSPCLKDIV=0;//1/clock ratio to SYSCLKOUT
	EPwm2Regs.TBCTL.bit.CLKDIV=0;//

	//setup shadowing
	EPwm2Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//enable shadow CMPA
	EPwm2Regs.CMPCTL.bit.SHDWBMODE=CC_SHADOW;//enable shadow CMPB
	EPwm2Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO;//load on zero
	EPwm2Regs.CMPCTL.bit.LOADBMODE=CC_CTR_ZERO;

	//set actions
	EPwm2Regs.AQCTLA.bit.CAU=AQ_SET;//set PWM1A on event A, up count
	EPwm2Regs.AQCTLA.bit.CAD=AQ_CLEAR;//clear PWM1A on event B, down count

	// EPwm2Regs.AQCTLA.bit.CAU=AQ_CLEAR;//set PWM1A on event A, up count
	// EPwm2Regs.AQCTLA.bit.CAD=AQ_SET;//clear PWM1A on event A, down count

	EPwm2Regs.AQCTLB.bit.CBU=AQ_CLEAR;// clear PWM1B on event B, up count
	EPwm2Regs.AQCTLB.bit.CBD=AQ_SET;// set PWM1B on event B, down count

	// Setup Deadband
	EPwm2Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
	//EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;// A is A and B is inversed.
	EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_LOC;// A is A and B is inversed.
	EPwm2Regs.DBCTL.bit.IN_MODE = DBA_ALL;
	EPwm2Regs.DBRED = DBTIME_RED;
	EPwm2Regs.DBFED = DBTIME_FED;

    EPwm2Regs.TZSEL.bit.OSHT1 = 1;
    EPwm2Regs.TZCTL.bit.TZA = TZ_FORCE_HI;
    EPwm2Regs.TZCTL.bit.TZB = TZ_FORCE_HI;
	//-------------------
	//initialize ePWM3
	//-------------------
	InitEPwm3Gpio();
	//set TBCLK
	EPwm3Regs.TBPRD=p->PeriodMax;
	EPwm3Regs.TBPHS.half.TBPHS=0x0000;//phase is 0
	EPwm3Regs.TBCTR=0x0000;// clear the counter

	//set the compare value
	EPwm3Regs.CMPA.half.CMPA=p->PeriodMax;//set compare A
	EPwm3Regs.CMPB=0;// set compare B

	// set counter mode
	EPwm3Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;// up and down counter
	EPwm3Regs.TBCTL.bit.PHSEN=TB_ENABLE;// disable phase
	EPwm3Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;//ϸģͬź
	EPwm3Regs.TBCTL.bit.HSPCLKDIV=0;//1/clock ratio to SYSCLKOUT
	EPwm3Regs.TBCTL.bit.CLKDIV=0;// TBCLK = SYSCLKOUT/128  0.853us

	//setup shadowing
	EPwm3Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//enable shadow CMPA
	EPwm3Regs.CMPCTL.bit.SHDWBMODE=CC_SHADOW;//enable shadow CMPB
	EPwm3Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO;//load on zero
	EPwm3Regs.CMPCTL.bit.LOADBMODE=CC_CTR_ZERO;

	//set actions
	EPwm3Regs.AQCTLA.bit.CAU=AQ_SET;//set PWM1A on event A, up count
	EPwm3Regs.AQCTLA.bit.CAD=AQ_CLEAR;//clear PWM1A on event B, down count

	// EPwm3Regs.AQCTLA.bit.CAU=AQ_CLEAR;//set PWM1A on event A, up count
	// EPwm3Regs.AQCTLA.bit.CAD=AQ_SET;//clear PWM1A on event A, down count

	EPwm3Regs.AQCTLB.bit.CBU=AQ_CLEAR;// clear PWM1B on event B, up count
	EPwm3Regs.AQCTLB.bit.CBD=AQ_SET;// set PWM1B on event B, down count

	// Setup Deadband
	EPwm3Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
	//EPwm3Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;// A is A and B is inversed.
	EPwm3Regs.DBCTL.bit.POLSEL = DB_ACTV_LOC;// A is A and B is inversed.
	EPwm3Regs.DBCTL.bit.IN_MODE = DBA_ALL;
	EPwm3Regs.DBRED = DBTIME_RED;
	EPwm3Regs.DBFED = DBTIME_FED;

    EPwm3Regs.TZSEL.bit.OSHT1 = 1;
    EPwm3Regs.TZCTL.bit.TZA = TZ_FORCE_HI;
    EPwm3Regs.TZCTL.bit.TZB = TZ_FORCE_HI;
	//-------------------
	//initialize ePWM4
	//-------------------
	InitEPwm4Gpio();
	//set TBCLK
	EPwm4Regs.TBPRD=p->PeriodMax;
	EPwm4Regs.TBPHS.half.TBPHS=0x0000;//phase is 0
	EPwm4Regs.TBCTR=0x0000;// clear the counter

	//set the compare value
	EPwm4Regs.CMPA.half.CMPA=p->PeriodMax;//set compare A
	EPwm4Regs.CMPB=0;// set compare B

	// set counter mode
	EPwm4Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;// up and down counter
	EPwm4Regs.TBCTL.bit.PHSEN=TB_ENABLE;// disable phase
	EPwm4Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;//ϸģͬź
	EPwm4Regs.TBCTL.bit.HSPCLKDIV=0;//1/clock ratio to SYSCLKOUT
	EPwm4Regs.TBCTL.bit.CLKDIV=0;// TBCLK = SYSCLKOUT/128  0.853us

	//setup shadowing
	EPwm4Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//enable shadow CMPA
	EPwm4Regs.CMPCTL.bit.SHDWBMODE=CC_SHADOW;//enable shadow CMPB
	EPwm4Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO;//load on zero
	EPwm4Regs.CMPCTL.bit.LOADBMODE=CC_CTR_ZERO;

	//set actions
	EPwm4Regs.AQCTLA.bit.CAU=AQ_SET;//set PWM1A on event A, up count
	EPwm4Regs.AQCTLA.bit.CAD=AQ_CLEAR;//clear PWM1A on event B, down count

	// EPwm4Regs.AQCTLA.bit.CAU=AQ_CLEAR;//set PWM1A on event A, up count
	// EPwm4Regs.AQCTLA.bit.CAD=AQ_SET;//clear PWM1A on event A, down count

	EPwm4Regs.AQCTLB.bit.CBU=AQ_CLEAR;// clear PWM1B on event B, up count
	EPwm4Regs.AQCTLB.bit.CBD=AQ_SET;// set PWM1B on event B, down count

	// Setup Deadband
	EPwm4Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
	//EPwm4Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;// A is A and B is inversed.
	EPwm4Regs.DBCTL.bit.POLSEL = DB_ACTV_LOC;// A is A and B is inversed.
	EPwm4Regs.DBCTL.bit.IN_MODE = DBA_ALL;
	EPwm4Regs.DBRED = DBTIME_RED;
	EPwm4Regs.DBFED = DBTIME_FED;

    EPwm4Regs.TZSEL.bit.OSHT1 = 1;
    EPwm4Regs.TZCTL.bit.TZA = TZ_FORCE_HI;
    EPwm4Regs.TZCTL.bit.TZB = TZ_FORCE_HI;

	//-------------------
	//initialize ePWM5
	//-------------------
	InitEPwm5Gpio();
	//set TBCLK
	EPwm5Regs.TBPRD=p->PeriodMax;//(235*TBCLK=200us)
	EPwm5Regs.TBPHS.half.TBPHS=0x0000;//phase is 0
	EPwm5Regs.TBCTR=0x0000;// clear the counter

	//set the compare value
	EPwm5Regs.CMPA.half.CMPA=p->PeriodMax;//set compare A
	EPwm5Regs.CMPB=0;// set compare B

	// set counter mode
	EPwm5Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;// up and down counter
	EPwm5Regs.TBCTL.bit.PHSEN=TB_ENABLE;// disable phase
	EPwm5Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;//ϸģͬź
	EPwm5Regs.TBCTL.bit.HSPCLKDIV=0;//1/clock ratio to SYSCLKOUT
	EPwm5Regs.TBCTL.bit.CLKDIV=0;// TBCLK = SYSCLKOUT/128  0.853us

	//setup shadowing
	EPwm5Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//enable shadow CMPA
	EPwm5Regs.CMPCTL.bit.SHDWBMODE=CC_SHADOW;//enable shadow CMPB
	EPwm5Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO;//load on zero
	EPwm5Regs.CMPCTL.bit.LOADBMODE=CC_CTR_ZERO;

	//set actions
	EPwm5Regs.AQCTLA.bit.CAU=AQ_SET;//CLEAR PWM1A on event A, up count
	EPwm5Regs.AQCTLA.bit.CAD=AQ_CLEAR;//SET PWM1A on event B, down count

	// EPwm5Regs.AQCTLA.bit.CAU=AQ_CLEAR;//set PWM1A on event A, up count
	// EPwm5Regs.AQCTLA.bit.CAD=AQ_SET;//clear PWM1A on event A, down count

	EPwm5Regs.AQCTLB.bit.CBU=AQ_CLEAR;// clear PWM1B on event B, up count
	EPwm5Regs.AQCTLB.bit.CBD=AQ_SET;// set PWM1B on event B, down count

	// Setup Deadband
	EPwm5Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
	//EPwm5Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;// A is A and B is inversed.
	EPwm5Regs.DBCTL.bit.POLSEL = DB_ACTV_LOC;// A is A and B is inversed.
	EPwm5Regs.DBCTL.bit.IN_MODE = DBA_ALL;
	EPwm5Regs.DBRED = DBTIME_RED;
	EPwm5Regs.DBFED = DBTIME_FED;

    EPwm5Regs.TZSEL.bit.OSHT1 = 1;
    EPwm5Regs.TZCTL.bit.TZA = TZ_FORCE_HI;
    EPwm5Regs.TZCTL.bit.TZB = TZ_FORCE_HI;
	//-------------------
	//initialize ePWM6
	//-------------------
	InitEPwm6Gpio();
	//set TBCLK
	EPwm6Regs.TBPRD=p->PeriodMax;
	EPwm6Regs.TBPHS.half.TBPHS=0x0000;//phase is 0
	EPwm6Regs.TBCTR=0x0000;// clear the counter

	//set the compare value
	EPwm6Regs.CMPA.half.CMPA=p->PeriodMax;//set compare A
	EPwm6Regs.CMPB=0;// set compare B

	// set counter mode
	EPwm6Regs.TBCTL.bit.CTRMODE=TB_COUNT_UPDOWN;// up and down counter
	EPwm6Regs.TBCTL.bit.PHSEN=TB_ENABLE;// disable phase
	EPwm6Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;//ϸģͬź
	EPwm6Regs.TBCTL.bit.HSPCLKDIV=0;//1/clock ratio to SYSCLKOUT
	EPwm6Regs.TBCTL.bit.CLKDIV=0;// TBCLK = SYSCLKOUT/128  0.853us

	//setup shadowing
	EPwm6Regs.CMPCTL.bit.SHDWAMODE=CC_SHADOW;//enable shadow CMPA
	EPwm6Regs.CMPCTL.bit.SHDWBMODE=CC_SHADOW;//enable shadow CMPB
	EPwm6Regs.CMPCTL.bit.LOADAMODE=CC_CTR_ZERO;//load on zero
	EPwm6Regs.CMPCTL.bit.LOADBMODE=CC_CTR_ZERO;

	//set actions
	EPwm6Regs.AQCTLA.bit.CAU=AQ_SET;//set PWM1A on event A, up count
	EPwm6Regs.AQCTLA.bit.CAD=AQ_CLEAR;//clear PWM1A on event B, down count

	// EPwm6Regs.AQCTLA.bit.CAU=AQ_CLEAR;//set PWM1A on event A, up count
	// EPwm6Regs.AQCTLA.bit.CAD=AQ_SET;//clear PWM1A on event A, down count

	EPwm6Regs.AQCTLB.bit.CBU=AQ_CLEAR;// clear PWM1B on event B, up count
	EPwm6Regs.AQCTLB.bit.CBD=AQ_SET;// set PWM1B on event B, down count

	// Setup Deadband
	EPwm6Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
	//EPwm6Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;// A is A and B is inversed.
	EPwm6Regs.DBCTL.bit.POLSEL = DB_ACTV_LOC;// A is A and B is inversed.
	EPwm6Regs.DBCTL.bit.IN_MODE = DBA_ALL;
	EPwm6Regs.DBRED = DBTIME_RED;
	EPwm6Regs.DBFED = DBTIME_FED;

    EPwm6Regs.TZSEL.bit.OSHT1 = 1;
    EPwm6Regs.TZCTL.bit.TZA = TZ_FORCE_HI;
    EPwm6Regs.TZCTL.bit.TZB = TZ_FORCE_HI;
}




//**********************************
/*
  @ Description:
  @ Param
  @ Return
 */
//**********************************
void ePWMs_Update(EPWMS *p)
{
	//used to drive six-phase VSC
	EPwm1Regs.CMPA.half.CMPA = (int)(2.0 * p->PeriodMax * p->Duty1A);
	EPwm2Regs.CMPA.half.CMPA = (int)(2.0 * p->PeriodMax * p->Duty2A);
	EPwm3Regs.CMPA.half.CMPA = (int)(2.0 * p->PeriodMax * p->Duty3A);
	EPwm4Regs.CMPA.half.CMPA = (int)(2.0 * p->PeriodMax * p->Duty4A);
	EPwm5Regs.CMPA.half.CMPA = (int)(2.0 * p->PeriodMax * p->Duty5A);
	EPwm6Regs.CMPA.half.CMPA = (int)(2.0 * p->PeriodMax * p->Duty6A);
}


//==============================================================
//End of file.
//==============================================================



