/*============================================================
File name: main.c

Originator: XXW THU

Description: define the functions related with main

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/


#include "DSP28x_Project.h" 
#include "C28x_FPU_FastRTS.h"
#include <math.h>

//ûͷļ
#include "ADC_volt_current_get.h"
#include "ePWMs.h"

#include "clarke.h"
#include "park.h"
#include "ipark.h"
#include "SVPWM_2L.h"
#include "PID.h"
#include "protect.h"
#include "SetGpio.h"

////****Flash̻سʼ****
//extern Uint16 RamfuncsLoadStart;
//extern Uint16 RamfuncsLoadEnd;
//extern Uint16 RamfuncsRunStart;
//
//#pragma CODE_SECTION(xint1_isr, "ramfuncs");
//#pragma CODE_SECTION(xint2_isr, "ramfuncs");
//#pragma CODE_SECTION(epwm1_timer_isr, "ramfuncs");
////****Flash̻س****

//=======궨=================================================
#define  T     0.0002   // PWMڣҲɢʱĲڣλ s
#define  PI    3.141592654

//****첽綯****
#define  MaxRPM  1260  //ͬת٣λ ת/
#define  p  2    //
#define  w1  MaxRPM*PI*2/60*p  //ͬٶȣλrad/s
#define  Rs   18.7  //ӵ裬λ ŷķ
#define  Ld   0.02682   //dУλH
#define  Lq   0.02682   //qУλH
#define  J    2.26e-5   //תλkgm2

//屣س
#define 	Udc_max	12	//ֱĸߵѹֵ
#define 	Udc_min	5	//ֱĸߵѹСֵ
#define 	Iac_max	10	//ֵ
#define 	Idc_max	10	//ֱֵ
#define 	Temp1_max	125	//Ȧ¶ֵ
#define 	Temp1_min	-40	//Ȧ¶Сֵ
#define 	Temp2_max	125	//¶ֵ
#define 	Temp2_min	-40	//¶Сֵ
#define 	OVER_VOLTAGE_SHOOT	10	//Ƿѹ
#define 	OVER_CURRENT_SHOOT	10	//
#define 	OVER_TEMP_SHOOT	10	//Ƿ¶ȼ

#define  PWMS_FRC_DISABLE  0x0000  //궨壬ֹePWMģǿƹ
#define  PWMS_ALBL   0x0005    //궨壬ǿePWMģePWMAΪ͵ƽePWMBΪ͵ƽ
#define  PWMS_AHBH   0x000A    //궨壬ǿePWMģePWMAΪߵƽePWMBΪߵƽ
#define  PWMS_AHBL   0x0006    //궨壬ǿePWMģePWMAΪߵƽePWMBΪ͵ƽ
#define  PWMS_ALBH   0x0009    //궨壬ǿePWMģePWMAΪ͵ƽePWMBΪߵƽ

#define  SPEED_STEP  0.0005 //ٶȲôֵٶȸ

//======== ȫֱ ====================================================
volatile Uint16 Enable_flag = 1;    //ȫʹλ1Ч
volatile Uint16 Fault_flag = 0;    //ȫʹλ1Ч

////Գʼ
//volatile Uint16 i = 0;
//volatile Uint32 j = 0;
//volatile Uint16 de = 0;
//volatile float PWM1A[100];
//volatile float PWM2A[100];
//volatile float PWM3A[100];
//volatile float PWM4A[100];
//volatile float PWM5A[100];
//volatile float PWM6A[100];
//volatile float al[100];
//volatile float be[100];
////Գ


//ת١תءidiqĲοֵ
volatile float currentref=0.1;  //οֵ
volatile float Teref=0;  //תزοֵ

//PIĲ޷ֵ
volatile float  Isd1Kp=2, Isd1Ki=15, Isd1Limit = 12;  //isd1 PI
volatile float  Isq1Kp=2, Isq1Ki=15, Isq1Limit = 12;  //isq1 PI
volatile float  Isd2Kp=2, Isd2Ki=15, Isd2Limit = 12;  //isd2 PI
volatile float  Isq2Kp=2, Isq2Ki=15, Isq2Limit = 12;  //isq2 PI

volatile float Mech_speed_w = 0;   //еٶ
volatile float Elec_speed_w = 0;    //ٶ

//½ṹĶûӦͷļĶй
ADC_VOLT_CURRENT_GET  Volt_current = ADC_VOLT_CURRENT_GET_DEFAULTS;  //ADģӦĽṹ
EPWMS  Epwm_modules = EPWMS_DEFAULTS; //ePWMģӦĽṹ

//ӦĽṹ
Protect prot = Protect_DEFAULTS;

//任,첽綯תӴϵͳУdqϵΪMTϵֻƲͬ
CLARKE  Iabc_to_Ialphabeta = CLARKE_DEFAULTS; //Clarke任ia ib ic iu iv iwi1 i1 i2 i2任ӦĽṹ
PARK  Ialphabeta_to_Idq1 = PARK_DEFAULTS;   //Park任i iid iq任ӦĽṹ
PARK  Ialphabeta_to_Idq2 = PARK_DEFAULTS;   //Park任i iid iq任ӦĽṹ
IPARK  Udq_to_Ualphabeta1 = IPARK_DEFAULTS; //Park任ѹud uqu u±任ӦĽṹ
IPARK  Udq_to_Ualphabeta2 = IPARK_DEFAULTS; //Park任ѹud uqu u±任ӦĽṹ

//PIӦĽṹ
PID_FUNC   A_Isd1_R=PID_FUNC_DEFAULTS;  //dPIA_Isd1_R
PID_FUNC   A_Isq1_R=PID_FUNC_DEFAULTS; //qPIA_Isq1_R
PID_FUNC   A_Isd2_R=PID_FUNC_DEFAULTS;//dPIA_Isd2_R
PID_FUNC   A_Isq2_R=PID_FUNC_DEFAULTS;//qPIA_Isq2_R

//ƽʸPWM㷨ӦĽṹ
SVPWM_2L  Svpwm_ABC = SVPWM_2L_DEFAULTS;
SVPWM_2L  Svpwm_UVW = SVPWM_2L_DEFAULTS;


//======== ==============================================
interrupt void xint1_isr(void);	//ⲿж1
interrupt void xint2_isr(void);	//ⲿж2
interrupt void epwm1_timer_isr(void); //ePWM1жϷ
void clear_states(void); //״̬

//==========================================================
void main()
{
    InitSysCtrl(); //ϵͳʼ
    DINT;//رȫж
    InitPieCtrl();//ʼжϿƼĴ
    IER= 0x0000;//رCPUж
    IFR = 0x0000;//CPUжź
    InitPieVectTable();//ʼж

    //ʱ50msȴưģɳʼ
    DELAY_US(50000L);

    //****жϺַ****
    EALLOW;
    //    PieVectTable.XINT1 = &xint1_isr;		//ⲿж1ַ
    //    PieVectTable.XINT2 = &xint2_isr;		//ⲿж2ַ
    PieVectTable.EPWM1_INT = &epwm1_timer_isr;   //EPWM1жַ
    EDIS;

    //    IER |= M_INT1;		//ʹCPU INT1ģжϹ
    IER |= M_INT3;// ʹCPU INT3ģжϹ
    //    PieCtrlRegs.PIEIER1.bit.INTx4  = 1;	//ʹPIEģⲿж1
    //    PieCtrlRegs.PIEIER1.bit.INTx5  = 1;	//ʹPIEģⲿж2
    PieCtrlRegs.PIEIER3.bit.INTx1 = 1; 	//ʹPIEģEPWM INTn

    //****ePWMģʼ****
    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;  //ePWMģǰȽֹTBCLKʱ
    EDIS;

    //ePWMs.cļ趨TBCLK = SYSCLKOUTΪģʽǲ=2*15000*6.67ns=200us
    Epwm_modules.PeriodMax = 7500;  //趨ֵ
    Epwm_modules.init(&Epwm_modules); //ePWMsģĳʼʼʼ

    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1; //ɺʹTBCLKʱź
    EDIS;

    //ʸϵͳʼǰǿePWM1~ePWM6ģΪ͵ƽ⿪عͨ
    //ǿePWM1~ePWM6ģΪ͵ƽǰȽֹABͨΪ
    EPwm1Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
    EPwm2Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
    EPwm3Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
    EPwm4Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
    EPwm5Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
    EPwm6Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ

    EPwm1Regs.AQCSFRC.all = PWMS_ALBL;
    EPwm2Regs.AQCSFRC.all = PWMS_ALBL;
    EPwm3Regs.AQCSFRC.all = PWMS_ALBL;
    EPwm4Regs.AQCSFRC.all = PWMS_ALBL;
    EPwm5Regs.AQCSFRC.all = PWMS_ALBL;
    EPwm6Regs.AQCSFRC.all = PWMS_ALBL;

    //****GPIO****
    gpioset();


    //****ADCģʼ****
    Volt_current.init(&Volt_current); //ADCģʼ

    //	//****ģʼ****
    //	prot.Udcmax=Udc_max;
    //	prot.Udcmin=Udc_min;
    prot.Iacmax=Iac_max;
    prot.Idcmax=Idc_max;
    //	prot.Temp1max=Temp1_max;
    //	prot.Temp1min=Temp1_min;
    //	prot.Temp2max=Temp2_max;
    //	prot.Temp2min=Temp2_min;
    prot.OVERVOLTAGE_SHOOT=OVER_VOLTAGE_SHOOT;
    prot.OVERCURRENT_SHOOT=OVER_CURRENT_SHOOT;
    //	prot.OVERTEMP_SHOOT=OVER_TEMP_SHOOT;

    //	//****eQEPģʼ****
    //	Pos_speed.init(&Pos_speed); //eQEPģʼ

    //****ʼ****
    A_Isd1_R.Give = 0;
    A_Isd1_R.Kp = Isd1Kp;
    A_Isd1_R.Ki = Isd1Ki;
    A_Isd1_R.Ts = T;
    A_Isd1_R.OutMax = Isd1Limit;
    A_Isd1_R.OutMin =-Isd1Limit;
    A_Isd1_R.init(&A_Isd1_R);

    A_Isq1_R.Give = currentref;
    A_Isq1_R.Kp = Isq1Kp;
    A_Isq1_R.Ki = Isq1Ki;
    A_Isq1_R.Ts = T;
    A_Isq1_R.OutMax = Isq1Limit;
    A_Isq1_R.OutMin =-Isq1Limit;
    A_Isq1_R.init(&A_Isq1_R);

    A_Isd2_R.Give = 0;
    A_Isd2_R.Kp = Isd2Kp;
    A_Isd2_R.Ki = Isd2Ki;
    A_Isd2_R.Ts = T;
    A_Isd2_R.OutMax = Isd2Limit;
    A_Isd2_R.OutMin =-Isd2Limit;
    A_Isd2_R.init(&A_Isd2_R);

    A_Isq2_R.Give = currentref;
    A_Isq2_R.Kp = Isq2Kp;
    A_Isq2_R.Ki = Isq2Ki;
    A_Isq2_R.Ts = T;
    A_Isq2_R.OutMax = Isq2Limit;
    A_Isq2_R.OutMin =-Isq2Limit;
    A_Isq2_R.init(&A_Isq2_R);

    //****ʼ****
    while(Enable_flag==0); //ȴֱEnable_flag=1ʱʼִУʱֱͨCCS趨Enable_flagֵ

    EINT; //CPUж
    ERTM;

    //	//****LEDԳʼ****
    //	   EALLOW;
    //	   GpioCtrlRegs.GPBMUX2.bit.GPIO60 = 0;
    //	   GpioCtrlRegs.GPBDIR.bit.GPIO60 = 1;
    //	   EDIS;
    //	//****LEDԳ****



    //ѭ
    while(1)
    {
        if((Enable_flag==0) || (Fault_flag==1)) //йУEnable_flagFault_flag1ôǿƸePWMģΪ͵ƽ
        {
            EPwm1Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
            EPwm2Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
            EPwm3Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
            EPwm4Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
            EPwm5Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ
            EPwm6Regs.DBCTL.bit.OUT_MODE = DB_DISABLE	;//ֹ

            EPwm1Regs.AQCSFRC.all = PWMS_AHBH;
            EPwm2Regs.AQCSFRC.all = PWMS_AHBH;
            EPwm3Regs.AQCSFRC.all = PWMS_AHBH;
            EPwm4Regs.AQCSFRC.all = PWMS_AHBH;
            EPwm5Regs.AQCSFRC.all = PWMS_AHBH;
            EPwm6Regs.AQCSFRC.all = PWMS_AHBH;
            //			clear_states();
        }
        else //ʱֹePWMģǿƹ
        {
            EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;//ʹ
            EPwm2Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;//ʹ
            EPwm3Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;//ʹ
            EPwm4Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;//ʹ
            EPwm5Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;//ʹ
            EPwm6Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;//ʹ

            EPwm1Regs.AQCSFRC.all = PWMS_FRC_DISABLE;
            EPwm2Regs.AQCSFRC.all = PWMS_FRC_DISABLE;
            EPwm3Regs.AQCSFRC.all = PWMS_FRC_DISABLE;
            EPwm4Regs.AQCSFRC.all = PWMS_FRC_DISABLE;
            EPwm5Regs.AQCSFRC.all = PWMS_FRC_DISABLE;
            EPwm6Regs.AQCSFRC.all = PWMS_FRC_DISABLE;
        }


        //		//****LEDԳʼ****
        //	       DELAY_US(100000L);
        //	       GpioDataRegs.GPBTOGGLE.bit.GPIO60 = 1;
        //	   	//****LEDԳ****

    }
}

//==============================================================
//жϷ
//==============================================================
//**********************************
/*
  @ Description: ePWM1жϷ
  @ Param
  @ Return
 */
//**********************************
void epwm1_timer_isr()
{
    //ѹ
    Volt_current.read(&Volt_current);

    //****Գʼ****
    //    PWM1A[i]=Volt_current.Volt_channelA0;
    //    PWM2A[i]=Volt_current.Volt_channelA1;
    //    PWM3A[i]=Volt_current.Volt_channelA2;
    //    PWM4A[i]=Volt_current.Volt_channelA3;
    //    PWM5A[i]=Volt_current.Volt_channelA4;
    //    PWM6A[i]=Volt_current.Volt_channelA5;
    //****Գ****

    //	//****Գʼ****
    //	Volt_current.Udc1=60;
    //	Volt_current.Udc2=60;
    //	Volt_current.Ia=0;
    //	Volt_current.Ib=0;
    //	Volt_current.Ic=0;
    //	Volt_current.Iu=0;
    //	Volt_current.Iv=0;
    //	Volt_current.Iw=0;
    //	Volt_current.Idc=0;
    //	Volt_current.TEMP1_1=0;
    //	Volt_current.TEMP1_2=0;
    //	Volt_current.TEMP2=0;
    //	//****Գ****

    //ϼ
    //	prot.Udc1=Volt_current.Udc1;
    //	prot.Udc2=Volt_current.Udc2;
    prot.Ia=Volt_current.Ia;
    prot.Ib=Volt_current.Ib;
    prot.Ic=Volt_current.Ic;
    //	prot.Iu=Volt_current.Iu;
    //	prot.Iv=Volt_current.Iv;
    //	prot.Iw=Volt_current.Iw;
    //	prot.Idc=Volt_current.Idc;
    //	prot.Temp1_1=Volt_current.TEMP1_1;
    //	prot.Temp1_2=Volt_current.TEMP1_2;
    //	prot.Temp2=Volt_current.TEMP2;
    prot.calc(&prot);
    Fault_flag = prot.FaultState.bit.Faultstate;

    //ABC UVWϵĵ任Alpha Beta  z1 z2ϵClarke任
    Iabc_to_Ialphabeta.As = Volt_current.Ia;
    Iabc_to_Ialphabeta.Bs = Volt_current.Ib;
    Iabc_to_Ialphabeta.Cs = Volt_current.Ic;
    Iabc_to_Ialphabeta.Us = 0;//Volt_current.Iu;
    Iabc_to_Ialphabeta.Vs = 0;//Volt_current.Iv;
    Iabc_to_Ialphabeta.Ws = 0;//Volt_current.Iw;
    Iabc_to_Ialphabeta.calc(&Iabc_to_Ialphabeta);

    //	 //----ʸջ㷨ʵ-----------------------------------

    //	Pos_speed.calc(&Pos_speed); //ȡǰת
    Mech_speed_w = Volt_current.speed_mech; //еٶȣλrad/s
    Elec_speed_w = Mech_speed_w * p;

    //	//****Գʼ****
    //	Ialphabeta_to_Idq.Ds=10;
    //	Ialphabeta_to_Idq.Qs=20;
    //	Elec_speed_w=9000*2*PI/60;
    //	//****Գ****

    //****Գʼ****
    //    PWM1A[i]=Elec_speed_w;
    //    PWM2A[i]=flux.Theta;
    //****Գ****

    // ϵµӵת d q(MT)ϵPark任
    Ialphabeta_to_Idq1.Alpha = Iabc_to_Ialphabeta.Alpha1;
    Ialphabeta_to_Idq1.Beta = Iabc_to_Ialphabeta.Beta1;
    Ialphabeta_to_Idq1.Cos = cos(Volt_current.theta_elec);
    Ialphabeta_to_Idq1.Sin = sin(Volt_current.theta_elec);
    Ialphabeta_to_Idq1.calc(&Ialphabeta_to_Idq1);

    Ialphabeta_to_Idq2.Alpha = Iabc_to_Ialphabeta.Alpha2;
    Ialphabeta_to_Idq2.Beta = Iabc_to_Ialphabeta.Beta2;
    Ialphabeta_to_Idq2.Cos = cos(Volt_current.theta_elec);
    Ialphabeta_to_Idq2.Sin = sin(Volt_current.theta_elec);
    Ialphabeta_to_Idq2.calc(&Ialphabeta_to_Idq2);

//    if(Fault_flag==0)
//    {
        //Isd(Ism)PI
        A_Isd1_R.Give = 0;   //οid㳣iq=Cd*fluxCd=1/Lm
        A_Isd1_R.Feedback = Ialphabeta_to_Idq1.Ds;
        A_Isd1_R.calc(&A_Isd1_R);

        //Isq(Ist)PI
        A_Isq1_R.Give = currentref;	//οiq㳣iq=Cq*Te/fluxCq=Lr/(3*p*Lm)
        A_Isq1_R.Feedback = Ialphabeta_to_Idq1.Qs;
        A_Isq1_R.calc(&A_Isq1_R);

        //Isz1PI
        A_Isd2_R.Give = 0;  //гοֵΪ
        A_Isd2_R.Feedback = Ialphabeta_to_Idq2.Ds;
        A_Isd2_R.calc(&A_Isd2_R);

        //Isz2PI
        A_Isq2_R.Give = 0 ;	//гοֵΪ
        A_Isq2_R.Feedback = Ialphabeta_to_Idq2.Qs;
        A_Isq2_R.calc(&A_Isq2_R);

        //	     //Գʼ
        //		A_Isd_R.Output =0 ;
        //		A_Isq_R.Output =50 ;
        //		al[i]=cos(i*1*PI/50);
        //		be[i]=sin(i*1*PI/50);
        //		Ialphabeta_to_Idq.Cos = al[i];
        //		Ialphabeta_to_Idq.Sin  = be[i];
        //		A_Isz1_R.Output =0 ;
        //		A_Isz2_R.Output =0 ;
        //	     //Գ

        //
        //d q(MT)ϵµĵѹת ϵ
        Udq_to_Ualphabeta1.Ds = 0;//A_Isd1_R.Output ;
        Udq_to_Ualphabeta1.Qs = 12;//A_Isq1_R.Output ;

        Udq_to_Ualphabeta1.Cos = cos(Elec_speed_w);
        Udq_to_Ualphabeta1.Sin = sin(Elec_speed_w);
        Udq_to_Ualphabeta1.calc(&Udq_to_Ualphabeta1);


        Udq_to_Ualphabeta2.Ds = A_Isd2_R.Output ;
        Udq_to_Ualphabeta2.Qs = A_Isq2_R.Output ;
        Udq_to_Ualphabeta2.Cos = cos(Elec_speed_w);
        Udq_to_Ualphabeta2.Sin = sin(Elec_speed_w);
        Udq_to_Ualphabeta2.calc(&Udq_to_Ualphabeta2);

        //----ƽĿ-----------------------------------------------------------
        //ƽSVPWM㷨
        Svpwm_ABC.Ualpha = Udq_to_Ualphabeta1.Alpha; //u1 5.019097822426848;//
        Svpwm_ABC.Ubeta = Udq_to_Ualphabeta1.Beta;  //u1 -1.344863208252080;//
        Svpwm_ABC.Vdc = 12;//Volt_current.VDC;  //ͨADģֱĸߵѹ
        Svpwm_ABC.calc(&Svpwm_ABC);

        Svpwm_UVW.Ualpha = Udq_to_Ualphabeta2.Alpha; //u2
        Svpwm_UVW.Ubeta = Udq_to_Ualphabeta2.Beta;  //u2
        Svpwm_UVW.Vdc = 12;//Volt_current.Udc2;  //ͨADģֱĸߵѹ
        //	Svpwm_UVW.Vdc = 300;  //ͨADģֱĸߵѹ
        Svpwm_UVW.calc(&Svpwm_UVW);

        //ʹePWMģӦPWM
        Epwm_modules.Duty1A = Svpwm_ABC.Tcmpa;
        Epwm_modules.Duty2A = Svpwm_ABC.Tcmpb;
        Epwm_modules.Duty3A = Svpwm_ABC.Tcmpc;
        Epwm_modules.Duty4A = 0;//Svpwm_UVW.Tcmpa;
        Epwm_modules.Duty5A = 0;//Svpwm_UVW.Tcmpb;
        Epwm_modules.Duty6A = 0;//Svpwm_UVW.Tcmpc;

        Epwm_modules.update(&Epwm_modules);

//   }
    //----㷨-----------------------------------------------------------

    EPwm1Regs.ETCLR.bit.INT = 1; //жϱ־λ
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
}

//======== ===========================
//**********************************
/*
  @ Description: ⲿж1
  @ Param
  @ Return
 */
//**********************************
/*void xint1_isr()
{
    Enable_flag = 1;
    PieCtrlRegs.PIEACK.all|=PIEACK_GROUP1;       //жϱ־λ
}
*/

//**********************************
/*
  @ Description: ⲿж2
  @ Param
  @ Return
 */
//**********************************
/*
void xint2_isr()
{
    Enable_flag = 0;
    PieCtrlRegs.PIEACK.all|=PIEACK_GROUP1;       //жϱ־λ
}
*/

//**********************************
/*
  @ Description: ״̬λӺ
  @ Param
  @ Return
 */
//**********************************
//void clear_states()
//{
//
////	Volt_current = Volt_current_clear;
////	Pos_speed = Pos_speed_clear;
////	Epwm_modules = Epwm_modules_clear;
////
////	Iabc_to_Ialphabeta = Iabc_to_Ialphabeta_clear;
////	Ialphabeta_to_Idq = Ialphabeta_to_Idq_clear;
////	Udq_to_Ualphabeta = Udq_to_Ualphabeta_clear;
////	abz_to_ab12 = abz_to_ab12_clear;
////
////	A_Isd_R = A_Isd_R_clear;
////	A_Isq_R = A_Isq_R_clear;
////	A_Isz1_R = A_Isz1_R_clear;
////	A_Isz2_R = A_Isz2_R_clear;
////
////	flux = flux_clear;
////
////	Svpwm_ABC  = Svpwm_ABC_clear;
////	Svpwm_UVW = Svpwm_UVW_clear;
//
//}


//==============================================================
//End of file.
//==============================================================
