/*============================================================
File name: protect.c

Originator: XXW THU

Description: define the functions related with protect

Reference: none

============================================================
History:
------------------------------------------------------------
2017-07-19 Version 1.0
------------------------------------------------------------*/
#include "DSP28x_Project.h"
#include "C28x_FPU_FastRTS.h"
#include <math.h>
#include "protect.h"


#pragma CODE_SECTION(Protect_calc,"ramfuncs")


void Protect_calc(Protect *v)
{
	v->FaultState.all=v->FaultState.all&0x0000;

	//ֱѹѹ
	if(((v->Udc1)>(v->Udcmax)) || ((v->Udc2)>(v->Udcmax)))
	{
		v->OverVOLTAGE_Count++;
		if(v->OverVOLTAGE_Count>v->OVERVOLTAGE_SHOOT)
		{
			v->FaultState.bit.OvervoltUdc=1;
			v->OverVOLTAGE_Count=v->OVERVOLTAGE_SHOOT;
		}
	}

	else
	{
		v->OverVOLTAGE_Count=0;
	}

	//ֱѹǷѹ
	if((v->Udc1)<(v->Udcmin))
	{
		v->UnderVOLTAGE_Count++;
		if(v->UnderVOLTAGE_Count>v->OVERVOLTAGE_SHOOT)
		{
			v->FaultState.bit.UndervoltUdc=1;
			v->UnderVOLTAGE_Count=v->OVERVOLTAGE_SHOOT;
		}
	}

	else
	{
		v->UnderVOLTAGE_Count=0;
	}

	//
	if((v->Ia)>(v->Iacmax)||(v->Ia)<-(v->Iacmax)||
			(v->Ib)>(v->Iacmax)||(v->Ib)<-(v->Iacmax)||
			(v->Ic)>(v->Iacmax)||(v->Ic)<-(v->Iacmax)||
			(v->Iu)>(v->Iacmax)||(v->Iu)<-(v->Iacmax)||
			(v->Iv)>(v->Iacmax)||(v->Iv)<-(v->Iacmax)||
			(v->Iw)>(v->Iacmax)||(v->Iw)<-(v->Iacmax))
	{
		v->OverCURRENTAC_Count++;
		if(v->OverCURRENTAC_Count>v->OVERCURRENT_SHOOT)
		{
			v->FaultState.bit.OvercurIac=1;
			v->OverCURRENTAC_Count=v->OVERCURRENT_SHOOT;
		}
	}
	else
	{
		v->OverCURRENTAC_Count=0;
	}

	//ֱ
	if((v->Idc)>(v->Idcmax))
	{
		v->OverCURRENTDC_Count++;
		if(v->OverCURRENTDC_Count>v->OVERCURRENT_SHOOT)
		{
			v->FaultState.bit.OvercurIdc=1;
			v->OverCURRENTDC_Count=v->OVERCURRENT_SHOOT;
		}
	}
	else
	{
		v->OverCURRENTDC_Count=0;
	}

	//Ȧ¶ȸ±
	if(((v->Temp1_1)>(v->Temp1max)) || ((v->Temp1_2)>(v->Temp1max)))
	{
		v->OverTEMP1_Count++;
		if(v->OverTEMP1_Count>v->OVERTEMP_SHOOT)
		{
			v->FaultState.bit.Overtemp1=1;
			v->OverTEMP1_Count=v->OVERTEMP_SHOOT;
		}
	}
	else
	{
		v->OverTEMP1_Count=0;
	}

	//Ȧ¶ȵ±
	if(((v->Temp1_1)<(v->Temp1min)) || ((v->Temp1_2)<(v->Temp1min)))
	{
		v->UnderTEMP1_Count++;
		if(v->UnderTEMP1_Count>v->OVERTEMP_SHOOT)
		{
			v->FaultState.bit.Undertemp1=1;
			v->UnderTEMP1_Count=v->OVERTEMP_SHOOT;
		}
	}
	else
	{
		v->UnderTEMP1_Count=0;
	}

	//¶ȸ±
	if(((v->Temp2)>(v->Temp2max)) || ((v->Temp2)>(v->Temp2max)))
	{
		v->OverTEMP2_Count++;
		if(v->OverTEMP2_Count>v->OVERTEMP_SHOOT)
		{
			v->FaultState.bit.Overtemp2=1;
			v->OverTEMP2_Count=v->OVERTEMP_SHOOT;
		}
	}
	else
	{
		v->OverTEMP2_Count=0;
	}

	//¶ȵ±
	if(((v->Temp2)<(v->Temp2min)) || ((v->Temp2)<(v->Temp2min)))
	{
		v->UnderTEMP2_Count++;
		if(v->UnderTEMP2_Count>v->OVERTEMP_SHOOT)
		{
			v->FaultState.bit.Undertemp2=1;
			v->UnderTEMP2_Count=v->OVERTEMP_SHOOT;
		}
	}
	else
	{
		v->UnderTEMP2_Count=0;
	}


	//źͳ
	if((v->FaultState.all & 0x00FF) != 0)
	{
		v->FaultState.bit.Faultstate=1;
		v->Fault_Count++;
	}

		//ź
		if(v->FaultState.bit.Faultstate==1)
		{
		    GpioDataRegs.GPBCLEAR.bit.GPIO36 = 1;
		}
		else
		{
			GpioDataRegs.GPBSET.bit.GPIO36 = 1;
		}

}


