#include "F28x_Project.h"
#include "device.h"
#include "math.h"
#include "driverlib.h"

#define pwm_db_ticks_hs      100U
#define pwm_db_ticks_ls      100U

uint16_t compAValue = 0;
//uint16_t dac;
uint16_t Ref=51721;
uint16_t Flag1=0;
uint16_t Flag2=0;
float32_t Lr;

volatile float f_PRD[3]={0.0,0.0,0.0};

#define EPWM3_BASE_H_GPIO               4
#define EPWM3_BASE_H_GPIO_PIN_CONFIG    GPIO_4_EPWM3A
#define EPWM3_BASE_L_GPIO               5
#define EPWM3_BASE_L_GPIO_PIN_CONFIG    GPIO_5_EPWM3B

#define EPWM4_BASE_H_GPIO               6
#define EPWM4_BASE_H_GPIO_PIN_CONFIG    GPIO_6_EPWM4A
#define EPWM4_BASE_L_GPIO               7
#define EPWM4_BASE_L_GPIO_PIN_CONFIG    GPIO_7_EPWM4B

__interrupt void epwm3TZISR(void);
//__interrupt void epwm4TZISR(void);
void InitCMPSS(void);
void initEPWM2(void);
void initEPWM3(void);
//void initEPWM4(void);
void InitGPIO(void);

void setupADC(void);
void setupADCSOCTrigger(void);
void initADCSOCs(void);
void main(void)
{

    Device_init();
    Ref=51721;

    Device_initGPIO();
    setupADC();
    setupADCSOCTrigger();
    initADCSOCs();

    Interrupt_initModule();

    Interrupt_initVectorTable();

    Interrupt_register(INT_EPWM3_TZ,&epwm3TZISR);
    //Interrupt_register(INT_EPWM4_TZ,&epwm4TZISR);

    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    InitGPIO();
    InitCMPSS();

    initEPWM2();
    initEPWM3();
    //initEPWM4();

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


    Interrupt_enable(INT_EPWM3_TZ);
    //Interrupt_enable(INT_EPWM4_TZ);

    EINT;
    ERTM;


    for(;;)
    {
        //GpioDataRegs.GPASET.bit.GPIO11=1;
        //Flag1++;
        //Lr=ADC_readResult(ADCARESULT_BASE,ADC_SOC_NUMBER1)*3.3/4095;
        //GpioDataRegs.GPACLEAR.bit.GPIO11=1;
        NOP;
    }
}


__interrupt void epwm3TZISR(void)
{

    GpioDataRegs.GPASET.bit.GPIO11=1;
    Flag2++;
     compAValue = 2*HWREGH(EPWM3_BASE + EPWM_O_TBCTR)-70;

     f_PRD[0]=0.0001*compAValue+0.9999*f_PRD[1];
     f_PRD[1]=f_PRD[0];

     HWREGH(EPWM3_BASE + EPWM_O_TBPRD) = f_PRD[0];
     CMPSS_setMaxRampValue(CMPSS4_BASE, Ref);
 //        LLCV=HWREGH(ADCARESULT_BASE + ADC_RESULTx_OFFSET_BASE + ADC_SOC_NUMBER1);
 //        LLCV2=LLCV<<4;
 //        HWREGH(CMPSS1_BASE + CMPSS_O_RAMPMAXREFS) = LLCV2;

         // Clear INT flag for this timer
         EALLOW;
         HWREGH(EPWM3_BASE + EPWM_O_TZCLR) |= (EPWM_TZ_FLAG_DCAEVT1|EPWM_TZ_INTERRUPT);
         EDIS;
         // Acknowledge interrupt group
         HWREGH(PIECTRL_BASE + PIE_O_ACK) = INTERRUPT_ACK_GROUP2;
         //Flag++;
         GpioDataRegs.GPACLEAR.bit.GPIO11=1;
}


/***
__interrupt void epwm4TZISR(void)
{

    GpioDataRegs.GPASET.bit.GPIO11=1;
    Flag2++;

     compAValue = 2*HWREGH(EPWM4_BASE + EPWM_O_TBCTR)-70;

     f_PRD[0]=0.0001*compAValue+0.9999*f_PRD[1];
     f_PRD[1]=f_PRD[0];

     HWREGH(EPWM4_BASE + EPWM_O_TBPRD) = f_PRD[0];
     CMPSS_setMaxRampValue(CMPSS4_BASE, Ref);
 //        LLCV=HWREGH(ADCARESULT_BASE + ADC_RESULTx_OFFSET_BASE + ADC_SOC_NUMBER1);
 //        LLCV2=LLCV<<4;
 //        HWREGH(CMPSS1_BASE + CMPSS_O_RAMPMAXREFS) = LLCV2;


         // Clear INT flag for this timer
         EALLOW;
         HWREGH(EPWM4_BASE + EPWM_O_TZCLR) |= (EPWM_TZ_FLAG_DCAEVT1|EPWM_TZ_INTERRUPT);
         EDIS;
         // Acknowledge interrupt group
         HWREGH(PIECTRL_BASE + PIE_O_ACK) = INTERRUPT_ACK_GROUP2;
         //Flag++;
         GpioDataRegs.GPACLEAR.bit.GPIO11=1;

}
***/

void InitCMPSS(void)
{

    ASysCtl_selectCMPHPMux(ASYSCTL_CMPHPMUX_SELECT_4, 0);

    CMPSS_enableModule(CMPSS4_BASE);
    CMPSS_configHighComparator(CMPSS4_BASE, CMPSS_INSRC_DAC);

    CMPSS_configDAC(CMPSS4_BASE, CMPSS_DACREF_VDDA |CMPSS_DACVAL_SYSCLK |CMPSS_DACSRC_RAMP);

    EALLOW;
    HWREGH(CMPSS4_BASE + CMPSS_O_COMPDACCTL) |= CMPSS_COMPDACCTL_RAMPSOURCE_M;
    EDIS;

    CMPSS_setMaxRampValue(CMPSS4_BASE, 32767U);
    //        //ÿʱڼȥֵ
    CMPSS_setRampDecValue(CMPSS4_BASE,56);
    CMPSS_setRampDelayValue(CMPSS4_BASE,6);

    CMPSS_setHysteresis(CMPSS4_BASE, 2);

    CMPSS_configOutputsHigh(CMPSS4_BASE, CMPSS_TRIP_ASYNC_COMP |
                                CMPSS_TRIPOUT_ASYNC_COMP);

    XBAR_setOutputMuxConfig(XBAR_OUTPUT3, XBAR_OUT_MUX06_CMPSS4_CTRIPOUTH);
    XBAR_enableOutputMux(XBAR_OUTPUT3, XBAR_MUX06);

    XBAR_setEPWMMuxConfig(XBAR_TRIP7, XBAR_EPWM_MUX06_CMPSS4_CTRIPH);
    XBAR_enableEPWMMux(XBAR_TRIP7, XBAR_MUX06);
}



void setupADC(void)
{
    //Write ADC configurations and power up the ADC for both ADC A

    ADC_setVREF(ADCA_BASE, ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
    ADC_setVREF(ADCB_BASE, ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);
    ADC_setVREF(ADCC_BASE, ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

    //write configurations for ADC-A
    ADC_setPrescaler(ADCA_BASE, ADC_CLK_DIV_2_0);
    ADC_setPrescaler(ADCB_BASE, ADC_CLK_DIV_2_0);
    ADC_setPrescaler(ADCC_BASE, ADC_CLK_DIV_2_0);

    ADC_setInterruptPulseMode(ADCA_BASE, ADC_PULSE_END_OF_CONV);

    //power up the ADC
    ADC_enableConverter(ADCA_BASE);
    ADC_enableConverter(ADCB_BASE);
    ADC_enableConverter(ADCC_BASE);

    //delay for > 1ms to allow ADC time to power up
    DEVICE_DELAY_US(1000);
}

void initADCSOCs(void)
{
    ADC_setupSOC(ADCA_BASE,ADC_SOC_NUMBER1,   //ʹõEPWM4SOCAѡͨSOC1ʹADCIN3Ϊͨ
                 ADC_TRIGGER_EPWM4_SOCA, ADC_CH_ADCIN4,7);//ʱΪ80ns

    ADC_setInterruptSource(ADCA_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER1);
    ADC_enableInterrupt(ADCA_BASE, ADC_INT_NUMBER1);
    ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);

}

void setupADCSOCTrigger(void)
{
    /* Select SOC from counter at ctr =CMPBD*/
    EPWM_setADCTriggerSource(EPWM2_BASE,EPWM_SOC_A,EPWM_SOC_TBCTR_U_CMPC );
    EPWM_setCounterCompareValue(EPWM2_BASE,EPWM_COUNTER_COMPARE_C, 50);

    /* Generate pulse on 1st even*/
    EPWM_setADCTriggerEventPrescale(EPWM2_BASE,EPWM_SOC_A,1);

   /* Enable SOC on A group*/
    EPWM_enableADCTrigger(EPWM2_BASE,EPWM_SOC_A);

}


void initEPWM3()
{
    // Select TRIPIN4 as the source for DCAH
    EPWM_selectDigitalCompareTripInput(EPWM3_BASE, EPWM_DC_TRIP_TRIPIN7, EPWM_DC_TYPE_DCAH);

    // DCAEVT1 is generated when DCAH is High
    EPWM_setTripZoneDigitalCompareEventCondition(EPWM3_BASE, EPWM_TZ_DC_OUTPUT_A1, EPWM_TZ_EVENT_DCXH_HIGH);

    // DCAEVT1 uses the unfiltered version of DCAEVT1
    EPWM_setDigitalCompareEventSource(
            EPWM3_BASE, EPWM_DC_MODULE_A, EPWM_DC_EVENT_1, EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);

    EPWM_setDigitalCompareEventSyncMode(
            EPWM3_BASE, EPWM_DC_MODULE_A, EPWM_DC_EVENT_1, EPWM_DC_EVENT_INPUT_SYNCED);


    //This option selects DCAEVT1 as the source for T1 event
    EPWM_setActionQualifierT1TriggerSource(EPWM3_BASE, EPWM_AQ_TRIGGER_EVENT_TRIG_DCA_1);

//    EPWM_setActionQualifierT2TriggerSource(EPWM1_BASE, EPWM_AQ_TRIGGER_EVENT_TRIG_DCB_1);

    // Enable TZ interrupt
    EPWM_enableTripZoneInterrupt(EPWM3_BASE, EPWM_TZ_INTERRUPT_DCAEVT1);

    EPWM_setTripZoneAction(EPWM3_BASE, EPWM_TZ_ACTION_EVENT_DCAEVT1,
                           EPWM_TZ_ACTION_DISABLE);

    EPWM_setPeriodLoadMode(EPWM3_BASE, EPWM_PERIOD_DIRECT_LOAD);

    EPWM_setTimeBasePeriod(EPWM3_BASE,0xFFFF);
    EPWM_setPhaseShift(EPWM3_BASE, 0U);
    EPWM_setTimeBaseCounter(EPWM3_BASE, 0U);

    EPWM_setPeriodLoadMode(EPWM3_BASE, EPWM_PERIOD_DIRECT_LOAD);

    EPWM_setTimeBaseCounterMode(EPWM3_BASE, EPWM_COUNTER_MODE_UP);
    EPWM_disablePhaseShiftLoad(EPWM3_BASE);
    EPWM_setClockPrescaler(EPWM3_BASE,
                              EPWM_CLOCK_DIVIDER_1,
                              EPWM_HSCLOCK_DIVIDER_1);

    EPWM_setActionQualifierAction(EPWM3_BASE,
                                         EPWM_AQ_OUTPUT_A,
                                         EPWM_AQ_OUTPUT_HIGH,
                                         EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    EPWM_setActionQualifierAction(EPWM3_BASE,
                                         EPWM_AQ_OUTPUT_A,
                                         EPWM_AQ_OUTPUT_LOW,
                                         EPWM_AQ_OUTPUT_ON_T1_COUNT_UP);
    EPWM_setActionQualifierAction(EPWM3_BASE,
                                         EPWM_AQ_OUTPUT_B,
                                         EPWM_AQ_OUTPUT_HIGH,
                                         EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    EPWM_setActionQualifierAction(EPWM3_BASE,
                                         EPWM_AQ_OUTPUT_B,
                                         EPWM_AQ_OUTPUT_LOW,
                                         EPWM_AQ_OUTPUT_ON_T1_COUNT_UP);

//
//           EPWM_DB_COUNTER_CLOCK_HALF_CYCLE to enable HR DB;
           EPWM_setDeadBandCounterClock(EPWM3_BASE,EPWM_DB_COUNTER_CLOCK_HALF_CYCLE);
           EPWM_setRisingEdgeDelayCount(EPWM3_BASE,pwm_db_ticks_hs);
           EPWM_setFallingEdgeDelayCount(EPWM3_BASE,pwm_db_ticks_ls);
//           EPWM_setRisingEdgeDelayCount(EPWM1_BASE,0U);
//           EPWM_setFallingEdgeDelayCount(EPWM1_BASE,0U);
           EPWM_setDeadBandDelayMode(EPWM3_BASE,EPWM_DB_RED,true);
           EPWM_setDeadBandDelayMode(EPWM3_BASE,EPWM_DB_FED,true);
           EPWM_setRisingEdgeDeadBandDelayInput(EPWM3_BASE,EPWM_DB_INPUT_EPWMA);
           EPWM_setFallingEdgeDeadBandDelayInput(EPWM3_BASE,EPWM_DB_INPUT_EPWMB);
           EPWM_setDeadBandDelayPolarity(EPWM3_BASE,EPWM_DB_RED,
                                         EPWM_DB_POLARITY_ACTIVE_HIGH);
//            xB is inverted
           EPWM_setDeadBandDelayPolarity(EPWM3_BASE,EPWM_DB_FED,
                                         EPWM_DB_POLARITY_ACTIVE_LOW);
}


/***
void initEPWM4()
{
    // Select TRIPIN4 as the source for DCAH
    EPWM_selectDigitalCompareTripInput(EPWM4_BASE, EPWM_DC_TRIP_TRIPIN7, EPWM_DC_TYPE_DCAH);

    // DCAEVT1 is generated when DCAH is High
    EPWM_setTripZoneDigitalCompareEventCondition(EPWM4_BASE, EPWM_TZ_DC_OUTPUT_A1, EPWM_TZ_EVENT_DCXH_HIGH);

    // DCAEVT1 uses the unfiltered version of DCAEVT1
    EPWM_setDigitalCompareEventSource(
            EPWM4_BASE, EPWM_DC_MODULE_A, EPWM_DC_EVENT_1, EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);

    EPWM_setDigitalCompareEventSyncMode(
            EPWM4_BASE, EPWM_DC_MODULE_A, EPWM_DC_EVENT_1, EPWM_DC_EVENT_INPUT_SYNCED);


    //This option selects DCAEVT1 as the source for T1 event
    EPWM_setActionQualifierT1TriggerSource(EPWM4_BASE, EPWM_AQ_TRIGGER_EVENT_TRIG_DCA_1);

//    EPWM_setActionQualifierT2TriggerSource(EPWM1_BASE, EPWM_AQ_TRIGGER_EVENT_TRIG_DCB_1);

    // Enable TZ interrupt
    EPWM_enableTripZoneInterrupt(EPWM4_BASE, EPWM_TZ_INTERRUPT_DCAEVT1);

    EPWM_setTripZoneAction(EPWM4_BASE, EPWM_TZ_ACTION_EVENT_DCAEVT1,
                           EPWM_TZ_ACTION_DISABLE);

    EPWM_setPeriodLoadMode(EPWM4_BASE, EPWM_PERIOD_DIRECT_LOAD);

    EPWM_setTimeBasePeriod(EPWM4_BASE,0xFFFF);
    EPWM_setPhaseShift(EPWM4_BASE, 0U);
    EPWM_setTimeBaseCounter(EPWM4_BASE, 0U);

    EPWM_setPeriodLoadMode(EPWM4_BASE, EPWM_PERIOD_DIRECT_LOAD);

    EPWM_setTimeBaseCounterMode(EPWM4_BASE, EPWM_COUNTER_MODE_UP);
    EPWM_disablePhaseShiftLoad(EPWM4_BASE);
    EPWM_setClockPrescaler(EPWM4_BASE,
                              EPWM_CLOCK_DIVIDER_1,
                              EPWM_HSCLOCK_DIVIDER_1);

    EPWM_setActionQualifierAction(EPWM4_BASE,
                                         EPWM_AQ_OUTPUT_A,
                                         EPWM_AQ_OUTPUT_HIGH,
                                         EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    EPWM_setActionQualifierAction(EPWM4_BASE,
                                         EPWM_AQ_OUTPUT_A,
                                         EPWM_AQ_OUTPUT_LOW,
                                         EPWM_AQ_OUTPUT_ON_T1_COUNT_UP);
    EPWM_setActionQualifierAction(EPWM4_BASE,
                                         EPWM_AQ_OUTPUT_B,
                                         EPWM_AQ_OUTPUT_HIGH,
                                         EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    EPWM_setActionQualifierAction(EPWM4_BASE,
                                         EPWM_AQ_OUTPUT_B,
                                         EPWM_AQ_OUTPUT_LOW,
                                         EPWM_AQ_OUTPUT_ON_T1_COUNT_UP);

//
//           EPWM_DB_COUNTER_CLOCK_HALF_CYCLE to enable HR DB;
           EPWM_setDeadBandCounterClock(EPWM4_BASE,EPWM_DB_COUNTER_CLOCK_HALF_CYCLE);
           EPWM_setRisingEdgeDelayCount(EPWM4_BASE,pwm_db_ticks_hs);
           EPWM_setFallingEdgeDelayCount(EPWM4_BASE,pwm_db_ticks_ls);
//           EPWM_setRisingEdgeDelayCount(EPWM1_BASE,0U);
//           EPWM_setFallingEdgeDelayCount(EPWM1_BASE,0U);
           EPWM_setDeadBandDelayMode(EPWM4_BASE,EPWM_DB_RED,true);
           EPWM_setDeadBandDelayMode(EPWM4_BASE,EPWM_DB_FED,true);
           EPWM_setRisingEdgeDeadBandDelayInput(EPWM4_BASE,EPWM_DB_INPUT_EPWMA);
           EPWM_setFallingEdgeDeadBandDelayInput(EPWM4_BASE,EPWM_DB_INPUT_EPWMB);
           EPWM_setDeadBandDelayPolarity(EPWM4_BASE,EPWM_DB_RED,
                                         EPWM_DB_POLARITY_ACTIVE_HIGH);
//            xB is inverted
           EPWM_setDeadBandDelayPolarity(EPWM4_BASE,EPWM_DB_FED,
                                         EPWM_DB_POLARITY_ACTIVE_LOW);
}
***/

void initEPWM2()
{

    EPWM_setPeriodLoadMode(EPWM2_BASE, EPWM_PERIOD_DIRECT_LOAD);
    // ePWMʱTBCLK 100MHzƵ£ÿһTBCLKӦ 10ns
   EPWM_setTimeBasePeriod(EPWM2_BASE,100);  //ģʽһΪ10usжƵΪ100KHz
    EPWM_setPhaseShift(EPWM2_BASE, 0U);
    EPWM_setTimeBaseCounter(EPWM2_BASE, 0U);

    //PWMװģʽΪװ
    EPWM_setPeriodLoadMode(EPWM2_BASE, EPWM_PERIOD_DIRECT_LOAD);

    // Ϊģʽ
    EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM_COUNTER_MODE_UP_DOWN);
    EPWM_disablePhaseShiftLoad(EPWM2_BASE);
    EPWM_setClockPrescaler(EPWM2_BASE,
                           EPWM_CLOCK_DIVIDER_1,
                           EPWM_HSCLOCK_DIVIDER_1);


    EPWM_setActionQualifierT1TriggerSource(EPWM2_BASE,
                                           EPWM_AQ_TRIGGER_EVENT_TRIG_DCA_1);

    EPWM_setActionQualifierAction(EPWM2_BASE,
                                      EPWM_AQ_OUTPUT_A,
                                      EPWM_AQ_OUTPUT_HIGH,
                                      EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
        EPWM_setActionQualifierAction(EPWM2_BASE,
                                      EPWM_AQ_OUTPUT_A,
                                      EPWM_AQ_OUTPUT_LOW,
                                      EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
        EPWM_setActionQualifierAction(EPWM2_BASE,
                                      EPWM_AQ_OUTPUT_B,
                                      EPWM_AQ_OUTPUT_LOW,
                                      EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
        EPWM_setActionQualifierAction(EPWM2_BASE,
                                      EPWM_AQ_OUTPUT_B,
                                      EPWM_AQ_OUTPUT_HIGH,
                                      EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

       //// EPWM_DB_COUNTER_CLOCK_HALF_CYCLE to enable HR DB
        EPWM_setDeadBandCounterClock(EPWM2_BASE,EPWM_DB_COUNTER_CLOCK_HALF_CYCLE);
        EPWM_setRisingEdgeDelayCount(EPWM2_BASE,pwm_db_ticks_hs);
        EPWM_setFallingEdgeDelayCount(EPWM2_BASE,pwm_db_ticks_ls);
        EPWM_setDeadBandDelayMode(EPWM2_BASE,EPWM_DB_RED,true);
        EPWM_setDeadBandDelayMode(EPWM2_BASE,EPWM_DB_FED,true);
        EPWM_setRisingEdgeDeadBandDelayInput(EPWM2_BASE,EPWM_DB_INPUT_EPWMA);
        EPWM_setFallingEdgeDeadBandDelayInput(EPWM2_BASE,EPWM_DB_INPUT_EPWMB);
        EPWM_setDeadBandDelayPolarity(EPWM2_BASE,EPWM_DB_RED,
                                      EPWM_DB_POLARITY_ACTIVE_HIGH);
        // xB is inverted
        EPWM_setDeadBandDelayPolarity(EPWM2_BASE,EPWM_DB_FED,
                                      EPWM_DB_POLARITY_ACTIVE_LOW);


    // ôжϵʱ,ΪΪ0ʱ
    // ʹжϡ
    // ÿ3δһжϣ15Ρ
    EPWM_setInterruptSource(EPWM2_BASE, EPWM_INT_TBCTR_ZERO);
    EPWM_enableInterrupt(EPWM2_BASE);
    EPWM_setInterruptEventCount(EPWM2_BASE, 3U);
}

void InitGPIO()
{

    GPIO_setDirectionMode(11, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(11, GPIO_PIN_TYPE_STD);
    GPIO_setMasterCore(11, GPIO_CORE_CPU1);
    GPIO_setQualificationMode(11, GPIO_QUAL_ASYNC);


    GPIO_setDirectionMode(EPWM3_BASE_H_GPIO,GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(EPWM3_BASE_H_GPIO,GPIO_PIN_TYPE_STD); // disable
    GPIO_setPinConfig(EPWM3_BASE_H_GPIO_PIN_CONFIG);

    GPIO_setDirectionMode(EPWM3_BASE_L_GPIO,GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(EPWM3_BASE_L_GPIO,GPIO_PIN_TYPE_STD); // disable
    GPIO_setPinConfig(EPWM3_BASE_L_GPIO_PIN_CONFIG);

    GPIO_setDirectionMode(EPWM4_BASE_H_GPIO,GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(EPWM4_BASE_H_GPIO,GPIO_PIN_TYPE_STD); // disable
    GPIO_setPinConfig(EPWM4_BASE_H_GPIO_PIN_CONFIG);

    GPIO_setDirectionMode(EPWM4_BASE_L_GPIO,GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(EPWM4_BASE_L_GPIO,GPIO_PIN_TYPE_STD); // disable
    GPIO_setPinConfig(EPWM4_BASE_L_GPIO_PIN_CONFIG);
}

