#include "F28x_Project.h"
#include "device.h"
#include "math.h"

void InitSpib(void);
void SibInitPin(void);

uint16_t AD2S1210_READ(uint16_t data);

//500K
#define SPI_BRR ((100E6) / 500E3) - 1

//
#define CS_LOW       GpioDataRegs.GPACLEAR.bit.GPIO27   = 1;  //
#define CS_HIGH      GpioDataRegs.GPASET.bit.GPIO27     = 1;  //

#define WR_LOW       GpioDataRegs.GPBCLEAR.bit.GPIO33   = 1;  //
#define WR_HIGH      GpioDataRegs.GPBSET.bit.GPIO33     = 1;  //

#define SAMMPLE_LOW  GpioDataRegs.GPACLEAR.bit.GPIO16   = 1;  //
#define SAMMPLE_HIGH GpioDataRegs.GPASET.bit.GPIO16     = 1;  //

//
uint16_t Save_data;


void main(void)
{
    // ʼʱӺ Initialize device clock and peripherals
    Device_init();
    // InitSysCtrl();  //̲ʹüĴInitSysCtrl();ʼ

    /*//⺯
    // ʼGPIOΪ Initialize GPIO and configure the GPIO pin as a push-pull output
    Device_initGPIO();
    */
    InitGpio();  //Ĵָ

    //SPI ʼ
    InitSpib();



    // ʼPIEPIEĴرCPUж
    // Initialize PIE and clear PIE registers. Disables CPU interrupts.
    Interrupt_initModule();

    // ʼPIE
    // Initialize the PIE vector table with pointers to the shell Interrupt
    // Service Routines (ISR).
    Interrupt_initVectorTable();

    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    EINT;
    ERTM;

    for(;;)
    {
        // ӳ0.5s Delay for a bit.
        //DEVICE_DELAY_US(500000);
        CS_LOW ;
        SAMMPLE_HIGH
        DELAY_US(1);
        SAMMPLE_LOW;
        //
        Save_data = AD2S1210_READ(0x8100);

        DELAY_US(1);
        SAMMPLE_HIGH;


    }
}

void InitSpib(void)
{
    EALLOW;

    //ʼ
    SibInitPin();

    //ʹSPI-Bʱ
    CpuSysRegs.PCLKCR8.bit.SPI_B  = 1;

    //SPI븴λ
    SpibRegs.SPICCR.bit.SPISWRESET = 0;

    //շģʽ
    SpibRegs.SPICCR.bit.CLKPOLARITY = 0;
    SpibRegs.SPICTL.bit.CLK_PHASE   = 1;

    //λ
    SpibRegs.SPICCR.bit.SPICHAR     = (8 - 1);

    //жϽֹ
    SpibRegs.SPICTL.bit.OVERRUNINTENA = 0;

    //ģʽ
    SpibRegs.SPICTL.bit.MASTER_SLAVE  = 1;

    //ʹܷ
    SpibRegs.SPICTL.bit.TALK          = 1;

    //ֹSPIж
    SpibRegs.SPICTL.bit.SPIINTENA     = 0;

    //look-back
    SpibRegs.SPICCR.bit.SPILBK        = 0;

    //ò
    SpibRegs.SPIBRR.bit.SPI_BIT_RATE  = SPI_BRR ;

    //SPI״̬
    SpibRegs.SPIFFTX.all              = 0x0;

    //ʱ
    SpibRegs.SPIFFCT.all              = 0x0;

    //SPIɸλ
    SpibRegs.SPICCR.bit.SPISWRESET    = 1;

    EDIS;

}

//
void SibInitPin(void)
{
    //SPI_B_SIMO
    GpioCtrlRegs.GPBMUX2.bit.GPIO56      = 9;    //SIMO
    //GpioCtrlRegs.GPBDIR.bit.GPIO56       = 1;    //Ϊ
    //GpioCtrlRegs.GPBQSEL2.bit.GPIO56     = 3;    //첽
    GpioCtrlRegs.GPBPUD.bit.GPIO56       = 0;    //ʹ

    //SPI_B_SOMI
    GpioCtrlRegs.GPAMUX2.bit.GPIO25      = 6;    //SOMI
    GpioCtrlRegs.GPADIR.bit.GPIO25       = 1;    //Ϊ
    GpioCtrlRegs.GPAQSEL2.bit.GPIO25     = 3;    //첽
    GpioCtrlRegs.GPAPUD.bit.GPIO25       = 0;    //ʹ

    //SPI_B_CLK
    GpioCtrlRegs.GPAMUX2.bit.GPIO26      = 6;    //CLK
    //GpioCtrlRegs.GPADIR.bit.GPIO26       = 1;    //Ϊ
    //GpioCtrlRegs.GPAQSEL2.bit.GPIO26     = 3;    //첽
    GpioCtrlRegs.GPAPUD.bit.GPIO26       = 0;    //ʹ

    ///CS STE
    GpioCtrlRegs.GPAMUX2.bit.GPIO27      = 0;    //ΪIOģʽ
    GpioCtrlRegs.GPADIR.bit.GPIO27       = 1;    //Ϊ
    //GpioCtrlRegs.GPAQSEL2.bit.GPIO27     = 3;    //첽
    GpioCtrlRegs.GPAPUD.bit.GPIO27       = 0;    //ʹ
    GpioDataRegs.GPACLEAR.bit.GPIO27     = 1;    //Ƭѡʹ

    ///WR
    GpioCtrlRegs.GPBMUX1.bit.GPIO33      = 0;    //ΪIOģʽ
    GpioCtrlRegs.GPBDIR.bit.GPIO33       = 1;    //Ϊ
    //GpioCtrlRegs.GPBQSEL1.bit.GPIO33     = 3;    //첽
    GpioCtrlRegs.GPBPUD.bit.GPIO33       = 0;    //ʹ

    ///SAMPLE
    GpioCtrlRegs.GPAMUX2.bit.GPIO16      = 0;    //ΪIOģʽ
    GpioCtrlRegs.GPADIR.bit.GPIO16       = 1;    //Ϊ
    //GpioCtrlRegs.GPAQSEL2.bit.GPIO16     = 3;    //첽
    GpioCtrlRegs.GPAPUD.bit.GPIO16       = 0;    //ʹ

}

//
uint16_t AD2S1210_READ(uint16_t data)
{
    SpibRegs.SPITXBUF = data;
    DELAY_US(1);
    return SpibRegs.SPIRXBUF;

}


