/*
 * sci_fifo.c
 *
 *  Created on: 2020827
 *      Author: Yeguanyong
 */

#include "sci_fifo.h"
#include "string.h"

//volatile LWRB scib_ringbuff;

#ifdef SCIA_FIFO_EN
    volatile LWRB scia_ringbuff;
    unsigned char sci_bufa[SCIA_RX_BUF_SIZE];
#endif
#ifdef SCIB_FIFO_EN
volatile LWRB scib_ringbuff;
	unsigned char sci_bufb[SCIB_RX_BUF_SIZE];
#endif
#ifdef SCIC_FIFO_EN
    volatile LWRB scic_ringbuff;
    unsigned char sci_bufc[SCIC_RX_BUF_SIZE];
#endif

unsigned char lwrb_init(volatile LWRB *buff, void *buffdata, size_t size)
{
    if (buff == NULL || buffdata == NULL || size == 0)
        return 0;

    memset((void*)buff, 0x00, sizeof(*buff));

    buff->size = size;
    buff->buff = buffdata;
	
    return 1;
}

/**
* @Description:sciӲóʼ..
* @param .
* @return 
*/
static void sci_init(void)
{
#ifdef SCIA_FIFO_EN
    InitSciaGpio();
    // ַʽͨЭ飬ͨģʽ
	//λSCIλֵ
	SciaRegs.SCICTL1.bit.SWRESET = 0;
	SciaRegs.SCICCR.all = 0x67;
	// ʹSCIͺͽ
	SciaRegs.SCICTL1.bit.RXENA = 1; //ʹܽչ
	SciaRegs.SCICTL1.bit.TXENA = 1;	//ʹܷ͹
	SciaRegs.SCICTL2.bit.RXBKINTENA = 1;
	// ò
	SciaRegs.SCIHBAUD    = 0x00;
	SciaRegs.SCILBAUD    = 0x40;
	// ʹж

    EALLOW;
    PieVectTable.SCIRXINTA = &scia_rx_fifo_isr;
    EDIS;

	PieCtrlRegs.PIEIER9.bit.INTx1 = 1;     // PIE Group 9, int3
	IER |= M_INT9;	// Enable CPU INT

	SciaRegs.SCICTL1.bit.SWRESET = 1;
#endif
#ifdef SCIB_FIFO_EN
    InitScibGpio();
    // ַʽͨЭ飬ͨģʽ
	//λSCIλֵ
	ScibRegs.SCICTL1.bit.SWRESET = 0;
	ScibRegs.SCICCR.all = 0x67;
	// ʹSCIͺͽ
	ScibRegs.SCICTL1.bit.RXENA = 1; //ʹܽչ
	ScibRegs.SCICTL1.bit.TXENA = 1;	//ʹܷ͹
	ScibRegs.SCICTL2.bit.RXBKINTENA = 1;
	// ò
	ScibRegs.SCIHBAUD    = 0x00;
	ScibRegs.SCILBAUD    = 0x40;
	// ʹж

    EALLOW;
    PieVectTable.SCIRXINTB = &scib_rx_fifo_isr;
    EDIS;

	PieCtrlRegs.PIEIER9.bit.INTx3 = 1;     // PIE Group 9, int3
	IER |= M_INT9;	// Enable CPU INT

	ScibRegs.SCICTL1.bit.SWRESET = 1;
#endif
#ifdef SCIC_FIFO_EN
    InitScicGpio();
    // ַʽͨЭ飬ͨģʽ
    //λSCIλֵ
    ScicRegs.SCICTL1.bit.SWRESET = 0;
    ScicRegs.SCICCR.all = 0x67;
    // ʹSCIͺͽ
    ScicRegs.SCICTL1.all = 3; //ʹܽչ
    ScicRegs.SCICTL2.bit.RXBKINTENA = 1;
    // ò
    ScicRegs.SCIHBAUD    = 0x00;
    ScicRegs.SCILBAUD    = 0x40;
    // ʹж

    EALLOW;
    PieVectTable.SCIRXINTC = &scic_rx_fifo_isr;
    EDIS;

    PieCtrlRegs.PIEIER8.bit.INTx5 = 1;
    PieCtrlRegs.PIEIER8.bit.INTx6=1;
    IER |= 0x080;

    ScicRegs.SCICTL1.bit.SWRESET = 1;
#endif
}

/**
* @Description:FIFOӲʼýӿ.
* @param .
* @return 
*/
void bsp_initsci(void)
{
	sci_init();			/* ôڵӲ(ʵ) */
    memset(sci_bufc, 0, sizeof(sci_bufc));
    lwrb_init(&scic_ringbuff, sci_bufc, SCIC_RX_BUF_SIZE);
}

unsigned char lwrb_is_ready(volatile LWRB *buff)
{
    return BUF_IS_VALID(buff);
}

void lwrb_free(volatile LWRB *buff)
{
    if (BUF_IS_VALID(buff)) {
        buff->buff = NULL;
    }
}

size_t lwrb_write(volatile LWRB *buff, const void *data, size_t btw)
{
    size_t tocopy, free;
    const unsigned char *d = data;

    if (!BUF_IS_VALID(buff) || data == NULL || btw == 0)
        return 0;

    /* Calculate maximum number of bytes available to write */
    free = lwrb_get_free(buff);
    btw = BUF_MIN(free, btw);
    if (btw == 0)
        return 0;
	
    /* Step 1: Write data to linear part of buffer */
    tocopy = BUF_MIN(buff->size - buff->w, btw);
    memcpy(&buff->buff[buff->w], d, tocopy);
    buff->w += tocopy;
    btw -= tocopy;

    /* Step 2: Write data to beginning of buffer (overflow part) */
    if (btw > 0)
	{
        memcpy(buff->buff, &d[tocopy], btw);
        buff->w = btw;
    }

    /* Step 3: Check end of buffer */
    if (buff->w >= buff->size)
	{
        buff->w = 0;
    }

    return tocopy + btw;
}
size_t lwrb_read(volatile LWRB *buff, void *data, size_t btr)
{
    size_t tocopy, full;
    unsigned char* d = data;

    if (!BUF_IS_VALID(buff) || data == NULL || btr == 0)
        return 0;

    /* Calculate maximum number of bytes available to read */
    full = lwrb_get_full(buff);
    btr = BUF_MIN(full, btr);
    if (btr == 0)
        return 0;

    /* Step 1: Read data from linear part of buffer */
    tocopy = BUF_MIN(buff->size - buff->r, btr);
    memcpy(d, &buff->buff[buff->r], tocopy);
    buff->r += tocopy;
    btr -= tocopy;

    /* Step 2: Read data from beginning of buffer (overflow part) */
    if (btr > 0)
	{
        memcpy(&d[tocopy], buff->buff, btr);
        buff->r = btr;
    }

    /* Step 3: Check end of buffer */
    if (buff->r >= buff->size)
	{
        buff->r = 0;
    }

    return tocopy + btr;
}

size_t lwrb_get_free(volatile LWRB *buff)
{
    size_t size, w, r;

    if (!BUF_IS_VALID(buff))
        return 0;

    /* Use temporary values in case they are changed during operations */
    w = buff->w;
    r = buff->r;
    if (w == r) 
	{
        size = buff->size;
    } 
	else if (r > w) 
	{
        size = r - w;
    } 
	else 
	{
        size = buff->size - (w - r);
    }

    /* Buffer free size is always 1 less than actual size */
    return size - 1;
}

size_t lwrb_get_full(volatile LWRB *buff)
{
    size_t w, r, size;

    if (!BUF_IS_VALID(buff))
        return 0;

    /* Use temporary values in case they are changed during operations */
    w = buff->w;
    r = buff->r;
    if (w == r)
	{
        size = 0;
    } 
	else if (w > r) 
	{
        size = w - r;
    }
	else
	{
        size = buff->size - (r - w);
    }
    return size;
}

void lwrb_reset(volatile LWRB *buff)
{
    if (BUF_IS_VALID(buff))
	{
        buff->w = 0;
        buff->r = 0;

    }
}

void scisendchar(volatile struct SCI_REGS *psci_reg, unsigned char temp)
{
    psci_reg->SCITXBUF = temp;
	while (psci_reg->SCICTL2.bit.TXRDY == 0);	// ״̬ģʽ
	while (psci_reg->SCICTL2.bit.TXEMPTY == 0);	//״̬⣬ȴͱʶΪ
}
void send_buf_scia(unsigned char *buf, unsigned short int len)
{
    GpioDataRegs.GPBSET.bit.GPIO60 = 1;
	while (len--)
		scisendchar(&SciaRegs, *buf++);
    GpioDataRegs.GPBCLEAR.bit.GPIO60 = 1;
}
void send_buf_scib(unsigned char *buf, unsigned short int len)
{
    GpioDataRegs.GPASET.bit.GPIO24 = 1;
    while (len--)
        scisendchar(&ScibRegs, *buf++);
    GpioDataRegs.GPACLEAR.bit.GPIO24 = 1;
}
void send_buf_scic(unsigned char *buf, unsigned short int len)
{
    GpioDataRegs.GPBSET.bit.GPIO61 = 1;
    while (len--)
        scisendchar(&ScicRegs, *buf++);
    GpioDataRegs.GPBCLEAR.bit.GPIO61 = 1;
}
#ifdef SCIA_FIFO_EN
#ifdef FLASH_RUN
#pragma CODE_SECTION(scib_rx_fifo_isr,"ramfuncs");
#endif
interrupt void scia_rx_fifo_isr(void)
{
	if (SciaRegs.SCIRXST.bit.RXERROR == 1)
	{
		SciaRegs.SCICTL1.bit.SWRESET = 0;
		//DELAY_US(500);
		SciaRegs.SCICTL1.bit.SWRESET = 1;
	}
	unsigned char ch = 0;
	ch = SciaRegs.SCIRXBUF.all;				// ȡݼĴ
	lwrb_write(&scia_ringbuff, &ch, 1);
    PieCtrlRegs.PIEACK.all = 0x0100;   //Ӧж
}
#endif

#ifdef SCIB_FIFO_EN
#ifdef FLASH_RUN
#pragma CODE_SECTION(scib_rx_fifo_isr,"ramfuncs");
#endif
interrupt void scib_rx_fifo_isr(void)
{
	if (ScibRegs.SCIRXST.bit.RXERROR == 1)
	{
		ScibRegs.SCICTL1.bit.SWRESET = 0;
		DELAY_US(1000);
		ScibRegs.SCICTL1.bit.SWRESET = 1;
	}
	unsigned char ch = 0;
	ch = ScibRegs.SCIRXBUF.all;				// ȡݼĴ
	lwrb_write(&scib_ringbuff, &ch, 1);
    PieCtrlRegs.PIEACK.all = 0x0100;   //Ӧж
}
#endif

#ifdef SCIC_FIFO_EN
#ifdef FLASH_RUN
#pragma CODE_SECTION(scic_rx_fifo_isr,"ramfuncs");
#endif
interrupt void scic_rx_fifo_isr(void)
{
    if (ScicRegs.SCIRXST.bit.RXERROR == 1)
    {
        ScicRegs.SCICTL1.bit.SWRESET = 0;
        DELAY_US(1000);
        ScicRegs.SCICTL1.bit.SWRESET = 1;
    }
    unsigned char ch = 0;
    ch = ScicRegs.SCIRXBUF.all;             // ȡݼĴ
    lwrb_write(&scic_ringbuff, &ch, 1);
    PieCtrlRegs.PIEACK.all = 0x080;   //Ӧж
}
#endif
