/*
 * sci_fifo.h
 *
 *  Created on: 2020827
 *      Author: Yeguanyong
 */

#ifndef SCI_FIFO_H_
#define SCI_FIFO_H_


#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include "DSP2833x_Device.h"     // DSP2833x Headerfile Include File
#include "DSP2833x_Examples.h"   // DSP2833x Examples Include File

#define	xSCIA_FIFO_EN
#define	xSCIB_FIFO_EN
#define	SCIC_FIFO_EN


#define BUF_IS_VALID(b)                 ((b) != NULL && (b)->buff != NULL && (b)->size > 0)
#define BUF_MIN(x, y)                   ((x) < (y) ? (x) : (y))
#define BUF_MAX(x, y)                   ((x) > (y) ? (x) : (y))


typedef struct LWRB
{
    unsigned char* buff;                              /*!< Pointer to buffer data.
                                                    Buffer is considered initialized when `buff != NULL` and `size > 0` */
    size_t size;                                /*!< Size of buffer data. Size of actual buffer is `1` byte less than value holds */
    size_t r;                                   /*!< Next read pointer. Buffer is considered empty when `r == w` and full when `w == r - 1` */
    size_t w;                                   /*!< Next write pointer. Buffer is considered empty when `r == w` and full when `w == r - 1` */
}LWRB;


#ifdef SCIA_FIFO_EN
	#define SCIA_RX_BUF_SIZE	1*512
extern unsigned char sci_bufa[SCIA_RX_BUF_SIZE];
extern volatile LWRB scia_ringbuff;
interrupt void scia_rx_fifo_isr(void);
#endif
#ifdef SCIB_FIFO_EN
	#define SCIB_RX_BUF_SIZE	1*512
extern unsigned char sci_bufb[SCIB_RX_BUF_SIZE];
extern volatile LWRB scib_ringbuff;
interrupt void scib_rx_fifo_isr(void);
#endif

#ifdef SCIC_FIFO_EN
    #define SCIC_RX_BUF_SIZE    1*512
extern unsigned char sci_bufc[SCIC_RX_BUF_SIZE];
extern volatile LWRB scic_ringbuff;
interrupt void scic_rx_fifo_isr(void);
#endif
unsigned char     lwrb_init(volatile LWRB* buff, void* buffdata, size_t size);
unsigned char     lwrb_is_ready(volatile LWRB* buff);
void        lwrb_free(volatile LWRB* buff);
void        lwrb_reset(volatile LWRB* buff);

/* Read/Write functions */
size_t      lwrb_write(volatile LWRB* buff, const void* data, size_t btw);
size_t      lwrb_read(volatile LWRB* buff, void* data, size_t btr);
/* Buffer size information */
size_t      lwrb_get_free(volatile LWRB* buff);
size_t      lwrb_get_full(volatile LWRB* buff);

void scisendchar(volatile struct SCI_REGS *psci_reg, unsigned char temp);
void send_buf_scia(unsigned char *buf, unsigned short int len);
void send_buf_scib(unsigned char *buf, unsigned short int len);
void send_buf_scic(unsigned char *buf, unsigned short int len);
void bsp_initsci(void);

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif /* SCI_FIFO_H_ */
