/*
 * Scib.c
 *
 *  Created on: 2018829
 *      Author: Neo
 */


#include "DSP280x_Device.h"     // DSP280x Headerfile Include File
#include "DSP280x_Examples.h"   // DSP280x Examples Include File
#include "GlobalVariables.h"


void InitSci(void)
{
		InitSciGpio();
	// Initialize SCI-B:
	   ScibRegs.SCICCR.all =0x0007;   				// 1 stop bit,  No loopback Odd parity,8 char bits, async mode, addr protocol

	   ScibRegs.SCICTL1.all =0x0003;  				// enable TX, RX, internal SCICLK,	 Disable RX ERR, SLEEP, TXWAKE

	   ScibRegs.SCICTL2.all =0x0002; 				//bit1 =1,ʹж ,bit0 =0,رշж

	   ScibRegs.SCIHBAUD = 0x0001;
	   ScibRegs.SCILBAUD =  0x0044;					//9600,25Mhz/BAUD/8 -1 =9600Ϊ01,44115200Ϊ00,1a

	   ScibRegs.SCIFFTX.all = 0xE040;				//bit15=1˳λbit14=1,ʹfifo,bit13=1,ʹfifoͣbit6=1,TXFFINT־
	   ScibRegs.SCIFFRX.all = 0x606C;				//bit14=1,RXFFOVF־λbit13=1,ʹfifoգ
	   	   	   	   	   	   	   	   	   	   	   	    //bit6=1,RXFFINT־bit5,RXFFIENA interrupt Enable,жϼ6.
	   	   	   	   	   	   	   	   	   	   	   	   	//bit0_4=12,RXFFL=1212ֽڽFIFOж
	   ScibRegs.SCIFFCT.all = 0x00;					//delay=0
	   ScibRegs.SCICTL1.all = 0x0023;     			// Relinquish SCI from Reset

}

void SciBSendChar(char a)
{
//    while (ScibRegs.SCIFFTX.bit.TXFFST  != 0);
//	ScibRegs.SCITXBUF = a;
//	while (ScibRegs.SCIFFTX.bit.TXFFST  != 0);
//	while(ScibRegs.SCICTL2.bit.TXEMPTY == 0);
	while(ScibRegs.SCICTL2.bit.TXRDY == 0);
	ScibRegs.SCITXBUF = a;
}

void SciBSendString(char* str)
{
	while(*str != '\0')
	{
		SciBSendChar(*str);
		str++;
	}
}

void SciBSendNumf(float num)
{
	char s[9];
	sprintf(s,"%-8.3f",num);
	SciBSendString(s);
}

void SciBSendNumld(int32 num)
{
	char s[11];
	sprintf(s,"%-10ld",num);
	SciBSendString(s);
}

void SciAcquire()
{
	switch( FunctionCode )
	{
//		case '1': 		SPLLPiPara.Proportion = atof(SciRxStr);	break;
//		case '2':		SPLLPiPara.Integral = atof(SciRxStr);  		break;
		case '1': 		MemFlag = 1;
						msg = "\r\n MMemFlag = 1 \n\0";
						SciBSendString(msg);
						break;

		case '2':		MemFlag = 2;
						msg = "\r\n MMemFlag = 2 \n\0";
						SciBSendString(msg);
						break;

		default:		break;

	}
//	PIParaF2F(SPLLPiPointer,SPLLPiPara);
}

//յַС趨FIFOλFifoRxbuf
void SciFifoRxbufClear()
{
	char temp;
	temp = ScibRegs.SCIFFRX.bit.RXFFST;
	if(temp > 0)
	{
		DELAY_US(10000);
		if(temp == ScibRegs.SCIFFRX.bit.RXFFST)
		{
			ScibRegs.SCIFFRX.bit.RXFIFORESET = 0;
			ScibRegs.SCIFFRX.bit.RXFIFORESET = 1;
		}
	}
}

//===========================================================================
// End of file.
//===========================================================================
