#include "DSP280x_Device.h"     // DSP280x Headerfile Include File
#include "DSP280x_Examples.h"   // DSP280x Examples Include File
#include "GlobalVariables.h"
interrupt void SCIRXINTB1_ISR(void);

void main(void)
 {
	InitSysCtrl();

	InitLedGpio();
	InitScibGpio();

	DINT;
	InitPieCtrl();
	IER = 0x0000;
	IFR = 0x0000;
	InitPieVectTable();

	MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);
	InitFlash();

	EALLOW;	// This is needed to write to EALLOW protected registers
   	PieVectTable.SCIRXINTB = &SCIRXINTB1_ISR; //SCI B ж
	EDIS;   // This is needed to disable write to EALLOW protected registers

	InitSci( );


	msg = "\r\n Hello world \n\0";
	SciBSendString(msg);

	while(1)
	{
		led1=~led1;

		if(SciRxFlag == 1)
		{
		   SciRxFlag = 0;
		   SciAcquire( );
		}
	//	SciFifoRxbufClear( );

		DELAY_US(200000);
	}

}


interrupt void SCIRXINTB1_ISR(void)     // SCI-B
{
	// Insert ISR Code here

	// To receive more interrupts from this PIE group, acknowledge this interrupt
	// PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

	// Next two lines for debug only to halt the processor here
	// Remove after inserting ISR Code

	char i,head,tail,FunCFlag;
	led2=~led2;
	temp++;
	head = (ScibRegs.SCIRXBUF.all) & 0x00FF;
	if(head == 'B')
	{

		for(i = 0; i < 8; i++)
		{
			SciRxStr[i] = (ScibRegs.SCIRXBUF.all) & 0x00FF;
		}

		FunCFlag = (ScibRegs.SCIRXBUF.all) & 0x00FF;
		if(FunCFlag == 'C')
		{
			FunctionCode = (ScibRegs.SCIRXBUF.all) & 0x00FF;
			tail = (ScibRegs.SCIRXBUF.all) & 0x00FF;
			if(tail == 'E')
			{
				SciRxFlag = 1;
			}
		}
	}

	ScibRegs.SCIFFRX.bit.RXFIFORESET = 0;
	ScibRegs.SCIFFRX.bit.RXFIFORESET = 1;
	ScibRegs.SCIFFRX.bit.RXFFINTCLR  = 1;
	PieCtrlRegs.PIEACK.all |= PIEACK_GROUP9; 		//д1㣬д0Ч,

}
//===========================================================================
// No more.
