#include "CANSetup.h"
#include "string.h"

tCANMsgObject sTXCANMessage;
tCANMsgObject sTXCANMessage2;
tCANMsgObject sRXCANMessage;
tCANMsgObject sRXCANMessage2;
unsigned char ucTXMsgData[8] ={ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
unsigned char ucRXMsgData[8];

unsigned long u32CntTXMsgData = 0x12345678;

void can_send(uint32_t id,uint32_t ui32ObjID)
{
/*    u32CntTXMsgData = 0x12345678;
    ucTXMsgData[0] = (u32CntTXMsgData>>24) & 0xFF;
    ucTXMsgData[1] = (u32CntTXMsgData>>16) & 0xFF;
    ucTXMsgData[2] = (u32CntTXMsgData>>8) & 0xFF;
    ucTXMsgData[3] = (u32CntTXMsgData) & 0xFF;*/
    sTXCANMessage.ui32MsgID = id;                      // CAN message ID - use 1
    sTXCANMessage.ui32MsgIDMask = 0x500;                  // no mask needed for TX
    sTXCANMessage.ui32Flags = MSG_OBJ_USE_ID_FILTER;//MSG_OBJ_TX_INT_ENABLE|MSG_OBJ_USE_ID_FILTER;  // enable interrupt on TX
    sTXCANMessage.ui32MsgLen = sizeof(ucTXMsgData);   // size of message is 8
    sTXCANMessage.pucMsgData = ucTXMsgData;           // ptr to message content

    CANMessageSet(CANB_BASE, ui32ObjID, &sTXCANMessage, MSG_OBJ_TYPE_TX);
}
unsigned long CAN_SendData(unsigned long ulID, unsigned long *pBuf, unsigned char uLen)
{
    int i;
    int iIndex;

    sTXCANMessage.ui32MsgID = ulID;                      // CAN message ID - use 1
    sTXCANMessage.ui32MsgIDMask = 0x82000000;                  // no mask needed for TX
    sTXCANMessage.ui32Flags = MSG_OBJ_USE_ID_FILTER | MSG_OBJ_EXTENDED_ID;//MSG_OBJ_TX_INT_ENABLE|MSG_OBJ_USE_ID_FILTER;  // enable interrupt on TX
    sTXCANMessage.ui32MsgLen = sizeof(ucTXMsgData);   // size of message is 8
    sTXCANMessage.pucMsgData = ucTXMsgData;           // ptr to message content

    memset(ucTXMsgData, 0, sizeof(ucTXMsgData));
    iIndex = 0;
    for (i = 0; i < uLen; i++)
    {
        ucTXMsgData[iIndex] = (pBuf[i] & 0x000000FF);
        ucTXMsgData[iIndex+1] = ((pBuf[i] >> 8) & 0x000000FF);
        ucTXMsgData[iIndex+2] = ((pBuf[i] >> 16) & 0x000000FF);
        ucTXMsgData[iIndex+3] = ((pBuf[i] >> 24) & 0x000000FF);

        iIndex += 4;
        if (iIndex >= sTXCANMessage.ui32MsgLen)
        {
            break;
        }
    }

    CANMessageSet(CANB_BASE, 4, &sTXCANMessage, MSG_OBJ_TYPE_TX);

    return 0;
}
void InitCANBGpio()
{
    //GPIO39 -  CANRXB
    GPIO_SetupPinMux(39, GPIO_MUX_CPU1, 6);
    //GPIO38 - CANTXB
    GPIO_SetupPinMux(38, GPIO_MUX_CPU1, 6);
    GPIO_SetupPinOptions(39, GPIO_INPUT, GPIO_ASYNC);
    GPIO_SetupPinOptions(38, GPIO_OUTPUT, GPIO_PUSHPULL);
}


//*****************************************************************************
// This function is the interrupt handler for the CAN peripheral.  It checks
// for the cause of the interrupt, and maintains a count of all messages that
// have been transmitted.
//*****************************************************************************
interrupt void
CANIntHandler(void)
{
    // Put the Flash to sleep
    EALLOW;
    Flash0CtrlRegs.FPAC1.bit.PMPPWR = 0x0;
    EDIS;
    unsigned long ulStatus;
    unsigned long ulData;

    // Read the CAN interrupt status to find the cause of the interrupt
    ulStatus = CANIntStatus(CANB_BASE, CAN_INT_STS_CAUSE);

    // If the cause is a controller status interrupt, then get the status
    if(ulStatus == CAN_INT_INT0ID_STATUS)
    {
        // Read the controller status.  This will return a field of status
        // error bits that can indicate various errors.  Error processing
        // is not done in this example for simplicity.  Refer to the
        // API documentation for details about the error status bits.
        // The act of reading this status will clear the interrupt.  If the
        // CAN peripheral is not connected to a CAN bus with other CAN devices
        // present, then errors will occur and will be indicated in the
        // controller status.
        ulStatus = CANStatusGet(CANB_BASE, CAN_STS_CONTROL);

        //Check to see if an error occurred.
        if(((ulStatus  & ~(CAN_ES_TXOK | CAN_ES_RXOK)) != 7) &&
                ((ulStatus  & ~(CAN_ES_TXOK | CAN_ES_RXOK)) != 0)){
            // Set a flag to indicate some errors may have occurred.
        ////    g_bErrFlag = 1;
        }
    }

    // Check if the cause is message object 1, which what we are using for
    // sending messages.
    else if(ulStatus == 1)
    {
        // Getting to this point means that the TX interrupt occurred on
        // message object 1, and the message TX is complete.  Clear the
        // message object interrupt.
        CANIntClear(CANB_BASE, 1);

        // Increment a counter to keep track of how many messages have been
        // sent.  In a real application this could be used to set flags to
        // indicate when a message is sent.
  ////      g_ulTxMsgCount++;

        // Since the message was sent, clear any error flags.
 ////       g_bErrFlag = 0;
    }
    else if(ulStatus == 4)
    {
        CANIntClear(CANB_BASE, 4);
    }

    // Check if the cause is message object 1, which what we are using for
    // receiving messages.
    else if(ulStatus == 15)
    {

        // Get the received message
        CANMessageGet(CANB_BASE, 15, &sRXCANMessage, true);
        if(sRXCANMessage.ui32MsgID == 0x601)
        {
            ;
        }

    }
    else if(ulStatus == 16)
    {
        // Get the received message
        CANMessageGet(CANB_BASE, 16, &sRXCANMessage, true);

    }
    else if(ulStatus == 17)
    {
        // Get the received message
        CANMessageGet(CANB_BASE, 17, &sRXCANMessage, true);

        //////////////////////////
    }

    // Otherwise, something unexpected caused the interrupt.  This should
    // never happen.
    else
    {
        // Spurious interrupt handling can go here.
    }

    //canaRegs.CAN_GLB_INT_CLR.bit.INT0_FLG_CLR = 1;
    CANGlobalIntClear(CANB_BASE, CAN_GLB_INT_CANINT0);
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;
}
void can_rec_setup()
{
    *(unsigned long *)ucRXMsgData = 0;
    sRXCANMessage.ui32MsgID = 0x301;                      // CAN message ID - use 1
    sRXCANMessage.ui32MsgIDMask = 0x300;                  // no mask needed for TX
    sRXCANMessage.ui32Flags = MSG_OBJ_RX_INT_ENABLE|MSG_OBJ_USE_ID_FILTER;  // enable interrupt on RX
    sRXCANMessage.ui32MsgLen = sizeof(ucRXMsgData);   // size of message is 8
    sRXCANMessage.pucMsgData = ucRXMsgData;           // ptr to message content

    // Setup the message object being used to receive messages
    CANMessageSet(CANB_BASE, 15, &sRXCANMessage, MSG_OBJ_TYPE_RX);

    *(unsigned long *)ucRXMsgData = 0;
    sRXCANMessage.ui32MsgID = 0x601;                      // CAN message ID - use 1
    sRXCANMessage.ui32MsgIDMask = 0x600;                  // no mask needed for TX
    sRXCANMessage.ui32Flags = MSG_OBJ_RX_INT_ENABLE|MSG_OBJ_USE_ID_FILTER;  // enable interrupt on RX
    sRXCANMessage.ui32MsgLen = sizeof(ucRXMsgData);   // size of message is 8
    sRXCANMessage.pucMsgData = ucRXMsgData;           // ptr to message content

    // Setup the message object being used to receive messages
    CANMessageSet(CANB_BASE, 16, &sRXCANMessage, MSG_OBJ_TYPE_RX);

    *(unsigned long *)ucRXMsgData = 0;
    sRXCANMessage.ui32MsgID = 0x8000001;                      // CAN message ID - use 1
    sRXCANMessage.ui32MsgIDMask = 0x8000000;                  // no mask needed for TX
    sRXCANMessage.ui32Flags = MSG_OBJ_RX_INT_ENABLE|MSG_OBJ_USE_ID_FILTER;  // enable interrupt on RX
    sRXCANMessage.ui32MsgLen = sizeof(ucRXMsgData);   // size of message is 8
    sRXCANMessage.pucMsgData = ucRXMsgData;           // ptr to message content

    // Setup the message object being used to receive messages
    CANMessageSet(CANB_BASE, 17, &sRXCANMessage, MSG_OBJ_TYPE_RX);
}
