//----------------------------------------------------------------------------------
//	FILE:			PM_tformat-Main.C
//
//	Description:	Example project for using PM tformat Library.
//					Includes PM_tformat_lib library and correspoding include files.
//					Initializes the encoders and performs delay compensation.
//					Runs tformat command set.
//					Continuously Read position value in an infinite loop
//
//	Version: 		1.0
//
//  Target:  		TMS320F28379D
//
//----------------------------------------------------------------------------------
//  Copyright Texas Instruments 2004-2015
//----------------------------------------------------------------------------------
//  Revision History:
//----------------------------------------------------------------------------------
//  Date	  | Description / Status
//----------------------------------------------------------------------------------
// Apr 2016  - Example project for PM T-Format Library Usage
//----------------------------------------------------------------------------------
#include "F28x_Project.h"    // Device Headerfile and Examples Include File
#include "tformat.h"		 // Include file for tformat interface
#include "CANSetup.h"
#include "string.h"

uint32_t crcResult;
uint16_t retval1;		//used for function return val storage and checks
uint32_t position, turns;
__interrupt void cpu_timer0_isr();
uint16_t flag = 0;
Uint32    nCnt = 0;

#pragma CODE_SECTION(cpu_timer0_isr, "ramfuncs");
//#pragma CODE_SECTION(CANIntHandler, "ramfuncs");
//#pragma CODE_SECTION(spiRxFifoIsr, "ramfuncs");
//#pragma CODE_SECTION(can_send, "ramfuncs");
//#pragma CODE_SECTION(InitFlash, "ramfuncs");
//#pragma CODE_SECTION(tformat_Init, "ramfuncs");



void main(void) {

//    memcpy(&RamfuncsRunStart, &RamfuncsLoadStart, (size_t)&RamfuncsLoadSize);
    // Call Flash Initialization to setup flash waitstates
        // This function must reside in RAM
//    InitFlash();


// Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the F2837xD_SysCtrl.c file.
	InitSysCtrl();

// Step 3. Clear all interrupts and initialize PIE vector table:
// Disable CPU interrupts
	DINT;

// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.
// This function is found in the F2837xD_PieCtrl.c file.
	InitPieCtrl();

// Disable CPU interrupts and clear all CPU interrupt flags:
	IER = 0x0000;
	IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt
// Service Routines (ISR).
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in F2837xD_DefaultIsr.c.
// This function is found in F2837xD_PieVect.c.
	InitPieVectTable();
	EALLOW;
	PieVectTable.TIMER0_INT = &cpu_timer0_isr;
	//can interrupt
    PieVectTable.CANB0_INT = &CANIntHandler;
	EDIS;
	InitCpuTimers();
	ConfigCpuTimer(&CpuTimer0,200,20);
	CpuTimer0Regs.TCR.all = 0x4000;

	// Configure GPIO34 as a GPIO output pin
	EALLOW;
	GpioCtrlRegs.GPAMUX1.bit.GPIO9 = 0;
	GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;
	GpioDataRegs.GPACLEAR.bit.GPIO9 = 1;
    //led2
    GpioCtrlRegs.GPAMUX2.bit.GPIO22 = 0;
    GpioCtrlRegs.GPADIR.bit.GPIO22 = 1;
    GpioDataRegs.GPACLEAR.bit.GPIO22 = 1;
	EDIS;
	InitCANBGpio();


//Initialization routine for tformat operation - defined in tformat.c
//Configures the peripherals and enables clocks for required modules
//Configures GPIO and XBar as needed for t-format operation
//Sets up the SPI peripheral in tformat data structure and enables interrupt

	tformat_Init();
	DELAY_US(800L); 	//Delay 800us

	//can setup
    // Initialize the CAN controller
    CANInit(CANB_BASE);
    // Setup CAN to be clocked off the PLL output clock
    CANClkSourceSelect(CANB_BASE, 0);   /* 500kHz CAN-Clock */
    // Set up the bit rate for the CAN bus
    CANBitRateSet(CANB_BASE, 200000000, 250000);
    CANIntEnable(CANB_BASE, CAN_INT_MASTER | CAN_INT_ERROR | CAN_INT_STATUS);
    can_rec_setup();

//Optional function exercising several tformat commands including eeprom accesses
////	retval1 = tformat_exCommands();

	IER |= M_INT1;
	PieCtrlRegs.PIEIER1.bit.INTx7 = 1;
	//CAN B
    PieCtrlRegs.PIEIER9.bit.INTx7 = 1;//canb

//Infinite loop to read position using DATAID3 command - returns position and turns information
	while(1)
	{
/*		retval1 = PM_tformat_setupCommand (DATAID3, 0, 0, 0);
		PM_tformat_startOperation();
		while (tformatData.dataReady != 1) {}
		retval1 = PM_tformat_receiveData(DATAID3);

		crcResult = PM_tformat_getCRC(0, 80, 8, (uint16_t *)&tformatData.rxPkts, tformatCRCtable, 10);
		crcResult = crcResult ^ (0xFF);
		 if (!CheckCRC(crcResult,tformatData.crc))
		 {
				 ESTOP0;
		 }

		 //Invert the received bit sequence for position and turns for actual data
		 position = ((__flip32((uint32_t) tformatData.dataField0) >> 24 ) & 0xFF)|
				    ((__flip32((uint32_t) tformatData.dataField1) >> 16 ) & 0xFF00)|
					((__flip32((uint32_t) tformatData.dataField2) >> 8 )  & 0xFF0000);

		 turns = ((__flip32((uint32_t) tformatData.dataField4) >> 24 ) & 0xFF)|
					((__flip32((uint32_t) tformatData.dataField5) >> 16 ) & 0xFF00)|
					((__flip32((uint32_t) tformatData.dataField6) >> 8 )  & 0xFF0000);

		 DELAY_US(200L);*/
/*	    GpioDataRegs.GPBTOGGLE.bit.GPIO45 = 1;
	    ucTXMsgData[0] = ((Uint32)(position)) & 0xFF;
        ucTXMsgData[1] = ((Uint32)(position)>>8) & 0xFF;
        ucTXMsgData[2] = ((Uint32)(position)>>16) & 0xFF;
        ucTXMsgData[3] = ((Uint32)(position)>>24) & 0xFF;
        ucTXMsgData[4] = ((Uint32)(turns)) & 0xFF;
        ucTXMsgData[5] = ((Uint32)(turns)>>8) & 0xFF;
        ucTXMsgData[6] = ((Uint32)(turns)>>16) & 0xFF;
        ucTXMsgData[7] = ((Uint32)(turns)>>24) & 0xFF;
        can_send(0x555,2);

        DELAY_US(1000000L);*/
	}
}

__interrupt void cpu_timer0_isr()
{
    // Put the Flash to sleep
    EALLOW;
    Flash0CtrlRegs.FPAC1.bit.PMPPWR = 0x0;
    EDIS;
    //GpioDataRegs.GPBTOGGLE.bit.GPIO45 = 1;
    if(flag == 0)
    {
        flag = 1;
        retval1 = PM_tformat_setupCommand (DATAID3, 0, 0, 0);
        PM_tformat_startOperation();
    }
    if(tformatData.dataReady == 1)
    {
        flag = 0;
        retval1 = PM_tformat_receiveData(DATAID3);

        crcResult = PM_tformat_getCRC(0, 80, 8, (uint16_t *)&tformatData.rxPkts, tformatCRCtable, 10);
        crcResult = crcResult ^ (0xFF);
         if (!CheckCRC(crcResult,tformatData.crc))
         {
                 //ESTOP0;
         }

         //Invert the received bit sequence for position and turns for actual data
         position = ((__flip32((uint32_t) tformatData.dataField0) >> 24 ) & 0xFF)|
                    ((__flip32((uint32_t) tformatData.dataField1) >> 16 ) & 0xFF00)|
                    ((__flip32((uint32_t) tformatData.dataField2) >> 8 )  & 0xFF0000);

         turns = ((__flip32((uint32_t) tformatData.dataField4) >> 24 ) & 0xFF)|
                    ((__flip32((uint32_t) tformatData.dataField5) >> 16 ) & 0xFF00)|
                    ((__flip32((uint32_t) tformatData.dataField6) >> 8 )  & 0xFF0000);
    }
    if(nCnt == 50000)
    {
        nCnt=0;
        GpioDataRegs.GPATOGGLE.bit.GPIO9 = 1;
        ucTXMsgData[0] = ((Uint32)(position)) & 0xFF;
        ucTXMsgData[1] = ((Uint32)(position)>>8) & 0xFF;
        ucTXMsgData[2] = ((Uint32)(position)>>16) & 0xFF;
        ucTXMsgData[3] = ((Uint32)(position)>>24) & 0xFF;
        ucTXMsgData[4] = ((Uint32)(turns)) & 0xFF;
        ucTXMsgData[5] = ((Uint32)(turns)>>8) & 0xFF;
        ucTXMsgData[6] = ((Uint32)(turns)>>16) & 0xFF;
        ucTXMsgData[7] = flag;//((Uint32)(turns)>>24) & 0xFF;
        can_send(0x555,2);
    }
    else
        nCnt++;
    PieCtrlRegs.PIEACK.bit.ACK1 = 1;
}
// End of file
