#include "DSP2833x_Project.h"
#include <stdio.h>
#include <string.h>
#include <math.h>

#if (CPU_FRQ_150MHZ)
  #define CPU_CLK   150e6
#endif
#if (CPU_FRQ_100MHZ)
  #define CPU_CLK   100e6
#endif

// ADC start parameters
#define ADC_MODCLK 0x3 // HSPCLK = SYSCLKOUT/2*ADC_MODCLK2 = 150/(2*3)   = 25.0 MHz
#define ADC_CKPS   0x0   // ADC module clock = HSPCLK/1      = 25.5MHz/(1)   = 25.0 MHz
#define ADC_SHCLK  0x1   // S/H width in ADC module periods                  = 2 ADC cycle
#define BUF_SIZE   25     // Sample buffer size


#define PWM_CLK   100e3                //Ƶ
#define SP        CPU_CLK/(2* PWM_CLK)//EPWM1ֵӦEPwm.cTBPRD
#define SP2       CPU_CLK/(2* PWM_CLK)   //òƵ
// Up-down cnt, timebase = SYSCLKOUT
#define lag 0x000E
#define lead 0x200E
#define phase_shift_cycle 750			//PWMڳ

//-------------------------------жϺ--------------------------//
interrupt void Phase_shift(void);		//жϺ
interrupt void ISRTimer0(void); 	//ʱ0жϺ
//-------------------------------жϺ--------------------------//

//-------------------------------Ӻ---------------------------//
void PID_initial(void);				//PIDʼ
void StartEPwm(void);				//PWMʼ
//-------------------------------Ӻ---------------------------//


double kstep=15;						//ٶȳ

float Security = 0;//ȫ־λ

//------------------------------PIDز-----------------------//
float Vin = 400;                         //ѹ
float v_ref_o = 11;						//˿2οѹ
//float v_ref_o_2 = 10;                   //˿3οѹ
float P3_ref = -121;					    //˿3
float refresh = 0;						//refresh = 5e5λ

//ADCж 
float v_adc_o;                      //ֱֵ
float v_adc_o2;                      //ֱֵ2
float v_adc_o3;						//
float i_adc_o;                      //ֱֵ
float i_adc_o2;                      //ֱֵ2
float i_adc_o3;
float P1 = 0;
float P2 = 0;
float P3 = 0;

//PI 
float error2 = 0;//error(n-2)
float error1 = 0;//error(n-1)
float ierror = 0;//error(n)
float PID_OUT = 0;
float error2_2 = 0;//error(n-2)
float error1_2 = 0;//error(n-1)
float ierror_2 = 0;//error(n)
float PID_OUT_2 = 0;
float Ki;
float Kp;
float Kd;
float Ki_2;
float Kp_2;
float Kd_2;
float error_sum = 0;//λʽ

//PWMȽڶ
float PWM1_CC_Duty = 0;
float PWM2_CC_Duty = -0.007;
float PWM2_CC_Duty0 = -0.007;
float PWM2_CC_Duty1 = 0;
//------------------------------PIDز-----------------//

//-----------------------------SCIز---------------//
Uint16 array_pointer=0;                                     //ָ
Uint16 sum1=0,sum2=0,sum=0;         //֮(sum1)ԼУ(sum2)
Uint16 serial_flag=0;                                      //崮ڼ־λ
Uint16 buf_size=0;                                         //ݳ
Uint16 receive_buf[BUF_SIZE];                                   //洢
Uint16 istep=600;						//
Uint16 a1=0;
Uint16 a2=0;
Uint16 a3=0;
Uint16 a4=0;
Uint16 Pid_start = 0;
Uint16 i;
Uint16 array_index = 0;             //



extern Uint16 secureRamFuncs_loadstart;
extern Uint16 secureRamFuncs_loadsize;
extern Uint16 secureRamFuncs_runstart;              //¼Flash

void main(void)
{
   InitSysCtrl();
   asm(" RPT #8 || NOP");
   InitGpio();
   InitScibGpio();
   InitPieCtrl();
   DINT;

   //------------------------¼Flash---------------------------------//
   // Section secureRamFuncs contains user defined code that runs from CSM secured RAM
       memcpy(&secureRamFuncs_runstart, &secureRamFuncs_loadstart, (Uint32)&secureRamFuncs_loadsize);
       InitFlash();                      // Initialize the Flash
   //------------------------¼Flash---------------------------------//

   EALLOW;
         SysCtrlRegs.HISPCP.all = ADC_MODCLK;  // HSPCLK = SYSCLKOUT/ADC_MODCLK
   EDIS;

   IER = 0x0000;        //CPUжʹλ
   IFR = 0x0000;        //CPUжϱ־λ
   InitPieVectTable();
   asm(" RPT #8 || NOP");    //ʱ
   DINT;

   EALLOW;
//-----------------жϺַ-------------//
   PieVectTable.TINT0 = &ISRTimer0;
   PieVectTable.EPWM1_INT=&Phase_shift;//жϺ
//-----------------жϺַ-------------//

   InitCpuTimers();   // For this example, only initialize the Cpu Timers
   ConfigCpuTimer(&CpuTimer0, 150, 10);//CPUʱ0
   StopCpuTimer0();

//------------------------ePWM GPIO---------------//
   InitEPwm1Gpio();
   InitEPwm2Gpio();
   InitEPwm3Gpio();
   InitEPwm4Gpio();
   InitEPwm5Gpio();
   InitEPwm6Gpio();
//------------------------ePWM GPIO---------------//
   EDIS;
//------------------------EPWMʼ
   DELAY_US(6e6);         //ʱ6s

   StartEPwm();

   EALLOW;

   SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK=0;				//رPWM23ʱ
   SysCtrlRegs.PCLKCR1.bit.EPWM3ENCLK=0;
   SysCtrlRegs.PCLKCR1.bit.EPWM5ENCLK=0;				//رPWM23ʱ
   SysCtrlRegs.PCLKCR1.bit.EPWM6ENCLK=0;

   EDIS;
//...................................жϳʼ------------------------
   EPwm1Regs.ETSEL.bit.INTSEL=2;         //TBCTR = TBPRD ж
   EPwm1Regs.ETPS.bit.INTPRD=1;          //һTBCTR = TBPRD¼һж
   EPwm1Regs.ETCLR.bit.INT=1;           //жϱ־λ
//-------------------------ADCʼ

   InitAdc();

//--------------------------ʹPIEж------------------------------------

   PieCtrlRegs.PIEIER1.bit.INTx7 = 1;   //ʱ0жϣݺPID
   PieCtrlRegs.PIEIER3.bit.INTx1 = 1; //ʹж

//--------------------------ʹCPU1ж--------------------------------

   IER |= M_INT1;
   IER |= M_INT3;       //ʹCPUж

//------------------------------------------------------------------------

   EINT;   // ʹȫж
   ERTM;   // ʹȫʵʱж
   EPwm1Regs.ETSEL.bit.INTEN=1;             //ʹEpwm1ж

//-------------------------------PID---------------------------------------------
     PID_initial();
//--------------------------------------------------------------------------------------

     SysCtrlRegs.PCLKCR3.bit.CPUTIMER0ENCLK=1;

//------------------------------ѭ--------------------------------------------
  for(;;)
  {


  }
}

//------------------------------------------PID----------------------------------------//
void PID_initial()
{
    Kp = 0;//150
    Ki = 30;//10
    Kd = 0;
    Kp_2 = 0;//150
    Ki_2 = 0.3;//10
    Kd_2 = 0;
}
//------------------------------------------PID----------------------------------------//

//------------------------------------------PWM----------------------------------------//
void StartEPwm()
{
	 //תƵEPWM.c
	    EALLOW;
	    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;
	    //ʱã0úEPWMΪ1
	    //øPWM2356   PWM14
	    //--------------------------------------PWM2----------------------------------------------//
	        EPwm2Regs.TBSTS.all=0;
	        EPwm2Regs.TBPHS.half.TBPHS=0;
	        EPwm2Regs.TBCTR=0;

	        EPwm2Regs.CMPCTL.all=0x50;        // Immediate mode for CMPA and CMPB
	        EPwm2Regs.CMPA.half.CMPA =SP*0.5;
	        EPwm2Regs.CMPB=0;

	        EPwm2Regs.AQCTLA.all=0x6;        // EPWMxA = 1 when CTR=CMPA and counter inc
	                                          // EPWMxA = 0 when CTR=CMPA and counter dec
	        EPwm2Regs.AQCTLB.all=0;
	        EPwm2Regs.AQSFRC.all=0;
	        EPwm2Regs.AQCSFRC.all=0;

	        EPwm2Regs.TZSEL.all=0x0300;		//
	        EPwm2Regs.TZCTL.all=0;
	        EPwm2Regs.TZEINT.all=0;
	        EPwm2Regs.TZFLG.all=0;
	        EPwm2Regs.TZCLR.all=0;
	        EPwm2Regs.TZFRC.all=0;
	        EPwm2Regs.TZCTL.bit.TZA = 0x2;   //OSHT״̬£EPWM1
	        EPwm2Regs.TZCTL.bit.TZB = 0x2;

	        EPwm2Regs.DBRED=20;				//
	        EPwm2Regs.DBFED=20;

	        EPwm2Regs.ETSEL.all=0;            // Interrupt when TBCTR = 0x0000
	        EPwm2Regs.ETFLG.all=0;
	        EPwm2Regs.ETCLR.all=0;
	        EPwm2Regs.ETFRC.all=0;

	        EPwm2Regs.PCCTL.all=0;
	        EPwm2Regs.TBCTL.all=0x0020+lag;  // ෽lagͺ
	        EPwm2Regs.TBPRD=SP;
	    //--------------------------------------PWM3----------------------------------------------
	        EPwm3Regs.TBSTS.all=0;
	        EPwm3Regs.TBPHS.half.TBPHS=0;   //
	        EPwm3Regs.TBCTR=0;

	        EPwm3Regs.CMPCTL.all=0x50;        // Immediate mode for CMPA and CMPB
	        EPwm3Regs.CMPA.half.CMPA =SP*0.5;
	        EPwm3Regs.CMPB=0;

	        EPwm3Regs.AQCTLA.all=0x6;        // EPWMxA = 1 when CTR=CMPA and counter inc
	                                          // EPWMxA = 0 when CTR=CMPA and counter dec
	        EPwm3Regs.AQCTLB.all=0;
	        EPwm3Regs.AQSFRC.all=0;
	        EPwm3Regs.AQCSFRC.all=0;

	        EPwm3Regs.TZSEL.all=0x0300;			//
	        EPwm3Regs.TZCTL.all=0;
	        EPwm3Regs.TZEINT.all=0;
	        EPwm3Regs.TZFLG.all=0;
	        EPwm3Regs.TZCLR.all=0;
	        EPwm3Regs.TZCTL.bit.TZA = 0x2;   //OSHT״̬£EPWM1
	        EPwm3Regs.TZCTL.bit.TZB = 0x2;
	        					//------ɺPWMB-------//
	        EPwm2Regs.DBCTL.all=0xb;          // EPWMxB is inverted
	        EPwm3Regs.DBCTL.all=0xb;          // EPWMxB is inverted

	        EPwm2Regs.TZFRC.bit.OST = 1;        //ǿEPWM2B
	        EPwm3Regs.TZFRC.bit.OST = 1;       //ǿEPWM3B

	        EPwm3Regs.DBRED=20;
	        EPwm3Regs.DBFED=20;

	        EPwm3Regs.ETSEL.all=0;            // Interrupt when TBCTR = 0x0000
	        EPwm3Regs.ETFLG.all=0;
	        EPwm3Regs.ETCLR.all=0;
	        EPwm3Regs.ETFRC.all=0;

	        EPwm3Regs.PCCTL.all=0;

	        EPwm3Regs.TBCTL.all=0x0020+lag;  // ෽
	        EPwm3Regs.TBPRD=SP;
//--------------------------------------PWM5----------------------------------------------
	        EPwm5Regs.TBSTS.all=0;
	        EPwm5Regs.TBPHS.half.TBPHS=0;     // λĴֵ 0
	        EPwm5Regs.TBCTR=0;                // TBCTRʱ

	        EPwm5Regs.CMPCTL.all=0x50;        // Immediate mode!!! for CMPA and CMPB
	        EPwm5Regs.CMPA.half.CMPA =SP*0.5;   // ռձ
	        EPwm5Regs.CMPB=0;

	        EPwm5Regs.AQCTLA.all=0x6;        // EPWMxA = 1 when CTR=CMPA and counter inc
	                                                  // EPWMxA = 0 when CTR=CMPA and counter dec
	        EPwm5Regs.AQCTLB.all=0;
	        EPwm5Regs.AQSFRC.all=0;
	        EPwm5Regs.AQCSFRC.all=0;

	        EPwm5Regs.TZSEL.all=0x0300;
	        EPwm5Regs.TZCTL.all=0;
	        EPwm5Regs.TZEINT.all=0;
	        EPwm5Regs.TZFLG.all=0;
	        EPwm5Regs.TZCLR.all=0;
	        EPwm5Regs.TZCTL.bit.TZA = 0x2;   //OSHT״̬£EPWM1
	        EPwm5Regs.TZCTL.bit.TZB = 0x2;
	                                                  // DBģ 
	        EPwm5Regs.DBRED=10;              // ʱ ?ʱ
	        EPwm5Regs.DBFED=10;

	        EPwm5Regs.ETSEL.all=0;            // Interrupt when TBCTR = 0x0000
	        EPwm5Regs.ETFLG.all=0;
	        EPwm5Regs.ETCLR.all=0;
	        EPwm5Regs.ETFRC.all=0;

	        EPwm5Regs.PCCTL.all=0;
	        EPwm5Regs.TBCTL.all=0x0020+lead;    // ʱƼĴ Enable Timerǰ
	        EPwm5Regs.TBPRD=SP;               //ʱڼĴ

	   //--------------------------------------PWM6----------------------------------------------

	        EPwm6Regs.TBSTS.all=0;
	        EPwm6Regs.TBPHS.half.TBPHS=0;
	        EPwm6Regs.TBCTR=0;

	        EPwm6Regs.CMPCTL.all=0x50;        // Immediate mode for CMPA and CMPB
	        EPwm6Regs.CMPA.half.CMPA =SP*0.5;
	        EPwm6Regs.CMPB=0;

	        EPwm6Regs.AQCTLA.all=0x6;        // EPWMxA = 1 when CTR=CMPA and counter inc
	                                         // EPWMxA = 0 when CTR=CMPA and counter dec
	        EPwm6Regs.AQCTLB.all=0;
	        EPwm6Regs.AQSFRC.all=0;
	        EPwm6Regs.AQCSFRC.all=0;

	        EPwm6Regs.TZSEL.all=0x0300;
	        EPwm6Regs.TZCTL.all=0;
	        EPwm6Regs.TZEINT.all=0;
	        EPwm6Regs.TZFLG.all=0;
	        EPwm6Regs.TZCLR.all=0;
	        EPwm6Regs.TZCTL.bit.TZA = 0x2;   //OSHT״̬£EPWM1
	        EPwm6Regs.TZCTL.bit.TZB = 0x2;

	        EPwm5Regs.DBCTL.all=0xb;          // EPWMxB is inverted
	        EPwm6Regs.DBCTL.all=0xb;          // EPWMxB is inverted

	        EPwm5Regs.TZFRC.bit.OST = 1;        //ǿEPWM1B
	        EPwm6Regs.TZFRC.bit.OST = 1;       //ǿEPWM4B

	        EPwm6Regs.DBRED=12;               //ʱ
	        EPwm6Regs.DBFED=12;

	        EPwm6Regs.ETSEL.all=0;            // Interrupt when TBCTR = 0x0000
	        EPwm6Regs.ETFLG.all=0;
	        EPwm6Regs.ETCLR.all=0;
	        EPwm6Regs.ETFRC.all=0;

	        EPwm6Regs.PCCTL.all=0;
	        EPwm6Regs.TBCTL.all=0x0020+lag;         // Enable Timer
	        EPwm6Regs.TBPRD=SP;

//--------------------------------------PWM1----------------------------------------------

	    EPwm1Regs.TBSTS.all=0;
	    EPwm1Regs.TBPHS.half.TBPHS=0;     // λĴֵ 0
	    EPwm1Regs.TBCTR=0;                // TBCTRʱ

	    EPwm1Regs.CMPCTL.all=0x50;        // Immediate mode!!! for CMPA and CMPB
	    EPwm1Regs.CMPA.half.CMPA =SP*0.5;   // ռձ
	    EPwm1Regs.CMPB=0;

	    EPwm1Regs.AQCTLA.all=0x6;        // EPWMxA = 1 when CTR=CMPA and counter inc
	                                      // EPWMxA = 0 when CTR=CMPA and counter dec
	    EPwm1Regs.AQCTLB.all=0;
	    EPwm1Regs.AQSFRC.all=0;
	    EPwm1Regs.AQCSFRC.all=0;

	    EPwm1Regs.TZSEL.all=0x0300;
	    EPwm1Regs.TZCTL.all=0;
	    EPwm1Regs.TZEINT.all=0;
	    EPwm1Regs.TZFLG.all=0;
	    EPwm1Regs.TZCLR.all=0;
	    EPwm1Regs.TZCTL.bit.TZA = 0x2;   //OSHT״̬£EPWM1
	    EPwm1Regs.TZCTL.bit.TZB = 0x2;
	                                      // DBģ 
	    EPwm1Regs.DBRED=10;              // ʱ ?ʱ
	    EPwm1Regs.DBFED=10;

	    //ADC&ePWMADCSOCź
	    EPwm1Regs.ETSEL.all=0x0A00;       //TBһһSOCA
	                                      //enable ePWMxSOCA
	    EPwm1Regs.ETPS.all=0x0100;        //TBƥһΣһδ
	    EPwm1Regs.ETCLR.bit.SOCA=1;       //SOCA flag

	    EPwm1Regs.PCCTL.all=0;
	    EPwm1Regs.TBCTL.all=0x0020+lead;    // ʱƼĴ Enable Timer
	    EPwm1Regs.TBPRD=SP;               //ʱڼĴ

	    //--------------------------------------PWM4----------------------------------------------
	         EPwm4Regs.TBSTS.all=0;
	         EPwm4Regs.TBPHS.half.TBPHS=istep;				//ೣ
	         EPwm4Regs.TBCTR=700;

	         EPwm4Regs.CMPCTL.all=0x50;        // Immediate mode for CMPA and CMPB
	         EPwm4Regs.CMPA.half.CMPA =SP*0.5;
	         EPwm4Regs.CMPB=0;

	         EPwm4Regs.AQCTLA.all=0x6;        // EPWMxA = 1 when CTR=CMPA and counter inc
	                                           // EPWMxA = 0 when CTR=CMPA and counter dec
	         EPwm4Regs.AQCTLB.all=0;
	         EPwm4Regs.AQSFRC.all=0;
	         EPwm4Regs.AQCSFRC.all=0;

	         EPwm4Regs.TZSEL.all=0x0300;
	         EPwm4Regs.TZCTL.all=0;
	         EPwm4Regs.TZEINT.all=0;
	         EPwm4Regs.TZFLG.all=0;
	         EPwm4Regs.TZCLR.all=0;
	         EPwm4Regs.TZCTL.bit.TZA = 0x2;   //OSHT״̬£EPWM1
	         EPwm4Regs.TZCTL.bit.TZB = 0x2;

	         EPwm1Regs.DBCTL.all=0xb;          // EPWMxB is inverted
	         EPwm4Regs.DBCTL.all=0xb;          // EPWMxB is inverted

	         EPwm1Regs.TZFRC.bit.OST = 1;        //ǿEPWM1B
	         EPwm4Regs.TZFRC.bit.OST = 1;       //ǿEPWM4B

	         EPwm4Regs.DBRED=12;               //ʱ
	         EPwm4Regs.DBFED=12;

	         EPwm4Regs.ETSEL.all=0;            // Interrupt when TBCTR = 0x0000
	         EPwm4Regs.ETFLG.all=0;
	         EPwm4Regs.ETCLR.all=0;
	         EPwm4Regs.ETFRC.all=0;

	         EPwm4Regs.PCCTL.all=0;
	         EPwm4Regs.TBCTL.all=0x0020+lag;         // Enable Timer
	         EPwm4Regs.TBPRD=SP;

	    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;  //PWMʱ
	    			//--------------------PWM1456ָ---------------------//
	    EPwm1Regs.TZCLR.bit.OST=1;
	    EPwm4Regs.TZCLR.bit.OST=1;
//	    EPwm5Regs.TZCLR.bit.OST=1;
//	    EPwm6Regs.TZCLR.bit.OST=1;
	     EDIS;
}
//------------------------------------------PWM----------------------------------------//

//------------------------------------------ʱ0жϺPIDݼ㣬ѹݷ----------------------------------------//
interrupt void ISRTimer0(void)
{

           //--------------------޷-------------------//
            if(PWM2_CC_Duty > 0.4)
            {
           	 PWM2_CC_Duty = 0.4;
            }
            else if(PWM2_CC_Duty < -0.4)
            {
           	 PWM2_CC_Duty = -0.4;
            }

            if(PWM2_CC_Duty <= 0.4 && PWM2_CC_Duty>= 0 && a1 == 0)
            {
                  PWM2_CC_Duty= PWM2_CC_Duty+ 0.00001;
                  a2 = 1;
            }

            if(PWM2_CC_Duty> 0.4)
            {
                PWM2_CC_Duty= PWM2_CC_Duty- 0.00001;
                a1 = 1;
            }
            if(PWM2_CC_Duty<= 0.4 && PWM2_CC_Duty>=0 && a1 == 1 && a2 ==1)
            {
                PWM2_CC_Duty= PWM2_CC_Duty-0.00001;
                a3 = 0;
                a4 = 0;
            }

            if(PWM2_CC_Duty< 0 && PWM2_CC_Duty>= -0.4 && a4 ==0)
            {
                    PWM2_CC_Duty= PWM2_CC_Duty-0.00001;
                    a3 = 1;
            }
            if(PWM2_CC_Duty< -0.4)
            {
                PWM2_CC_Duty= PWM2_CC_Duty+ 0.0001;
                a4 = 1;
            }
            if(PWM2_CC_Duty>= -0.4 && PWM2_CC_Duty< 0 && a3 ==1 && a4 ==1)
            {
                PWM2_CC_Duty= PWM2_CC_Duty+0.00001;
                a1 = 0;
                a2 = 0;
            }
            PWM2_CC_Duty1 = PWM2_CC_Duty;
            if(PWM2_CC_Duty1 >= 0)
            {
    	        EPwm5Regs.TBCTL.all=0x0020+lag;
                EPwm5Regs.TBPHS.half.TBPHS=PWM2_CC_Duty1*phase_shift_cycle;
            }
            else if(PWM2_CC_Duty1 < 0)
            {
            	PWM2_CC_Duty1 = -PWM2_CC_Duty1;
    	        EPwm5Regs.TBCTL.all=0x0020+lead;
                EPwm5Regs.TBPHS.half.TBPHS=PWM2_CC_Duty1*phase_shift_cycle;
            }

    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
    CpuTimer0Regs.TCR.bit.TIF=1;
    CpuTimer0Regs.TCR.bit.TRB=1;
    EINT;
}

//------------------------------------------жϺ----------------------------------------//
interrupt void Phase_shift(void)
{
    kstep++;

    if(kstep==175)
    {
        istep--;
        EPwm4Regs.TBPHS.half.TBPHS=istep;
//        EPwm6Regs.TBPHS.half.TBPHS=istep;
        kstep=15;
    }
    if(istep==0)							//PWM23
    {
    	EPwm1Regs.ETSEL.bit.INTEN=0;		//PWM1ࣩж
    	EALLOW;
        EPwm2Regs.TBCTR=0;
        EPwm3Regs.TBCTR=0;
        EPwm5Regs.TBCTR=0;
        EPwm6Regs.TBCTR=0;
        CpuTimer0Regs.TCR.bit.TSS = 0;					//PIDжϣʱ0
        DELAY_US(1.6);									//Ϊ˴PWM23ʱPWM1ͬźŶӰ
        SysCtrlRegs.PCLKCR1.bit.EPWM2ENCLK=1;			//PWM23ʱӿ
        SysCtrlRegs.PCLKCR1.bit.EPWM3ENCLK=1;
        SysCtrlRegs.PCLKCR1.bit.EPWM5ENCLK=1;			//PWM23ʱӿ
        SysCtrlRegs.PCLKCR1.bit.EPWM6ENCLK=1;
        EPwm2Regs.TZCLR.bit.OST=1;						//PWM23־λ
        EPwm3Regs.TZCLR.bit.OST=1;
        EPwm5Regs.TZCLR.bit.OST=1;						//PWM23־λ
        EPwm6Regs.TZCLR.bit.OST=1;
//        EPwm5Regs.TBPHS.half.TBPHS=0.007*750;     // λĴֵ 0
//        EPwm5Regs.TBCTL.bit.PHSEN = 1;         // Enable Timer
        EDIS;
    }

    EPwm1Regs.ETCLR.bit.INT=1;							//PWM1жϱ־λ
    PieCtrlRegs.PIEACK.all=PIEACK_GROUP3;				//PIE3ж
}
//------------------------------------------жϺ----------------------------------------//
