/**
 * ---------------------------------------------------------------------------------------
 * ---------------------------------------------------------------------------------------
 * 
 * 	   ǲ
 * 	   ADC 0-3V
 * 	   DAC 0-3V
 * ---------------------------------------------------------------------------------------
 * ʱ䣺2020-10-26
 * ---------------------------------------------------------------------------------------
 */

#include "F28x_Project.h"
#include "SciStdio.h"
#include<math.h>
#include<stdio.h>




#include"Adc.h"

// ʼ DAC Ĵָ
volatile struct DAC_REGS* DAC_PTR[4] = {0x0,&DacaRegs,&DacbRegs,&DaccRegs};

//  ADC οѡ
#define REFERENCE_VDAC		0
#define REFERENCE_VREF		1

//  DAC ͨ
#define DACA				1
#define DACB				2
#define DACC				3


#define REFERENCE			REFERENCE_VREF
#define DAC_NUM				DACA
float dacval = 0;

float32 a1[1024];
unsigned int n=0;
// 洢ADCĴ
//Uint16 AdcaResult[6];
Uint16 AdcbResult[1];
//Uint16 AdccResult[6];
//Uint16 AdcdResult[6];

// 洢ADCʵʵѹֵ
//float Adca_V[6];
float Adcb_V[1];
//float Adcc_V[6];
//float Adcd_V[6];
#define DATA_SIZE 768
Uint16 DATA_BUF[DATA_SIZE]; //һڲ
// 
void configureDAC(Uint16 dac_num);
void test();
void Data_print(void);

__interrupt void cpu_timer0_isr(void);
__interrupt void cpu_timer1_isr(void);  //öʱжadc

void main(void)
{
    float T=7.2;  //DACݲΪ2.4ms

    //double step = 0;
	// ϵͳʼPLLرտŹʹʱ

    test();

    InitSysCtrl();

    // ж
    DINT;

    // ʼPieƼĴ
    InitPieCtrl();

    // ʹжϣжϱ־
    IER = 0x0000;
    IFR = 0x0000;

    // ʼж
    InitPieVectTable();

    // DAC
    configureDAC(DAC_NUM);

    //עжϷ
    EALLOW;
    PieVectTable.TIMER0_INT = &cpu_timer0_isr;
    PieVectTable.TIMER1_INT = &cpu_timer1_isr;
    EDIS;

    //ʼCPUʱ
    InitCpuTimers();

    // CPUʱ  T*(float)(10^(3)/3072
    // 200MHz CPU Freq, 1 second Period (in uSeconds)
    ConfigCpuTimer(&CpuTimer0, 200,T*(float)1000/1024);
    CpuTimer0Regs.TCR.all = 0x4000;   //ʱ

    //  ADCs  ʹ ADC power
    ConfigureADC();

    //  ADCs ת
    SetupADCSoftware();

    ConfigCpuTimer(&CpuTimer1, 200,2.4*(float)1000/256); //ad
    CpuTimer1Regs.TCR.all = 0x4000;   //ʱ

    //ʹܶӦж
    IER |= M_INT1;
    IER |= M_INT13;
    IER |= M_INT14;

    //ʹжӦж
    PieCtrlRegs.PIEIER1.bit.INTx7 = 1;  //ʹܶʱж

    //ʹȫжϺʵʱж
    EINT;
    ERTM;

    // ʼ
    SCIStdioInit();
    // ӡadc
    while(1);


}

void test()
{
    //double a1[1024];
    int t1;
    for(t1=0;t1<1024;t1++)
    {
        a1[t1]=1.5+(float)t1/2560;
    }
}


void configureDAC(Uint16 dac_num)
{
	EALLOW;
	DAC_PTR[dac_num]->DACCTL.bit.DACREFSEL = REFERENCE;
	DAC_PTR[dac_num]->DACOUTEN.bit.DACOUTEN = 1;
	DAC_PTR[dac_num]->DACVALS.all = 0;
	DELAY_US(10); // Delay for buffered DAC to power up
	EDIS;
}

__interrupt void cpu_timer0_isr(void)
{
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1; //0x000112жACKnowledgeĴȫж
    //CpuTimer0.InterruptCount++;
    dacval = (Uint16)((a1[n]/3.0)*4095);
    n = (n==1023)?0:(n+1);
    DAC_PTR[DAC_NUM]->DACVALS.all = dacval;
 }

__interrupt void cpu_timer1_isr(void)
{
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1; //0x000112жACKnowledgeĴȫж
    //    //Ǳÿɼ256㣬Сÿɼ128 ͬһ
//    DELAY_US(1);
//     // ADCB ת
//    AdcbRegs.ADCSOCFRC1.all = 0x003F; //SOC0 ~ SOC5
//    // ȴ ADCB ת
//    while(AdcbRegs.ADCINTFLG.bit.ADCINT1 == 0);
//    AdcbRegs.ADCINTFLGCLR.bit.ADCINT1 = 1;

    AdcbResult[0] = AdcbResultRegs.ADCRESULT5;
    //  ADCs ʵʵѹֵ
    //Adcb_V[0] = (float)AdcbResult[0]*3/4095;

    //int a1;
    //a1 = (int)((Adcb_V[0]-1)*10000);

     //ڴӡ ADC ͨ
    SCIprintf("%d   ",AdcbResult[0]);
    //SCIprintf("Adcb_V = 1.%d\n",a1);
    //SCIprintf("ADCINB0 = %d,Adcb_V = 1.%d\n",AdcbResult[0],a1);
}


