#include "My_Pwm.h"
#include "math.h"

Uint16 i = 0;
float num = 0.0;
float tb = 0.0;     // ƲźƵʵ趨
float quar_tb = 0;  // tb/4(ļ)
float Fre = 50.0;   // ƲƵ
float m = 0.8;      // ƶ

const float sinc[200] =
{
    0.000000, 0.015707, 0.031411, 0.047106, 0.062791, 0.078459, 0.094108, 0.109734, 0.125333, 0.140901,
    0.156434, 0.171929, 0.187381, 0.202787, 0.218143, 0.233445, 0.248690, 0.263873, 0.278991, 0.294040,
    0.309017, 0.323917, 0.338738, 0.353475, 0.368125, 0.382683, 0.397148, 0.411514, 0.425779, 0.439939,
    0.453990, 0.467930, 0.481754, 0.495459, 0.509041, 0.522499, 0.535827, 0.549023, 0.562083, 0.575005,
    0.587785, 0.600420, 0.612907, 0.625243, 0.637424, 0.649448, 0.661312, 0.673013, 0.684547, 0.695913,
    0.707107, 0.718126, 0.728969, 0.739631, 0.750111, 0.760406, 0.770513, 0.780430, 0.790155, 0.799685,
    0.809017, 0.818150, 0.827081, 0.835807, 0.844328, 0.852640, 0.860742, 0.868632, 0.876307, 0.883766,
    0.891007, 0.898028, 0.904827, 0.911403, 0.917755, 0.923880, 0.929776, 0.935444, 0.940881, 0.946085,
    0.951057, 0.955793, 0.960294, 0.964557, 0.968583, 0.972370, 0.975917, 0.979223, 0.982287, 0.985109,
    0.987688, 0.990024, 0.992115, 0.993961, 0.995562, 0.996917, 0.998027, 0.998890, 0.999507, 0.999877,
    1.000000, 0.999877, 0.999507, 0.998890, 0.998027, 0.996917, 0.995562, 0.993961, 0.992115, 0.990024,
    0.987688, 0.985109, 0.982287, 0.979223, 0.975917, 0.972370, 0.968583, 0.964557, 0.960294, 0.955793,
    0.951057, 0.946085, 0.940881, 0.935444, 0.929776, 0.923880, 0.917755, 0.911403, 0.904827, 0.898028,
    0.891007, 0.883766, 0.876307, 0.868632, 0.860742, 0.852640, 0.844328, 0.835807, 0.827081, 0.818150,
    0.809017, 0.799685, 0.790155, 0.780430, 0.770513, 0.760406, 0.750111, 0.739631, 0.728969, 0.718126,
    0.707107, 0.695913, 0.684547, 0.673013, 0.661312, 0.649448, 0.637424, 0.625243, 0.612907, 0.600420,
    0.587785, 0.575005, 0.562083, 0.549023, 0.535827, 0.522499, 0.509041, 0.495459, 0.481754, 0.467930,
    0.453990, 0.439939, 0.425779, 0.411514, 0.397148, 0.382683, 0.368125, 0.353475, 0.338738, 0.323917,
    0.309017, 0.294040, 0.278991, 0.263873, 0.248690, 0.233445, 0.218143, 0.202787, 0.187381, 0.171929,
    0.156434, 0.140901, 0.125333, 0.109734, 0.094108, 0.078459, 0.062791, 0.047106, 0.031411, 0.015707
};  // źΪźţΪڵֵڵֱֵӷ༴



void InitMyEPwm(void)
{
    // For this case just initialize GPIO pins for ePWM1
    InitEPwm1Gpio();  // Disable Pull-up to reduce power consumption
                      // And chose the function of ePWM
    InitEPwm2Gpio();  // Please Remember You need ePWM1 and ePWM2

    // Special for Many ePWM(This operation is unnecessary for single ePWM module)
    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;  // Time-Base CLock Synchronization
                                            // Stop all the TB clocks
    EDIS;

    /******* EPWM Module 1 config ******/
    // Setup TBCLK
    EPwm1Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;  // Count up
    EPwm1Regs.TBPRD = 300;                      // Set timer period;
                                                // The period of PWM = (TBPRD+1)*TBLCK
    EPwm1Regs.TBCTL.bit.PHSEN = TB_DISABLE;     // Disable phase loading(master module)
    EPwm1Regs.TBCTL.bit.PRDLD = TB_IMMEDIATE;   // Load the TBPRD register immediately
    EPwm1Regs.TBCTL.bit.SYNCOSEL = TB_CTR_ZERO; // Sync down-stream module
    EPwm1Regs.TBPHS.half.TBPHS = 0x0000;        // Phase is 0
    EPwm1Regs.TBCTR = 0x0000;                   // Clear counter
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;    // Determine part of the time-base clock prescale value
    EPwm1Regs.TBCTL.bit.CLKDIV = TB_DIV1;       // TBCLK = SYSCLKOUT/(HSPCLKDIV*CLKDIV)


    // Setup shadow register load on ZERO
    EPwm1Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // CMPAΪӰӼĴģʽ
    EPwm1Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    EPwm1Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;  // Load on ZERO
    EPwm1Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    // Set Compare values
    EPwm1Regs.CMPA.half.CMPA = 75;  // Set Compare A value
    EPwm1Regs.CMPB = 225;           // Set Compare B value

    // Set Actions
    EPwm1Regs.AQCTLA.bit.CAU = AQ_SET;   // Force EPWM1A output high
    EPwm1Regs.AQCTLA.bit.CBU = AQ_CLEAR; // Force EPWM1A output low
    EPwm1Regs.AQCTLB.bit.CAU = AQ_SET;
    EPwm1Regs.AQCTLB.bit.CBU = AQ_CLEAR;

    // Setup Dead-band
    EPwm1Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
    EPwm1Regs.DBCTL.bit.IN_MODE  = DBA_RED_DBB_FED;
    EPwm1Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;        // Active high complementary(AHC).EPWMxB is inverted.
    EPwm1Regs.DBFED = 0x000A; // FED-Delay = DBFED  TTBCLK/2(110ns)
    EPwm1Regs.DBRED = 0x000A;

    // Interrupt where we will change the Compare values to Set SPWM
    EPwm1Regs.ETSEL.bit.INTSEL = ET_CTR_ZERO;  // Select INT on ZERO event
    EPwm1Regs.ETSEL.bit.INTEN  = 1;            // Enable INT
    EPwm1Regs.ETPS.bit.INTPRD  = ET_1ST;       // Generate INT on 1st event


    /******* EPWM Module 2 config ******/
    // Setup TBCLK
    EPwm2Regs.TBCTL.bit.CTRMODE = TB_COUNT_UP;  // Count up
    EPwm2Regs.TBPRD = 300;                      // Set timer period;
                                                // The period of PWM = (TBPRD+1)*TBLCK
    EPwm2Regs.TBCTL.bit.PHSEN = TB_ENABLE;      // Enable phase loading(Slave mode)
    EPwm2Regs.TBCTL.bit.PRDLD = TB_IMMEDIATE;   // Load the TBPRD register immediately
    EPwm2Regs.TBCTL.bit.SYNCOSEL = TB_SYNC_IN;  // Sync flow-through
    EPwm2Regs.TBPHS.half.TBPHS = 0x0000;        // Phase is 0
    EPwm2Regs.TBCTR = 0x0000;                   // Clear counter
    EPwm2Regs.TBCTL.bit.HSPCLKDIV = TB_DIV1;    // Determine part of the time-base clock prescale value
    EPwm2Regs.TBCTL.bit.CLKDIV = TB_DIV1;       // TBCLK = SYSCLKOUT/(HSPCLKDIV*CLKDIV)

    // Setup shadow register load on ZERO
    EPwm2Regs.CMPCTL.bit.SHDWAMODE = CC_SHADOW;    // CMPAΪӰӼĴģʽ
    EPwm2Regs.CMPCTL.bit.SHDWBMODE = CC_SHADOW;
    EPwm2Regs.CMPCTL.bit.LOADAMODE = CC_CTR_ZERO;  // Load on ZERO
    EPwm2Regs.CMPCTL.bit.LOADBMODE = CC_CTR_ZERO;

    // Set Compare values
    EPwm2Regs.CMPA.half.CMPA = 75;  // Set Compare A value
    EPwm2Regs.CMPB = 225;           // Set Compare B value

    // Set Actions
    EPwm2Regs.AQCTLA.bit.CAU = AQ_SET;   // Force EPWM1A output high
    EPwm2Regs.AQCTLA.bit.CBU = AQ_CLEAR; // Force EPWM1A output low
    EPwm2Regs.AQCTLB.bit.CAU = AQ_SET;
    EPwm2Regs.AQCTLB.bit.CBU = AQ_CLEAR;

    // Setup Dead-band
    EPwm2Regs.DBCTL.bit.OUT_MODE = DB_FULL_ENABLE;
    EPwm2Regs.DBCTL.bit.IN_MODE  = DBA_RED_DBB_FED;
    EPwm2Regs.DBCTL.bit.POLSEL = DB_ACTV_HIC;        // Active high complementary(AHC).EPWMxB is inverted.
    EPwm2Regs.DBFED = 0x000A; // FED-Delay = DBFED  TTBCLK/2(110ns)
    EPwm2Regs.DBRED = 0x000A;

    // Update_fre(50); // SPWMƵ,ʼΪ100Hz
    EALLOW;
    SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;  // Start all the timers synced
    EDIS;
}


// SPWM˼·TBCTRǵƲεƵйأļй400㣩
// ҲƲĲҪ400PWMСϡԭ--PWM
// עPWMжϴãһμϺһж
// SPWMƵ
void Update_fre(float f)
{
    EPwm1Regs.TBCTR = 0x0000;      // ʱ
    EPwm2Regs.TBCTR = 0x0000;      // ʱ
    tb = round(225000 / f) - 1.0;  // (90Mhz/400)/Fre - 1
    EPwm1Regs.TBPRD = (Uint16)tb;  // ıźŵƵ
    EPwm2Regs.TBPRD = (Uint16)tb;  // ıźŵƵ
    quar_tb = round(tb / 4.0);
}

void Update_sin(void)
{
    if (i < 200)
    {
        num = quar_tb * (1.0 - m * sinc[i]);  // (T/4)*(1.0-M*sinc[i]),
        EPwm1Regs.CMPA.half.CMPA = num;
        EPwm1Regs.CMPB = tb - num;
        EPwm2Regs.CMPA.half.CMPA = num;
        EPwm2Regs.CMPB = tb - num;
        i++;
    }
    else if (i >= 200 && i < 400)
    {
        num = quar_tb * (1.0 + m * sinc[i - 200]);
        EPwm1Regs.CMPA.half.CMPA = num;
        EPwm1Regs.CMPB = tb - num;
        EPwm2Regs.CMPA.half.CMPA = num;
        EPwm2Regs.CMPB = tb - num;

        i++;
    }
    else if (i >= 400)
    {
        i = 0;
        num = quar_tb * (1.0 - m * sinc[i]);
        EPwm1Regs.CMPA.half.CMPA = num;
        EPwm1Regs.CMPB = tb - num;
        EPwm2Regs.CMPA.half.CMPA = num;
        EPwm2Regs.CMPB = tb - num;
        i++;
    }
}

// Ϊǲõ˫ԵƵģԲжһ
interrupt void epwm1_timer_isr(void)
{
    // Update_sin();
    EPwm1Regs.ETCLR.bit.INT = 1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;
}
