//###########################################################################
//
// FILE:    Example_2837xDSci_Echoback.c
//
// TITLE:   SCI Echoback.
//
//! \addtogroup cpu01_example_list
//! <h1>SCI Echoback (sci_echoback)</h1>
//!
//!  This test receives and echo-backs data through the SCI-A port.
//!
//!  The PC application 'hyperterminal' or another terminal
//!  such as 'putty' can be used to view the data from the SCI and
//!  to send information to the SCI.  Characters received
//!  by the SCI port are sent back to the host.
//!
//!  \b Running \b the \b Application
//!  -# Configure hyperterminal or another terminal such as putty:
//!
//!  For hyperterminal you can use the included hyperterminal configuration
//!  file SCI_96.ht.
//!  To load this configuration in hyperterminal
//!    -# Open hyperterminal
//!    -# Go to file->open
//!    -# Browse to the location of the project and
//!       select the SCI_96.ht file.
//!  -# Check the COM port.
//!  The configuration file is currently setup for COM1.
//!  If this is not correct, disconnect (Call->Disconnect)
//!  Open the File-Properties dialogue and select the correct COM port.
//!  -# Connect hyperterminal Call->Call
//!  and then start the 2837xD SCI echoback program execution.
//!  -# The program will print out a greeting and then ask you to
//!  enter a character which it will echo back to hyperterminal.
//!
//!  \note If you are unable to open the .ht file, or you are using
//!  a different terminal, you can open a COM port with the following settings
//!  -  Find correct COM port
//!  -  Bits per second = 9600
//!  -  Date Bits = 8
//!  -  Parity = None
//!  -  Stop Bits = 1
//!  -  Hardware Control = None
//!
//!  \b Watch \b Variables \n
//!  - LoopCount - the number of characters sent
//!
//! \b External \b Connections \n
//!  Connect the SCI-A port to a PC via a transceiver and cable.
//!  - GPIO15 is SCI_A-RXD (Connect to Pin3, PC-TX, of serial DB9 cable)
//!  - GPIO14 is SCI_A-TXD (Connect to Pin2, PC-RX, of serial DB9 cable)
//!
//
//###########################################################################
//
// $Release Date:  $
// $Copyright:
// Copyright (C) 2013-2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//###########################################################################

//
// Included Files
//
#include "F28x_Project.h"
#include "comm_printf.h"
#include "comm_sysconfig.h"
#include "comm_Drv832x.h"
//
// Globals
//
//Uint16 LoopCount;


void spi_xmit(Uint16 a);
//
// Main
//
void main(void)
{

    Uint16 sdata = 0x1212;  // send data
    Uint16 rdata;  // received data
    //char *ReceivedChar;
    char *msg;

//    sysconfig();

        InitSysCtrl();

       //
       // Step 2. Initialize GPIO:
       // This example function is found in the F2837xD_Gpio.c file and
       // illustrates how to set the GPIO to it's default state.
       //
        InitGpio();

       //GPIOMux
       /*
        * SPI gpioMux
        */
        spi_gpioMux();
       /*
        * SCIb gpioMux
        */
        sci_gpioMux();

 //   INTconfig();

   //
       // Step 3. Clear all __interrupts and initialize PIE vector table:
       // Disable CPU __interrupts
       //
          DINT;

       //
       // Initialize PIE control registers to their default state.
       // The default state is all PIE __interrupts disabled and flags
       // are cleared.
       // This function is found in the F2837xD_PieCtrl.c file.
       //
          InitPieCtrl();

       //
       // Disable CPU __interrupts and clear all CPU __interrupt flags:
       //
          IER = 0x0000;
          IFR = 0x0000;

       //
       // Initialize the PIE vector table with pointers to the shell Interrupt
       // Service Routines (ISR).
       // This will populate the entire table, even if the __interrupt
       // is not used in this example.  This is useful for debug purposes.
       // The shell ISR routines are found in F2837xD_DefaultIsr.c.
       // This function is found in F2837xD_PieVect.c.
       //
          InitPieVectTable();

//
// Step 4. User specific code:
//
//  LoopCount = 0;
//   comm_printfInit(&SciaRegs);
   comm_printfInit(&ScibRegs);
   comm_spiInit(&SpibRegs);



   msg = "Hello World!\0";
   uart_printf(msg);

   msg = "\r\nYou will enter a character, and the DSP will echo it back! \n\0";
   uart_printf(msg);

   for(;;)
   {

       //
              // Transmit data
              //
              spi_xmit(sdata);

              //
              // Wait until data is received
              //
              while(SpibRegs.SPIFFRX.bit.RXFFST !=1) { }

              rdata = SpibRegs.SPIRXBUF;



   }


}


void spi_xmit(Uint16 a)
{
    SpibRegs.SPITXBUF = a;
}

//
