//###########################################################################
//
// FILE:   F2837xD_DefaultISR.c
//
// TITLE:  F2837xD Device Default Interrupt Service Routines
//
//###########################################################################
// $TI Release: F2837xD Support Library v150 $
// $Release Date: Thu Mar  5 14:18:39 CST 2015 $
// $Copyright: Copyright (C) 2013-2015 Texas Instruments Incorporated -
//             http://www.ti.com/ ALL RIGHTS RESERVED $
//###########################################################################

#include "main.h"   // main Include File


//---------------------------------------------------------------------------
// CPU Timer 1 Interrupt
Void TIMER1_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// CPU Timer 2 Interrupt
Void TIMER2_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// Datalogging Interrupt
Void DATALOG_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// RTOS Interrupt
Void RTOS_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// Emulation Interrupt
Void EMU_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// Non-Maskable Interrupt
Void NMI_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// Illegal Operation Trap
Void ILLEGAL_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 1
Void USER1_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 2
Void USER2_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 3
Void USER3_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 4
Void USER4_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 5
Void USER5_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 6
Void USER6_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 7
Void USER7_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 8
Void USER8_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 9
Void USER9_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 10
Void USER10_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 11
Void USER11_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// User Defined Trap 12
Void USER12_ISR()
{
    // Insert ISR Code here

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.1 - ADCA Interrupt 1
Void ADCA1_ISR()
{

    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);

}

// 1.2 - ADCB Interrupt 1
Void ADCB1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.3 - ADCC Interrupt 1
Void ADCC1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.4 - XINT1 Interrupt
Void XINT1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.5 - XINT2 Interrupt
Void XINT2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.6 - ADCD Interrupt 1
Void ADCD1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.7 - Timer 0 Interrupt
Void TIMER0_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.8 - Standby and Halt Wakeup Interrupt
Void WAKE_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.1 - ePWM1 Trip Zone Interrupt
Void EPWM1_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.2 - ePWM2 Trip Zone Interrupt
Void EPWM2_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.3 - ePWM3 Trip Zone Interrupt
Void EPWM3_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.4 - ePWM4 Trip Zone Interrupt
Void EPWM4_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.5 - ePWM5 Trip Zone Interrupt
Void EPWM5_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.6 - ePWM6 Trip Zone Interrupt
Void EPWM6_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.7 - ePWM7 Trip Zone Interrupt
Void EPWM7_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.8 - ePWM8 Trip Zone Interrupt
Void EPWM8_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.1 - ePWM1 Interrupt
Void EPWM1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.2 - ePWM2 Interrupt
Void EPWM2_ISR()
{
    // Insert ISR Code here
    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);

}

// 3.3 - ePWM3 Interrupt
Void EPWM3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.4 - ePWM4 Interrupt
Void EPWM4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.5 - ePWM5 Interrupt
Void EPWM5_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.6 - ePWM6 Interrupt
Void EPWM6_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.7 - ePWM7 Interrupt
Void EPWM7_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.8 - ePWM8 Interrupt
Void EPWM8_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 4.1 - eCAP1 Interrupt
Void ECAP1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code

	ECap1Regs.ECCTL2.bit.REARM = 1;
	//	Data_Period.Flag_Hard_CrossingZero = 1;
	ECap1Regs.ECCLR.bit.CEVT1 = 1;
	ECap1Regs.ECCLR.bit.INT = 1;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;

}

// 4.2 - eCAP2 Interrupt
Void ECAP2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
	ECap2Regs.ECCTL2.bit.REARM = 1;
	//	Data_Period.Flag_Hard_CrossingZero = 1;
	ECap2Regs.ECCLR.bit.CEVT1 = 1;
	ECap2Regs.ECCLR.bit.INT = 1;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;
}

// 4.3 - eCAP3 Interrupt
Void ECAP3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 4.4 - eCAP4 Interrupt
Void ECAP4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 4.5 - eCAP5 Interrupt
Void ECAP5_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 4.6 - eCAP6 Interrupt
Void ECAP6_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 5.1 - eQEP1 Interrupt
Void EQEP1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 5.2 - eQEP2 Interrupt
Void EQEP2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 5.3 - eQEP3 Interrupt
Void EQEP3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.1 - SPIA Receive Interrupt
Void SPIA_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.2 - SPIA Transmit Interrupt
Void SPIA_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.3 - SPIB Receive Interrupt
Void SPIB_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code

	if(SpiB_Data.RX_Len < (SIZEOFSPICOMMBUFFER - 4))
	{
		SpiB_Data.RX_State = DATA_RECEIVEING;
		while(SpibRegs.SPIFFRX.bit.RXFFST!=0)
		{
			SpiB_Data.RX_Buf[SpiB_Data.RX_Len++] = SpibRegs.SPIRXBUF & 0xFF;
			if(SpiB_Data.RX_Buf[0] == 0x01) //reply spi master as soon as possible
			{
				SpiB_Send();
			}
		}
	}
	else
	{
		SpiB_Data.RX_Len = 0;
	}

	if( (SpiB_Data.RX_Buf[0] != 2) && (SpiB_Data.RX_Buf[0] != 1))
	{
		SpiB_Data.RX_Len = 0;  //ERROR DATA
	}


	SpibRegs.SPIFFRX.bit.RXFFOVFCLR = 1;	// Clear overflow flag
	SpibRegs.SPIFFRX.bit.RXFFINTCLR = 1; // Clear Interrupt flag

	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;
}

// 6.4 - SPIB Transmit Interrupt
Void SPIB_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.5 - McBSPA Receive Interrupt
Void MCBSPA_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.6 - McBSPA Transmit Interrupt
Void MCBSPA_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.7 - McBSPB Receive Interrupt
Void MCBSPB_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.8 - McBSPB Transmit Interrupt
Void MCBSPB_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 6.9 - SPIC Receive Interrupt
Void SPIC_RX_ISR(void)
{
	if(SpiC_Data.RX_Len < 50)
	{
		while(SpicRegs.SPIFFRX.bit.RXFFST!=0)
		{
			SpiC_Data.RX_Buf[SpiC_Data.RX_Len++] = SpicRegs.SPIRXBUF & 0xFF;
		}
	}
	else
	{
		SpiC_Data.RX_Len = 0;
	}

    SpiC_Data.RX_State = DATA_RECEIVE_END;



	SpicRegs.SPIFFRX.bit.RXFFOVFCLR = 1;	// Clear overflow flag
	SpicRegs.SPIFFRX.bit.RXFFINTCLR = 1;    // Clear Interrupt flag

	PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;
}

// 6.10 - SPIC Transmit Interrupt
Void SPIC_TX_ISR(void)
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP6;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}


// 7.1 - DMA Channel 1 Interrupt
Void DMA_CH1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP7;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 7.2 - DMA Channel 2 Interrupt
Void DMA_CH2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP7;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 7.3 - DMA Channel 3 Interrupt
Void DMA_CH3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP7;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 7.4 - DMA Channel 4 Interrupt
Void DMA_CH4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP7;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 7.5 - DMA Channel 5 Interrupt
Void DMA_CH5_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP7;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 7.6 - DMA Channel 6 Interrupt
Void DMA_CH6_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP7;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 8.1 - I2CA Interrupt 1
Void I2CA_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 8.2 - I2CA Interrupt 2
Void I2CA_FIFO_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 8.3 - I2CB Interrupt 1
Void I2CB_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 8.4 - I2CB Interrupt 2
Void I2CB_FIFO_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 8.5 - SCIC Receive Interrupt
Void SCIC_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code

	  Uint8 u8Temp;

	PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;
	  // Insert ISR Code here
	u8Temp = ScicRegs.SCIRXBUF.bit.SAR;
	if(UART_Data[RS485_PORT_SOLEIL].RX_Len < (SIZEOFMODBUSRXMESSAGEBUFFER - 10))
	{
		UART_Data[RS485_PORT_SOLEIL].RX_Buf[UART_Data[RS485_PORT_SOLEIL].RX_Len++] = u8Temp;
	}
	else
	{
		UART_Data[RS485_PORT_SOLEIL].RX_Len = 0;
	}
	UART_Data[RS485_PORT_SOLEIL].RX_State = DATA_RECEIVEING;
	ScicRegs.SCIFFRX.bit.RXFFOVRCLR = 1;  // Clear Overflow flag
	ScicRegs.SCIFFRX.bit.RXFFINTCLR = 1; // Clear Interrupt flag
}

// 8.6 - SCIC Transmit Interrupt
Void SCIC_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 8.7 - SCID Receive Interrupt
Void SCID_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 8.8 - SCID Transmit Interrupt
Void SCID_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 9.1 - SCIA Receive Interrupt
Void SCIA_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 9.2 - SCIA Transmit Interrupt
Void SCIA_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 9.3 - SCIB Receive Interrupt
Void SCIB_RX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
	  Uint8 u8Temp;

	PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;
	  // Insert ISR Code here
	u8Temp = ScibRegs.SCIRXBUF.bit.SAR;
	if(UART_Data[LCD_PORT].RX_Len < (SIZEOFMODBUSRXMESSAGEBUFFER - 10))
	{
		UART_Data[LCD_PORT].RX_Buf[UART_Data[LCD_PORT].RX_Len++] = u8Temp;
	}
	else
	{
		UART_Data[LCD_PORT].RX_Len = 0;
	}
	UART_Data[LCD_PORT].RX_State = DATA_RECEIVEING;
	ScibRegs.SCIFFRX.bit.RXFFOVRCLR = 1;  // Clear Overflow flag
	ScibRegs.SCIFFRX.bit.RXFFINTCLR = 1; // Clear Interrupt flag
}

// 9.4 - SCIB Transmit Interrupt
Void SCIB_TX_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 9.5 - CANA Interrupt 1
Void CANA_1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    Uint32 status;

    //
    // Read the CAN-B interrupt status to find the cause of the interrupt
    //
    status = CANIntStatus(CANA_BASE, CAN_INT_STS_CAUSE);

    //
    // If the cause is a controller status interrupt, then get the status
    //
    if(status == CAN_INT_INT0ID_STATUS)
    {
        //
        // Read the controller status.  This will return a field of status
        // error bits that can indicate various errors.  Error processing
        // is not done in this example for simplicity.  Refer to the
        // API documentation for details about the error status bits.
        // The act of reading this status will clear the interrupt.
        //
        status = CANStatusGet(CANA_BASE, CAN_STS_CONTROL);

        //
        // Check to see if an error occurred.
        //
        if(((status  & ~(CAN_ES_RXOK)) != 7) &&
           ((status  & ~(CAN_ES_RXOK)) != 0))
        {
            //
            // Set a flag to indicate some errors may have occurred.
            //
            //errorFlag = 1;
        	errorFlag++;//20160506 modified by qrz
        }
    }
    //
    // Check if the cause is the CAN-B receive message object 1
    //
    else if(status == RX_MSG_OBJ_ID)
    {
        //
        // Get the received message
        //
        CANMessageGet(CANA_BASE, RX_MSG_OBJ_ID, &sRXCANMessage, true);

        //
        // Getting to this point means that the RX interrupt occurred on
        // message object 1, and the message RX is complete.  Clear the
        // message object interrupt.
        //
        CANIntClear(CANA_BASE, RX_MSG_OBJ_ID);

        //
        // Increment a counter to keep track of how many messages have been
        // received. In a real application this could be used to set flags to
        // indicate when a message is received.
        //
        rxMsgCount++;

    	if(txMsgData[0] == rxMsgData[0] && txMsgData[1] == rxMsgData[1] &&  txMsgData[2] == rxMsgData[2] && txMsgData[3] == rxMsgData[3])
        {
            //CANMessageSet(CANA_BASE, TX_MSG_OBJ_ID, &sTXCANMessage,
            //             MSG_OBJ_TYPE_TX);

            //txMsgCount++;

            //rxMsgData[0] = 0;
            //rxMsgData[1] = 0;
           // rxMsgData[2] = 0;
           // rxMsgData[3] = 0;
            memset((void*)&rxMsgData,0,sizeof(rxMsgData));
        }
        else
        {
            //errorFlag = 1;//20160506 modified by qrz
        	errorFlag++;
        }
        //
        // Since the message was received, clear any error flags.
        //
        //errorFlag = 0;
    }
    //
    // If something unexpected caused the interrupt, this would handle it.
    //
    else
    {
        //
        // Spurious interrupt handling can go here.
        //
    }

    //
    // Clear the global interrupt flag for the CAN interrupt line
    //
    CANGlobalIntClear(CANA_BASE, CAN_GLB_INT_CANINT0);

    //
    // Acknowledge this interrupt located in group 9
    //
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;
}

// 9.6 - CANA Interrupt 2
Void CANA_2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 9.7 - CANB Interrupt 1
Void CANB_1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 9.8 - CANB Interrupt 2
Void CANB_2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.1 - ADCA Event Interrupt
Void ADCA_EVT_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.2 - ADCA Interrupt 2
Void ADCA2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.3 - ADCA Interrupt 3
Void ADCA3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.4 - ADCA Interrupt 4
Void ADCA4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.5 - ADCB Event Interrupt
Void ADCB_EVT_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.6 - ADCB Interrupt 2
Void ADCB2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.7 - ADCB Interrupt 3
Void ADCB3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.8 - ADCB Interrupt 4
Void ADCB4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.1 - CLA1 Interrupt 1
Void CLA1_1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.2 - CLA1 Interrupt 2
Void CLA1_2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.3 - CLA1 Interrupt 3
Void CLA1_3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.4 - CLA1 Interrupt 4
Void CLA1_4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.5 - CLA1 Interrupt 5
Void CLA1_5_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.6 - CLA1 Interrupt 6
Void CLA1_6_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.7 - CLA1 Interrupt 7
Void CLA1_7_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 11.8 - CLA1 Interrupt 8
Void CLA1_8_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP11;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.1 - XINT3 Interrupt
Void XINT3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.2 - XINT4 Interrupt
Void XINT4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.3 - XINT5 Interrupt
Void XINT5_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.6 - VCU Interrupt
Void VCU_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.7 - FPU Overflow Interrupt
Void FPU_OVERFLOW_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.8 - FPU Underflow Interrupt
Void FPU_UNDERFLOW_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.13 - IPC Interrupt 0
Void IPC0_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
	tIpcMessage sMessage;

    // Continue processing messages as long as CPU01 to CPU02 GetBuffer1 is full
    while (IpcGet(&g_sIpcController1, &sMessage,
                  DISABLE_BLOCKING) != STATUS_FAIL)
    {
        switch (sMessage.ulcommand)
        {
        case IPC_DATA_WRITE:

            IPCRtoLDataWrite(&sMessage);
            break;
        case IPC_DATA_READ:

            IPCRtoLDataRead(&g_sIpcController1, &sMessage, ENABLE_BLOCKING);
            break;
        case IPC_FUNC_CALL:

            IPCRtoLFunctionCall(&sMessage);

                   break;
        default:
            break;
        }
    }

    // Acknowledge IPC INT0 Flag and PIE to receive more interrupts
    IpcRegs.IPCACK.bit.IPC0 = 1;
    PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

}

// 1.14 - IPC Interrupt 1
Void IPC1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
	Gpio_Toggle(83);
    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
	Semaphore_post(SEM_ZeroCrossing);			//Post SEM_ZeroCrossing For TSK_ZeroCrossing
	// Acknowledge IPC INT0 Flag and PIE to receive more interrupts
	IpcRegs.IPCACK.bit.IPC1 = 1;
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

// 1.15 - IPC Interrupt 2
Void IPC2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 1.16 - IPC Interrupt 3
Void IPC3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.9 - ePWM9 Trip Zone Interrupt
Void EPWM9_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.10 - ePWM10 Trip Zone Interrupt
Void EPWM10_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.11 - ePWM11 Trip Zone Interrupt
Void EPWM11_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 2.12 - ePWM12 Trip Zone Interrupt
Void EPWM12_TZ_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP2;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.9 - ePWM9 Interrupt
Void EPWM9_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.10 - ePWM10 Interrupt
Void EPWM10_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.11 - ePWM11 Interrupt
Void EPWM11_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 3.12 - ePWM12 Interrupt
Void EPWM12_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP3;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 5.9 - SD1 Interrupt
Void SD1_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 5.10 - SD2 Interrupt
Void SD2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP5;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}



// 8.15 - uPPA Interrupt
Void UPPA_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP8;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 9.15 - USBA Interrupt
Void USBA_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP9;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.9 - ADCC Event Interrupt
Void ADCC_EVT_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.10 - ADCC Interrupt 2
Void ADCC2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.11 - ADCC Interrupt 3
Void ADCC3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.12 - ADCC Interrupt 4
Void ADCC4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.13 - ADCD Event Interrupt
Void ADCD_EVT_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.14 - ADCD Interrupt 2
Void ADCD2_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.15 - ADCD Interrupt 3
Void ADCD3_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 10.16 - ADCD Interrupt 4
Void ADCD4_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP10;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.9 - EMIF Error Interrupt
Void EMIF_ERROR_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.10 - RAM Correctable Error Interrupt
Void RAM_CORRECTABLE_ERROR_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.11 - Flash Correctable Error Interrupt
Void FLASH_CORRECTABLE_ERROR_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.12 - RAM Access Violation Interrupt
Void RAM_ACCESS_VIOLATION_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.13 - System PLL Slip Interrupt
Void SYS_PLL_SLIP_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.14 - Auxiliary PLL Slip Interrupt
Void AUX_PLL_SLIP_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.15 - CLA Overflow Interrupt
Void CLA_OVERFLOW_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

// 12.16 - CLA Underflow Interrupt
Void CLA_UNDERFLOW_ISR()
{
    // Insert ISR Code here

    // To receive more interrupts from this PIE group,
    // acknowledge this interrupt.
    // PieCtrlRegs.PIEACK.all = PIEACK_GROUP12;

    // Next two lines for debug only to halt the processor here
    // Remove after inserting ISR Code
    asm ("      ESTOP0");
    for(;;);
}

//---------------------------------------------------------------------------
// Catch-all Default ISRs:

// Reserved ISR
Void PIE_RESERVED_ISR()
{
    asm ("      ESTOP0");
    for(;;);
}

// Only does a return
Void EMPTY_ISR()
{

}

// Unused ISR
Void NOTUSED_ISR()
{
    asm ("      ESTOP0");
    for(;;);
}

