/*=============================================================================*
 ***  FILENAME 	: RuningManage.c 
 ***  TITLE		: For interver mode logic process.
================================================================================*/

#include "main.h"


union STATE_FAULT  State_Fault;


void Switch_ComTskStart(void);
/**********************************************************************
***Name		: TSK_ModeSwitch()
***Function	: for inverter work mode switch
***Called by	:
**********************************************************************/
Void TSK_ModeSwitch(Void)
{
	static Uint16 timer_Cnt = 0;
	//--- System Initialization
	SysCfg_Init();
	Init_ConfigGpio();
	Init_Devcfg();
	while(1)
	{
		Semaphore_pend(SEM_Timer2msForStateMachine, BIOS_WAIT_FOREVER);
		{
			Switch_FaultCheck();
			Switch_StateManage();
			Gpio_Control();
			if((State_Flag.bit.PWM_Module1_Enable == 1) ||( State_Flag.bit.PWM_Module2_Enable == 1)
					||( State_Flag.bit.PWM_Module3_Enable == 1))
			{
				//calculate Id ref with 2ms period
				MPPT_Obtain_IdRef();
				//MPPT_Obtain_IdRef_Fixed();
			}
			else
			{

			}

			Switch_ComTskStart();
			UART_DealWith_Send(LCD_PORT);
			UART_DealWith_Send(RS485_PORT_SOLEIL);
		//	SpiB_DealWith_Send();
			timer_Cnt++;
			if(timer_Cnt >= 50)
			{
				timer_Cnt = 0;
				#if 1
		        if(txMsgCount < rxMsgCount && rxMsgCount != 0)//for CAN test
		        {

		            CANMessageSet(CANA_BASE, TX_MSG_OBJ_ID, &sTXCANMessage,
		                       MSG_OBJ_TYPE_TX);
		            txMsgCount++;
		            txMsgData[4] += 0x1;
		            txMsgData[5] += 0x2;
		            txMsgData[6] += 0x3;
		            txMsgData[7] += 0x4;
		        }
				#endif
			}
		}

	}

		
}



/**********************************************************************
***Name		: Switch_Init()
***Function	:
***Called by	:
**********************************************************************/
void Switch_Init(void)
{
	memset((void*)&State_Flag,0,sizeof(State_Flag));
	memset((void*)&State_Fault,0,sizeof(State_Fault));
	memset((void*)&State_Switch,0,sizeof(State_Switch));
	State_Switch.State_Working = StateWaiting;
	State_Fault.bit.Fault_Stop_Command = 1;
	State_Flag.bit.Contactor_DC_Enable = 1;

}


/**********************************************************************
***Name		: Switch_StateWaiting()
***Function	:
***Called by	:
**********************************************************************/
void Switch_StateWaiting(void)
{
	static Uint16 Delaycnt = 0;

	if (State_Flag.bit.State_Fault_Flag == 1)          // fault
	{
		State_Switch.State_Working = StateFault;
	}
	else
	{
		#ifdef TempDebug
		if (Data_Period.Mean_Vdc1 >= SysConfig.TurnOn_Volt)
		{
			Delaycnt ++;
			if (Delaycnt > 1500)  /// 3s
			{
				Delaycnt = 0;
				State_Switch.State_Working = StateChecking;

				//Initial Check State needed  Parameters
				State_Switch.CheckingTime_Cnt = (Uint32)SysConfig.Check_Time*TIME_2MS_PERIOD;//10s for test
				//State_Flag.bit.Contactor_DC_Enable = 1;
			}
		}
		else
		{
			Delaycnt = 0;
			State_Switch.State_Working = StateWaiting;

		}
		#endif
	}
	//Close PWM
	State_Flag.bit.PWM_Module1_Enable = 0;
	State_Flag.bit.PWM_Module2_Enable = 0;
	State_Flag.bit.PWM_Module3_Enable = 0;
	//Disconnect Contactor
	State_Flag.bit.Contactor_Module1_Enable = 0;
	State_Flag.bit.Contactor_Module2_Enable = 0;
	State_Flag.bit.Contactor_Module3_Enable = 0;
	State_Flag.bit.Contactor_Slave_Enable = 0;
	State_Switch.ContactorTime_Cnt = 0;

}


/**********************************************************************
***Name		: Switch_StateChecking()
***Function	:
***Called by	:
**********************************************************************/
void Switch_StateChecking(void)
{

	if (State_Flag.bit.State_Fault_Flag == 1)          // fault
	{
		State_Switch.State_Working = StateFault;
	}
	else
	{
		#ifdef TempDebug
		if (Data_Period.Mean_Vdc1 >= SysConfig.TurnOn_Volt)
		{
			if (State_Switch.CheckingTime_Cnt > 0)  /// 3s
			{
				State_Switch.CheckingTime_Cnt--;

			}
			else
			{
				Switch_Control_ACContactor();
			}
		}
		else
		{
			State_Switch.State_Working = StateWaiting;
			State_Switch.CheckingTime_Cnt = (Uint32)SysConfig.Check_Time*TIME_2MS_PERIOD;//10s for test
			State_Switch.ContactorTime_Cnt = 0;
		}
		#endif
	}


}


/**********************************************************************
***Name		: Switch_StateRuning()
***Function	:
***Called by	:
**********************************************************************/
void Switch_StateRuning(void)
{

	if (State_Flag.bit.State_Fault_Flag == 1)          // fault
	{
		State_Switch.State_Working = StateFault;
	}
	else
	{



	}


}


/**********************************************************************
***Name		: Switch_StateFault()
***Function	:
***Called by	:
**********************************************************************/
void Switch_StateFault(void)
{

	if (State_Flag.bit.State_Fault_Flag == 1)          // fault
	{
		State_Switch.State_Working = StateFault;
	}
	else
	{
		State_Switch.State_Working = StateWaiting;

	}
	//Close PWM
	State_Flag.bit.PWM_Module1_Enable = 0;
	State_Flag.bit.PWM_Module2_Enable = 0;
	State_Flag.bit.PWM_Module3_Enable = 0;
	//Disconnect Contactor
	State_Flag.bit.Contactor_Module1_Enable = 0;
	State_Flag.bit.Contactor_Module2_Enable = 0;
	State_Flag.bit.Contactor_Module3_Enable = 0;
	State_Flag.bit.Contactor_Slave_Enable = 0;
	//State_Flag.bit.Contactor_DC_Enable = 0;


}



/**********************************************************************
***Name		: Switch_StateManage()
***Function	:
***Called by	:
**********************************************************************/
void Switch_StateManage(void)
{

	switch (State_Switch.State_Working)
	{
		case StateWaiting:
			Switch_StateWaiting();			// waiting  state
			break;

		case StateChecking:
			Switch_StateChecking();			//  checking  state
			break;

		case StateRuning:
			Switch_StateRuning();			// running  state
			break;

		case StateFault:
			Switch_StateFault();				// fault state
			break;
		default:
			break;
	}


}

/**********************************************************************
***Name		: Switch_Control_ACContactor()
***Function	:
***Called by	:
**********************************************************************/
void Switch_Control_ACContactor(void)
{
	State_Switch.ContactorTime_Cnt++;
	switch (State_Switch.ContactorTime_Cnt)
	{
		case 5:        // 10ms
		{
			State_Flag.bit.Contactor_Slave_Enable = 1;
		}
			break;

		case 1000:   ///2S
		{
			State_Flag.bit.Contactor_Module1_Enable = 1;
			State_Flag.bit.Contactor_Module2_Enable = 1;
		}
			break;

		case 2000:   // 4S
		{
			State_Flag.bit.Contactor_Slave_Enable = 0;
		}
			break;

		case  4000:  //8S
		{
			#ifdef TempDebug
			if (Data_Period.Mean_Vdc1 >= SysConfig.TurnOn_Volt)
			{
				State_Flag.bit.PWM_Module1_Enable = 1;
				State_Flag.bit.PWM_Module2_Enable = 1;
				State_Flag.bit.PWM_Module3_Enable = 1;

				State_Switch.State_Working = StateRuning;
			}
			else
			{
				State_Switch.CheckingTime_Cnt = (Uint32)SysConfig.Check_Time*TIME_2MS_PERIOD;//10s for test

				State_Switch.State_Working = StateWaiting;

				//Disconnect Contactor
				State_Flag.bit.Contactor_Module1_Enable = 0;
				State_Flag.bit.Contactor_Module2_Enable = 0;
				State_Flag.bit.Contactor_Module3_Enable = 0;
				State_Flag.bit.Contactor_Slave_Enable = 0;
				//State_Flag.bit.Contactor_DC_Enable = 0;
			}
			#endif
			State_Switch.ContactorTime_Cnt = 0;
		}
			break;

		default:
			break;
	}

}

/**********************************************************************
***Name		: Switch_FaultCheck()
***Function	:
***Called by	:
**********************************************************************/
void Switch_FaultCheck(void)
{
	if ((0 == State_Fault.Word.Word0) && (0 == State_Fault.Word.Word1)
		&& (0 == State_Fault.Word.Word2) && (0 == State_Fault.Word.Word3)
		&& (0 == State_Fault.Word.Word4) && (0 == State_Fault.Word.Word5)
		&& (0 == State_Fault.Word.Word6))
	{
		State_Flag.bit.State_Fault_Flag = 0;
	}
	else
	{
		State_Flag.bit.State_Fault_Flag = 1;
	}
}
/*=============================================================================*
 * FUNCTION: All_Faults_Clear()
 * PURPOSE : clear all faults
 * CALLED BY:
 *
 *============================================================================*/
void ALL_Faults_Clear(void)
{
	State_Fault.Word.Word0 = 0;
	State_Fault.Word.Word1 = 0;
	State_Fault.Word.Word2 = 0;
	State_Fault.Word.Word3 = 0;
	State_Fault.Word.Word4 = 0;
	State_Fault.Word.Word5 = 0;
	State_Fault.Word.Word6 = 0;
}

/**********************************************************************
***Name		: Switch_ComTskStart()
***Function	:
***Called by	:
**********************************************************************/
void Switch_ComTskStart(void)
{

	if(SpibRegs.SPIFFRX.bit.RXFFOVF == 1)   //If receive error is detected, reset receiver
	{
		SpibRegs.SPICCR.bit.SPISWRESET = 0; // Reset SPI
		SpibRegs.SPICCR.bit.SPISWRESET = 1; // Reset SPI
	}
	//  Ҫ;жݴǷ
	if(SpiB_Data.RX_State < DATA_SPIRECEIVE_END)
	{
		SpiB_Data.RX_State++;
		if(SpiB_Data.RX_State == DATA_SPIRECEIVE_END)
		{
			SpiB_Data.RX_Active = 1;
			Semaphore_post(SEM_StartCommTsk);
		}
	}
	else
	{
		SpiB_Data.RX_State = DATA_SPIRECEIVE_END;

	}

	// LCD
	if(UART_Data[LCD_PORT].RX_State < DATA_RECEIVE_END)
	{
		UART_Data[LCD_PORT].RX_State++;
		if(UART_Data[LCD_PORT].RX_State == DATA_RECEIVE_END)
		{
			UART_Data[LCD_PORT].RX_Active = 1;
			Semaphore_post(SEM_StartCommTsk);
		}
	}
	else
	{
		UART_Data[LCD_PORT].RX_State = DATA_RECEIVE_END;

	}
	// RS485
	if(UART_Data[RS485_PORT_SOLEIL].RX_State < DATA_RECEIVE_END)
	{
		UART_Data[RS485_PORT_SOLEIL].RX_State++;
		if(UART_Data[RS485_PORT_SOLEIL].RX_State == DATA_RECEIVE_END)
		{
			UART_Data[RS485_PORT_SOLEIL].RX_Active = 1;
			Semaphore_post(SEM_StartCommTsk);

		}
	}
	else
	{
		UART_Data[RS485_PORT_SOLEIL].RX_State = DATA_RECEIVE_END;

	}



}


