
//================================constant for ADC===========================//
#define ADC_PU_SCALE_FACTOR  (float32_t)(0.0002442002442002f)// 1/4095
#define ADC_PU_SCALE_VOLTAGE  (float32_t)(0.105024593248f)//max sense 430.18f
#define ADC_PU_SCALE_IBUS   (float32_t)(0.0100146671f)//amplify 28.16382 times,adjust *1.05
//###########################################################################//


//================================constant for math==========================//
#define INV_SQRT2    (float32_t)(0.707106781187f)
#define SQRT2   (float32_t)1.414213562373f
#define PI_VALUE (float32_t)3.141592653589f
#define PI_VALUE_DIV2   (float32_t)1.570796326794f
//###########################################################################//

//================================Protection set=============================//
#define OCP_POINT 3.0f//max OUTPUT current point
#define OVP_POINT_S 405.0f//software OVP point
#define OVP_POINT_H 425.0f//hardware OVP point
//###########################################################################//

//ac zero cross threshold
#define PWM_SWITCHING_NZC1 (float32_t)0.01f
#define PWM_SWITCHING_NZC2 (float32_t)-0.01f
#define PWM_SWITCHING_PZC1 (float32_t)-0.01f
#define PWM_SWITCHING_PZC2 (float32_t)0.01f

//PWM limit value
#define MAX_PWM_PERIOD  (uint16_t)1000//10us
#define MIN_PWM_PERIOD  (uint16_t)300//3us
#define SET_DB_OFF_PWM  (uint16_t)8000//<2^13
#define SET_PERID_OFF_PWM   (uint16_t)100//

#define state_slew_max  (uint16_t)5//state


enum enum_BuildLevel
{
        BuildLevel1_OpenLoop_AC = 0,
        BuildLevel1_OpenLoop_DC=1,
        BuildLevel2_CurrentLoop_AC = 2,
        BuildLevel2_CurrentLoop_DC = 3,
        BuildLevel3_VoltageLoop_AC = 4,
        BuildLevel3_VoltageLoop_DC = 5,
        BuildLevel1_OpenLoop_AC_CLA = 6,
        BuildLevel1_OpenLoop_DC_CLA = 7,
        BuildLevel2_CurrentLoop_AC_CLA = 8,
        BuildLevel2_CurrentLoop_DC_CLA = 9,
        BuildLevel3_VoltageLoop_AC_CLA = 10,
        BuildLevel3_VoltageLoop_DC_CLA = 11,
};

enum enum_boardState
{
        boardState_OFF = 0,
        boardState_CheckACInput = 1,
        boardState_RlyConnect = 2,
        boardState_PowerStageON=3,
        boardState_TripCondition = 4,
};

enum enum_boardStatus
{
        boardStatus_Idle = 0,
        boardStatus_NoFault=1,
        boardStatus_OverCurrentTrip = 2,
        boardStatus_EmulatorStopTrip = 3,
        boardStatus_OverVoltageTrip = 4,
        boardStatus_InputUnderVoltageTrip = 5,
};

enum enum_pwmSwState
{
        pwmSwState_normalOperation = 0,
        pwmSwState_positiveHalf = 1,
        pwmSwState_negativeZeroCrossing1=2,
        pwmSwState_negativeZeroCrossing2=3,
        pwmSwState_negativeZeroCrossing3=4,
        pwmSwState_negativeHalf = 5,
        pwmSwState_positiveZeroCrossing1=6,
        pwmSwState_positiveZeroCrossing2=7,
        pwmSwState_positiveZeroCrossing3=8,
        pwmSwState_defaultState=9,
};

enum enum_interleavingState
{
        interleavingState_1ph = 0,
        interleavingState_2ph = 1,
        interleavingState_3ph = 2,
};



/*void computeNotchFltrCoeff(DCL_DF22 *coeff, float32_t Fs, float32_t notch_freq,
                           float32_t c1, float32_t c2)
{
    float32_t temp1;
    float32_t temp2;
    float32_t wn2;
    float32_t Ts;
    Ts=1/Fs;

    // pre warp the notch frequency
    wn2=2*Fs*tanf(notch_freq* PI_VALUE*Ts);

    temp1= 4*Fs*Fs + 4* wn2 * c2 * Fs + wn2*wn2;
    temp2= 1/ ( 4*Fs*Fs + 4* wn2 * c1 * Fs + wn2*wn2);

    coeff->b0 = temp1* temp2;
    coeff->b1 = (-8*Fs*Fs + 2* wn2* wn2)* temp2;
    coeff->b2 = (4*Fs*Fs-4*wn2*c2*Fs+wn2*wn2)*temp2;
    coeff->a1 = (-8*Fs*Fs + 2* wn2* wn2)*temp2;
    coeff->a2 = (4*Fs*Fs-4*wn2*c1*Fs+wn2*wn2)*temp2;

computeNotchFltrCoeff( &notch1,
    (float32_t)(INSTRUMENTATION_ISR_FREQUENCY),
    (float32_t)(sine_mains.acFreq*2.0) ,
    0.25,
    0.00001);
}
void computeNotchFltrCoeff1(DCL_DF22 *coeff, float32_t Fs, float32_t notch_freq,
                           float32_t c1, float32_t c2)
{
    float32_t temp1;
    float32_t temp2;
    float32_t wn2;
    float32_t Ts;
    Ts=1/Fs;

    // pre warp the notch frequency
    wn2=2*Fs*tanf(notch_freq* PI_VALUE*Ts);

    temp1= 4*Fs*Fs + 4* wn2 * c2 * Fs + wn2*wn2;
    temp2= 1/ ( 4*Fs*Fs + 4* wn2 * c1 * Fs + wn2*wn2);

    coeff->b0 = temp1* temp2;
    coeff->b1 = (-8*Fs*Fs + 2* wn2* wn2)* temp2;
    coeff->b2 = (4*Fs*Fs-4*wn2*c2*Fs+wn2*wn2)*temp2;
    coeff->a1 = (-8*Fs*Fs + 2* wn2* wn2)*temp2;
    coeff->a2 = (4*Fs*Fs-4*wn2*c1*Fs+wn2*wn2)*temp2;
    coeff->x1=0;
    coeff->x2=0;
}*/
