/*==================================================================================*/
/*	User specific Linker command file for running from FLASH						*/
/*==================================================================================*/
/*	FILE:			F28035_FLASH_Lighting_DCDC.CMD                                    */
/*                                                                                  */
/*	Description:	Linker command file for User custom sections targetted to run   */
/*					from FLASH.  			                                        */
/*                                                                                  */
/*  Target:  		TMS320F28035                                */
/*                                                                                  */
/*	Version: 		1.00                                							*/
/*                                                                                  */
/*----------------------------------------------------------------------------------*/
/*  Copyright Texas Instruments 2009                                			    */
/*----------------------------------------------------------------------------------*/
/*  Revision History:                                                               */
/*----------------------------------------------------------------------------------*/
/*  Date	  | Description                                                         */
/*----------------------------------------------------------------------------------*/
/*  4/13/09  | Release 1.0  		New release.                                    */
/*----------------------------------------------------------------------------------*/
 

/* Define the memory block start/length for the F28035
   PAGE 0 will be used to organize program sections
   PAGE 1 will be used to organize data sections

   Notes:
         Memory blocks on F2803x are uniform (ie same
         physical memory) in both PAGE 0 and PAGE 1.
         That is the same memory region should not be
         defined for both PAGE 0 and PAGE 1.
         Doing so will result in corruption of program
         and/or data.

         L0 memory block is mirrored - that is
         it can be accessed in high memory or low memory.
         For simplicity only one instance is used in this
         linker file.

         Contiguous SARAM memory blocks or flash sectors can be
         be combined if required to create a larger memory block.
*/

_Cla1Prog_Start = _Cla1funcsRunStart;
-heap 0x200
-stack 0x200

// Define a size for the CLA scratchpad area that will be used
// by the CLA compiler for local symbols and temps
// Also force references to the special symbols that mark the
// scratchpad are.
 CLA_SCRATCHPAD_SIZE = 0x100;
--undef_sym=__cla_scratchpad_end
--undef_sym=__cla_scratchpad_start


MEMORY
{
/* Note that the memory allocation below does not create sections as necessary for
   the CLA on the F2803x. Please download the Peripheral Files and Example Projects 
   collection (SPRC832) and look at the cla_adc project for information on how to 
   define sections for the CLA.
*/

PAGE 0:
	/*progRAM	    : origin = 0x3F8000, length = 0x000800  */        /* on-chip RAM (L0)*/
	progRAM	    : origin = 0x000400, length = 0x000400     /* on-chip RAM (M1)*/
	RAML3       : origin = 0x009000, length = 0x000f00     /* on-chip RAM block L3 */
	OTP         : origin = 0x3D7800, length = 0x000400     /* on-chip OTP */
	FLASHH      : origin = 0x3E8000, length = 0x002000     /* on-chip FLASH */
	FLASHG      : origin = 0x3EA000, length = 0x002000     /* on-chip FLASH */
//	FLASHF      : origin = 0x3EC000, length = 0x002000     /* on-chip FLASH */
	//FLASHEDF    : origin = 0x3EC002, length = 0x005ffE     /* on-chip FLASH */
    FLASHEDF    : origin = 0x3EC002, length = 0x005ffD     /* on-chip FLASH */
    PROM_VERIFY : origin =0x3F1fff,  length =0x000001        /*Уֵ*/
//	FLASHED     : origin = 0x3EE002, length = 0x003ffe     /* on-chip FLASH */
//	FLASHD      : origin = 0x3F0000, length = 0x002000     /* on-chip FLASH */
	FLASHC      : origin = 0x3F2000, length = 0x002000     /* on-chip FLASH */
	FLASHB      : origin = 0x3F4000, length = 0x002000     /* on-chip FLASH */
	FLASHA      : origin = 0x3F6000, length = 0x001F80     /* on-chip FLASH */
	CSM_RSVD    : origin = 0x3F7F80, length = 0x000076     /* Part of FLASHA.  Program with all 0x0000 when CSM is in use. */
	//BEGIN       : origin = 0x3F7FF6, length = 0x000002     /* Part of FLASHA.  Used for "boot to Flash" bootloader mode. */
	BEGIN       : origin = 0x3EC000, length = 0x000002
	CSM_PWL     : origin = 0x3F7FF8, length = 0x000008     /* Part of FLASHA.  CSM password locations in FLASHA */

	IQTABLES    : origin = 0x3FE000, length = 0x000B50     /* IQ Math Tables in Boot ROM */
	IQTABLES2   : origin = 0x3FEB50, length = 0x00008C     /* IQ Math Tables in Boot ROM */
	IQTABLES3   : origin = 0x3FEBDC, length = 0x0000AA     /* IQ Math Tables in Boot ROM */

	BOOTROM     : origin = 0x3FF27C, length = 0x000D44     /* Boot ROM */
	RESET       : origin = 0x3FFFC0, length = 0x000002     /* part of boot ROM  */
	VECTORS     : origin = 0x3FFFC2, length = 0x00003E     /* part of boot ROM  */

PAGE 1 : 
	BOOT_RSVD   : origin = 0x000000, length = 0x000050     /* Part of M0, BOOT rom will use this for stack */
	RAMM0       : origin = 0x000050, length = 0x0006B0     /* on-chip RAM block M0 */
   	RAMM1       : origin = 0x009f00, length = 0x000100     /* on-chip RAM block M1 */
   	RAML2		: origin = 0x008C00, length = 0x000400	   /* on-chip RAM block L2 */
	dataRAM	    : origin = 0x008000, length = 0x000C00     /* data RAM (L0-L2) */
//	claRAM      : origin = 0x008C00, length = 0x000400
	//FLASHB      : origin = 0x3F4000, length = 0x002000     /* on-chip FLASH */


	CLA_CPU_MSGRAM  : origin = 0x001480, length = 0x000080 /* CLA-R/W, CPU-R message RAM */
	CPU_CLA_MSGRAM  : origin = 0x001500, length = 0x000080 /* CPU-R/W, CLA-R message RAM */
}
 
 
SECTIONS
{
   /* Allocate program areas: */
   .cinit            : > FLASHEDF,     PAGE = 0
   .pinit            : > FLASHEDF,     PAGE = 0
   .text             : > FLASHEDF,    PAGE = 0

   codestart         : > BEGIN       PAGE = 0


   ramfuncs          : LOAD = FLASHEDF,
                       RUN = progRAM, 
                       LOAD_START(_RamfuncsLoadStart),
                       LOAD_END(_RamfuncsLoadEnd),
                       RUN_START(_RamfuncsRunStart),
                       PAGE = 0

   DLID        		 : > OTP     PAGE = 0
   csmpasswds        : > CSM_PWL     PAGE = 0
   csm_rsvd          : > CSM_RSVD    PAGE = 0
   
   /* Allocate uninitalized data sections: */
   .stack            : > RAMM0,      PAGE = 1
   .ebss             : > dataRAM,    PAGE = 1
   .esysmem          : > dataRAM,      PAGE = 1
//   	Cla1Data		 : > RAML2, 	 PAGE = 1

   .stack              : > dataRAM       PAGE = 1
   .cio                : > RAMM1      PAGE = 1
   .sysmem             : > RAMM1      PAGE = 1


	Cla1Prog        : LOAD = FLASHEDF,
	                 RUN = RAML3,
	                 LOAD_START(_Cla1funcsLoadStart),
	                 LOAD_END(_Cla1funcsLoadEnd),
	                 RUN_START(_Cla1funcsRunStart),
	                 LOAD_SIZE(_Cla1funcsLoadSize),
	                 PAGE = 0

   	.bss_cla		 : > RAMM1,   PAGE = 1
//   	.const_cla		 : > RAML2,   PAGE = 1
   .scratchpad       : > RAML2,   PAGE = 1
// 	Cla1Data		 : > RAML2, 	 PAGE = 1

   /* Initalized sections go in Flash */
   /* For SDFlash to program these, they must be allocated to page 0 */
   //.econst           : > FLASHA      PAGE = 0
   //-------20140322gjh-----------//
   .econst           : > FLASHEDF      PAGE = 0
   .switch           : > FLASHEDF      PAGE = 0



   /* Allocate IQ math areas: */
   IQmath            : > FLASHEDF      PAGE = 0                  /* Math Code */
   IQmathTables      : > IQTABLES     PAGE = 0, TYPE = NOLOAD   /* Math Tables In ROM */

   Cla1ToCpuMsgRAM   : > CLA_CPU_MSGRAM PAGE = 1
   CpuToCla1MsgRAM   : > CPU_CLA_MSGRAM PAGE = 1

   Cla1DataRam1		   : > RAMM1,		  PAGE = 1

   GROUP	           : LOAD = FLASHEDF,
                         RUN = RAML2,
                         LOAD_START(_Cla1mathTablesLoadStart),
                         LOAD_END(_Cla1mathTablesLoadEnd),
                         RUN_START(_Cla1mathTablesRunStart),
                         LOAD_SIZE(_Cla1mathTablesLoadSize),
                         PAGE = 1

   {
    CLA1mathTables
    .const_cla
   }

   CLAscratch          :
                         { *.obj(CLAscratch)
                         . += CLA_SCRATCHPAD_SIZE;
                         *.obj(CLAscratch_end) } > RAML2,
					     PAGE = 1


   .reset            : > RESET,      PAGE = 0, TYPE = DSECT
   vectors           : > VECTORS     PAGE = 0, TYPE = DSECT

   /*DLOG	 			: >	dataRAM,    PAGE = 1*/

 /* Uncomment the section below if calling the IQNexp() or IQexp()
      functions from the IQMath.lib library in order to utilize the
      relevant IQ Math table in Boot ROM (This saves space and Boot ROM
      is 1 wait-state). If this section is not uncommented, IQmathTables2
      will be loaded into other memory (SARAM, Flash, etc.) and will take
      up space, but 0 wait-state is possible.
   */
   /*
   IQmathTables2    : > IQTABLES2, PAGE = 0, TYPE = NOLOAD
   {

              IQmath.lib<IQNexpTable.obj> (IQmathTablesRam)

   }
   */
   /* Uncomment the section below if calling the IQNasin() or IQasin()
      functions from the IQMath.lib library in order to utilize the
      relevant IQ Math table in Boot ROM (This saves space and Boot ROM
      is 1 wait-state). If this section is not uncommented, IQmathTables2
      will be loaded into other memory (SARAM, Flash, etc.) and will take
      up space, but 0 wait-state is possible.
   */
   /*
   IQmathTables3    : > IQTABLES3, PAGE = 0, TYPE = NOLOAD
   {

              IQmath.lib<IQNasinTable.obj> (IQmathTablesRam)

   }
   */

}
    
SECTIONS
{
/*************       DPLIB Sections C28x      ************************/
	/* ADCDRV_1ch section */
	ADCDRV_1ch_Section				: > dataRAM				PAGE = 1
	
	/* ADCDRV_4ch section */
	/*ADCDRV_4ch_Section				: > dataRAM				PAGE = 1*/

	/* CNTL_2P2Z section */
	CNTL_2P2Z_Section				: > dataRAM				PAGE = 1
	CNTL_2P2Z_InternalData			: > dataRAM				PAGE = 1
	CNTL_2P2Z_Coef					: > dataRAM				PAGE = 1
	CNTL_2P2Z_Coef1					: > dataRAM				PAGE = 1
	CNTL_2P2Z_Coef2					: > dataRAM				PAGE = 1
//	CNTL_2P2Z_Coef4					: > dataRAM				PAGE = 1
//	Lin_Structure                   : > dataRAM				PAGE = 1

	/*WM_Temp_dataStr                 : > dataRAM				PAGE = 1*/
	/* CNTL_3P3Z section */
	/*CNTL_3P3Z_Section				: > dataRAM				PAGE = 1*/
	/*CNTL_3P3Z_InternalData			: > dataRAM				PAGE = 1*/
	/*CNTL_3P3Z_Coef					: > dataRAM				PAGE = 1*/
	
	
	/*DLOG_4CH section */
	/*DLOG_4CH_Section				: > dataRAM				PAGE = 1*/
	/*DLOG_BUFF						: > dataRAM				PAGE = 1*/
	
	/*MATH_EMAVG section */
	MATH_EMAVG_Section				: > dataRAM				PAGE = 1
	/*PFC_ICMD section*/
	/*PFC_ICMD_Section				: > dataRAM				PAGE = 1*/

	/*PFC_INVSQR section*/
	/*PFC_INVSQR_Section				: > dataRAM				PAGE = 1*/
	
	/* PWMDRV_1ch driver section */
	/*PWMDRV_1ch_Section				: > dataRAM				PAGE = 1*/

	/* PWMDRV_1chHiRes driver section */
	/*PWMDRV_1chHiRes_Section			: > dataRAM				PAGE = 1*/
	
	/* PWMDRV_PFC2PhiL driver section */
	/*PWMDRV_PFC2PhiL_Section			: > dataRAM				PAGE = 1*/
	
 	/* PWMDRV_PSFB driver section */
	/*PWMDRV_PSFB_Section				: > dataRAM				PAGE = 1*/
	
	/* PWMDRV_DualUpDwnCnt driver section */
	/*PWMDRV_DualUpDwnCnt_Section		: > dataRAM				PAGE = 1*/
	
	/* PWMDRV_ComplPairDB driver section */
	PWMDRV_ComplPairDB_Section		: > dataRAM				PAGE = 1
	
	/* ZeroNet_Section  */
	ZeroNet_Section					: > dataRAM				PAGE = 1

	/* PWMDRV_1ch_UpCntDB_Compl driver section */
	PWMDRV_LLC_1ch_UpCntDB_Compl_Section	: > dataRAM				PAGE = 1

	/* PWMDRV_1ch_UpCntDB driver section */
	PWMDRV_LLC_1ch_UpCntDB_Section		: > dataRAM				PAGE = 1

	/* PWMDRV_LLC_ComplPairDB driver section */
	PWMDRV_LLC_ComplPairDB_Section	: > dataRAM				PAGE = 1




	ADCDRV_1ch_CLA_Section				: > CPU_CLA_MSGRAM				PAGE = 1

	CNTL_2P2Z_CLA_Section				: > CPU_CLA_MSGRAM				PAGE = 1
	CNTL_2P2Z_CLA_InternalData			: > CPU_CLA_MSGRAM				PAGE = 1
	CNTL_2P2Z_CLA_Coef					: > CPU_CLA_MSGRAM				PAGE = 1
	CNTL_2P2Z_CLA_Coef1					: > CPU_CLA_MSGRAM				PAGE = 1
	CNTL_2P2Z_CLA_Coef2					: > CPU_CLA_MSGRAM				PAGE = 1
	CNTL_2P2Z_CLA_Coef3					: > CPU_CLA_MSGRAM				PAGE = 1

	MATH_EMAVG_CLA_Section				: > CPU_CLA_MSGRAM				PAGE = 1
	MATH_EMAVG_CLA_InternalData			: > CPU_CLA_MSGRAM				PAGE = 1

	PWMDRV_ComplPairDB_CLA_Section		: > CPU_CLA_MSGRAM				PAGE = 1
	PWMDRV_ComplPairDB_CLA_InternalData	: > CPU_CLA_MSGRAM				PAGE = 1

	/* ZeroNet_Section  */
	ZeroNetCLA_Section					: > CPU_CLA_MSGRAM				PAGE = 1

	/* PWMDRV_1ch_UpCntDB_Compl driver section */
	PWMDRV_LLC_ComplPairDB_CLA_Section	: > CPU_CLA_MSGRAM		        PAGE = 1

	PROM_CHECK                          : >PROM_VERIFY                  PAGE = 0
}




 




