/*
 * Diagnostic.c
 *
 *  Created on: 2020514
 *      Author: Administrator
 */
#include <UDS_networklayer.h>
#include <Diagnostic.h>
#include "DSP2803x_Device.h"     // DSP28 Headerfile Include File
#include "Flash2803x_API_Library.h"
//#include "common.h"
#include "DSP2833x_I2C_defines.h"              // Macros used for I2C examples.
//#include "CRC.h"
/* Private define ------------------------------------------------------------*/
#define SERVICE_NUMBER              26
typedef void (*ServiceHandler)(Uint16 N_TAType,Uint16 length, Uint16 *MessageData);
//typedef far Uint16 * far EEProm_TAddress;

typedef  Uint16 * EEProm_TAddress;    //˴иȷǷӰ
//
typedef enum{
    SESSION_CONTROL = 0x10,
    RESET_ECU = 0x11,
    SECURITY_ACCESS = 0x27,
    COMMUNICATION_CONTROL = 0x28,
    TESTER_PRESENT = 0x3E,
    GET_TIME_PARAM = 0x83,
    SECURITY_DATA_TRANSMISSION = 0x84,
    CONTROL_DTC_SETTING = 0x85,
    RESPONSE_ON_EVENT = 0x86,
    LINK_CONTROL = 0x87,
    READ_DATA_BY_ID = 0x22,
    READ_MEMORY_BY_ADDRESS = 0x23,
    READ_SCALING_DATA_BY_ID = 0x24,
    READ_DATA_PERIOD_ID = 0x2A,
    DYNAMICALLY_DEFINE_DATA_ID = 0x2C,
    WRITE_DATA_BY_ID = 0x2E,
    WRITE_MEMORY_BY_ADDRESS = 0x3D,
    CLEAR_DTC_INFO = 0x14,
    READ_DTC_INFO = 0X19,
    IO_CONTROL_BY_ID = 0x2F,
    ROUTINE_CONTROL = 0x31,
    REQUEST_DOWNLOAD = 0x34,
    REQUEST_UPLOAD = 0x35,
    TRANSMIT_DATA = 0x36,
    REQUEST_TRANSFER_EXIT = 0x37,
}ServiceName;
//Ӧ
typedef enum{
    PR = 0x00,            //positive response
    GR = 0x10,            //general reject
    SNS = 0x11,           //service not supported
    SFNS = 0x12,          //sub-function not supported
    IMLOIF = 0x13,        //incorrect message length or invalid format
    RTL = 0x14,           //response too long
    BRR = 0x21,           //busy repeat request
    CNC = 0x22,           //condifitons not correct
    RSE = 0x24,           //request sequence error
    NRFSC = 0x25,
    FPEORA = 0x26,
    ROOR = 0x31,          //reqeust out of range
    SAD = 0x33,           //security access denied
    IK = 0x35,            //invalid key
    ENOA = 0x36,          //exceed number of attempts
    RTDNE = 0x37,         //required time delay not expired
    UDNA = 0x70,          //upload download not accepted
    TDS = 0x71,           //transfer data suspended
    GPF = 0x72,           //general programming failure
    WBSC = 0x73,          //wrong block sequence coutner
    RCRRP = 0x78,         //request correctly received-respone pending
    SFNSIAS = 0x7e,       //sub-function not supported in active session
    SNSIAS  = 0x7F,       //service not supported in active session
    VTH = 0x92,           //voltage too high
    VTL = 0x93,           //voltage too low
}NegativeResposeCode;

//Ự
typedef enum{
    ECU_DEFAULT_SESSION = 1,
    ECU_PAOGRAM_SESSION = 2,
    ECU_EXTENED_SESSION = 3,
    ECU_FACTORY_SESSION = 0x71,//Ӧsession
}SessionType;
//ܽ
typedef enum{
    WAIT_SEED_REQ,  //ȴ
    WAIT_KEY,       //ȴԿ
    WAIT_DELAY,     //ȴʱ
    UNLOCKED,       //ѽ
}SecurityUnlockStep;

//DTCӹ
typedef enum{
    REPORT_DTCNUMBER_BY_MASK = 1,
    REPORT_DTCCODE_BY_MASK = 2,
    REPORT_DTCSNAPSHOT_BY_ID = 3,
    REPORT_DTCSNAPSHOT_BY_DTCNUMBER = 4,
    REPORT_DTCSNAPSHOT_BY_RECORDNUMBER = 5,
    REPORT_DTCEXTEND_DATA_BY_DTCNUMBER = 6,
    REPORT_DTCNUMBER_BY_SEVERITYMASK,
    REPORT_DTC_BY_SEVERITYMASK,
    REPORT_SEVERITYID_OF_DTC,
    REPORT_SUPPORTED_DTC = 0x0A,
    REPORT_FIRST_FAILED_DTC,
    REPORT_FIRST_CONFIRMED_DTC,
    REPORT_MOST_FAILED_DTC,
    REPORT_MOST_CONFIRMED_DTC,
    REPORT_MIRRORDTC_BY_MASK,
    REPORT_MIRRORDTC_EXTENDED_BY_DTC_NUMBER,
    REPORT_MIRRORDTC_NUMBER_BY_MASK,
    REPORT_OBDDTC_NUMBER_BY_MASK,
    REPORT_OBDDTC_BY_MASK,
}DTCSubFunction;

typedef enum{
    POWERTRAIN,
    CHASSIS,
    BODY,
    NETWORK,
}DTCAlphanumeric ;

//DTC״̬
typedef union{
    struct{
        Uint16 TestFailed:1;    //bit0
        Uint16 TestFailedThisMonitoringCycle:1;//bit1
        Uint16 PendingDTC:1;//bit2
        Uint16 ConfirmedDTC:1;//bit3
        Uint16 TestNotCompleteSinceLastClear:1;//bit4
        Uint16 TestFailedSinceLastClear:1;//bit5
        Uint16 TestNotCompleteThisMonitoringCycle:1;//bit6
        Uint16 WarningIndicatorRequested:1;//bit7
        Uint16 rsd:8;
    }DTCbit;
    Uint16 DTCStatusByte;
}DTCStatusType;

//1939DTC
typedef struct _J1939DTC{
    Uint32 SPN;
    Uint16 FMI;
    Uint16 CM;
    Uint16 OC;
}J1939DTC;

typedef struct _DtcNode{
    Uint32 DTCCode;                //DTC
    DetectFun DetectFunction;        //ϼ⺯
    Uint16 EEpromAddr;             //EEpromַ
    Uint16 TripLimitTimes;          //ʱ
    DTCStatusType DTCStatus;
    Uint16 OldCounter;
    Uint16 GoneCounter;
    Uint16 TripCounter;             //ϴ
    Uint16 FaultOccurrences;        //ϳִ
    Uint16 SnapShotEEpromAddr;     //Ϣַ
    //Uint16 ExtenedDataEEpromAddr;//չݵַ
    #if USE_J1939_DTC
    DTCLevel dtcLevel;
    J1939DTC DM1Code;
    #endif
    #if USE_MALLOC
    struct _DtcNode* next;
    #endif
}DTCNode;

typedef struct _DidNode{
    Uint16 ID;
    Uint16 dataLength;
    Uint16* dataPointer;
    IoControl Callback;
    DIDType didType;
    ReadWriteAttr RWAttr;
    Uint16 EEpromAddr;
    Uint16 SupportWriteInFactoryMode;
    #if USE_MALLOC
    struct _DidNode* next;
    #endif
}DIDNode;
//DTC״̬
typedef struct _GroupNode{
    Uint32 GroupID;
    struct _GroupNode* next;
}DTCGroupNode;
//ݿ
typedef struct _Snapshot{
    Uint16 snapshotRecord;
    Uint16 snapshotID;
    Uint16* dataPointer;
    Uint16 dataLength;
}Snapshot;
//Ự
typedef struct{
    Uint16 support;                         //֧״̬
    ServiceName serviceName;              //
    Uint16 PHYDefaultSession_Security:4; //security suppport in default session physical address  ĬϻỰ
    Uint16 PHYProgramSeesion_Security:4; //security suppport in program session physical address  ̻Ự
    Uint16 PHYExtendedSession_Security:4;//security suppport in extened session physical address չỰ
    Uint16 FUNDefaultSession_Security:4; //security suppport in default session function address  ĬϻỰ
    Uint16 FUNProgramSeesion_Security:4; //security suppport in program session function address  ̻Ự
    Uint16 FUNExtendedSession_Security:4;//security suppport in extened session function address չỰ
    ServiceHandler serviceHandle;         //         
}SessionService;

typedef struct{
    bool valid;                          //Ч
    SecurityLevel level;                 //ȫȼ
    SecurityFun UnlockFunction;          //ȫ
    uint8_t seedID;
    uint8_t keyID;
    uint8_t FaultCounter;                //ϼ
    uint16_t FaultCounterAddr;           //ϼַ
    uint8_t FaultLimitCounter;           //ϼ޼
    uint32_t UnlockFailedDelayTime;      //ʧʱʱ
    uint8_t subFunctionSupported;        //ӹ֧
    DiagTimer SecurityLockTimer;                 //ʧ3κٴνʱʱ
    uint8_t KeySize;                     //Կ״С
}SecurityUnlock;

/* Private macro -------------------------------------------------------------*/

/* Private function prototypes -----------------------------------------------*/

void ServiceNegReponse(uint8_t serviceName,uint8_t RejectCode);        //֧
void Diagnostic_ReadDTCPositiveResponse(uint8_t DTCSubFunction,uint8_t DTCStatausMask);
void Service10Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service11Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service27Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service28Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service3EHandle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service83Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service84Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service85Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service86Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service87Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service22Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service23Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service24Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service2AHandle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service2CHandle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service2EHandle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service3DHandle(uint8_t N_TAType,uint16_t length, uint8_t *MessageData);
void Service14Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service19Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service2FHandle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service31Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service34Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service35Handle(uint8_t N_TAType,uint16_t length, uint8_t *MessageData);
void Service36Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
void Service37Handle(uint8_t N_TAType, uint16_t length, uint8_t *MessageData);
DIDNode* SearchDidNode(uint16_t DID);
void Diagnostic_ClearDTC(uint32_t Group);
void Diagnostic_SaveAllDTC(void);
void Diagnostic_LoadAllDTC(void);
DTCNode* GetDTCNodeByCode(uint32_t dtcCode);

byte Diagnostic_EEProm_Read(uint16_t add, byte size, byte *data);
byte Diagnostic_EEProm_Write(uint16_t add, byte size, byte *data);
/* Private variables ---------------------------------------------------------*/

/*========================diagnositc version================================*/
 uint8_t DriverVersion[] = {1,2,3};
 uint8_t NMVersion[] = {4,5,6};
 uint8_t DiagnosticVersion[] = {7,8,9};
 uint8_t DatabaseVersion[] = {4,5};
 uint8_t VIN_Data[]={1,2,3,4,5,6,7,8,9};
// FLASH_ST ProgStatus;
/*========================about security acces================================*/


/*========================about security acces================================*/
static uint8_t Seed[5];                                                   //
static uint8_t key[4];                                                    //ܳ
//static uint32_t retLen;
static SecurityLevel m_SecurityLevel = LEVEL_ZERO;          //ǰȼ
static SecurityUnlockStep m_UnlockStep = WAIT_SEED_REQ; //ǰ
SecurityUnlock UnlockList[4];    //
/*========================about security acces================================*/

/*========================sesion , id , buf and so on================================*/
static NegativeResposeCode m_NRC;                     //Ӧ
uint8_t m_CurrSessionType;                            //ǰػ
bool ResponsePending;                                 //Ƿ͹78Ӧ
bool suppressResponse;
uint16_t ResponseLength;
uint8_t CurrentService;
static uint8_t DiagnosticBuffTX[50];                 //ݵĻ
//static uint8_t J1939BufTX[90];                      //J1939ͻ
static DiagTimer S3serverTimer;                       //S3ʱ
static DiagTimer normal_protimer;
static uint16_t P2CanServerMax = 0x32;                //ػ
static uint16_t P2ECanServerMax = 0x1F4;              //ػ
static uint32_t TesterPhyID;
static uint32_t TesterFunID;
static uint32_t TesterPhyID1;
static uint32_t TesterFunID1;
static uint32_t EcuID1;
static uint32_t EcuID;
static uint8_t N_Ta;
static uint8_t N_Sa;
static uint8_t SessionSupport;//bit0: default session 01 support
                                          //bit1: program session 02 support
                                          //bit2: extended session 03 support
                                          //bit3: sub02 supported in defaultsession
                                          //bit4: sub03 supported in program
                                          //bit5: supressPosRespnse support
#define Service10Sub01Supported()   ((SessionSupport & 0x01) != 0)
#define Service10Sub02Supported()   ((SessionSupport & 0x02) != 0)
#define Service10Sub03Supported()   ((SessionSupport & 0x04) != 0)
#define Service10Sub01To02OK()      ((SessionSupport & 0x08) != 0)
#define Service10Sub02To03OK()      ((SessionSupport & 0x10) != 0)
#define Service10SupressSupproted() ((SessionSupport & 0x20) != 0)
//#define BOOTLOADER 0
/*========================sesion , id , buf and so on================================*/

/*========================about program================================*/
static uint8_t m_BlockIndex = 0;
static uint32_t ProgramAddress = 0;     // ʼַ
static uint32_t ProgramLength = 0;      //̳
static uint32_t ProgramLengthComplete = 0;
static bool IsUpdating = FALSE;
static bool WaitConfirmBeforeJump = FALSE;              //ȴǰת
static bool WaitConfirmBeforeErase = FALSE;             //ǰȴ78ȷϢ
/*========================about program================================*/

/*========================about DTC and DIDs================================*/
#if USE_MALLOC
static DTCNode* DTCHeader;
static DIDNode* DIDHeader;
static DTCGroupNode *GroupHeader;
#else
//static DTCNode DTCS[MAX_DTC_NUMBER];
#pragma DATA_SECTION(DTCS, "UDS_DATA");
//#pragma DATA_SECTION(DIDS, "UDS_DATA");
#pragma DATA_SECTION(SnapShots, "UDS_DATA");
#pragma DATA_SECTION(DTCGROUPS, "UDS_DATA");
#pragma DATA_SECTION(ServiceList, "UDS_DATA");
DTCNode DTCS[MAX_DTC_NUMBER];
static uint8_t DTCAdded;
static DIDNode DIDS[MAX_DID_NUMBER];
static uint8_t DIDAdded;
static Snapshot SnapShots[MAX_SNAPSHOT_NUMBER];  //ݿ
static uint8_t SnapShotAdded = 0;
//static Snapshot ExtendedData[MAX_EXTENDED_DATA_NUMBER];
//static uint8_t ExtendedDataAdded = 0;
static uint8_t AgedCounterRecord = 0;
static uint8_t AgingCounterRecord = 0;
static uint8_t OccurenceCounterRecord = 0;
static uint8_t PendingCounterRecord = 0;

static DTCGroupNode DTCGROUPS[MAX_GROUP_NUMBER];
static uint8_t DTCGroupAdded;
#endif
#if USE_J1939_DTC
static bool DiagDM1Enable = TRUE;
#endif
static bool DtcAvailibaleMask;
static DiagTimer DtcTimer;
static uint16_t ModuleEEpromStartAddr;
static uint16_t EEpromSizeForUse;
static uint16_t EEpromUsed;
#define DTC_BYTE_NUMBER_TO_SAVE 5
bool EnableDTCDetect;                             //ʹܹ
bool HighVoltage;                                     //ѹ־
bool LowVoltage;                                      //Ƿѹ־
bool SaveDTCInBlock;
static uint8_t DTCSaved;
//static uint8_t DM1DTCNumber;                    //J1939 DTC number
//static DiagTimer J1939Timer;                    //j1939 timer
static DiagTimer DTCSavedTimer;
/*========================about DTC and DIDs================================*/

/*========================about reset  λ÷================================*/
static uint8_t ResetTypeSupport;//bit0: 01 sub function supported
                                            //bit1: 02 sub function supported
                                            //bit2: 03 sub function supported
                                            //bit3: 04 sub function supported
                                            //bit4: 05 sub function supported
                                            //bit5:posresonpse supress supported
#define Service11SupressSupported()  ((ResetTypeSupport & 0x20) != 0)
#define Service11Sub01Supported()    ((ResetTypeSupport & 0x01) != 0)
#define Service11Sub02Supported()    ((ResetTypeSupport & 0x02) != 0)
#define Service11Sub03Supported()    ((ResetTypeSupport & 0x04) != 0)
#define Service11Sub04Supported()    ((ResetTypeSupport & 0x08) != 0)
#define Service11Sub05Supported()    ((ResetTypeSupport & 0x10) != 0)
static ResetCallBack ResetCallBackFun;
static EcuResetType m_EcuResetType;                     //ECUλ
static bool WaitConfimBeforeReset = FALSE;
/*========================about reset===============================*/

/*========================about tester present===============================*/
static uint8_t TesterPresentSuppport;//posresonpse supress supported
#define Service3ESupressSupported()   ((TesterPresentSuppport & 0x01) != 0)
#define Service85SupressSupported()   ((TesterPresentSuppport & 0x02) != 0)
/*========================about tester present===============================*/

/*========================ͨſ===============================*/

static uint8_t CommTypeSupport;//bit0:00 sub function supported
                                             //bit1:01 sub function supported
                                             //bit2:02 sub function supported
                                             //bit3:03 sub function supported
                                             //bit4:01 type supported
                                             //bit5:02 type supported
                                             //bit6:03 type supported
                                             //bit6:posresponse supress supported
#define Service28Sub00Suppoted()    ((CommTypeSupport & 0x01) != 0)
#define Service28Sub01Suppoted()    ((CommTypeSupport & 0x02) != 0)
#define Service28Sub02Suppoted()    ((CommTypeSupport & 0x04) != 0)
#define Service28Sub03Suppoted()    ((CommTypeSupport & 0x08) != 0)
#define Service28Type01Suppoted()   ((CommTypeSupport & 0x10) != 0)
#define Service28Type02Suppoted()   ((CommTypeSupport & 0x20) != 0)
#define Service28Type03Suppoted()   ((CommTypeSupport & 0x40) != 0)
#define Service28SupressSupported() ((CommTypeSupport & 0x80) != 0)
static CommCallBack commCallBack;
/*========================about commulication control===============================*/

/*========================about factory mode use ===============================*/
void Diagnostic_DTCDefaultValue(void);
/*========================about factory mode use===============================*/

SessionService ServiceList[SERVICE_NUMBER] = {
    {FALSE, SESSION_CONTROL,            LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         Service10Handle},           //0X10
    {FALSE, RESET_ECU,                  LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_ZERO,         Service11Handle},           //0X11
    {FALSE, SECURITY_ACCESS,            LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service27Handle},           //0X27
    {FALSE, COMMUNICATION_CONTROL,      LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_ZERO,         Service28Handle},           //0X28
    {FALSE, TESTER_PRESENT,             LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_ZERO,         Service3EHandle},           //0X3E
    {FALSE, GET_TIME_PARAM,             LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service83Handle},           //0X83
    {FALSE, SECURITY_DATA_TRANSMISSION, LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service84Handle},           //0X84
    {FALSE, CONTROL_DTC_SETTING,        LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_ZERO,         Service85Handle},           //0X85
    {FALSE, RESPONSE_ON_EVENT,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service86Handle},           //0X86
    {FALSE, LINK_CONTROL,               LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service87Handle},           //0X87
    {FALSE, READ_DATA_BY_ID,            LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service22Handle},           //0X22
    {FALSE, READ_MEMORY_BY_ADDRESS,     LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service23Handle},               //0X23
    {FALSE, READ_SCALING_DATA_BY_ID,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service24Handle},           //0X24
    {FALSE, READ_DATA_PERIOD_ID,        LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service2AHandle},           //0X2A
    {FALSE, DYNAMICALLY_DEFINE_DATA_ID, LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service2CHandle},           //0X2C
    {FALSE, WRITE_MEMORY_BY_ADDRESS,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service3DHandle},           //0X3D
    {FALSE, WRITE_DATA_BY_ID,           LEVEL_UNSUPPORT,    LEVEL_ONE,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service2EHandle},           //0X2E
    //{FALSE, WRITE_DATA_BY_ID,             LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_ONE,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service2EHandle},       //0X2E
    {FALSE, CLEAR_DTC_INFO,             LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_ZERO,         Service14Handle},           //0X14
    {FALSE, READ_DTC_INFO,              LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_ZERO,         LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service19Handle},           //0X19
    {FALSE, IO_CONTROL_BY_ID,           LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_ONE,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service2FHandle},           //0X2F
    {FALSE, ROUTINE_CONTROL,            LEVEL_UNSUPPORT,    LEVEL_ONE,          LEVEL_ONE,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service31Handle},           //0X31
    {FALSE, REQUEST_DOWNLOAD,           LEVEL_UNSUPPORT,    LEVEL_ONE,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service34Handle},           //0X34
    {FALSE, REQUEST_UPLOAD,             LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service35Handle},           //0X35
    {FALSE, TRANSMIT_DATA,              LEVEL_UNSUPPORT,    LEVEL_ONE,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service36Handle},           //0X36
    {FALSE, REQUEST_TRANSFER_EXIT,      LEVEL_UNSUPPORT,    LEVEL_ONE,          LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    LEVEL_UNSUPPORT,    Service37Handle},           //0X37
};


#define ENTRYPOINT 0x003EC000      //ʼַ
void (*run_iap)(void);
//ת
void goto_normal_app(void)
{
    EALLOW;
    run_iap = ( void(*)() ) ENTRYPOINT ; //0x003F6000//iap洢ַ
    (*run_iap)();
    EDIS;
}
/* Private functions ---------------------------------------------------------*/
/* Public functions ----------------------------------------------------------*/

/*========interface for application layer setting diagnostic parameters==============*/
bool InitAddSecurityAlgorithm(SecurityLevel level, SecurityFun AlgoritthmFun,byte SeedSubFunctionNum,byte KeySubFunctionNum , uint8_t* FaultCounter,uint8_t FaultLimitCounter , uint32_t UnlockFailedDelayTimeMS, SubFunSuppInSession SubFuntioncSupportedInSession,uint8_t KeySize)
{
    uint8_t i;
    for(i = 0 ; i < 3 ; i++)
    {
       // if(UnlockList[i].valid == FALSE)
        if(UnlockList[i].valid != TRUE)
        {
            UnlockList[i].UnlockFunction = AlgoritthmFun;
            UnlockList[i].seedID = SeedSubFunctionNum;
            UnlockList[i].keyID = KeySubFunctionNum;
            UnlockList[i].level = level;
            UnlockList[i].valid = TRUE;
            UnlockList[i].FaultCounterAddr = (ModuleEEpromStartAddr + EEpromUsed);
            EEpromUsed += 1;
            UnlockList[i].FaultLimitCounter = FaultLimitCounter;
            UnlockList[i].UnlockFailedDelayTime = UnlockFailedDelayTimeMS;
            UnlockList[i].subFunctionSupported = SubFuntioncSupportedInSession;
            UnlockList[i].KeySize = KeySize;
            return TRUE;
        }
    }
    return FALSE;
}
void Init_Ulocklist(void)
{
    uint8_t i;
    for(i=0;i<3;i++)
    {
        UnlockList[i].valid=FALSE;
    }
}

uint32_t FactorySecuritySeedToKey(uint32_t seed)
{
    uint8_t i;
    uint32_t xor = 0x52756959;// asscii "RuiY"
    uint32_t key;

    key = seed ^ xor;

    for (i=0; i < 32; i++)
    {
        if (key & 0x80000000)
        {
            key = key << 1;
            key = key ^ xor;
        }
        else
        {
            key = key << 1;
        }
    }
    return key;
}

//ʼӦ̼ܲ
void InitFactorySecuriyAlgorithm(void)
{
    InitAddSecurityAlgorithm(LEVEL_FOUR,FactorySecuritySeedToKey,0x71,0x72, NULL ,3 , 10000, SUB_FACTORY,4);
}
//Ựܵȼ
bool InitSetSessionSupportAndSecurityAccess(bool support ,uint8_t service,uint8_t PHYDefaultSession_Security,   uint8_t PHYProgramSeesion_Security, uint8_t PHYExtendedSession_Security,    uint8_t FUNDefaultSession_Security, uint8_t FUNProgramSeesion_Security, uint8_t FUNExtendedSession_Security)
{
    uint8_t i;
    if(support == FALSE)
    {
        //warning ,we suggest set service supported when init,or we can not access this service
    }
    for(i = 0 ; i < SERVICE_NUMBER ; i++)
    {
        if(ServiceList[i].serviceName ==  service)
        {
            ServiceList[i].FUNDefaultSession_Security = FUNDefaultSession_Security;
            ServiceList[i].FUNExtendedSession_Security = FUNExtendedSession_Security;
            ServiceList[i].FUNProgramSeesion_Security = FUNProgramSeesion_Security;
            ServiceList[i].PHYDefaultSession_Security = PHYDefaultSession_Security;
            ServiceList[i].PHYExtendedSession_Security = PHYExtendedSession_Security;
            ServiceList[i].PHYProgramSeesion_Security = PHYProgramSeesion_Security;
            ServiceList[i].support = support;
            return TRUE;
        }
    }
    return FALSE;
}
//ʼݱʶ
void InitAddDID(uint16_t DID , uint8_t DataLength , uint8_t* DataPointer , DIDType DidType , IoControl ControlFun , ReadWriteAttr RWAttr,uint16_t EEaddr, bool SupportWriteInFactoryMode)
{
    #if USE_MALLOC
    DIDNode* didNode = (DIDNode*)malloc(sizeof(DIDNode));
    DIDNode* temp = DIDHeader;
    didNode->ID = DID;
    didNode->dataLength = DataLength;
    didNode->Callback = ControlFun;
    didNode->didType = DidType;
    didNode->RWAttr = RWAttr;
    didNode->next = NULL;
    if(didNode->RWAttr == READWRITE && DidType == EEPROM_DID)
    {
        didNode->dataPointer = (byte*)(ModuleEEpromStartAddr + EEpromUsed);
        EEpromUsed += DataLength;
    }
    else
    {
        didNode->dataPointer = DataPointer;
    }

    if(temp == NULL)
    {
        DIDHeader = didNode;
    }
    else
    {
        while(temp->next != NULL)
        {
            temp = temp->next;
        }
        temp->next = didNode;
    }
    #else
    if(DIDAdded < MAX_DID_NUMBER)
    {
        DIDS[DIDAdded].ID = DID;
        DIDS[DIDAdded].dataLength = DataLength;
        DIDS[DIDAdded].Callback = ControlFun;
        DIDS[DIDAdded].didType = DidType;
        DIDS[DIDAdded].RWAttr = RWAttr;
        DIDS[DIDAdded].SupportWriteInFactoryMode = SupportWriteInFactoryMode;
        if(DidType == EEPROM_DID)
        {
            if(EEaddr == 0)
            {
                DIDS[DIDAdded].EEpromAddr = ModuleEEpromStartAddr + EEpromUsed;
                EEpromUsed += DataLength;
            }
            else
            {
                DIDS[DIDAdded].EEpromAddr = EEaddr;
            }
        }
        else
        {
            DIDS[DIDAdded].dataPointer = DataPointer;
        }

        DIDAdded++;
    }
    #endif
}

//ʼ
#if USE_J1939_DTC
bool InitAddDTC(uint32_t DTCCode,DetectFun MonitorFun,byte DectecPeroid, byte ValidTimes,DTCLevel dtcLevel,uint32_t spn, uint8_t fmi)
#else
bool InitAddDTC(uint32_t DTCCode,DetectFun MonitorFun,byte DectecPeroid, byte ValidTimes,DTCLevel dtcLevel)
#endif
{
    #if USE_MALLOC
    DTCNode* dtcNode = (DTCNode*)malloc(sizeof(DTCNode));
    DTCNode* temp = DTCHeader;
    dtcNode->DTCCode = DTCCode;
    dtcNode->DetectFunction = MonitorFun;
    dtcNode->dtcLevel = dtcLevel;
    dtcNode->EEpromAddr = ModuleEEpromStartAddr + EEpromUsed;
    dtcNode->next = NULL;
    EEpromUsed += DTC_BYTE_NUMBER_TO_SAVE;

    if(temp == NULL)
    {
        DTCHeader = dtcNode;
    }
    else
    {
        while(temp->next != NULL)
        {
            temp = temp->next;
        }
        temp->next = dtcNode;
    }
    return TRUE;
    #else
    if(DTCAdded < MAX_DTC_NUMBER)
    {
        DTCS[DTCAdded].DTCCode = DTCCode;
        DTCS[DTCAdded].DetectFunction = MonitorFun;
        DTCS[DTCAdded].TripLimitTimes = ValidTimes;
        #if USE_J1939_DTC
        DTCS[DTCAdded].dtcLevel = dtcLevel;
        DTCS[DTCAdded].DM1Code.SPN = spn;
        DTCS[DTCAdded].DM1Code.FMI = fmi;
        //DTCS[DTCAdded].DM1Code.CM = 0;
        DTCS[DTCAdded].DM1Code.OC = 0;
        #endif
        DTCS[DTCAdded].EEpromAddr = ModuleEEpromStartAddr + EEpromUsed;
        EEpromUsed += DTC_BYTE_NUMBER_TO_SAVE;

        DTCAdded++;
        return TRUE;
    }
    else
    {
        return FALSE;
    }
    #endif
}
//ʼݿ
void InitAddDTCSnapShot(uint8_t recordNumber , uint16_t ID , uint8_t* datap , uint8_t size)
{
    if(SnapShotAdded < MAX_SNAPSHOT_NUMBER)
    {
        SnapShots[SnapShotAdded].snapshotRecord = recordNumber;
        SnapShots[SnapShotAdded].snapshotID = ID;
        SnapShots[SnapShotAdded].dataPointer = datap;
        SnapShots[SnapShotAdded].dataLength = size;
        SnapShotAdded++;
    }
}

