/**
 * main.c
 */
#include "F28x_Project.h"
#include "driverlib.h"
#include "device.h"

#include "MY_CLA.h"

// PIṹ
typedef struct
{
    float kp;
    float ki;
    float error;
    float proportional;
    float integral;
    float integral_max;
    float integral_min;
    float output;
    float max_output;
    float min_output;
} PI_Controller_t;

// οֵṹ
typedef struct
{
    float Vout_Ref_AC;        // ѹο(˲ʱֵ)
    float Vout_Ref_RMS;       // ѹЧֵοֵ
    float Vout_Ref_RMS_Temp;  // ʱοֵ
    float Vout_Ref_RMS_Target;// ĿЧֵ
    float I_ref;              // ⻷ĵֵο
    float I_ref_instant;      // ˲ʱοֵ
} PI_Controller_Ref_t;

// λ
typedef struct
{
    float Phase_Angle;        // λ()
    float Phase_Angle_Rad;    // λ()
} Phase_Data_t;

// ADC
typedef struct
{
    float Vout_AC;           // ѹ˲ʱֵ
    float Vin_AC;            // ѹ˲ʱֵ
    float IL_AC;             // е˲ʱֵ
    float Vout_AC_Filter;    // ˲ѹ
    float Vin_AC_Filter;     // ˲ѹ
    float IL_AC_Filter;      // ˲е
    float Vout_RMS;          // ѹЧֵ
    float Vin_RMS;           // ѹЧֵ
    float IL_RMS;            // еЧֵ
} ADC_Data_t;

// ԭʼADC
typedef struct
{
    float vout_pos_voltage;
    float vout_neg_voltage;
    float vout_ac_voltage;
    float vin_pos_voltage;
    float vin_neg_voltage;
    float vin_ac_voltage;
    float biased_voltage;
    float current_voltage;
} ADC_RAW_Data_t;

// CLAݶ
#pragma DATA_SECTION(Voltage_PI, "CLADataLS0")
#pragma DATA_SECTION(Current_PI, "CLADataLS0")
#pragma DATA_SECTION(ADC_RAW_Data, "CLADataLS0")
#pragma DATA_SECTION(ADC_Data, "CLADataLS0")
#pragma DATA_SECTION(Ref, "CLADataLS0")
#pragma DATA_SECTION(Phase_Data, "CLADataLS0")

// CPU-CLAͨ
#pragma DATA_SECTION(target_Vout_RMS, "CpuToCla1MsgRAM")     // CPUѹĿ
#pragma DATA_SECTION(calculated_duty, "Cla1ToCpuMsgRAM")     // CLAռձ
#pragma DATA_SECTION(duty_updated, "Cla1ToCpuMsgRAM")        // ±־
#pragma DATA_SECTION(system_status, "Cla1ToCpuMsgRAM")       // ϵͳ״̬

// 
PI_Controller_t Voltage_PI;
PI_Controller_t Current_PI;
PI_Controller_Ref_t Ref;
Phase_Data_t Phase_Data;
ADC_RAW_Data_t ADC_RAW_Data;
ADC_Data_t ADC_Data;

// 
#define EPWM1_PERIOD 62500        // PWMֵ
#define PI 3.141592653589793f     // ֵ
#define Ts_adc 0.0001f            // ʱ100us (10kHz)

volatile float target_Vout_RMS = 110.0f;      // Ĭ110V RMS
volatile float calculated_duty = 0.0f;        // CLAռձ
volatile uint16_t duty_updated = 0;           // ±־
volatile uint16_t system_status = 0;          // ״̬־

volatile float theta;
volatile float sin_theta;
volatile float cos_theta;

/*
: ADC
˵: 
*/
void MY_ADC_Init(void)
{

    // === GPIO39-43: ADC ===
        GPIO_setPinConfig(GPIO_39_GPIO39);
        GPIO_setDirectionMode(39, GPIO_DIR_MODE_IN);
        GPIO_setPadConfig(39, GPIO_PIN_TYPE_STD);
        GPIO_setQualificationMode(39, GPIO_QUAL_SYNC);
        GPIO_setControllerCore(39, GPIO_CORE_CPU1);

        GPIO_setPinConfig(GPIO_40_GPIO40);
        GPIO_setDirectionMode(40, GPIO_DIR_MODE_IN);
        GPIO_setPadConfig(40, GPIO_PIN_TYPE_STD);
        GPIO_setQualificationMode(40, GPIO_QUAL_SYNC);
        GPIO_setControllerCore(40, GPIO_CORE_CPU1);

        GPIO_setPinConfig(GPIO_41_GPIO41);
        GPIO_setDirectionMode(41, GPIO_DIR_MODE_IN);
        GPIO_setPadConfig(41, GPIO_PIN_TYPE_STD);
        GPIO_setQualificationMode(41, GPIO_QUAL_SYNC);
        GPIO_setControllerCore(41, GPIO_CORE_CPU1);

        GPIO_setPinConfig(GPIO_42_GPIO42);
        GPIO_setDirectionMode(42, GPIO_DIR_MODE_IN);
        GPIO_setPadConfig(42, GPIO_PIN_TYPE_STD);
        GPIO_setQualificationMode(42, GPIO_QUAL_SYNC);
        GPIO_setControllerCore(42, GPIO_CORE_CPU1);

        GPIO_setPinConfig(GPIO_43_GPIO43);
        GPIO_setDirectionMode(43, GPIO_DIR_MODE_IN);
        GPIO_setPadConfig(43, GPIO_PIN_TYPE_STD);
        GPIO_setQualificationMode(43, GPIO_QUAL_SYNC);
        GPIO_setControllerCore(43, GPIO_CORE_CPU1);
    // === ADC ===
        ADC_setPrescaler(ADCA_BASE, ADC_CLK_DIV_4_0);
        ADC_setInterruptPulseMode(ADCA_BASE, ADC_PULSE_END_OF_CONV);
        ADC_setMode(ADCA_BASE, ADC_RESOLUTION_12BIT, ADC_MODE_SINGLE_ENDED);
        ADC_enableConverter(ADCA_BASE);

        ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN0, 20);
        ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN1, 20);
        ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER2, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN2, 20);
        ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER3, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN3, 20);
        ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER4, ADC_TRIGGER_EPWM2_SOCA,ADC_CH_ADCIN4, 20);

        //ADC_setBurstModeConfig(ADCA_BASE, ADC_TRIGGER_EPWM2_SOCA, 5);  // ͻ5SOC
        //ADC_enableBurstMode(ADCA_BASE);                                // ʹͻģʽ

        ADC_setInterruptSource(ADCA_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER4); // INT1SOC4ɺ󴥷
        ADC_enableInterrupt(ADCA_BASE, ADC_INT_NUMBER1);                     // ʹINT1
        ADC_disableContinuousMode(ADCA_BASE, ADC_INT_NUMBER1);               // ģʽ
        ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);                // INT1־λ

        DELAY_US(1000);
}


/*
Timer0ʼ
˵4ж
*/
void MY_Timer0_Init(void)
{
    // === TIMER0  : ʱ ===
    CPUTimer_stopTimer(CPUTIMER0_BASE);
    ConfigCpuTimer(&CpuTimer0, 200, 4000000);
    CPUTimer_reloadTimerCounter(CPUTIMER0_BASE);
    CPUTimer_setEmulationMode(CPUTIMER0_BASE,CPUTIMER_EMULATIONMODE_STOPAFTERNEXTDECREMENT);
    CPUTimer_enableInterrupt(CPUTIMER0_BASE);
    CPUTimer_startTimer(CPUTIMER0_BASE);
}

/*
Timer1ʼ
˵8ж
*/
void MY_Timer1_Init(void)
{
    // === TIMER0  : ʱ ===
    CPUTimer_stopTimer(CPUTIMER1_BASE);
    ConfigCpuTimer(&CpuTimer1, 200, 8000000);
    CPUTimer_reloadTimerCounter(CPUTIMER1_BASE);
    CPUTimer_setEmulationMode(CPUTIMER1_BASE,CPUTIMER_EMULATIONMODE_STOPAFTERNEXTDECREMENT);
    CPUTimer_enableInterrupt(CPUTIMER1_BASE);
    CPUTimer_startTimer(CPUTIMER1_BASE);
}


int main(void)
{

    // 1: ʼ豸ʱӺ
        Device_init();
        Device_initGPIO();

        // 2: ʼʱ
        InitCpuTimers();

        // 3: жϳʼ
    //    Interrupt_initModule();
    //    Interrupt_initVectorTable();
        DINT;
        InitPieCtrl();
        IER = 0x0000;
        IFR = 0x0000;
        InitPieVectTable();

        // 4: ʼģ
        MY_ADC_Init();                //ADC
        MY_CLA_Init();                // CLA

        // 6: CPUж
        Interrupt_enableInCPU(INTERRUPT_CPU_INT1);  // ʹPIE1 (ADCA1TIMER0)
        Interrupt_enableInCPU(INTERRUPT_CPU_INT3);  // ʹPIE3 (EPWM1)
    //    Interrupt_enableInCPU(INTERRUPT_CPU_INT4);  // ʹPIE4 (ECAP1)
    //    Interrupt_enableInCPU(INTERRUPT_CPU_INT11); // ʹPIE11(CLA)
    //    IER |= M_INT1;  // ʹPIE1 (ADCA1TIMER0)
    //    IER |= M_INT3;  // ʹPIE3 (EPWM1)
        //IER |= M_INT4;  // ʹPIE4 (ECAP1)
        //IER |= M_INT11; // ʹPIE11(CLA)
        //Interrupt_enableGlobal();
        EINT;
        ERTM;

        while(1)
        {
            asm(" NOP");
        }
}
