
#include "AdcConfigure.h"
void Adc_GPIO_Init(uint32_t pinConfig, uint32_t pin)
{
    GPIO_setPinConfig(pinConfig);
    // AIO -> Analog mode selected
    GPIO_setAnalogMode(pin, GPIO_ANALOG_ENABLED);
}
void ADC_Port_Init(void)
{
    EALLOW;
    Adc_GPIO_Init(PVFirstSimpleCurrent_PIN,PVFirstSimpleCurrent_PAD);
    Adc_GPIO_Init(PVFirstSimpleVoltage_PIN,PVFirstSimpleVoltage_PAD);
    Adc_GPIO_Init(InverterSimpleVoltage_PIN,InverterSimpleVoltage_PAD);

//    Adc_GPIO_Init(GPIO_231_GPIO231,231);
//    Adc_GPIO_Init(GPIO_232_GPIO232,232);
//    Adc_GPIO_Init(GPIO_224_GPIO224,224);
    EDIS;
}


//*****************************************************************************
//
// ASYSCTL Configurations
//
//*****************************************************************************
void ASYSCTL_init()
{
    EALLOW;
    //
    // asysctl initialization
    //
    // Disables the temperature sensor output to the ADC.
    //
    ASysCtl_disableTemperatureSensor();
    //
    // Set the analog voltage reference selection to internal.
    //
    ASysCtl_setAnalogReferenceInternal( ASYSCTL_VREFHI );
    //
    // Set the internal analog voltage reference selection to 1.65V.
    //
    ASysCtl_setAnalogReference1P65( ASYSCTL_VREFHI );
    EDIS;
}

void ADC_Configure(void)
{
    ADC_Port_Init();
    ASYSCTL_init();
    EALLOW;
    ADC_setOffsetTrimAll(ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

    ADC_setPrescaler(myADC0_BASE, ADC_CLK_DIV_2_0);

    ADC_setInterruptPulseMode(myADC0_BASE, ADC_PULSE_END_OF_CONV);

    ADC_enableConverter(myADC0_BASE);

    DEVICE_DELAY_US(5000);

    ADC_disableBurstMode(myADC0_BASE);

    ADC_setSOCPriority(myADC0_BASE, ADC_PRI_ALL_ROUND_ROBIN);

    ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN0, 9U);
    ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);
///PVVoltage
    ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER1, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN4, 9U);
    ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER1, ADC_INT_SOC_TRIGGER_NONE);
//current
    ADC_setupSOC(myADC0_BASE, ADC_SOC_NUMBER2, ADC_TRIGGER_EPWM1_SOCA, ADC_CH_ADCIN12, 9U);
    ADC_setInterruptSOCTrigger(myADC0_BASE, ADC_SOC_NUMBER2, ADC_INT_SOC_TRIGGER_NONE);
//inverterVoltage
    ADC_setInterruptSource(myADC0_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER2);
    ADC_clearInterruptStatus(myADC0_BASE, ADC_INT_NUMBER1);
    ADC_disableContinuousMode(myADC0_BASE, ADC_INT_NUMBER1);
    ADC_enableInterrupt(myADC0_BASE, ADC_INT_NUMBER1);
    EDIS;
}
