//#############################################################################
//
// FILE:    gpio_ex2_toggle.c
//
// TITLE:   Device GPIO Toggle
//
//! \addtogroup driver_example_list
//! <h1> Device GPIO Toggle </h1>
//!
//! Configures the device GPIO through the sysconfig file. The GPIO pin is 
//! toggled in the infinit loop.
//
//#############################################################################
//
//
// $Copyright:
// Copyright (C) 2023 Texas Instruments Incorporated - http://www.ti.com/
//
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
//   Redistributions of source code must retain the above copyright 
//   notice, this list of conditions and the following disclaimer.
// 
//   Redistributions in binary form must reproduce the above copyright
//   notice, this list of conditions and the following disclaimer in the 
//   documentation and/or other materials provided with the   
//   distribution.
// 
//   Neither the name of Texas Instruments Incorporated nor the names of
//   its contributors may be used to endorse or promote products derived
//   from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// $
//#############################################################################

//
// Included Files
//
#include "driverlib.h"
#include "device.h"
#include "boardtest.h"
#include "PWMConfigure.h"
#include "AdcConfigure.h"
#include "realy.h"
#include "math.h"
uint32_t EPwm1TimerIntCount;
uint16_t LEDcount;
uint16_t adcAResult0;
uint16_t adcAResult1;
uint16_t adcAResult2;
uint16_t adcCResult0;
uint16_t adcCResult1;
uint16_t adcCResult2;
uint16_t keyenable = 1;
uint16_t keyenable1 = 0;
#define N_2PI 6.2831853f
#define N_PI 3.1415926f
float theta = 0.0f;
float dealttheta = N_2PI/200.0f;
float hudu = 0.0f;
float fuzhi = 0.1f;
float tri = 0.0f;
uint16_t ame = 400;
uint16_t COMPFly = 0;
uint16_t PWMout = 400;
float test[400];
uint16_t testcount;
float testcurrent[400];
float testVolInv[400];
//
// Function Prototypes
//
//void initEPWM();
__interrupt void adcA1ISR(void);
interrupt void xint1ISR(void);
//
// Main
//
void main(void)
{
    Device_init();
    Interrupt_initModule();
    Interrupt_initVectorTable();
    Boardtest_init();
    PWM_Port_Init();
    Realy_Port_Init();
    GPIO_setDirectionMode(17, GPIO_DIR_MODE_IN);             // input
    GPIO_setQualificationMode(17, GPIO_QUAL_SYNC);
    GPIO_setDirectionMode(17, GPIO_DIR_MODE_IN);
    GPIO_setInterruptPin(17, GPIO_INT_XINT1);
    GPIO_setInterruptType(GPIO_INT_XINT1, GPIO_INT_TYPE_FALLING_EDGE);
    GPIO_enableInterrupt(GPIO_INT_XINT1);
    ADC_Configure();
    PWM_Configure();


    EALLOW;
    Interrupt_register(INT_XINT1, &xint1ISR);
    Interrupt_register(INT_ADCA1, &adcA1ISR);
    Interrupt_enable(INT_XINT1);
    Interrupt_enable(INT_ADCA1);
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
    EDIS;


    EINT;
    ERTM;
    GPIO_writePin(3,1);
    for(;;)
    {

////        GPIO_togglePin(3);
//        GPIO_togglePin(1);
//        GPIO_togglePin(4);
//        GPIO_togglePin(5);
//        GPIO_togglePin(7);
////       /
//        DEVICE_DELAY_US(100000);
//        InverterStop();
//        GPIO_togglePin(1);
//        GPIO_togglePin(4);
//        GPIO_togglePin(5);
//        GPIO_togglePin(7);
//        EnablePWMOut();
//        DEVICE_DELAY_US(100000);
    }
}

float PVVoltage;
float PVCurrent;
float InverterVoltage;
//
__interrupt void adcA1ISR(void)
{
    //
    // Store results
    //
    EINT;

    adcAResult0 = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);
    adcAResult1 = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER1);
    adcAResult2 = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER2);
    PVVoltage= adcAResult0;
    PVCurrent= ((int)adcAResult1)/169.3f;
    InverterVoltage = ((int)adcAResult2-(int)2100)/4.0f;
//    adcCResult0 = ADC_readResult(ADCCRESULT_BASE, ADC_SOC_NUMBER0);
//    adcCResult1 = ADC_readResult(ADCCRESULT_BASE, ADC_SOC_NUMBER1);
//    adcCResult2 = ADC_readResult(ADCCRESULT_BASE, ADC_SOC_NUMBER2);
    EPwm1TimerIntCount++;
    LEDcount++;
    if (LEDcount == 5000)
    {
//        GPIO_togglePin(myGPIOOutput0test);
        GPIO_writePin(myGPIOOutput0test,1);
    }
    //
    // Toggle LED2 when the count reaches 500
    //
    if (LEDcount == 100)
    {
        fuzhi += 0.01f;
        if(fuzhi>0.5f)
            fuzhi = 0.5f;
//        GPIO_togglePin(myGPIOOutput0test);
        GPIO_writePin(myGPIOOutput0test,0);
        LEDcount=0;
    }
    theta += dealttheta;
    if(theta>N_PI)
        theta -= N_2PI;
    else if(theta<-N_PI)
        theta += N_2PI;

    hudu = (float)sin(theta);
    tri = hudu *fuzhi;
    testcount++;
    if(testcount<400)
    {

    }
    else
    {
        testcount = 0;
    }
    test[testcount] = adcAResult0;
    testcurrent[testcount] = PVCurrent;
    testVolInv[testcount] = InverterVoltage;
    if(keyenable)
        {
            if(tri<0.0f)
                tri = -tri;
            COMPFly = (uint16_t)(tri*ame);
             PWMout = ame-COMPFly;
             if(PWMout<200)
                 PWMout = 200;
             else if(PWMout>395)
                 PWMout = 400;
             else if(PWMout>390)
                 PWMout = 390;

            EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, PWMout);
//            keyenable1++;
//            if(keyenable1<1000)
//            {
                if(theta>(0.05f*N_PI))
                {
                    InverterPositive();
                    EnablePWMOut();
                }
                else if(theta<(-0.05f*N_PI))
                {
                    InverterNegative();
                    EnablePWMOut();
                }
                else
                {
                    InverterStop();
                    DisablePWMOut();
                }
//            }
//            else
//            {
//                keyenable = 0;
//                keyenable1 = 0;
//                DisablePWMOut();
//            }

        }
        else
        {
            DisablePWMOut();
        }

    //
    // Clear the interrupt flag
    //
    ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);

    //
    // Check if overflow has occurred
    //
    if(true == ADC_getInterruptOverflowStatus(ADCA_BASE, ADC_INT_NUMBER1))
    {
        ADC_clearInterruptOverflowStatus(ADCA_BASE, ADC_INT_NUMBER1);
        ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
    }

    //
    // Acknowledge the interrupt
    //
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP1);
}

interrupt void xint1ISR(void)
{
//    GPIO_writePin(40, 0); // GPIO16 is lowered
//    DisablePWMOut();
//    InverterStop();
    keyenable = 0;
    //
    // Acknowledge this interrupt to get more from group 1
    //
    Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP1);
}




