/* =================================================================================
File name:       CUR_LOOP.H  (IQ version)
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description: 
Header file containing constants, data type definitions, and 
function prototypes for the CURDQ.
=====================================================================================
 History:
-------------------------------------------------------------------------------------
 03-13-2019	Version 2.01
------------------------------------------------------------------------------*/
#ifndef __CURDQ_H__
#define __CURDQ_H__


typedef struct{
	_iq			Is_ref;					// Input: ⲿ
	_iq			I_back;					// Input: ⲿⷴ
	_iq 		Is_ud_next;				// Input: жԤһжϵ趨Ԥֵ
	_iq 		IM_pd_befor;			// Input: жϼѹֵʱõһжϵֵ
	_iq 		IM_ud;					// Input: жϲĵֵ
	_iq 		Vud_pd;					// Input: жʱҪ絽ڵĵѹƽֵһжʱ̵ĵѹԤֵ
	_iq			VC_ud;					// Output: жʱ̼ȫڵѹƽֵ
	_iq 		Vpd_ud_next;			// Output: жһ絽˴ڵĵѹƽֵҲжϸµvDQֵ
	_iq 		Vpd_ud_next_before;		// inner: жϼѹҪǰ0.25TĵѹֵǰһVpd_ud_next
	_iq 		Eud;					// Output: жʱ̹ķ綯ƽֵ,Ϊ-0.25Tʱֵ
	_iq 		Vfdb_ud;				// Output: жʱ̹ȫڵĵѹƽֵݷı仯㣩Ϊ-0.25Tʱֵ
	_iq  		Is_pd_next;				// Input:жԤһжϵĵ趨Ԥֵ
	_iq  		IM_ud_next;				// Input:жԤһжʱ̵ĵֵ				_iq  Is_ud_next;	// Variable:жԤһжϵ趨Ԥֵ
	_iq  		Idelta;					// inner:жԤһжʱ̵ĵֵʱõĲ
	_iq  		IM_pd;					// Input:жϲĵֵ:
	_iq  		Is_pd;					// Input:жʱ̵趨ֵ
	_iq 		VC_pd;					// Output: жϼĵѹֵPWMӰӼĴһжϸ±Ƚֵ
	_iq 		VC_pd_before;			// inner: жϼĵѹֵҪ0.25Tʱ̵ĵѹֵ
	_iq 		Epd;					// Output: жʱ̹һ絽һʱ֮ķ綯ƽֵ
	_iq 		Vfdb_pd;				// inner: жʱ̹һ絽һʱ֮䣨ݷı仯)
	_iq 		E;						// Output: new Back EMF
	_iq 		E1;						// Output: Back EMF after first filter
	_iq 		E2;						// Output: Back EMF after second filter
	_iq			E3;						// Output: Back EMF after commp
	_iq 		Vout;					// Output: ѹ
} CUR_VAR;



typedef struct {  CUR_VAR  D;   		// struct: D shaft
				  CUR_VAR  Q;   		// struct: Q shaft
				  Uint16   ISR_flag;    // жϺAD־
				  Uint16   Vsat_flag;	// ѹͱ־
				  _iq	   dleta_coef;	// ϵ
				  Uint16   Vfdb_select; //
				  float32  Rs;			// Variable: Motor Resistance
				  float32  LDs;			// Variable: Motor Inductance
				  float32  LQs;			// Variable: Motor Inductance
				  float32  LRs;			// Variable: Motor Inductance
				  float32  LDTs;
				  float32  LQTs;
				  float32  Ib; 			// Input: Base phase current (amp)
				  float32  Vb;			// Input: Base phase voltage (volt)
				  float32  Ts;			// Input: Sampling period in sec
				  float32  Theta;		// Output:
				  float32  Efliter_K2;	// Parameter: Constant for low-pass filter (pu) for E
				  float32  Efliter_K3;  // Parameter: Constant for low-pass filter (pu) for E
				  _iq  A;				// Input: 綯˲油
				  _iq  thetacomm;		// Input: 綯˲+ӳٽǶȲ
				  _iq  OutMax;		    // Parameter: Maximum output 
				  _iq  OutMin;	    	// Parameter: Minimum output
		 	 	  void  (*init)();	  	// Pointer to calculation function
		 	 	  void  (*calc)();	  	// Pointer to calculation function
				 } CURDQ;

typedef CURDQ *CURDQ_handle;
/*-----------------------------------------------------------------------------
Default initalizer for the CURDQ object.
-----------------------------------------------------------------------------*/                     
#define CURDQ_DEFAULTS { {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, \
						 {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}, \
                           0, \
                           0, \
                           _IQ(0.5), \
                           0, \
                           0, \
                           0, \
                           0, \
						   0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           _IQ(1), \
                           0, \
                           _IQ(0.99), \
                           _IQ(-0.99), \
              			  (void (*)(Uint32))Cur_DQ_init,\
  	  	  	  	  	  	  (void (*)(Uint32))Cur_DQ_calc }

/*------------------------------------------------------------------------------
Prototypes for the functions in PIDREG3.C
------------------------------------------------------------------------------*/
void Cur_DQ_init(CURDQ_handle);
void Cur_DQ_calc(CURDQ_handle);

#endif
