/* =================================================================================
File name:       CUR_LOOP.H  (IQ version)
                    
Originator:	Digital Control Systems Group
			Texas Instruments

Description: 
Header file containing constants, data type definitions, and 
function prototypes for the CURDQ.
=====================================================================================
 History:
-------------------------------------------------------------------------------------
 04-15-2005	Version 3.20
------------------------------------------------------------------------------*/
#ifndef __FLITER_COMP_H__
#define __FLITER_COMP_H__


typedef struct{
	Uint16   ISR_flag;    // жϺAD־
	float 	fs;			// para: Reference input,زƵ
	float   fb;			// para  Ƶ
	float	NBase;		// para: ز
	float	N;			// para: ʵز
	float 	T;			// para: жڣһڣжʱ
	_iq		speed;		//
	_iq		Tcomm_uf;	// para: ʱϵ
	_iq		Tcomm_pd;	// para ʱϵ
	float 	thetadelta;	// Output: ˲ӳٲʱ
	_iq 	theta;		// Output: ղǶ
	_iq		theta_comm_T;// Outputӳٲ
	_iq 	A;			// Output: һ˲ֵ
	void  (*init)();	// Pointer to calculation function
	void  (*calc)();	// Pointer to calculation function
} FILTER_COMP;



typedef FILTER_COMP *FILTER_COMP_handle;
/*-----------------------------------------------------------------------------
Default initalizer for the CURDQ object.
-----------------------------------------------------------------------------*/                     
#define FILTER_COMP_DEFAULTS { 0, \
	                       6000, \
	                       100, \
	                       60, \
	                       0, \
	                       0, \
	                       0, \
	                       0, \
                           0, \
                           0, \
                           0, \
                           0, \
                           _IQ(1), \
              			  (void (*)(Uint32))Fliter_Comp_init,\
  	  	  	  	  	  	  (void (*)(Uint32))Fliter_Comp_calc }

/*------------------------------------------------------------------------------
Prototypes for the functions in PIDREG3.C
------------------------------------------------------------------------------*/
void Fliter_Comp_init(FILTER_COMP_handle);
void Fliter_Comp_calc(FILTER_COMP_handle);

#endif
