/* ==============================================================================
System Name:  PMSM32

File Name:	PARAMETER.H

Description:	Parameters file for the Real Implementation of Sensorless 
          		Field Orientation Control for a Three Phase Permanent-Magnet
          		Synchronous Motor (PMSM) using sliding-mode rotor position estimator
          		
Originator:		Digital control systems Group - Texas Instruments

Note: In this software, the default inverter is supposed to be DMC1500 board.
=====================================================================================
 History:
-------------------------------------------------------------------------------------
 04-15-2005	Version 3.20
=================================================================================  */

#ifndef PARAMETER_H
#define PARAMETER_H



/*-------------------------------------------------------------------------------
Next, definitions used in main file.
-------------------------------------------------------------------------------*/
#ifndef TRUE
#define FALSE 0
#define TRUE  1
#endif

#define PI 3.14159265358979

#define Rou 0.75

// Define the system frequency (MHz)


#define SYSTEM_FREQUENCY 150			// 150޸


// Define the ISR frequency (kHz)
#define ISR_FREQUENCY 3				// 20޸ 20190306 10k3k

// This machine parameters are based on 1-hp PacSci PMSM motor
// Define the PMSM motor parameters -- Taiyuan
//#define RS   	0.18              	// Stator resistance (ohm) 0.18
//#define RR   	0               	// Rotor resistance (ohm)
//#define LDS   	0.001799   		// Stator inductance (H)
//#define LQS   	0.003777    	// Stator inductance (H)
//#define LS   	0.001994    		// Stator inductance (H)
//#define LR   	0					// Rotor inductance (H)
//#define LM   	0					// Magnetizing inductance (H)
//#define P    	8					// Number of poles

// taiyuan motr para
//#define BASE_VOLTAGE   560   					// Base peak phase voltage (volt) 184.752
//#define BASE_CURRENT   129            			// Base peak phase current (amp)  35*1.414
//#define BASE_TORQUE    105   					// Base torque (N.m)
//#define BASE_FLUX      	0.79616       			// Base flux linkage (volt.sec/rad)
//#define BASE_FREQ     	100          			// Base electrical frequency (Hz)



// Beijing PMSM parameter
#define RS   	0.186 //taiyuan//0.49//beijing//		             	// Stator resistance (ohm) 0.18
#define RR   	0               	// Rotor resistance (ohm)
#define LDS   	0.00381 //taiyuan//0.0064//beijing//		//  	Stator inductance (H)
#define LQS   	0.00381 //taiyuan//0.0064//beijing// 	//    Stator inductance (H)
#define LS   	0.001994    		// Stator inductance (H)
#define LR   	0					// Rotor inductance (H)
#define LM   	0					// Magnetizing inductance (H)
#define P    	8					// Number of poles


// Define the base quantites 
// These base values are for 1-hp PacSci PMSM motor
//  beijing 220VֵΪ311V380VֵΪ537V
#define BASE_VOLTAGE    540 //320//   					// Base peak phase voltage (volt) 184.752
#define BASE_CURRENT    50//taiyuan//66 //beijing//           			// Base peak phase current (amp)
#define BASE_TORQUE     55   					// Base torque (N.m)
#define BASE_FLUX      	0.79616       			// Base flux linkage (volt.sec/rad)
#define BASE_FREQ     	100          			// Base electrical frequency (Hz)



#endif  // end of PARAMETER.H definition

//===========================================================================
// No more.
//===========================================================================
