
#ifndef VCTEST_H_
#define VCTEST_H_
#include "DSP281x_Device.h"
#include "IQmathLib.h"
#include "math.h"
#include "vcpublic.h"

typedef struct{
	              Uint16   VC_start;			        // input: voltate compentation test flag
	              Uint16   VC_start_flag;			    // para: vc status flag
	              Uint16   VC_end;			            // para: vc end flag
	              Uint16   VC_cal_num;			        // para: 
	              Uint16  VC_I_set_flag;                //para: С־1 2С
	              Uint16   VC_f2_change_flag;		    // para:ıƵʱ־
	              Uint16   VC_f1_flag;		            // para:ıƵʱ־
	              Uint16   VC_f2_flag;		            // para:ıƵ
	              Uint16   cur_f1;			            // para: زƵ
	              Uint16   cur_f2;			            // para: زƵ
	              float32  VC_t_f1;			            // para: ز
	              float32  VC_t_f2;			            // para: ز
	              float32  VC_I_f_u;				     // input: u current
	              float32  VC_I_f_v;		             // input: v current
	              float32  VC_vdc;                       // input: vdc
	              float32  VC_ID;                        // output: D
	              float32  VC_IQ;                        // output: Q
	              float32  VC_motor_R;                   // input: 
	              float32  VC_I_rated;                   // input: 
	              float32  VC_I_input;                   // input: 
	              float32  VC_V_output;                  // output: ѹ
	              float32  VC_vdc_rated;                  // input: ĸߵѹ
	              _iq19    iq_VC_D_return;               // input: DѹΪ
	              _iq19    iq_VC_Q_return;               // input: QѹΪ
	              Uint16  VC_I_count;                    // para: 
	              float32 VC_Iu_set;                     // para: U
	              float32 VC_Iv_set;                     // para: V
	              Uint16  VC_test_count;
	              void (*init)();                        // ʼ
	              void (*compensator)();                 // 㲹ѹ
	              void (*query)();                       // ѯѹ
	              void (*querysmall)();                  // ѯСѹ
	              }VCTEST;

typedef VCTEST *VCTEST_handle;
#define VCTEST_DEFAULTS {  0, \
                          0, \
                          0, \
                          0, \
                          1, \
                          0, \
                          0, \
                          0, \
                          24999, \
                          12499, \
                          0, \
                          0, \
                          0, \
                          0, \
                          0, \
                          0, \
                          0, \
                          0.186, \
                          30, \
                          0, \
                          0, \
                          564.0, \
                          0, \
                          0, \
                          0, \
                          0, \
                          10, \
                          0, \
                          (void (*)(Uint32))VCTEST_init,\
                          (void (*)(Uint32))VCTEST_compensator, \
                          (void(*)(Uint32))VCTEST_query, \
                          (void(*)(Uint32))VCTEST_querysmall \
	                    }

void VCTEST_init(VCTEST_handle);
void VCTEST_compensator(VCTEST_handle);
void VCTEST_query(VCTEST_handle);
void VCTEST_querysmall(VCTEST_handle);


#endif /* VCTEST_H_ */
