// TI File $Revision: /main/2 $
// Checkin $Date: April 29, 2005   11:11:45 $
//###########################################################################
//
// FILE:	DSP281x_Adc.c
//
// TITLE:	DSP281x ADC Initialization & Support Functions.
//
//###########################################################################
// $TI Release: DSP281x C/C++ Header Files V1.20 $
// $Release Date: July 27, 2009 $
//###########################################################################

#include "DSP281x_Device.h"     // DSP281x Headerfile Include File
#include "DSP281x_Examples.h"   // DSP281x Examples Include File

#define ADC_usDELAY  8000L
#define ADC_usDELAY2 20L

#define ADC_MODCLK 0x3   // HSPCLK = SYSCLKOUT/2*ADC_MODCLK2 = 150/(2*3)     = 25MHz
#define ADC_CKPS   0x0   // ADC module clock = HSPCLK/1      = 25MHz/(1)     = 25MHz
#define ADC_SHCLK  0x0   // S/H width in ADC module periods0-15
#define AVG        1000  // Average sample limit
#define ZOFFSET    0x00  // Average Zero offset
#define BUF_SIZE   2048  // Sample buffer size
//---------------------------------------------------------------------------
// InitAdc: 
// InitAdc_1st;
//---------------------------------------------------------------------------
// This function initializes ADC to a known state.
//
void InitAdc(void)
{
	extern void DSP28x_usDelay(Uint32 Count);
	
    // To powerup the ADC the ADCENCLK bit should be set first to enable
    // clocks, followed by powering up the bandgap and reference circuitry.
    // After a 5ms delay the rest of the ADC can be powered up. After ADC
    // powerup, another 20us delay is required before performing the first
    // ADC conversion. Please note that for the delay function below to
    // operate correctly the CPU_CLOCK_SPEED define statement in the
    // DSP28_Examples.h file must contain the correct CPU clock period in
    // nanoseconds. For example:

	AdcRegs.ADCTRL3.bit.ADCBGRFDN = 0x3;	// Power up bandgap/reference circuitry
	DELAY_US(ADC_usDELAY);                  // Delay before powering up rest of ADC
	AdcRegs.ADCTRL3.bit.ADCPWDN = 1;		// Power up rest of ADC
	DELAY_US(ADC_usDELAY2);                 // Delay after powering up ADC

	// Configure ADC
	AdcRegs.ADCTRL3.bit.ADCCLKPS = ADC_MODCLK;	///ADC ʱӣ150/(ADC_CKPS*2) /(CPS+1) = 25 MHz
	AdcRegs.ADCTRL1.bit.CPS = ADC_CKPS;
	AdcRegs.ADCTRL1.bit.ACQ_PS = ADC_SHCLK;  // ΪACQ_PS+1

	AdcRegs.ADCTRL1.bit.SEQ_CASC = 1;       // 1  Cascaded mode
	AdcRegs.ADCTRL1.bit.CONT_RUN = 0;       //  Զλ
	AdcRegs.ADCTRL1.bit.SUSMOD = 3;         //  ͣз߼ֹͣ

	AdcRegs.ADCMAXCONV.all = 0x000F;        // Setup 2 conv's on SEQ1
	AdcRegs.ADCTRL2.bit.EVA_SOC_SEQ1 = 1;   //   Enable EVASOC to start SEQ1
	AdcRegs.ADCTRL2.bit.INT_ENA_SEQ1 = 1;   // Enable SEQ1 interrupt (every EOS)

	   ////////-----test
//	   AdcRegs.ADCCHSELSEQ1.bit.CONV00 = 0x1;  // 4
//	   AdcRegs.ADCCHSELSEQ1.bit.CONV01 = 0x1;
//	   AdcRegs.ADCCHSELSEQ1.bit.CONV02 = 0x1;
//	   AdcRegs.ADCCHSELSEQ1.bit.CONV03 = 0x1;
//	   AdcRegs.ADCCHSELSEQ2.bit.CONV04 = 0x1;
//	   AdcRegs.ADCCHSELSEQ2.bit.CONV05 = 0x1;
//	   AdcRegs.ADCCHSELSEQ2.bit.CONV06 = 0x1;
//	   AdcRegs.ADCCHSELSEQ2.bit.CONV07 = 0x1;
//	   AdcRegs.ADCCHSELSEQ3.bit.CONV08 = 0x1;
//	   AdcRegs.ADCCHSELSEQ3.bit.CONV09 = 0x1;
//	   AdcRegs.ADCCHSELSEQ3.bit.CONV10 = 0x1;
//	   AdcRegs.ADCCHSELSEQ3.bit.CONV11 = 0x1;
//	   AdcRegs.ADCCHSELSEQ4.bit.CONV12 = 0x1;
//	   AdcRegs.ADCCHSELSEQ4.bit.CONV13 = 0x1;
//	   AdcRegs.ADCCHSELSEQ4.bit.CONV14 = 0x1;
//	   AdcRegs.ADCCHSELSEQ4.bit.CONV15 = 0x1;	///ֱĸߵѹ
	   ////////-----test
	   AdcRegs.ADCCHSELSEQ1.bit.CONV00 = 0x1;  // 4
	   AdcRegs.ADCCHSELSEQ1.bit.CONV01 = 0x1;
	   AdcRegs.ADCCHSELSEQ1.bit.CONV02 = 0x1;
	   AdcRegs.ADCCHSELSEQ1.bit.CONV03 = 0x1;
	   AdcRegs.ADCCHSELSEQ2.bit.CONV04 = 0x9;
	   AdcRegs.ADCCHSELSEQ2.bit.CONV05 = 0x9;
	   AdcRegs.ADCCHSELSEQ2.bit.CONV06 = 0x9;
	   AdcRegs.ADCCHSELSEQ2.bit.CONV07 = 0x9;
	   AdcRegs.ADCCHSELSEQ3.bit.CONV08 = 0xa;
	   AdcRegs.ADCCHSELSEQ3.bit.CONV09 = 0xa;
	   AdcRegs.ADCCHSELSEQ3.bit.CONV10 = 0xa;
	   AdcRegs.ADCCHSELSEQ3.bit.CONV11 = 0xa;
	   AdcRegs.ADCCHSELSEQ4.bit.CONV12 = 0x2;
	   AdcRegs.ADCCHSELSEQ4.bit.CONV13 = 0x2;
	   AdcRegs.ADCCHSELSEQ4.bit.CONV14 = 0x2;
	   AdcRegs.ADCCHSELSEQ4.bit.CONV15 = 0x2;	///ֱĸߵѹ
}	

void ad_intt_init()
{
	  AdcRegs.ADCTRL2.bit.RST_SEQ1 = 1;         // Reset SEQ1
	  AdcRegs.ADCST.bit.INT_SEQ1_CLR = 1;       // Clear INT SEQ1 bit
	  PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;   // Acknowledge interrupt to PIE
	  EINT;
}
//===========================================================================
// No more.
//===========================================================================
