// TI File $Revision: /main/2 $
// Checkin $Date: April 29, 2005   11:10:23 $
//###########################################################################
//
// FILE:	DSP281x_Ev.c
//
// TITLE:	DSP281x Event Manager Initialization & Support Functions.
//
//###########################################################################
// $TI Release: DSP281x C/C++ Header Files V1.20 $
// $Release Date: July 27, 2009 $
//###########################################################################

#include "DSP281x_Device.h"     // DSP281x Headerfile Include File
#include "DSP281x_Examples.h"   // DSP281x Examples Include File


//---------------------------------------------------------------------------
// InitEv: 
//---------------------------------------------------------------------------
// This function initializes to a known state.
//
void InitEv(void)
{
	// EVA Configure T1PWM, T2PWM, PWM1-PWM6
	// Initalize the timers
	   // Initalize EVA Timer1
	   EvaRegs.T1PR =   24999; //14999; //   // Timer1 period 0x1d4b 7499  10k  0x61a7 24999  3k
	   EvaRegs.T1CMPR = 0x3C00;     // Timer1 compare
	   EvaRegs.T1CNT = 0x0000;      // Timer1 counter
	   // TMODE = continuous up/down
	   // Timer enable
	   // Timer compare enable
	   EvaRegs.T1CON.all = 0x0846;//0x0846;//0846ʾںжϸ±ȽϼĴֵ//0x0942;//0942ʾT1ʱΪʱӳ2//continuous up/down//
	   EvaRegs.EVAIMRA.bit.T1PINT = 1;
	   EvaRegs.EVAIFRA.bit.T1PINT = 1;
	   EvaRegs.EVAIMRA.bit.T1UFINT = 1;
	   EvaRegs.EVAIFRA.bit.T1UFINT = 1;
	   EvaRegs.EVAIFRA.bit.CMP1INT = 1;
	   EvaRegs.EVAIMRA.bit.CMP1INT = 1;
	   EvaRegs.EVAIFRA.bit.CMP2INT = 1;
	   EvaRegs.EVAIMRA.bit.CMP2INT = 1;
	   EvaRegs.EVAIFRA.bit.CMP3INT = 1;
	   EvaRegs.EVAIMRA.bit.CMP3INT = 1;


	  // Initalize EVA Timer2
	  EvaRegs.T2PR = 0x0FFF;       // Timer2 period
	  EvaRegs.T2CMPR = 0x03C0;     // Timer2 compare
	  EvaRegs.T2CNT = 0x0000;      // Timer2 counter
	  // TMODE = continuous up/down
	  // Timer enable
	  // Timer compare enable
	  EvaRegs.T2CON.all = 0x1002;


	  // Setup T1PWM and T2PWM
	  // Drive T1/T2 PWM by compare logic
	  EvaRegs.GPTCONA.bit.TCMPOE = 1;
	  // Polarity of GP Timer 1 Compare = Active low
	  EvaRegs.GPTCONA.bit.T1PIN = 1;
	  // Polarity of GP Timer 2 Compare = Active high
	  EvaRegs.GPTCONA.bit.T2PIN = 2;

	  // Enable compare for PWM1-PWM6
	  EvaRegs.CMPR1 = 0x3000;
	  EvaRegs.CMPR2 = 0x3000;
	  EvaRegs.CMPR3 = 0x3000;

	  // Compare action control.  Action that takes place
	  // on a cmpare event
	  // output pin 1 CMPR1 - active high
	  // output pin 2 CMPR1 - active low
	  // output pin 3 CMPR2 - active high
	  // output pin 4 CMPR2 - active low
	  // output pin 5 CMPR3 - active high
	  // output pin 6 CMPR3 - active low
	  EvaRegs.ACTRA.all = 0x0666;
	  EvaRegs.DBTCONA.all = 0x0ff4; // 3.2us
	  EvaRegs.COMCONA.all = 0xA600;         //Compare register CMPRx reload condition

	    EvaRegs.GPTCONA.bit.T1TOADC = 1;
}	
	
//===========================================================================
// No more.
//===========================================================================
