/*
 *  This file is automatically generated and does not require a license
 *
 *  ==== WARNING: CHANGES TO THIS GENERATED FILE WILL BE OVERWRITTEN ====
 *
 *  To make changes to the generated code, use the space between existing
 *      "USER CODE START (section: <name>)"
 *  and
 *      "USER CODE END (section: <name>)"
 *  comments, where <name> is a single word identifying the section.
 *  Only these sections will be preserved.
 *
 *  Do not move these sections within this file or change the START and
 *  END comments in any way.
 *  ==== ALL OTHER CHANGES WILL BE OVERWRITTEN WHEN IT IS REGENERATED ====
 *
 */
/* ============================================================================
System Name:    Power Factor Correction for single phase AC input with two phase
                interleaved transition mode totem pole configuration

File Name:	  	pfc2philtrmttpl-Settings.h

Target:

Author:         Hrishi Nene

Copyright (C) {2018} Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED*
==============================================================================*/

#ifndef _PROJSETTINGS_H
#define _PROJSETTINGS_H

#ifdef __cplusplus

extern "C" {
#endif

//******************************************************************************
//defines
//******************************************************************************

/* Device Related Defines */
#define CPU_SYS_CLOCK      (100*1000000)
#define PWMSYSCLOCK_FREQ   (100*1000000)
#define ECAPSYSCLOCK_FREQ  (100*1000000)

/* Project Options*/
//==============================================================================
// Incremental Build options for System check-out
//==============================================================================
// BUILD 1 	 Open Loop Check
// BUILD 2   Closed Current Loop Check
// BUILD 3   Closed Voltage Loop Check
#define INCR_BUILD 2

// Enable Demo Mode option
#define DEMO_MODE 0

// Check system under DC condition (cleanest SFRA curves) 0 is FALSE, 1 is TRUE
#define DC_CHECK 0
 
// set 1 to enable phase shedding 0 to disable 
#define PHASE_SHEDDING_ENABLED 0

#define AC_FREQ        	50//*60
#define GRID_FREQ       AC_FREQ
#define EXT_LOGIC       0

#define UNIVERSAL_GRID_MAX_VRMS 250.0
#define UNIVERSAL_GRID_MIN_VRMS 180.0//*90
#define UNIVERSAL_GRID_MAX_FREQ 63.0
#define UNIVERSAL_GRID_MIN_FREQ 47.0

/* Power Stage Related Values*/
//#define AC_SOURCE_TYPE      LOW_1KW_POWER_SOURCE	// Defined under user section
#define HIGH_POWER_SOURCE       1
#define LOW_1KW_POWER_SOURCE    0

// Max and Min period clamping
#define MIN_PFC_PWM_SWITCHING_FREQUENCY ((float)200*1000)
#define MAX_PFC_PWM_SWITCHING_FREQUENCY ((float)1200*1000)

// 200kHz with 100 MHz clock
#define MAX_PFC_PWM_PERIOD ((PWMSYSCLOCK_FREQ)/(MIN_PFC_PWM_SWITCHING_FREQUENCY)) 
// 1.2MHz with 100 MHz clock
#define MIN_PFC_PWM_PERIOD ((PWMSYSCLOCK_FREQ)/(MAX_PFC_PWM_SWITCHING_FREQUENCY)) 

//#define PERIOD_MIN_CLAMP    82     // 1.2MHz with 100 MHz clock
// 1.2MHz with 100 MHz clock // This value corresponds to the highest frequency 
// entered on the powerSuite page in kHz
#define PERIOD_MIN_CLAMP    MIN_PFC_PWM_PERIOD 
#define PERIOD_MAX          MAX_PFC_PWM_PERIOD     // 200kHz with 100 MHz clock
// 1MHz with 100 MHz clock (This value is used for Ton calculations)
#define PERIOD_MIN          (float)MIN_PFC_PWM_PERIOD*(1.2) 
#define TON_MAX             (float)PERIOD_MAX*(0.98)
#define WGHT_MAX            (float)PERIOD_MAX*(0.5)

#define PFC_DEADBAND_LS_US 0.4     //us
#define PFC_DEADBAND_HS_US 0.1     //us
#define PFC_PWM_PERIOD (PWMSYSCLOCK_FREQ)/((float)200*1000)	//Initial Period
#define PFC_DEADBAND_PWM_HS_COUNT (int)((float)PFC_DEADBAND_HS_US*(float)PWMSYSCLOCK_FREQ*(float)0.000001)
#define PFC_DEADBAND_PWM_LS_COUNT (int)((float)PFC_DEADBAND_LS_US*(float)PWMSYSCLOCK_FREQ*(float)0.000001)

//ADC SOC trigger frequency
#define PFC_PWM_SWITCHING_FREQUENCY ((float)200*1000)		

//
#define PFC_DEADBAND_CNTMAX  (80)       // 400 ns maximum
#define PFC_DEADBAND_CNTMIN  (6)        // 30 ns minimum

#define PFC_DEADBAND_CNTMAX_FALL    40  // 200 ns max
#define PFC_DEADBAND_CNTMIN_FALL     4  // 20 ns min

#define TOFF_MIN    (PFC_DEADBAND_CNTMIN/2)

#define VAC_MAX_SENSE 		677.51
#define VDCBUS_MAX_SENSE 	536.85
#define I_MAX_SENSE 		22.295
#define I_TRIP_LIMIT 		15
#define MIN_VAC_TYPICAL		90
#define MAX_VAC_TYPICAL		245

#define VBUS_TYPICAL 		390

#define VBUS_OVP_THRESHOLD	425
#define OCP_THRESHOLD		15

#define PFC_INDUCTOR_VALUE  15	//in uH
#define FET_COSS_VALUE 		145	//in pF
//**********************real variables definition**********************//
#define INDUCTOR_BACKWARDS  (float)(1/15)
#define INDUCTOR_BACKWARDS2  (float)(1/225)
#define RESONANT_IMPEDENCE  227.43//*Zn=sqrt(L/2/Coss)
#define RESONANT_IMPEDENCE2  51724//*Zn^2=(L/2/Coss)
#define RESONANT_BACKWARDS  0.004397//*1/Zn
#define RESONANT_BACKWARDS2 0.000019333333//*1/(Zn*Zn)
#define RESONANT_FREQUENCY  15161961//*wr=1/sqrt(2*L*Coss)
#define RESONANT_PERIOD     65.95//*in ns 1/wr=sqrt(2*L*Coss)
#define TZVS_MIN     0//*50//in ns ZVSʱԣ
#define TZVS_MIN2    0//*2500//*TZVS_MIN*TZVS_MIN
#define FSW_MAX      (float)(1500)//*λkHz
#define TSW_MIN      (float)(1/(FSW_MAX))//*λms
//*********************end definition***************************//

/* Control Loop Design */
#define CONTROL_ISR_FREQUENCY  (((float)50)*1000.0)

//SFRA Options 	
#define SFRA_CURRENT 1
#define SFRA_VOLTAGE 2

#define SFRA_TYPE			1
#if SFRA_TYPE == SFRA_CURRENT
#define SFRA_ISR_FREQ       CONTROL_ISR_FREQUENCY
#else
#define SFRA_ISR_FREQ       INSTRUMENTATION_ISR_FREQUENCY
#endif

#define PI_VALUE 3.141592653589
#define SQRT2    1.414213562373

#define GI_PI_KP	(float) 0.3220885022
#define GI_PI_KI	(float) 0.4837893764
#define GI_PI_MAX   0.6
#define GI_PI_MIN   0.0

#define GV_PI_KP	(float) 0.5999993085
#define GV_PI_KI	(float) 0.0020013830
#define GV_PI_MAX   (float)0.7
#define GV_PI_MIN   (float)0.0

#define C28x_CONTROLISR_INTERRUPT_PIE_GROUP_NO INTERRUPT_ACK_GROUP3
#define C28x_PWMISR_INTERRUPT_PIE_GROUP_NO     INTERRUPT_ACK_GROUP3
#define C28x_TENKHZISR_INTERRUPT_PIE_GROUP_NO INTERRUPT_ACK_GROUP14

/* USER CODE START (section: User_Section) */
/* User defined includes, defines, global variables and functions */
/////////////////////////////////////////////////////////////////////

#define INV_SQRT2    0.707106781187

#if INCR_BUILD == 3
    #define AUTO_RUN  DEMO_MODE
#else
    #define AUTO_RUN  0
#endif

/* Solution Related Defines */
#define AC_SOURCE_TYPE     HIGH_POWER_SOURCE    //LOW_1KW_POWER_SOURCE

// Following were modified to improve iTHD
//#define AC_CUR_MIN_TH_IN_A   7.0
//#define AC_CUR_LOW_TH_IN_A   6.0       //8A (rms) at low line
//#define AC_CUR_MID_TH_IN_A   5.0
//#define AC_CUR_HI_TH_IN_A    5.0       //4A (rms) at high line
//#define AC_CUR_MAX_TH_IN_A   5.0       //5A (rms) at high line

#define AC_CUR_MIN_TH_IN_A   7.8
#define AC_CUR_LOW_TH_IN_A   6.5       //8A (rms) at low line
#define AC_CUR_MID_TH_IN_A   5.0
#define AC_CUR_HI_TH_IN_A    4.2       //4A (rms) at high line
#define AC_CUR_MAX_TH_IN_A   4.1       //5A (rms) at high line

/* Control Loop Design */
// Interrupt generated every 4th event for 50 kHz (default) loop freq.
// (PWM1 switches at MIN_PFC_PWM_SWITCHING_FREQUENCY).
#define CNTRL_ISR_FREQ_RATIO    4
// Interrupt generated every 3rd event
#define PWM_ISR_FREQ_RATIO      3
#define VOLTAGE_LOOP_RUN_RATIO  1

#define INSTRUMENTATION_ISR_FREQUENCY 10000

/* PWM pin, ADC, SDFM, Relay Selection related variables */


/******************************************************************************/
/*              Board configurations                                          */
/******************************************************************************/

#define RELAY_IO            12
#define RELAY_IO_CONF       GPIO_12_GPIO12
#define REC_SHUTDWON_IO     24
#define GAC_I_IO            25
#define GAC_I_IO_CONF       GPIO_25_GPIO25
#define GAC_I_FAULT_IO      23
#define GAC_I_FAULT_IO_CONF GPIO_23_GPIO23
#define GaN_FAULT1_IO       37
#define GaN_FAULT1_IO_CONF  GPIO_37_GPIO37
#define GaN_FAULT2_IO       35
#define GaN_FAULT2_IO_CONF  GPIO_35_GPIO35
#define LED_CCARD1_IO       32
#define LED_CCARD1_IO_CONF  GPIO_32_GPIO32
#define LED_CCARD2_IO       34
#define LED_CCARD2_IO_CONF  GPIO_34_GPIO34

#define FAN_FB_IO           15
#define FAN_FB_IO_CONF      GPIO_15_GPIO15
#define FAN_FB_ECAP_MODU    ECAP3_BASE
//-----------------------------------------------//
//   ADC MODULE A
//-----------------------------------------------//

//ACN
#define ACN_SENSE_ADC_MODULE  ADCA_BASE
#define ACN_SENSE_ADC_SOC_NO  ADC_SOC_NUMBER1
#define ACN_SENSE_ADC_PIN     ADC_CH_ADCIN3
#define ACN_SENSE_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM1_SOCA
#define ACN_SENSE_ADC_ACQPS_SYS_CLKS 10
#define ACN_SENSE_ADCRESULTREGBASE ADCARESULT_BASE

#define ACN_SENSE_2_ADC_MODULE  ADCA_BASE
#define ACN_SENSE_2_ADC_SOC_NO  ADC_SOC_NUMBER2
#define ACN_SENSE_2_ADC_PIN     ADC_CH_ADCIN3
#define ACN_SENSE_2_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM1_SOCB
#define ACN_SENSE_2_ADC_ACQPS_SYS_CLKS 10
#define ACN_SENSE_2_ADCRESULTREGBASE ADCARESULT_BASE

#define ACN_SENSE_3_ADC_MODULE  ADCA_BASE
#define ACN_SENSE_3_ADC_SOC_NO  ADC_SOC_NUMBER3
#define ACN_SENSE_3_ADC_PIN     ADC_CH_ADCIN3
#define ACN_SENSE_3_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM7_SOCA
#define ACN_SENSE_3_ADC_ACQPS_SYS_CLKS 10
#define ACN_SENSE_3_ADCRESULTREGBASE ADCARESULT_BASE

#define ACN_SENSE_4_ADC_MODULE  ADCA_BASE
#define ACN_SENSE_4_ADC_SOC_NO  ADC_SOC_NUMBER4
#define ACN_SENSE_4_ADC_PIN     ADC_CH_ADCIN3
#define ACN_SENSE_4_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM7_SOCB
#define ACN_SENSE_4_ADC_ACQPS_SYS_CLKS 10
#define ACN_SENSE_4_ADCRESULTREGBASE ADCARESULT_BASE


//-----------------------------------------------//
//   ADC MODULE B
//-----------------------------------------------//
//AC CURR REF
#define AC_CUR_REF_ADC_MODULE  ADCB_BASE
#define AC_CUR_REF_ADC_SOC_NO  ADC_SOC_NUMBER0
#define AC_CUR_REF_ADC_PIN     ADC_CH_ADCIN0
#define AC_CUR_REF_ADC_TRIG_SOURCE ADC_TRIGGER_CPU1_TINT2  // Sensed at 10 kHz
#define AC_CUR_REF_ADC_ACQPS_SYS_CLKS 10
#define AC_CUR_REF_ADCRESULTREGBASE ADCBRESULT_BASE

//AC CUR SENSE
#define AC_CUR_SENSE_ADC_MODULE  ADCB_BASE
#define AC_CUR_SENSE_ADC_SOC_NO  ADC_SOC_NUMBER1
#define AC_CUR_SENSE_ADC_PIN     ADC_CH_ADCIN2
#define AC_CUR_SENSE_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM1_SOCA
#define AC_CUR_SENSE_ADC_ACQPS_SYS_CLKS 10
#define AC_CUR_SENSE_ADCRESULTREGBASE ADCBRESULT_BASE

#define AC_CUR_SENSE_2_ADC_MODULE  ADCB_BASE
#define AC_CUR_SENSE_2_ADC_SOC_NO  ADC_SOC_NUMBER2
#define AC_CUR_SENSE_2_ADC_PIN     ADC_CH_ADCIN2
#define AC_CUR_SENSE_2_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM1_SOCB
#define AC_CUR_SENSE_2_ADC_ACQPS_SYS_CLKS 10
#define AC_CUR_SENSE_2_ADCRESULTREGBASE ADCBRESULT_BASE

#define AC_CUR_SENSE_3_ADC_MODULE  ADCB_BASE
#define AC_CUR_SENSE_3_ADC_SOC_NO  ADC_SOC_NUMBER3
#define AC_CUR_SENSE_3_ADC_PIN     ADC_CH_ADCIN2
#define AC_CUR_SENSE_3_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM7_SOCA
#define AC_CUR_SENSE_3_ADC_ACQPS_SYS_CLKS 10
#define AC_CUR_SENSE_3_ADCRESULTREGBASE ADCBRESULT_BASE

#define AC_CUR_SENSE_4_ADC_MODULE  ADCB_BASE
#define AC_CUR_SENSE_4_ADC_SOC_NO  ADC_SOC_NUMBER4
#define AC_CUR_SENSE_4_ADC_PIN     ADC_CH_ADCIN2
#define AC_CUR_SENSE_4_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM7_SOCB
#define AC_CUR_SENSE_4_ADC_ACQPS_SYS_CLKS 10
#define AC_CUR_SENSE_4_ADCRESULTREGBASE ADCBRESULT_BASE

//ACL
#define ACL_SENSE_ADC_MODULE  ADCB_BASE
#define ACL_SENSE_ADC_SOC_NO  ADC_SOC_NUMBER5
#define ACL_SENSE_ADC_PIN     ADC_CH_ADCIN3
#define ACL_SENSE_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM1_SOCA
#define ACL_SENSE_ADC_ACQPS_SYS_CLKS 10
#define ACL_SENSE_ADCRESULTREGBASE ADCBRESULT_BASE

#define ACL_SENSE_2_ADC_MODULE  ADCB_BASE
#define ACL_SENSE_2_ADC_SOC_NO  ADC_SOC_NUMBER6
#define ACL_SENSE_2_ADC_PIN     ADC_CH_ADCIN3
#define ACL_SENSE_2_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM1_SOCB
#define ACL_SENSE_2_ADC_ACQPS_SYS_CLKS 10
#define ACL_SENSE_2_ADCRESULTREGBASE ADCBRESULT_BASE

#define ACL_SENSE_3_ADC_MODULE  ADCB_BASE
#define ACL_SENSE_3_ADC_SOC_NO  ADC_SOC_NUMBER7
#define ACL_SENSE_3_ADC_PIN     ADC_CH_ADCIN3
#define ACL_SENSE_3_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM7_SOCA
#define ACL_SENSE_3_ADC_ACQPS_SYS_CLKS 10
#define ACL_SENSE_3_ADCRESULTREGBASE ADCBRESULT_BASE

#define ACL_SENSE_4_ADC_MODULE  ADCB_BASE
#define ACL_SENSE_4_ADC_SOC_NO  ADC_SOC_NUMBER8
#define ACL_SENSE_4_ADC_PIN     ADC_CH_ADCIN3
#define ACL_SENSE_4_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM7_SOCB
#define ACL_SENSE_4_ADC_ACQPS_SYS_CLKS 10
#define ACL_SENSE_4_ADCRESULTREGBASE ADCBRESULT_BASE

//-----------------------------------------------//
//   ADC MODULE C
//-----------------------------------------------//
//HVBUS
#define HVBUS_ADC_MODULE  ADCC_BASE
#define HVBUS_ADC_SOC_NO  ADC_SOC_NUMBER0
#define HVBUS_ADC_PIN     ADC_CH_ADCIN14
#define HVBUS_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM1_SOCA
#define HVBUS_ADC_ACQPS_SYS_CLKS 10
#define HVBUS_ADCRESULTREGBASE ADCCRESULT_BASE

//AC CYCLE
#define ACCYCLE_ADC_MODULE  ADCC_BASE
#define ACCYCLE_ADC_SOC_NO  ADC_SOC_NUMBER1
#define ACCYCLE_ADC_PIN     ADC_CH_ADCIN4
#define ACCYCLE_ADC_TRIG_SOURCE ADC_TRIGGER_CPU1_TINT2  // Sensed at 10 kHz
#define ACCYCLE_ADC_ACQPS_SYS_CLKS 10
#define ACCYCLE_ADCRESULTREGBASE ADCCRESULT_BASE

#define BOARD_PROTECTION_AC_CUR_CMPSS_BASE               CMPSS3_BASE
#define BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_3
#define BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_3
#define BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_MUX_VALUE 0

#define ZVS_LOSS_DETECT_CMPSS_BASE                      CMPSS4_BASE
#define ZVS_LOSS_DETECT_CMPSS_ASYSCTRL_CMPHPMUX         ASYSCTL_CMPHPMUX_SELECT_4
#define ZVS_LOSS_DETECT_CMPSS_ASYSCTRL_MUX_VALUE        1

// set 1 to enable the appropriate protection scheme
#define BOARD_PROTECTION_L100_SENSE 0
#define BOARD_PROTECTION_L101_SENSE 0
#define BOARD_PROTECTION_L102_SENSE 0
#define BOARD_PROTECTION_GAN_F1 0
#define BOARD_PROTECTION_GAN_F2 0
#define BOARD_PROTECTION_GAN_F3 0
#define BOARD_PROTECTION_AC_CUR_FAULT 0
#define BOARD_PROTECTION_AC_CUR_SENSE 1


/* PWM pin, ADC, SDFM, Relay Selection related variables */

#define LOW_FREQ_PWM_BASE                   EPWM1_BASE
#define LOW_FREQ_PWM_DCBEVT1                EPWM_TZ_INTERRUPT_DCBEVT1
#define LOW_FREQ_PWM_INT                    INT_EPWM1

#define LOW_FREQ_PWM_H_GPIO                 0
#define LOW_FREQ_PWM_H_GPIO_PIN_CONFIG      GPIO_0_EPWM1A
//#define LOW_FREQ_PWM_H_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_0_GPIO0

#define LOW_FREQ_PWM_L_GPIO                 1
#define LOW_FREQ_PWM_L_GPIO_PIN_CONFIG      GPIO_1_EPWM1B
//#define LOW_FREQ_PWM_L_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_1_GPIO1

#define HIGH_FREQ_PWM1_BASE                 EPWM2_BASE
#define HIGH_FREQ_PWM1_INT                  INT_EPWM2

#define HIGH_FREQ_PWM1_H_GPIO               2
#define HIGH_FREQ_PWM1_H_GPIO_PIN_CONFIG    GPIO_2_EPWM2A
//#define HIGH_FREQ_PWM1_H_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_2_GPIO2

#define HIGH_FREQ_PWM1_L_GPIO               3
#define HIGH_FREQ_PWM1_L_GPIO_PIN_CONFIG    GPIO_3_EPWM2B
//#define HIGH_FREQ_PWM1_L_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_3_GPIO3

#define HIGH_FREQ_PWM2_BASE                 EPWM3_BASE

#define HIGH_FREQ_PWM2_H_GPIO               4
#define HIGH_FREQ_PWM2_H_GPIO_PIN_CONFIG    GPIO_4_EPWM3A
//#define HIGH_FREQ_PWM2_H_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_4_GPIO4

#define HIGH_FREQ_PWM2_L_GPIO               5
#define HIGH_FREQ_PWM2_L_GPIO_PIN_CONFIG    GPIO_5_EPWM3B
//#define HIGH_FREQ_PWM2_L_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_5_GPIO5

#define ACTIVE_PWM_DUPLICATE_PWM_BASE       EPWM4_BASE

#define ACTIVE_PWM_DUPLICATE_L_GPIO               6
#define ACTIVE_PWM_DUPLICATE_L_GPIO_PIN_CONFIG    GPIO_6_EPWM4A

#define ACTIVE_PWM_DUPLICATE_H_GPIO               7
#define ACTIVE_PWM_DUPLICATE_H_GPIO_PIN_CONFIG    GPIO_7_EPWM4B

#define DEBUG_PWM_BASE                      EPWM6_BASE

#define ADC_OVERSAMPLE_PWM_BASE             EPWM7_BASE

//
// SFRA related
//
#define SFRA_GUI_SCI_BASE               SCIA_BASE
#define SFRA_GUI_SCIRX_GPIO             28
#define SFRA_GUI_SCIRX_GPIO_PIN_CONFIG  GPIO_28_SCIRXDA
#define SFRA_GUI_SCITX_GPIO             29
#define SFRA_GUI_SCITX_GPIO_PIN_CONFIG  GPIO_29_SCITXDA
#define SCI_VBUS_CLK                    50000000
#define SFRA_GUI_SCI_BAUDRATE           57600

// if the following #define is set to 1 SFRA GUI indicates status on an LED
// otherwise LED code is ignored
#define SFRA_GUI_LED_INDICATOR 1
#define SFRA_GUI_LED_GPIO 31
#define SFRA_GUI_LED_GPIO_PIN_CONFIG GPIO_31_GPIO31
//check sfra_gui_scicomms_driverlib.c file for defines used by SCI CommsSFRA GUI
/* USER CODE END (section: User_Section) */


#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif //_PROJSETTINGS_H
