//#############################################################################
//
// FILE:   ttplpfc.h
//
// TITLE: This is the solution header file.
//
//#############################################################################
// $TI Release: TIDM_1007 v1.00.02.00 $
// $Release Date: Tue Mar 23 14:55:26 CDT 2021 $
// $Copyright:
// Copyright (C) 2021 Texas Instruments Incorporated - http://www.ti.com/
//
// ALL RIGHTS RESERVED
// $
//#############################################################################

#ifndef TTPLPFC_H
#define TTPLPFC_H

#ifdef __cplusplus

extern "C" {
#endif

//
// the includes & defines
//
#include <stdint.h>
#include <stddef.h>

#ifndef __TMS320C28XX_CLA__
#include <math.h>
#else
#include <CLAmath.h>
#endif

//
// this is the file generated by the powerSUITE page for this system
//
#include "ttplpfc_settings.h"
#include <ttplpfc_hal.h>

//
// Library header files
// DCL Library is used for the controller implementation
// GI -> series form of DCL_PI for current loop (gi),
// GV -> parallel form of DCL_PI for voltage loop (gv),
// NOTCH_2P2Z -> notch filter using DCL_DF22 which implements a 2p2z structure
//
#ifndef __TMS320C28XX_CLA__
#include "DCLF32.h"
#define TTPLPFC_GI_STRUCT DCL_PI
//
// GI on C28x ,run DCL_PI routine written in assembly
//
#define TTPLPFC_GI_RUN DCL_runPI_C1
#define TTPLPFC_GV_STRUCT DCL_PI

//
// gv on C28x, run DCL_PI routine written in assembly
//
#define TTPLPFC_GV_RUN DCL_runPI_C4
#define TTPLPFC_NOTCH_2P2Z_STRUCT DCL_DF22

//
// notch filter on C28x, run DCL_DF22 routine written in assembly
//
#define TTPLPFC_NOTCH_2P2Z_RUN DCL_runDF22_C1
#else
#include "DCLCLA.h"

//
//GI
//
#define TTPLPFC_GI_STRUCT DCL_PI_CLA

//
// GI on CLA, run DCL_PI routine written in CLA assembly
//
#define TTPLPFC_GI_RUN DCL_runPI_L1

#define TTPLPFC_GV_STRUCT DCL_PI_CLA

//
// gv on CLA, run DCL_PI routine written as inline function
// because it is called in the background task
//
#define TTPLPFC_GV_RUN DCL_runPI_L4

#define TTPLPFC_NOTCH_2P2Z_STRUCT DCL_DF22_CLA

//
// notch filter on CLA, run DCL_DF22 routine written as inline function
// because it is called in the background task
//
#define TTPLPFC_NOTCH_2P2Z_RUN DCL_runDF22_L4

#pragma FUNC_ALWAYS_INLINE(DCL_runDF22_L4)
#pragma FUNC_ALWAYS_INLINE(CLAsqrt_inline)

#define TTPLPFC_PR_CNTL_STRUCT DCL_DF22_CLA

#endif

#include "dlog_4ch.h"
#include "rampgen.h"
#include "spll_1ph_sogi.h"
#include "spll_1ph_notch.h"
#include "spll_1ph_sogi_fll.h"
#include "power_meas_sine_analyzer.h"
#pragma FUNC_ALWAYS_INLINE(POWER_MEAS_SINE_ANALYZER_run)
#pragma FUNC_ALWAYS_INLINE(EPWM_setActionQualifierContSWForceAction)


#ifndef __TMS320C28XX_CLA__
#include "sfra_f32.h"
#include "sfra_gui_scicomms_driverlib.h"
#else
#define SFRA_F32_inject(m)    m
#define SFRA_F32_collect(m, n)
#endif

#define TTPLPFC_PWM_SWITCHING_NZC1 ((float32_t)0.01)
#define TTPLPFC_PWM_SWITCHING_NZC2 ((float32_t)-0.01)

#define TTPLPFC_PWM_SWITCHING_PZC1 ((float32_t)-0.01)
#define TTPLPFC_PWM_SWITCHING_PZC2 ((float32_t)0.01)

#define TTPLPFC_EMAVG_MACRO(in, out, multiplier) out =                         \
        ((in - out) * multiplier) + out;

//
// System Settings
//

//
//Add any system specific setting below
//
#if TTPLPFC_SFRA_TYPE == TTPLPFC_SFRA_VOLTAGE

#define TTPLPFC_SFRA_FREQ_START 2
#define TTPLPFC_SFRA_FREQ_LENGTH 30

//
//SFRA step Multiply = 10^(1/No of steps per decade(40))
//
#define TTPLPFC_SFRA_FREQ_STEP_MULTIPLY ((float32_t)1.08)
#define TTPLPFC_SFRA_AMPLITUDE ((float32_t)0.005)

#elif TTPLPFC_SFRA_TYPE == TTPLPFC_SFRA_CURRENT

#if TTPLPFC_DC_CHECK == 1
#define TTPLPFC_SFRA_FREQ_START 30

//
//SFRA step Multiply = 10^(1/No of steps per decade(40))
//
#define TTPLPFC_SFRA_FREQ_STEP_MULTIPLY ((float32_t)1.07)
#define TTPLPFC_SFRA_AMPLITUDE ((float32_t)0.005)
#else
#define TTPLPFC_SFRA_FREQ_START 200

//
//SFRA step Multiply = 10^(1/No of steps per decade(40))
//
#define TTPLPFC_SFRA_FREQ_STEP_MULTIPLY ((float32_t)1.052)
#define TTPLPFC_SFRA_AMPLITUDE ((float32_t)0.01)
#endif

#define TTPLPFC_SFRA_FREQ_LENGTH 100

#endif

#define TTPLPFC_GRID_MAX_FREQ 70
#define TTPLPFC_GRID_MIN_FREQ 40


//
// typedefs
//
typedef union{
    enum
    {
        Lab1 = 0,
        Lab2 = 1,
        Lab3 = 2,
        Lab4 = 3,
        Lab5 = 4,
        Lab6 = 5,
        Lab7 = 6,
        Lab8 = 7,
        Lab9 = 8,
        Lab1_CLA = 9,
        Lab2_CLA = 10,
        Lab3_CLA = 11,
        Lab4_CLA = 12,
        Lab5_CLA = 13,
        Lab6_CLA = 14,
        Lab7_CLA = 15,
        Lab8_CLA = 16,
        Lab9_CLA = 17,
    }enum_lab;
    int32_t pad;
}TTPLPFC_Lab_EnumType;

extern volatile TTPLPFC_Lab_EnumType TTPLPFC_lab;

typedef union{
    enum
    {
        boardState_OFF = 0,
        boardState_CheckACInput = 1,
        boardState_RlyConnect = 2,
        boardState_PowerStageON = 3,
        boardState_TripCondition = 4,
    }enum_boardState;
    int32_t pad;
}TTPLPFC_boardState;

extern volatile TTPLPFC_boardState TTPLPFC_board_State;

typedef union{
    enum
    {
        boardStatus_Idle = 0,
        boardStatus_NoFault = 1,
        boardStatus_OverCurrentTrip = 2,
        boardStatus_EmulatorStopTrip = 3,
        boardStatus_OverVoltageTrip = 4,
        boardStatus_InputUnderVoltageTrip = 5,
        boardStatus_NoGridConnection = 6,
    }enum_boardStatus;
    int32_t pad;
}TTPLPFC_boardStatus;

extern volatile TTPLPFC_boardStatus TTPLPFC_board_Status;

typedef union{
    enum
    {
        pwmSwState_normalOperation = 0,
        pwmSwState_positiveHalf = 1,
        pwmSwState_negativeZeroCrossing1 = 2,
        pwmSwState_negativeZeroCrossing2 = 3,
        pwmSwState_negativeZeroCrossing3 = 4,
        pwmSwState_negativeHalf = 5,
        pwmSwState_positiveZeroCrossing1 = 6,
        pwmSwState_positiveZeroCrossing2 = 7,
        pwmSwState_positiveZeroCrossing3 = 8,
        pwmSwState_defaultState = 9,
    }enum_pwmSwState;
    int32_t pad;
}TTPLPFC_pwmSwState;

extern volatile TTPLPFC_pwmSwState TTPLPFC_pwm_SwState;

typedef union{
    enum
    {
        acVolState_noFault_syncOff = 0, // Initial acVolState without Grid sync
        acVolState_noFault_syncInit = 1, // Wait for 10 ac cycles (may be 5?) for SPLL to catch up with grid phase (Implementation : Just a counter and if statement!)
        acVolState_noFault_syncOn = 2, // Run SPLL regen and read angle from SPLL in every 1 ms and run acVol Monitoring after sync ( SPLL_Regen + SPLL_Regen_Flag & acDrop_detection )
        acVolState_fault_brownOut = 3, //
        acVolState_fault_detect = 4, // Detect ac fault condition and shut down all the SWs immediately (Trip and shutdown)
        acVolState_fault_clearTrip = 5, // Clear all the trips (Clear trip)
        acVolState_fault_resetControl = 6, // Reset Control Parameters
        acVolState_fault_resumeReady = 7, // Ready for the normal PFC operation ( waiting for pos/neg ZCD & ac_drop_flag == 0 ?? how to implement this???? the most tricky part!!!)
        acVolState_resume_syncOff = 8, // If acDrop flag is set to zero, force PFC into normal operation with SPLL_regen for 10 ac cycles (acSine from SPLL_Regen)
        acVolState_resume_syncOn = 9, // Once SPLL catch up the grid phase, force PFC into normal operation with SPLL and switch state to 'acVolState_NoFault_syncOn' (acSine from SPLL)
        acVolState_fault_brownOutShutDown = 10, // The system is completely turned off due to brown out
        acVolState_fault_acDropShutDown = 11, // The system is completely turned off due to ac drop
    }enum_acVolState;
    int32_t pad;
}TTPLPFC_acVolState;

extern volatile TTPLPFC_acVolState TTPLPFC_ac_vol_State;

typedef union{
    enum
    {
        interleavingState_1ph = 0,
        interleavingState_2ph = 1,
        interleavingState_3ph = 2,
    }enum_interleavingState;
    int32_t pad;
}TTPLPFC_interleavingState;

extern volatile TTPLPFC_interleavingState TTPLPFC_interleaving_State;

//
// globals
//

//
// RAMP to generate forced angle when grid is not present
//
extern RAMPGEN TTPLPFC_rgen;

//
// current controller
//
extern TTPLPFC_GI_STRUCT TTPLPFC_gi;

//
// voltage controller
//
extern TTPLPFC_GV_STRUCT TTPLPFC_gv;

extern SPLL_1PH_SOGI TTPLPFC_spll1;
extern SPLL_1PH_NOTCH TTPLPFC_spll2;
extern SPLL_1PH_SOGI_FLL TTPLPFC_spll3;

extern TTPLPFC_NOTCH_2P2Z_STRUCT TTPLPFC_notch1;
extern TTPLPFC_NOTCH_2P2Z_STRUCT TTPLPFC_notch2;
extern TTPLPFC_NOTCH_2P2Z_STRUCT TTPLPFC_notch_50Hz;
extern TTPLPFC_NOTCH_2P2Z_STRUCT TTPLPFC_notch_60Hz;
extern TTPLPFC_NOTCH_2P2Z_STRUCT TTPLPFC_spll_notch_50Hz;
extern TTPLPFC_NOTCH_2P2Z_STRUCT TTPLPFC_spll_notch_60Hz;

extern uint16_t TTPLPFC_guiPowerStageStart;
extern uint16_t TTPLPFC_guiPowerStageStop;

#if TTPLPFC_SFRA_TYPE != TTPLPFC_SFRA_DISABLED
extern float32_t TTPLPFC_plantMagVect[TTPLPFC_SFRA_FREQ_LENGTH];
extern float32_t plantPhaseVect[TTPLPFC_SFRA_FREQ_LENGTH];
extern float32_t olMagVect[TTPLPFC_SFRA_FREQ_LENGTH];
extern float32_t olPhaseVect[TTPLPFC_SFRA_FREQ_LENGTH];
extern float32_t freqVect[TTPLPFC_SFRA_FREQ_LENGTH];
#endif

extern float32_t TTPLPFC_iL1_sensed_pu;
extern float32_t TTPLPFC_iL2_sensed_pu;
extern float32_t TTPLPFC_iL3_sensed_pu;
extern float32_t TTPLPFC_iL1_sensed_Amps;
extern float32_t TTPLPFC_iL2_sensed_Amps;
extern float32_t TTPLPFC_iL3_sensed_Amps;
extern float32_t TTPLPFC_iL1_senseOffset_pu;
extern float32_t TTPLPFC_iL2_senseOffset_pu;
extern float32_t TTPLPFC_iL3_senseOffset_pu;

//
// AC Current Measurement
//
extern float32_t TTPLPFC_ac_cur_sensed_pu;
extern float32_t TTPLPFC_ac_cur_sensed_Amps;
extern float32_t TTPLPFC_ac_cur_senseOffset_pu;

//
// AC Grid Sync offset
//
extern float32_t TTPLPFC_thetaOffset_pu;


//
// AC Drop Test Variables
//
extern float32_t TTPLPFC_acSine_regen;
extern float32_t TTPLPFC_acCosine_regen;
extern float32_t TTPLPFC_regen_theta;
extern float32_t TTPLPFC_acSine_regen_freq;
extern float32_t TTPLPFC_acSine_regen_ISRperiod;
extern float32_t TTPLPFC_ac_vol_regen_Volts;
extern float32_t TTPLPFC_ac_vol_regen_magnitude;
extern float32_t TTPLPFC_ac_volRMS_regen_Volts;
extern uint16_t TTPLPFC_acDrop_flag;
extern uint16_t TTPLPFC_autoStart_disable;
extern uint16_t TTPLPFC_UVP_disable;
extern uint16_t TTPLPFC_syncInit_cnt;
extern uint16_t TTPLPFC_clearTrip_cnt;
extern uint16_t TTPLPFC_ac_resume_cnt;
extern uint16_t TTPLPFC_acFault_cnt;
extern uint16_t TTPLPFC_brownOut_cnt;
extern uint16_t TTPLPFC_brownOut_state;
extern uint16_t TTPLPFC_brownOut_resume_cnt;
extern uint16_t TTPLPFC_brownOut_flag;

// Output Voltage measurement
//
extern volatile float32_t TTPLPFC_vBus_sensed_pu;
extern volatile float32_t TTPLPFC_vBus_sensedOffset_pu;
extern volatile float32_t TTPLPFC_vBus_sensed_Volts;

//
//Input voltage measurement
//
extern volatile float32_t TTPLPFC_ac_L_sensed_pu;
extern volatile float32_t TTPLPFC_ac_N_sensed_pu;
extern volatile float32_t TTPLPFC_ac_vol_sensed_pu;
extern volatile float32_t TTPLPFC_ac_vol_sensed_Volts;
extern volatile float32_t TTPLPFC_ac_L_senseOffset_pu;
extern volatile float32_t TTPLPFC_ac_N_senseOffset_pu;
extern volatile float32_t TTPLPFC_ac_vol_senseOffset_pu;

//
// Filtered DC bus measurement
//
extern volatile float32_t TTPLPFC_vBusAvg_pu;
extern volatile float32_t TTPLPFC_vRmsAvg_pu;

extern uint32_t TTPLPFC_dbRED_SetValue_ticks;
extern uint32_t TTPLPFC_dbRED_SetValue_Temp_ticks;
extern uint32_t TTPLPFC_dbFED_SetValue_ticks;
extern uint32_t TTPLPFC_dbRED_SetValue1_ticks;
extern uint32_t TTPLPFC_dbRED_SetValue_Temp1_ticks;
extern uint32_t TTPLPFC_dbRED_SetValue2_ticks;
extern uint32_t TTPLPFC_dbRED_SetValue_Temp2_ticks;
extern uint32_t TTPLPFC_dbRED_SetValue3_ticks;
extern uint32_t TTPLPFC_dbRED_SetValue_Temp3_ticks;
extern uint32_t TTPLPFC_dbRED_Min_ticks;
extern uint32_t TTPLPFC_dbRED_Max_ticks;

extern volatile float32_t TTPLPFC_softstart_duty;

//
// Reference variables
//

//
//  current set point
//
extern volatile float32_t TTPLPFC_ac_cur_ref_pu;
extern float32_t TTPLPFC_ac_cur_ref_inst_pu;
extern float32_t TTPLPFC_ac_cur_ref_inst_prev_pu;
extern volatile float32_t TTPLPFC_inductor_voltage_drop_feedforward;

//
// voltage set point
//
extern volatile float32_t TTPLPFC_vBusRef_pu;
extern volatile float32_t TTPLPFC_vBusRefSlewed_pu;

//
// Display Values
//
extern volatile float32_t TTPLPFC_vBus_overVoltage_Volts;
extern volatile float32_t TTPLPFC_vBus_underVoltage_Volts;
extern volatile float32_t TTPLPFC_powerRms_Watts;
extern volatile float32_t TTPLPFC_ac_curRms_sensed_Amps;
extern volatile float32_t TTPLPFC_ac_volRms_sensed_Volts;
extern volatile float32_t TTPLPFC_ac_volRms_overVoltage_Volts;
extern volatile float32_t TTPLPFC_ac_volRms_underVoltage_Volts;
extern volatile float32_t TTPLPFC_powerFactor;
extern volatile float32_t TTPLPFC_apparentPower_VA;
extern volatile float32_t TTPLPFC_acFreqAvg_Hz;
extern volatile float32_t TTPLPFC_ac_volEma_sensed_Volts;
extern volatile float32_t TTPLPFC_ac_volRmsEma_sensed_Volts;
extern volatile int32_t TTPLPFC_autoStartSlew;

//
// Phase-Shedding Variables
//
extern volatile float32_t TTPLPFC_iref1_pu;
extern volatile float32_t TTPLPFC_iref2_pu;
extern volatile float32_t TTPLPFC_deltaIref_pu;

//
// Variables used to calibrate measurement offsets
//Offset filter coefficient K1: 0.05/(T+0.05);
//
extern float32_t k1;

//
//Offset filter coefficient K2: T/(T+0.05)
//
extern float32_t k2;
extern int16_t offsetCalCounter;
extern float32_t offset165;


//
// Duty variables for inverter (per unit and compare register values)
// per unit duty value
//
extern volatile float32_t TTPLPFC_dutyPU;
extern volatile float32_t TTPLPFC_dutyPU_DC;

//
// Flags for clearing trips and closing the loops and the Relay
//
extern volatile int32_t TTPLPFC_closeGiLoop;
extern volatile int32_t TTPLPFC_closeGvLoop;
extern volatile int32_t TTPLPFC_clearTrip;
extern volatile int32_t TTPLPFC_rlyConnect;
extern volatile int32_t TTPLPFC_firstTimeGvLoop;

//
// Flags for detecting ZCD
//
extern volatile float32_t TTPLPFC_acSine;
extern volatile float32_t TTPLPFC_acSinePrev;
extern volatile float32_t TTPLPFC_acCosine;
extern volatile float32_t TTPLPFC_acCosinePrev;
extern volatile int32_t TTPLPFC_zeroCrossDetectFlag;
extern int32_t TTPLPFC_posZeroCrossingStart;
extern int32_t TTPLPFC_negZeroCrossingStart;
extern volatile int32_t TTPLPFC_state_slew;
extern volatile int32_t TTPLPFC_state_slew_max;

extern volatile float32_t TTPLPFC_gi_out;
extern volatile float32_t TTPLPFC_gv_out;

extern volatile float32_t TTPLPFC_phase1ScaleFactor;
extern volatile float32_t TTPLPFC_phase2ScaleFactor;
extern volatile float32_t TTPLPFC_phase3ScaleFactor;

////
//// Variable to log how many times ISR1 is nested from
////
extern volatile int32_t TTPLPFC_ISR1_nestingCounter;
extern volatile int32_t TTPLPFC_ISR1_nests;
extern volatile int32_t TTPLPFC_ISR1_nestsMax;
extern volatile float32_t TTPLPFC_ISR1_nestsAvg;

//
// eCAP Profiling related variables
//

//
// Variables to log the capture value for profiling ISR1
//
extern uint32_t  TTPLPFC_ISR1cap1Count;
extern uint32_t  TTPLPFC_ISR1cap2Count;
extern uint32_t  TTPLPFC_ISR1cap3Count;
extern uint32_t  TTPLPFC_ISR1cap4Count;

//
// Variable for logging the the max value and 
// also computing the average for ISR1
//
extern uint32_t TTPLPFC_ISR1_capCountMax;
extern float32_t TTPLPFC_ISR1cap1CountAvg;
extern float32_t TTPLPFC_ISR2_LoadingAvg_accountingForNesting;

//
// Variables to compute the loading percentage for ISR1
//
extern float32_t TTPLPFC_ISR1_Loading;
extern float32_t TTPLPFC_ISR1_LoadingMax;

//
// Variables to log the capture value for profiling ISR2
//
extern uint32_t  TTPLPFC_ISR2cap1Count;
extern uint32_t  TTPLPFC_ISR2cap2Count;
extern uint32_t  TTPLPFC_ISR2cap3Count;
extern uint32_t  TTPLPFC_ISR2cap4Count;

//
// Variables to compute the loading percentage for ISR2
// subtracts the ISR1 nesting cycles
//
extern float32_t TTPLPFC_ISR2_Loading;
extern float32_t TTPLPFC_ISR2_LoadingAvg;

//
// Sine analyzer block for RMS Volt, Curr and Power measurements
//
extern POWER_MEAS_SINE_ANALYZER TTPLPFC_sine_mains;
extern uint32_t TTPLPFC_Regen_cnt;
extern uint32_t TTPLPFC_Regen_cnt_Max;
extern uint32_t TTPLPFC_SPLL_regen_syncOn;
extern uint32_t TTPLPFC_acDrop_cnt;

//
// Variables for ac drop and brown out shutdown counter
//
extern float32_t TTPLPFC_ac_period_sec;
extern float32_t TTPLPFC_ISR1_period_sec;
extern float32_t TTPLPFC_acSine_brownOutMax_sec;
extern float32_t TTPLPFC_acSine_acDropMax_sec;
extern uint32_t TTPLPFC_acSine_brownOutMax_cnt;
extern uint32_t TTPLPFC_acSine_acDropMax_cnt;
extern float32_t TTPLPFC_syncInitMax_sec;
extern uint32_t TTPLPFC_syncInitMax_cnt;
extern float32_t TTPLPFC_ac_resumeMax_sec;
extern uint32_t TTPLPFC_ac_resumeMax_cnt;
extern uint32_t TTPLPFC_ac_period_cnt;

#ifndef __TMS320C28XX_CLA__

//
// datalogger
//
extern DLOG_4CH TTPLPFC_dLog1;
extern float32_t TTPLPFC_dBuff1[100];
extern float32_t TTPLPFC_dBuff2[100];
extern float32_t TTPLPFC_dBuff3[100];
extern float32_t TTPLPFC_dBuff4[100];
extern float32_t TTPLPFC_dVal1;
extern float32_t TTPLPFC_dVal2;
extern float32_t TTPLPFC_dVal3;
extern float32_t TTPLPFC_dVal4;

#endif

extern volatile float32_t TTPLPFC_vBusSensedBuff[10];
extern volatile float32_t TTPLPFC_vBus_sensedFiltered;
extern volatile int32_t TTPLPFC_vBusSensedBuffIndex;

extern volatile float32_t TTPLPFC_vBus_sensedFiltered_notch1;
extern volatile float32_t TTPLPFC_vBus_sensedFiltered_notch2;

extern volatile float32_t TTPLPFC_threshold_PZC1;
extern volatile float32_t TTPLPFC_threshold_PZC2;
extern volatile float32_t TTPLPFC_threshold_NZC1;
extern volatile float32_t TTPLPFC_threshold_NZC2;

extern volatile float32_t TTPLPFC_ac_vol_sensed_buff[5];
extern volatile int32_t TTPLPFC_ac_vol_sensed_buff_index;
extern volatile int32_t TTPLPFC_ac_sign_filtered;

extern volatile float32_t TTPLPFC_spll_sine;
extern volatile float32_t TTPLPFC_spll_cosine;
extern volatile float32_t TTPLPFC_voltage_error;

//
// 1 if using non linear voltage loop, 0 otherwise
//
extern volatile uint32_t TTPLPFC_nonLinearVoltageLoopFlag;

extern volatile uint32_t TTPLPFC_softStartDeadBandFED;


#ifndef __TMS320C28XX_CLA__
void TTPLPFC_setupSFRA();
void TTPLPFC_globalVariablesInit();
#else
#endif

//
// the function prototypes
//

void TTPLPFC_runSFRABackGroundTasks(void);

void TTPLPFC_setLabIndicatorVariable(void);

void TTPLPFC_autoStart(void);

void TTPLPFC_updateBoardStatus(void);

static inline void TTPLPFC_detectZeroCrossingClearPWMTrip(
                uint32_t base1, uint32_t base2, uint32_t base3, uint32_t base4);

void TTPLPFC_computeNotchFltrCoeff(TTPLPFC_NOTCH_2P2Z_STRUCT *coeff,
                float32_t Fs, float32_t notch_freq, float32_t c1, float32_t c2);

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_read_acReturnCurrent)
static inline void TTPLPFC_read_acReturnCurrent()
{
    TTPLPFC_ac_cur_sensed_pu =  (((float32_t)(TTPLPFC_AC_CUR_FB +
                                TTPLPFC_AC_CUR_FB_2 +  TTPLPFC_AC_CUR_FB_3))
                                * 0.333 * TTPLPFC_ADC_PU_SCALE_FACTOR
                                - (TTPLPFC_ac_cur_senseOffset_pu)) * -2.0f;
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_read_acVoltage_separateResistor)
static inline void TTPLPFC_read_acVoltage_separateResistor()
{
    TTPLPFC_ac_L_sensed_pu = (((float32_t)(TTPLPFC_AC_L_FB +
            TTPLPFC_AC_L_FB_2 + TTPLPFC_AC_L_FB_3 ) * 0.333f *
            TTPLPFC_ADC_PU_SCALE_FACTOR));
    TTPLPFC_ac_N_sensed_pu = (((float32_t) (TTPLPFC_AC_N_FB +
            TTPLPFC_AC_N_FB_2 + TTPLPFC_AC_N_FB_3 ) * 0.333f *
            TTPLPFC_ADC_PU_SCALE_FACTOR));
    TTPLPFC_ac_vol_sensed_pu = TTPLPFC_ac_L_sensed_pu -
                TTPLPFC_ac_N_sensed_pu - TTPLPFC_ac_vol_senseOffset_pu;
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_read_individualCurrent)
static inline void TTPLPFC_read_individualCurrent()
{
    TTPLPFC_iL1_sensed_pu = (((float32_t)(TTPLPFC_IL1_FB ) *
            TTPLPFC_ADC_PU_SCALE_FACTOR - TTPLPFC_iL1_senseOffset_pu)) * 2.0f;
    TTPLPFC_iL2_sensed_pu = (((float32_t)(TTPLPFC_IL2_FB ) *
            TTPLPFC_ADC_PU_SCALE_FACTOR - TTPLPFC_iL2_senseOffset_pu)) * 2.0f;
    TTPLPFC_iL3_sensed_pu = (((float32_t)(TTPLPFC_IL3_FB ) *
            TTPLPFC_ADC_PU_SCALE_FACTOR - TTPLPFC_iL3_senseOffset_pu)) * 2.0f;
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_read_busVoltage)
static inline void TTPLPFC_read_busVoltage()
{
    TTPLPFC_vBus_sensed_pu = ((float32_t)(TTPLPFC_VBUS_FB  +
            TTPLPFC_VBUS_FB_2 + TTPLPFC_VBUS_FB_3 ) *
            TTPLPFC_ADC_PU_SCALE_FACTOR * (1.0 / 3.0));
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_rampGenerate)
static inline void TTPLPFC_rampGenerate()
{
    RAMPGEN_run(&TTPLPFC_rgen);

    //
    // Use the angle value to compute the sine value
    //
    TTPLPFC_acSinePrev = TTPLPFC_acSine;
    TTPLPFC_acSine = sinf(TTPLPFC_rgen.out * ((float32_t) 6.283185307));
    TTPLPFC_acCosine = cosf(TTPLPFC_rgen.out * ((float32_t) 6.283185307));
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runCurrentLoop)
static inline void TTPLPFC_runCurrentLoop()
{
    if(TTPLPFC_closeGiLoop == 1)
    {

    #if TTPLPFC_SFRA_TYPE == TTPLPFC_SFRA_CURRENT
        TTPLPFC_gi_out = TTPLPFC_GI_RUN(&TTPLPFC_gi, TTPLPFC_ac_cur_sensed_pu,
                            SFRA_F32_inject(TTPLPFC_ac_cur_ref_inst_pu));

    #else
        TTPLPFC_gi_out = TTPLPFC_GI_RUN(&TTPLPFC_gi, TTPLPFC_ac_cur_sensed_pu,
                                        TTPLPFC_ac_cur_ref_inst_pu);
    #endif

        TTPLPFC_dutyPU = (TTPLPFC_gi_out + (TTPLPFC_ac_vol_sensed_pu *
                    (float32_t)TTPLPFC_VAC_MAX_SENSE /
                    (float32_t)TTPLPFC_VDCBUS_MAX_SENSE) -
                    TTPLPFC_inductor_voltage_drop_feedforward ) /
                    (TTPLPFC_vBus_sensed_pu);

        TTPLPFC_dutyPU = (TTPLPFC_dutyPU > (float32_t)(1.0f))?
                (float32_t)(1.0f):TTPLPFC_dutyPU;
        TTPLPFC_dutyPU = (TTPLPFC_dutyPU < (float32_t)(-1.0f))?
                (float32_t)(-1.0f):TTPLPFC_dutyPU;
    }
    else
    {
        TTPLPFC_dutyPU = 0.01f;
    }
}


#pragma FUNC_ALWAYS_INLINE(TTPLPFC_acCurrentRef)
static inline void TTPLPFC_acCurrentRef()
{
    if(TTPLPFC_closeGiLoop == 1)
    {
        #if  TTPLPFC_DC_CHECK == 1
                TTPLPFC_ac_cur_ref_inst_pu = TTPLPFC_ac_cur_ref_pu;
        #else
            #if TTPLPFC_INPUT_CAP_COMPENSATION == 1
                TTPLPFC_ac_cur_ref_inst_pu = TTPLPFC_ac_cur_ref_pu *
                        TTPLPFC_spll_sine + TTPLPFC_thetaOffset_pu *
                        TTPLPFC_spll_cosine;
            #else
                TTPLPFC_ac_cur_ref_inst_pu = TTPLPFC_ac_cur_ref_pu *
                        TTPLPFC_spll1.sine;
            #endif
        #endif
    }

        TTPLPFC_inductor_voltage_drop_feedforward = (float32_t)1.0*
         ((TTPLPFC_ac_cur_ref_inst_pu - TTPLPFC_ac_cur_ref_inst_prev_pu)/3.0f) *
               ((float32_t)TTPLPFC_INDUCTOR_VALUE*TTPLPFC_CONTROL_ISR_FREQUENCY*
                                TTPLPFC_I_MAX_SENSE / TTPLPFC_VDCBUS_MAX_SENSE);


    TTPLPFC_ac_cur_ref_inst_prev_pu = TTPLPFC_ac_cur_ref_inst_pu;
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runVoltageLoop)
static inline void TTPLPFC_runVoltageLoop()
{
    //
    // Soft start for the voltage set point
    //
    if(TTPLPFC_closeGvLoop == 1)
    {
        if( fabsf(TTPLPFC_vBusRef_pu - TTPLPFC_vBusRefSlewed_pu) > 0.0001f)
        {
            if(TTPLPFC_vBusRef_pu > TTPLPFC_vBusRefSlewed_pu)
            {
                TTPLPFC_vBusRefSlewed_pu = TTPLPFC_vBusRefSlewed_pu + 0.0001f;
            }
            else
            {
                TTPLPFC_vBusRefSlewed_pu = TTPLPFC_vBusRefSlewed_pu - 0.0001f;
            }
        }
        else
        {
            TTPLPFC_vBusRefSlewed_pu = TTPLPFC_vBusRef_pu;
        }

        #if TTPLPFC_NON_LINEAR_VOLTAGE_LOOP == 1
            TTPLPFC_nonLinearVoltageLoopFlag = 1;
        #else
            TTPLPFC_nonLinearVoltageLoopFlag = 0;
        #endif

    }

    if(TTPLPFC_closeGvLoop == 1)
    {
        if(TTPLPFC_firstTimeGvLoop == 1)
        {
            TTPLPFC_vBusRefSlewed_pu = TTPLPFC_vBus_sensed_pu;
            TTPLPFC_firstTimeGvLoop = 0;
        }

        TTPLPFC_voltage_error = fabsf(TTPLPFC_vBusRefSlewed_pu -
                                      TTPLPFC_vBus_sensedFiltered_notch2);

        if(TTPLPFC_nonLinearVoltageLoopFlag == 0)
        {
            TTPLPFC_gv.Kp = TTPLPFC_GV_PI_KP;
            TTPLPFC_gv.Ki = TTPLPFC_GV_PI_KI;
        }
        else
        {
            if(TTPLPFC_voltage_error > 0.005f)
            {
                if(TTPLPFC_gv.Kp < (TTPLPFC_NON_LINEAR_V_LOOP_KP_MULTIPLIER *
                        TTPLPFC_GV_PI_KP))
                {
                    TTPLPFC_gv.Kp = TTPLPFC_gv.Kp + 0.05f;
                }
            }
            else if(TTPLPFC_voltage_error < 0.001f)
            {
                if(TTPLPFC_gv.Kp > TTPLPFC_GV_PI_KP)
                {
                    TTPLPFC_gv.Kp = TTPLPFC_gv.Kp - 0.05f;
                }
            }
        }


        #if TTPLPFC_SFRA_TYPE == SFRA_VOLTAGE
        TTPLPFC_gv_out = TTPLPFC_GV_RUN(&TTPLPFC_gv,
                                      SFRA_F32_inject(TTPLPFC_vBusRefSlewed_pu),
                                      TTPLPFC_vBus_sensedFiltered_notch2);
        #else
        TTPLPFC_gv_out = TTPLPFC_GV_RUN(&TTPLPFC_gv,
                                      TTPLPFC_vBusRefSlewed_pu,
                                      TTPLPFC_vBus_sensedFiltered_notch2);
        #endif

        #if TTPLPFC_SFRA_TYPE == SFRA_VOLTAGE
            SFRA_F32_collect((float32_t*)&TTPLPFC_gv_out,
                             (float32_t*)&TTPLPFC_vBus_sensedFiltered_notch2);
        #endif

            TTPLPFC_ac_cur_ref_pu = TTPLPFC_gv_out * TTPLPFC_vBusAvg_pu /
                                    (TTPLPFC_vRmsAvg_pu);
    }
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_pwmDriver)
static inline void TTPLPFC_pwmDriver()
{
    #if TTPLPFC_DC_CHECK == 0
        switch(TTPLPFC_pwm_SwState.enum_pwmSwState)
        {
            case pwmSwState_normalOperation:

                if(TTPLPFC_acDrop_flag == 0)
                {
                    //
                    // wait for positive zero crossing
                    //
                    if(TTPLPFC_acSine < TTPLPFC_threshold_PZC2  &&
                            TTPLPFC_acSinePrev < 0)
                    {
                        TTPLPFC_posZeroCrossingStart = 1;

                        TTPLPFC_pwm_SwState.enum_pwmSwState =
                                pwmSwState_positiveZeroCrossing1;

                        TTPLPFC_dutyPU = 0.004;

                        TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(
                                TTPLPFC_LOW_FREQ_PWM_BASE);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_gi.i10 = 0;
                        TTPLPFC_gi.i6 = 1;
                        TTPLPFC_gi_out = 0;

                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_LOW_FREQ_PWM_BASE);
                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM3_BASE);

                        TTPLPFC_ac_cur_ref_inst_pu = 0.00f;
                        TTPLPFC_ac_cur_ref_inst_prev_pu = 0.00f;
                        TTPLPFC_closeGiLoop = 1;
                        TTPLPFC_closeGvLoop = 1;

                        if (TTPLPFC_ac_vol_State.enum_acVolState == acVolState_noFault_syncOff)
                        {
                            TTPLPFC_ac_vol_State.enum_acVolState = acVolState_noFault_syncInit;

                        }

                    }

                    //
                    // wait for negative zero crossing
                    //
                    if(TTPLPFC_acSine > TTPLPFC_threshold_NZC2  &&
                            TTPLPFC_acSinePrev > 0)
                    {
                        TTPLPFC_negZeroCrossingStart = 1;

                        TTPLPFC_pwm_SwState.enum_pwmSwState =
                                pwmSwState_negativeZeroCrossing1;

                        TTPLPFC_dutyPU = 0.004;

                        TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(
                                TTPLPFC_LOW_FREQ_PWM_BASE);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_gi.i10 = 0;
                        TTPLPFC_gi.i6 = 1;
                        TTPLPFC_gi_out = 0;

                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_LOW_FREQ_PWM_BASE);
                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                        TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM3_BASE);

                        TTPLPFC_ac_cur_ref_inst_pu = 0.00f;
                        TTPLPFC_ac_cur_ref_inst_prev_pu = 0.00f;
                        TTPLPFC_closeGiLoop = 1;
                        TTPLPFC_closeGvLoop = 1;

                        if (TTPLPFC_ac_vol_State.enum_acVolState == acVolState_noFault_syncOff)
                        {
                            TTPLPFC_ac_vol_State.enum_acVolState = acVolState_noFault_syncInit;

                        }

                    }
                }


                break;

            case pwmSwState_positiveHalf:

                //
                //AQCSFRC xA LOW, xB HIGH
                //
                TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_HIGH(
                        TTPLPFC_LOW_FREQ_PWM_BASE);


                TTPLPFC_HAL_SET_PWM_DBRED(
                     TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_dbRED_SetValue_ticks);
                TTPLPFC_HAL_SET_PWM_DBRED(
                     TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_dbRED_SetValue_ticks);
                TTPLPFC_HAL_SET_PWM_DBRED(
                     TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_dbRED_SetValue_ticks);

                TTPLPFC_state_slew++;

                if( TTPLPFC_acSine < TTPLPFC_threshold_NZC1
                        || TTPLPFC_ac_sign_filtered == 0 )
                    {
                        TTPLPFC_pwm_SwState.enum_pwmSwState =
                                pwmSwState_negativeZeroCrossing1;

                        //
                        //AQCSFRC xA LOW, xB LOW
                        //
                        TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(
                                TTPLPFC_LOW_FREQ_PWM_BASE);
                    }


                break;

            case pwmSwState_negativeZeroCrossing1 :
                TTPLPFC_state_slew++;


                TTPLPFC_HAL_SET_PWM_DBRED(
                        TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(
                        TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);

                TTPLPFC_HAL_SET_PWM_DBRED(
                        TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(
                        TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);

                TTPLPFC_HAL_SET_PWM_DBRED(
                        TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(
                        TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);

                TTPLPFC_dutyPU = 0.004f;

                //
                // now wait till actual zero in this state
                // before switching to zero2
                //
                if(TTPLPFC_acSine <= 0 )
                {
                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_negativeZeroCrossing2;
                }
                break;

            case pwmSwState_negativeZeroCrossing2 :
                TTPLPFC_state_slew++;

                TTPLPFC_dutyPU = 0.004f;

                //
                // wait till certain positive threshold
                // before moving to the normal operation
                //
                if(TTPLPFC_acSine < TTPLPFC_threshold_NZC2)
                {
                    TTPLPFC_state_slew = 0;
                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_negativeZeroCrossing3;

                    //
                    // Enable xA xB Swap
                    //
                    TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                            TTPLPFC_HIGH_FREQ_PWM1_BASE);
                    TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                            TTPLPFC_HIGH_FREQ_PWM2_BASE);
                    TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                            TTPLPFC_HIGH_FREQ_PWM3_BASE);
                    TTPLPFC_softstart_duty = 0;

                    TTPLPFC_gi.i10 = 0;
                    TTPLPFC_gi.i6 = 1;
                    TTPLPFC_gi.Ki = 0;
                    TTPLPFC_gi_out = 0;
                }

                break;

            case pwmSwState_negativeZeroCrossing3 :

                //
                // wait till certain positive threshold
                // before moving to the normal operation
                //
                TTPLPFC_softstart_duty = TTPLPFC_softstart_duty + 1;

                TTPLPFC_softStartDeadBandFED = TTPLPFC_PWM_PERIOD -
                        TTPLPFC_softstart_duty * 50;

                if(TTPLPFC_softStartDeadBandFED < TTPLPFC_dbFED_SetValue_ticks )
                {
                    TTPLPFC_softStartDeadBandFED = TTPLPFC_dbFED_SetValue_ticks;
                }

                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                          TTPLPFC_softStartDeadBandFED );
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          TTPLPFC_softStartDeadBandFED );
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                          TTPLPFC_softStartDeadBandFED );

                TTPLPFC_state_slew++;

                if(fabsf(TTPLPFC_dutyPU) <  0.004f)
                              {
                                  if(TTPLPFC_dutyPU > 0)
                                  {
                                      TTPLPFC_dutyPU = 0.004;
                                  }
                                  else
                                  {
                                      TTPLPFC_dutyPU = -0.004;
                                  }
                              }

                if(TTPLPFC_state_slew > TTPLPFC_state_slew_max
                        && TTPLPFC_ac_sign_filtered == 0 )
                {
                    TTPLPFC_gi.i10 = 0;
                    TTPLPFC_gi.i6 = 1;
                    TTPLPFC_gi.Ki = TTPLPFC_GI_PI_KI;
                    TTPLPFC_gi.Umax = TTPLPFC_GI_PI_MAX;
                    TTPLPFC_gi.Umin = TTPLPFC_GI_PI_MIN;
                    TTPLPFC_gi_out = 0;

                    TTPLPFC_pwm_SwState.enum_pwmSwState
                                             = pwmSwState_negativeHalf;
                    TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                              TTPLPFC_dbFED_SetValue_ticks);
                    TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                              TTPLPFC_dbFED_SetValue_ticks);
                    TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                              TTPLPFC_dbFED_SetValue_ticks);

                    TTPLPFC_state_slew = 0;
                }
                break;

            case pwmSwState_negativeHalf:

                //
                //AQCSFRC xA HIGH, xB LOW
                //
                TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_HIGH_PWMxB_LOW(
                        TTPLPFC_LOW_FREQ_PWM_BASE);


                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                          TTPLPFC_dbRED_SetValue1_ticks);
                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          TTPLPFC_dbRED_SetValue2_ticks);
                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                          TTPLPFC_dbRED_SetValue3_ticks);

                if( TTPLPFC_acSine > TTPLPFC_threshold_PZC1 ||
                        TTPLPFC_ac_sign_filtered == 1)
                {
                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_positiveZeroCrossing1;

                    //
                    //AQCSFRC xA LOW, xB LOW
                    //
                    TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(
                            TTPLPFC_LOW_FREQ_PWM_BASE);

                }

                break;

            case pwmSwState_positiveZeroCrossing1 :
                TTPLPFC_state_slew++;
                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                          TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                          TTPLPFC_PWM_PERIOD);

                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          TTPLPFC_PWM_PERIOD);

                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                          TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                          TTPLPFC_PWM_PERIOD);


                TTPLPFC_dutyPU = 0.004f;

                if(TTPLPFC_acSine >= 0 )
                {
                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_positiveZeroCrossing2;
                    TTPLPFC_softstart_duty = 0.0;

                }
                break;

            case pwmSwState_positiveZeroCrossing2 :
                TTPLPFC_state_slew++;

                TTPLPFC_dutyPU = 0.004f;

                if(TTPLPFC_acSine > TTPLPFC_threshold_PZC2 )
                {
                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_positiveZeroCrossing3;
                    TTPLPFC_state_slew = 0;
                    TTPLPFC_softstart_duty = 0;

                    //
                    // Dead band output swap disabled
                    //
                    TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                            TTPLPFC_HIGH_FREQ_PWM1_BASE);
                    TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                            TTPLPFC_HIGH_FREQ_PWM2_BASE);
                    TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                            TTPLPFC_HIGH_FREQ_PWM3_BASE);

                    TTPLPFC_gi.i10 = 0;
                    TTPLPFC_gi.i6 = 1;
                    TTPLPFC_gi_out = 0;
                    TTPLPFC_gi.Ki = 0;
                }
                break;

            case pwmSwState_positiveZeroCrossing3 :
                TTPLPFC_state_slew++;

                if(fabsf(TTPLPFC_dutyPU) <  0.004f)
                            {
                                if(TTPLPFC_dutyPU > 0)
                                {
                                    TTPLPFC_dutyPU = 0.004;
                                }
                                else
                                {
                                    TTPLPFC_dutyPU = -0.004;
                                }
                            }

                TTPLPFC_softstart_duty = TTPLPFC_softstart_duty + 1;

                TTPLPFC_softStartDeadBandFED = TTPLPFC_PWM_PERIOD -
                        TTPLPFC_softstart_duty * 50;

                if(TTPLPFC_softStartDeadBandFED < TTPLPFC_dbFED_SetValue_ticks )
                {
                    TTPLPFC_softStartDeadBandFED = TTPLPFC_dbFED_SetValue_ticks;
                }

                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                          TTPLPFC_softStartDeadBandFED );
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          TTPLPFC_softStartDeadBandFED );
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                          TTPLPFC_softStartDeadBandFED );

                if(TTPLPFC_state_slew > TTPLPFC_state_slew_max &&
                        TTPLPFC_ac_sign_filtered == 1)
                {
                    TTPLPFC_gi.i10 = 0;
                    TTPLPFC_gi.i6 = 1;
                    TTPLPFC_gi_out = 0;
                    TTPLPFC_gi.Ki = TTPLPFC_GI_PI_KI;

                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_positiveHalf;

                    TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                              TTPLPFC_dbFED_SetValue_ticks);
                    TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                              TTPLPFC_dbFED_SetValue_ticks);
                    TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                              TTPLPFC_dbFED_SetValue_ticks);

                    TTPLPFC_state_slew = 0;
                }

                break;

            case pwmSwState_defaultState:
                TTPLPFC_dutyPU = 0.01f;

                TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(
                        TTPLPFC_LOW_FREQ_PWM_BASE);

                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                          TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                          TTPLPFC_PWM_PERIOD);

                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          TTPLPFC_PWM_PERIOD);

                TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                          TTPLPFC_PWM_PERIOD);
                TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                          TTPLPFC_PWM_PERIOD);

                TTPLPFC_posZeroCrossingStart = 0;

                TTPLPFC_negZeroCrossingStart = 0;

                break;
            default:
                TTPLPFC_pwm_SwState.enum_pwmSwState =
                        pwmSwState_defaultState;
        }

    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_pwmDriver_DC)
static inline void TTPLPFC_pwmDriver_DC()
{
    //
    //  DC Check for PFC Mode
    //
    #if TTPLPFC_DC_CHECK == 1
        if(TTPLPFC_ac_vol_sensed_pu > 0 && TTPLPFC_dutyPU > 0)
        {
            //
            //AQCSFRC xA LOW, xB HIGH
            //
            TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_HIGH(
                    TTPLPFC_LOW_FREQ_PWM_BASE);

            TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                      TTPLPFC_dbRED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                      TTPLPFC_dbRED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                      TTPLPFC_dbRED_SetValue_ticks);

            TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                      TTPLPFC_dbFED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                      TTPLPFC_dbFED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                      TTPLPFC_dbFED_SetValue_ticks);

            //
            // Dead band output swap disabled
            //
            TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                    TTPLPFC_HIGH_FREQ_PWM1_BASE);
            TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                    TTPLPFC_HIGH_FREQ_PWM2_BASE);
            TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                    TTPLPFC_HIGH_FREQ_PWM3_BASE);
        }
        else if((TTPLPFC_ac_vol_sensed_pu < 0 && TTPLPFC_dutyPU < 0))
        {
            //
            //AQCSFRC xA HIGH, xB LOW
            //
            TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_HIGH_PWMxB_LOW(
                    TTPLPFC_LOW_FREQ_PWM_BASE);

            TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                      TTPLPFC_dbRED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                      TTPLPFC_dbRED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBRED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                      TTPLPFC_dbRED_SetValue_ticks);

            TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                      TTPLPFC_dbFED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                      TTPLPFC_dbFED_SetValue_ticks);
            TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                      TTPLPFC_dbFED_SetValue_ticks);

            //
            // Dead band output swap disabled
            //
            TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                    TTPLPFC_HIGH_FREQ_PWM1_BASE);
            TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                    TTPLPFC_HIGH_FREQ_PWM2_BASE);
            TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                    TTPLPFC_HIGH_FREQ_PWM3_BASE);
        }
    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_acVolMonitor)
static inline void TTPLPFC_acVolMonitor()
{
        switch(TTPLPFC_ac_vol_State.enum_acVolState)
        {
            case acVolState_noFault_syncOff :

                //
                // Init or reset counter values
                // ac_vol_state stays at noFault_syncOff until
                // triggered by pwmSwState_normalOperation
                //
                TTPLPFC_syncInit_cnt = 0;
                TTPLPFC_ac_resume_cnt = 0;
                TTPLPFC_autoStart_disable = 0;
                TTPLPFC_UVP_disable = 0;
                TTPLPFC_brownOut_cnt = 0;
                TTPLPFC_acFault_cnt = 0;

                break;

            case acVolState_noFault_syncInit :

                TTPLPFC_syncInit_cnt++;

                //
                // Wait at least 5 ac cycles for
                // SPLL to catch up with the grid phase angle
                //
                if(TTPLPFC_syncInit_cnt == TTPLPFC_syncInitMax_cnt
                   && TTPLPFC_autoStartSlew == 5 )
                {
                    //
                    // Switch to the next state
                    //
                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_noFault_syncOn;
                    TTPLPFC_syncInit_cnt = 0;

                }

                break;

            case acVolState_noFault_syncOn :

                //
                // Disable autoStart and under voltage protection
                // to enable ac drop and brown out recovery
                //
                TTPLPFC_autoStart_disable = 1;

                TTPLPFC_UVP_disable = 1;

                //
                // Set syncOn flag to 1 and SPLL_Regen
                // reads angle from SPLL in every 1 ms
                //
                TTPLPFC_SPLL_regen_syncOn = 1;

                //
                // Switch to the ac fault brown out state when it is detected
                //
                if (TTPLPFC_brownOut_flag == 1 && TTPLPFC_acDrop_flag == 0)
                {

                    TTPLPFC_SPLL_regen_syncOn = 0;

                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_brownOut;

                }

                //
                // Switch to ac fualt state when it is detected
                //
                if (TTPLPFC_acDrop_flag == 1)
                {
                    TTPLPFC_SPLL_regen_syncOn = 0;

                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_detect;
                }

                break;

            case acVolState_fault_brownOut :

                TTPLPFC_brownOut_cnt++;

                //
                // Shutdown the system if the input voltage goes below 50 % of nominal value
                //
                if (TTPLPFC_ac_volRms_sensed_Volts < TTPLPFC_ac_volRMS_regen_Volts * 0.5f)
                {
                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_brownOutShutDown;

                    TTPLPFC_brownOut_state = 1;
                }

                //
                // If brown out is longer than the specific ac cycles, shut down the system
                //
                if ( TTPLPFC_brownOut_cnt == TTPLPFC_acSine_brownOutMax_cnt )
                {

                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_brownOutShutDown;

                    TTPLPFC_brownOut_cnt = 0;
                }

                //
                // Switch to the normal operation when brown out is cleared
                //
                if (TTPLPFC_brownOut_flag == 0)
                {

                    TTPLPFC_brownOut_cnt = 0;

                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_noFault_syncOn;

                }

                break;

            case acVolState_fault_detect :

                //
                // Turn off all the High/Low Freq Switches immediately
                //
                TTPLPFC_board_Status.enum_boardStatus =
                        boardStatus_Idle;

                TTPLPFC_pwm_SwState.enum_pwmSwState =
                        pwmSwState_defaultState;

                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM3_BASE);

                EPWM_setActionQualifierContSWForceAction(
                        TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_A,
                        EPWM_AQ_SW_OUTPUT_LOW);
                EPWM_setActionQualifierContSWForceAction(
                        TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_B ,
                        EPWM_AQ_SW_OUTPUT_LOW);

                if(TTPLPFC_board_Status.enum_boardStatus
                        == boardStatus_NoFault)
                {
                    TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
                }

                //
                //Close loop disabled and set duty to zero
                //
                TTPLPFC_closeGiLoop = 0;
                TTPLPFC_closeGvLoop = 0;
                TTPLPFC_dutyPU = 0;

                TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_clearTrip;

                break;

            case acVolState_fault_clearTrip :

                TTPLPFC_clearTrip_cnt++;

                //
                // Wait 1ms and clear trip from OCP
                //
                if (TTPLPFC_clearTrip_cnt == 100)
                {
                    TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_LOW_FREQ_PWM_BASE);
                    TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                    TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                    TTPLPFC_HAL_clearPWMTripFlags(TTPLPFC_HIGH_FREQ_PWM3_BASE);

                    TTPLPFC_board_Status.enum_boardStatus = boardStatus_NoFault;

                    TTPLPFC_pwm_SwState.enum_pwmSwState = pwmSwState_defaultState;

                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_resetControl;

                    TTPLPFC_clearTrip_cnt = 0;
                }

                break;

            case acVolState_fault_resetControl:

                TTPLPFC_vBusRefSlewed_pu = 0;

                //
                //Reset current loop
                //
                TTPLPFC_gi.i10 = 0;
                TTPLPFC_gi.i6 = 1;
                TTPLPFC_gi.Ki = 0;
                TTPLPFC_gi_out = 0;

                //
                //Reset voltage loop
                //
//                TTPLPFC_gv.i10 = 0;
//                TTPLPFC_gv.i6 = 1;
//                TTPLPFC_gv.Ki = 0;
//                TTPLPFC_gv_out = 0;

                TTPLPFC_firstTimeGvLoop = 1;

                TTPLPFC_state_slew = 0;
                TTPLPFC_softstart_duty = 0;

                TTPLPFC_vBusRef_pu = TTPLPFC_VBUS_TYPICAL / TTPLPFC_VDCBUS_MAX_SENSE;

                TTPLPFC_ac_cur_ref_pu = 0.03f;

                TTPLPFC_ac_cur_ref_inst_pu = 0;
                TTPLPFC_ac_cur_ref_inst_prev_pu = 0;

                TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_resumeReady;

                break;

            case acVolState_fault_resumeReady :

                TTPLPFC_acFault_cnt++;

                //
                // Wait for acDrop_flag become 0
                //
                if (TTPLPFC_acDrop_flag == 0)
                {
                    //
                    // Waits for PZC or NZC and automatically run the closed loop operation
                    //
//                    TTPLPFC_pwm_SwState.enum_pwmSwState = pwmSwState_normalOperation;


                    //
                    // Instantaneous resuming mode
                    //
                    if (TTPLPFC_acSine_regen > 0 )
                    {

                        //
                        //pwmSwState_normalOperation for positive half
                        //
                        TTPLPFC_dutyPU = 0.004;

                        TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(
                                TTPLPFC_LOW_FREQ_PWM_BASE);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_HAL_SET_PWM_DBRED(
                                TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);
                        TTPLPFC_HAL_SET_PWM_DBFED(
                                TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);

                        TTPLPFC_ac_cur_ref_inst_pu = 0.00f;
                        TTPLPFC_ac_cur_ref_inst_prev_pu = 0.00f;
                        TTPLPFC_closeGiLoop = 1;
                        TTPLPFC_closeGvLoop = 1;

                        //
                        //Disable Swap Deadband
                        //
                        TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                                TTPLPFC_HIGH_FREQ_PWM1_BASE);
                        TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                                TTPLPFC_HIGH_FREQ_PWM2_BASE);
                        TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(
                                TTPLPFC_HIGH_FREQ_PWM3_BASE);

                        //
                        //Controller parameter setup for closed loop operation
                        //
                        TTPLPFC_gi.i10 = 0;
                        TTPLPFC_gi.i6 = 1;
                        TTPLPFC_gi.Ki = TTPLPFC_GI_PI_KI;
                        TTPLPFC_gi.Umax = TTPLPFC_GI_PI_MAX;
                        TTPLPFC_gi.Umin = TTPLPFC_GI_PI_MIN;
                        TTPLPFC_gi_out = 0.0;

                        //
                        //Switchg pwm_SwState to positiveHalf
                        //
                        TTPLPFC_pwm_SwState.enum_pwmSwState =
                                pwmSwState_positiveHalf;

                        TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                                  TTPLPFC_dbFED_SetValue_ticks);
                        TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                                  TTPLPFC_dbFED_SetValue_ticks);
                        TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                                  TTPLPFC_dbFED_SetValue_ticks);

                    }

                    else
                    {

                        //
                        //pwmSwState_normalOperation for negative half
                        //
                        TTPLPFC_dutyPU = 0.004;

                         TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(
                                 TTPLPFC_LOW_FREQ_PWM_BASE);

                         TTPLPFC_HAL_SET_PWM_DBRED(
                                 TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);
                         TTPLPFC_HAL_SET_PWM_DBFED(
                                 TTPLPFC_HIGH_FREQ_PWM1_BASE, TTPLPFC_PWM_PERIOD);

                         TTPLPFC_HAL_SET_PWM_DBRED(
                                 TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);
                         TTPLPFC_HAL_SET_PWM_DBFED(
                                 TTPLPFC_HIGH_FREQ_PWM2_BASE, TTPLPFC_PWM_PERIOD);

                         TTPLPFC_HAL_SET_PWM_DBRED(
                                 TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);
                         TTPLPFC_HAL_SET_PWM_DBFED(
                                 TTPLPFC_HIGH_FREQ_PWM3_BASE, TTPLPFC_PWM_PERIOD);

                         TTPLPFC_ac_cur_ref_inst_pu = 0.00f;
                         TTPLPFC_ac_cur_ref_inst_prev_pu = 0.00f;
                         TTPLPFC_closeGiLoop = 1;
                         TTPLPFC_closeGvLoop = 1;

                         //
                         //Enable Swap Deadband
                         //
                         TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                                 TTPLPFC_HIGH_FREQ_PWM1_BASE);
                         TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                                 TTPLPFC_HIGH_FREQ_PWM2_BASE);
                         TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(
                                 TTPLPFC_HIGH_FREQ_PWM3_BASE);
                         TTPLPFC_softstart_duty = 0;

                         //
                         //Controller parameter setup for closed loop operation
                         //
                         TTPLPFC_gi.i10 = 0;
                         TTPLPFC_gi.i6 = 1;
                         TTPLPFC_gi.Ki = TTPLPFC_GI_PI_KI;
                         TTPLPFC_gi.Umax = TTPLPFC_GI_PI_MAX;
                         TTPLPFC_gi.Umin = TTPLPFC_GI_PI_MIN;
                         TTPLPFC_gi_out = 0.0;

                         TTPLPFC_pwm_SwState.enum_pwmSwState
                                                  = pwmSwState_negativeHalf;
                         TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM1_BASE,
                                                   TTPLPFC_dbFED_SetValue_ticks);
                         TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                                   TTPLPFC_dbFED_SetValue_ticks);
                         TTPLPFC_HAL_SET_PWM_DBFED(TTPLPFC_HIGH_FREQ_PWM3_BASE,
                                                   TTPLPFC_dbFED_SetValue_ticks);

                    }

                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_resume_syncOff;

                    TTPLPFC_acFault_cnt = 0;
                }

                 //
                 // Shut off the system after the specific ac cycles
                 // 100 cycles were used for clear trip state and therefore it should be subtracted
                 //
//                if (TTPLPFC_acFault_cnt == TTPLPFC_acSine_acDropMax_cnt - 100 )
//                {
//                    TTPLPFC_autoStart_disable = 0;
//
//                    TTPLPFC_UVP_disable = 0;
//
//                    TTPLPFC_acFault_cnt = 0;
//
//                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_fault_acDropShutDown;
//                }

                break;

            case acVolState_resume_syncOff :

                TTPLPFC_ac_resume_cnt++;

                //
                // Wait for 3 ac cycles for SPLL to catch up
                //
                if (TTPLPFC_ac_resume_cnt == TTPLPFC_ac_resumeMax_cnt)
                {
                    TTPLPFC_ac_vol_State.enum_acVolState = acVolState_resume_syncOn;

                    TTPLPFC_SPLL_regen_syncOn = 1;

                    TTPLPFC_ac_resume_cnt = 0;

                    //
                    // Set high ac current reference for the fast dc bus recovery
                    //
//                    TTPLPFC_ac_cur_ref_pu = 0.8;
//                    TTPLPFC_gv_out = 0.5;
                }

                break;

            case acVolState_resume_syncOn :


                TTPLPFC_ac_vol_State.enum_acVolState = acVolState_noFault_syncOn;

                break;

            case acVolState_fault_brownOutShutDown :

                //
                // Turn off all the High/Low Freq Switches immediately
                //
                TTPLPFC_board_Status.enum_boardStatus =
                        boardStatus_Idle;

                TTPLPFC_pwm_SwState.enum_pwmSwState =
                        pwmSwState_defaultState;

                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM3_BASE);

                EPWM_setActionQualifierContSWForceAction(
                        TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_A,
                        EPWM_AQ_SW_OUTPUT_LOW);
                EPWM_setActionQualifierContSWForceAction(
                        TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_B ,
                        EPWM_AQ_SW_OUTPUT_LOW);

                if(TTPLPFC_board_Status.enum_boardStatus
                        == boardStatus_NoFault)
                {
                    TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
                }

                //
                //Close loop disabled
                //
                TTPLPFC_closeGiLoop = 0;
                TTPLPFC_closeGvLoop = 0;

                //
                // Enable autostart and under voltage protection
                //
                TTPLPFC_autoStart_disable = 0;
                TTPLPFC_UVP_disable = 0;

                break;

            case acVolState_fault_acDropShutDown :

                //
                // Turn off all the High/Low Freq Switches immediately
                //
                TTPLPFC_board_Status.enum_boardStatus =
                        boardStatus_Idle;

                TTPLPFC_pwm_SwState.enum_pwmSwState =
                        pwmSwState_defaultState;

                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM3_BASE);

                EPWM_setActionQualifierContSWForceAction(
                        TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_A,
                        EPWM_AQ_SW_OUTPUT_LOW);
                EPWM_setActionQualifierContSWForceAction(
                        TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_B ,
                        EPWM_AQ_SW_OUTPUT_LOW);

                if(TTPLPFC_board_Status.enum_boardStatus
                        == boardStatus_NoFault)
                {
                    TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
                }

                //
                //Close loop disabled
                //
                TTPLPFC_closeGiLoop = 0;
                TTPLPFC_closeGvLoop = 0;

                //
                // Enable autostart and under voltage protection
                //
                TTPLPFC_autoStart_disable = 0;
                TTPLPFC_UVP_disable = 0;

                break;

            default:
                TTPLPFC_ac_vol_State.enum_acVolState = acVolState_noFault_syncOff;
        }
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_adaptiveDeadTime)
static inline void TTPLPFC_adaptiveDeadTime()
{
    #if TTPLPFC_ADAPTIVE_DEADTIME == 1
        TTPLPFC_ac_cur_sensed_Amps = fabsf(TTPLPFC_ac_cur_sensed_pu *
                                         TTPLPFC_I_MAX_SENSE);
        TTPLPFC_ac_cur_sensed_Amps = (TTPLPFC_ac_cur_sensed_Amps < 0.01f)?0.01f:
                TTPLPFC_ac_cur_sensed_Amps;

        TTPLPFC_dbRED_SetValue_Temp_ticks = (uint16_t)((float32_t)100000000.0 *
                            (2.0 * TTPLPFC_VBUS_TYPICAL * TTPLPFC_HF_FET_COSS) /
                            (TTPLPFC_ac_cur_sensed_Amps*0.33));

        TTPLPFC_dbRED_SetValue_ticks = (TTPLPFC_dbRED_SetValue_Temp_ticks <
                TTPLPFC_dbRED_Min_ticks)?TTPLPFC_dbRED_Min_ticks:
                                        TTPLPFC_dbRED_SetValue_Temp_ticks;
        TTPLPFC_dbRED_SetValue_ticks = (TTPLPFC_dbRED_SetValue_Temp_ticks >
                TTPLPFC_dbRED_Max_ticks)?TTPLPFC_dbRED_Max_ticks:
                                        TTPLPFC_dbRED_SetValue_Temp_ticks;

        //
        // Individual Peak Current Sensing
        //

        //
        // Phase A
        //
        TTPLPFC_iL1_sensed_Amps = fabsf(TTPLPFC_iL1_sensed_pu *
                                      TTPLPFC_I_INDIVIDUAL_MAX_SENSE);
        TTPLPFC_iL1_sensed_Amps = (TTPLPFC_iL1_sensed_Amps < 0.0033f)?
                0.0033f:TTPLPFC_iL1_sensed_Amps;

        TTPLPFC_dbRED_SetValue_Temp1_ticks = (uint16_t)((float32_t)100000000.0 *
                            (2.0 * TTPLPFC_VBUS_TYPICAL * TTPLPFC_HF_FET_COSS) /
                            (TTPLPFC_iL1_sensed_Amps));
        TTPLPFC_dbRED_SetValue1_ticks = (TTPLPFC_dbRED_SetValue_Temp1_ticks <
                TTPLPFC_dbRED_Min_ticks)?TTPLPFC_dbRED_Min_ticks:
                                         TTPLPFC_dbRED_SetValue_Temp1_ticks;
        TTPLPFC_dbRED_SetValue1_ticks = (TTPLPFC_dbRED_SetValue_Temp1_ticks >
        TTPLPFC_dbRED_Max_ticks)?TTPLPFC_dbRED_Max_ticks:
                                         TTPLPFC_dbRED_SetValue_Temp1_ticks;

        //
        // Phase B
        //
        TTPLPFC_iL2_sensed_Amps = fabsf(TTPLPFC_iL2_sensed_pu *
                                      TTPLPFC_I_INDIVIDUAL_MAX_SENSE);
        TTPLPFC_iL2_sensed_Amps = (TTPLPFC_iL2_sensed_Amps < 0.0033f)?
                0.0033f:TTPLPFC_iL2_sensed_Amps;

        TTPLPFC_dbRED_SetValue_Temp2_ticks = (uint16_t)((float32_t)100000000.0 *
                            (2.0 * TTPLPFC_VBUS_TYPICAL * TTPLPFC_HF_FET_COSS) /
                            (TTPLPFC_iL2_sensed_Amps)
                                 );
        TTPLPFC_dbRED_SetValue2_ticks = (TTPLPFC_dbRED_SetValue_Temp2_ticks <
                TTPLPFC_dbRED_Min_ticks)?TTPLPFC_dbRED_Min_ticks:
                                         TTPLPFC_dbRED_SetValue_Temp2_ticks;
        TTPLPFC_dbRED_SetValue2_ticks = (TTPLPFC_dbRED_SetValue_Temp2_ticks >
        TTPLPFC_dbRED_Max_ticks)?TTPLPFC_dbRED_Max_ticks:
                                         TTPLPFC_dbRED_SetValue_Temp2_ticks;

        //
        // Phase C
        //
        TTPLPFC_iL3_sensed_Amps = fabsf(TTPLPFC_iL3_sensed_pu *
                                      TTPLPFC_I_INDIVIDUAL_MAX_SENSE);
        TTPLPFC_iL3_sensed_Amps = (TTPLPFC_iL3_sensed_Amps < 0.0033f)?
                0.0033f:TTPLPFC_iL3_sensed_Amps;

        TTPLPFC_dbRED_SetValue_Temp3_ticks = (uint16_t)((float32_t)100000000.0 *
                            (2.0 * TTPLPFC_VBUS_TYPICAL * TTPLPFC_HF_FET_COSS) /
                            (TTPLPFC_iL3_sensed_Amps));
        TTPLPFC_dbRED_SetValue3_ticks = (TTPLPFC_dbRED_SetValue_Temp3_ticks <
                TTPLPFC_dbRED_Min_ticks)?TTPLPFC_dbRED_Min_ticks:
                                         TTPLPFC_dbRED_SetValue_Temp3_ticks;
        TTPLPFC_dbRED_SetValue3_ticks = (TTPLPFC_dbRED_SetValue_Temp3_ticks >
        TTPLPFC_dbRED_Max_ticks)?TTPLPFC_dbRED_Max_ticks:
                                         TTPLPFC_dbRED_SetValue_Temp3_ticks;

    #else
        TTPLPFC_dbRED_SetValue_ticks =
                TTPLPFC_HIGH_FREQ_PWM_DEADBAND_RED_COUNT;
        TTPLPFC_dbRED_SetValue1_ticks =
                TTPLPFC_HIGH_FREQ_PWM_DEADBAND_RED_COUNT;
        TTPLPFC_dbRED_SetValue2_ticks =
                TTPLPFC_HIGH_FREQ_PWM_DEADBAND_RED_COUNT;
        TTPLPFC_dbRED_SetValue3_ticks =
                TTPLPFC_HIGH_FREQ_PWM_DEADBAND_RED_COUNT;
    #endif
}


#pragma FUNC_ALWAYS_INLINE(TTPLPFC_SPLL)
static inline void TTPLPFC_SPLL()
{
    #if TTPLPFC_LAB == 5 || TTPLPFC_LAB == 6 || TTPLPFC_LAB == 7 ||            \
        TTPLPFC_LAB == 8 || (TTPLPFC_LAB == 1 && TTPLPFC_PWM_AC_CHECK == 1 )

        //
        //acSine is generated from ramp_gen for resistive load test
        //
        if(TTPLPFC_acSine > 0.0)
        {
            TTPLPFC_ac_sign_filtered = 1;
        }
        else
        {
            TTPLPFC_ac_sign_filtered = 0;
        }

            TTPLPFC_spll_sine = TTPLPFC_acSine;
            TTPLPFC_spll_cosine = TTPLPFC_acCosine;
    #else

        //
        //acSine is obtained from SPLL for grid-connected test
        //
        #if TTPLPFC_SPLL_METHOD_SELECT == TTPLPFC_SPLL_1PH_SOGI_SEL
            SPLL_1PH_SOGI_run(&TTPLPFC_spll1, TTPLPFC_ac_vol_sensed_pu);

            //
            // Read sine from SPLL when ac input is alive
            //
            if (TTPLPFC_ac_vol_State.enum_acVolState <= 2)
            {
                TTPLPFC_spll_sine = TTPLPFC_spll1.sine;
                TTPLPFC_spll_cosine = TTPLPFC_spll1.cosine;
            }

            //
            // Read sine from SPLL_Regen when ac input is out
            //
            else
            {
                TTPLPFC_spll_sine = TTPLPFC_acSine_regen;
                TTPLPFC_spll_cosine = TTPLPFC_acCosine_regen;
            }


            if(fabsf(TTPLPFC_spll1.ylf[0]) > 2.0f)
            {
                if(TTPLPFC_ac_vol_State.enum_acVolState <= 2)
                {
                    if(TTPLPFC_ac_vol_sensed_pu > 0.0)
                    {
                        TTPLPFC_ac_sign_filtered = 1;
                    }
                    else
                    {
                        TTPLPFC_ac_sign_filtered = 0;
                    }
                }

                else
                {
                    if(TTPLPFC_ac_vol_regen_Volts > 0.0)
                    {
                        TTPLPFC_ac_sign_filtered = 1;
                    }
                    else
                    {
                        TTPLPFC_ac_sign_filtered = 0;
                    }
                }
            }

            else
            {
                if(TTPLPFC_spll_sine > 0.0)
                {
                    TTPLPFC_ac_sign_filtered = 1;
                }
                else
                {
                    TTPLPFC_ac_sign_filtered = 0;
                }
            }

            TTPLPFC_acSinePrev = TTPLPFC_acSine;
            TTPLPFC_acSine = TTPLPFC_spll_sine;

        #endif


        #if TTPLPFC_SPLL_METHOD_SELECT == TTPLPFC_TTPLPFC_SPLL_1PH_NOTCH_SEL
            SPLL_1PH_NOTCH_run(&TTPLPFC_spll2, TTPLPFC_ac_vol_sensed_pu);
            TTPLPFC_spll_sine = TTPLPFC_spll2.sine;
            TTPLPFC_spll_cosine = TTPLPFC_spll2.cosine;
            if(fabsf(TTPLPFC_spll2.ylf[0]) > 8.0f)
            {

                if(TTPLPFC_ac_vol_sensed_pu > 0.0)
                {
                    TTPLPFC_ac_sign_filtered = 1;
                }
                else
                {
                    TTPLPFC_ac_sign_filtered = 0;
                }
            }
            else
            {

                if(TTPLPFC_spll2.sine > 0.0)
                {
                    TTPLPFC_ac_sign_filtered = 1;
                }
                else
                {
                    TTPLPFC_ac_sign_filtered = 0;
                }
            }

            TTPLPFC_acSinePrev = TTPLPFC_acSine;
            TTPLPFC_acSine = TTPLPFC_spll_sine;
        #endif


        #if TTPLPFC_SPLL_METHOD_SELECT == TTPLPFC_SPLL_1PH_SOGI_FLL_SEL
          SPLL_1PH_SOGI_FLL_run(&TTPLPFC_spll3, TTPLPFC_ac_vol_sensed_pu);
          TTPLPFC_spll_sine = TTPLPFC_spll3.sine;
          TTPLPFC_spll_cosine = TTPLPFC_spll3.cosine;

            if(fabsf(TTPLPFC_spll3.ylf[0]) > 0.8f)
            {

                if(TTPLPFC_ac_vol_sensed_pu > 0.0)
                {
                    TTPLPFC_ac_sign_filtered = 1;
                }
                else
                {
                    TTPLPFC_ac_sign_filtered = 0;
                }
            }
            else
            {

                if(TTPLPFC_spll3.sine > 0.0)
                {
                    TTPLPFC_ac_sign_filtered = 1;
                }
                else
                {
                    TTPLPFC_ac_sign_filtered = 0;
                }
            }

            TTPLPFC_acSinePrev = TTPLPFC_acSine;
            TTPLPFC_acSine = TTPLPFC_spll_sine;
        #endif
    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_SPLL_Regen)
static inline void TTPLPFC_SPLL_Regen()
{
    //
    //Generate ramp signal
    //

    TTPLPFC_regen_theta = TTPLPFC_regen_theta
                    + (TTPLPFC_acSine_regen_freq * TTPLPFC_acSine_regen_ISRperiod) *
                    (float32_t)(2.0*3.1415926f);

    //
    //Read SPLL Angle from normal PFC operation in every 1 ms
    //The internal angle is synchronized with the grid angle when syncOn = 1
    //
    if ( TTPLPFC_SPLL_regen_syncOn == 1)
    {
        if(TTPLPFC_Regen_cnt == TTPLPFC_Regen_cnt_Max)
        {

            TTPLPFC_regen_theta = TTPLPFC_spll1.theta;
            TTPLPFC_Regen_cnt = 0;
        }

        TTPLPFC_Regen_cnt++;

    }


    //
    // Set the upper and lower boundary for the generated angle
    //
    if(TTPLPFC_regen_theta > (float32_t)(2.0*3.1415926f))
    {
        TTPLPFC_regen_theta = TTPLPFC_regen_theta -
                                    (float32_t)(2.0*3.1415926f);
    }

    //
    // Generate ac voltage signal from SPLL_regen
    //
    TTPLPFC_acSine_regen = sinf(TTPLPFC_regen_theta);
    TTPLPFC_acCosine_regen = cosf(TTPLPFC_regen_theta);
    TTPLPFC_ac_vol_regen_Volts = TTPLPFC_ac_vol_regen_magnitude * TTPLPFC_acSine_regen;
}
#pragma FUNC_ALWAYS_INLINE(TTPLPFC_dataLogger)
static inline void TTPLPFC_dataLogger()
{
    #ifndef __TMS320C28XX_CLA__

        #if(TTPLPFC_LAB == 1 || TTPLPFC_LAB == 5 || TTPLPFC_LAB == 6)
            //
            // check output voltage and inverter current meas.
            //
            TTPLPFC_dVal1 = TTPLPFC_acSine;
            TTPLPFC_dVal2 = TTPLPFC_acSine - TTPLPFC_spll1.sine;
            TTPLPFC_dVal3 = TTPLPFC_acSine - TTPLPFC_spll3.sine;
            TTPLPFC_dVal4 = TTPLPFC_ac_cur_sensed_pu;
        #elif(TTPLPFC_LAB == 2 || TTPLPFC_LAB == 3  || TTPLPFC_LAB == 7 ||     \
              TTPLPFC_LAB == 8 || TTPLPFC_LAB == 9)
            //
            // check inverter current meas and reference.
            //
            TTPLPFC_dVal1 = TTPLPFC_spll1.sine;
            TTPLPFC_dVal2 = TTPLPFC_iL2_sensed_pu;;
            TTPLPFC_dVal3 = TTPLPFC_dutyPU;
            TTPLPFC_dVal4 = TTPLPFC_ac_cur_sensed_pu;
        #else
            //
            // check inverter voltage meas and reference
            //
            TTPLPFC_dVal1 = TTPLPFC_acSine;
            TTPLPFC_dVal2 = TTPLPFC_ac_cur_sensed_pu;
            TTPLPFC_dVal3 = TTPLPFC_ac_cur_ref_pu;
            TTPLPFC_dVal4 = TTPLPFC_spll3.ylf[0];
        #endif
            DLOG_4CH_run(&TTPLPFC_dLog1);
    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_rlyConnectFlag)
static inline void TTPLPFC_rlyConnectFlag()
{
    #if TTPLPFC_DC_CHECK == 0
        #if TTPLPFC_LAB <= 4
            //
            //Relay connection condition for PFC mode
            //
            if(TTPLPFC_ac_volRms_sensed_Volts > TTPLPFC_ac_volRms_underVoltage_Volts  )

            {

                TTPLPFC_rlyConnect = 1;

            }

            else
            {

                if (TTPLPFC_vBus_sensed_Volts > TTPLPFC_ac_volRMS_regen_Volts * 1.414f)
                {
                    TTPLPFC_rlyConnect = 1;
                }

                else
                {
                    TTPLPFC_rlyConnect = 0;
                }

            }

        #else
            //
            //Relay connection condition for INV mode
            //
            if( TTPLPFC_vBus_sensed_Volts > TTPLPFC_vBus_underVoltage_Volts)
            {
                TTPLPFC_rlyConnect = 1;
            }
            else
            {
                TTPLPFC_rlyConnect = 0;
            }
        #endif
    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_overVoltageProtection)
static inline void TTPLPFC_overVoltageProtection()
{
    #if TTPLPFC_LAB <= 4
        //
        // Overvoltage protection for PFC mode
        //
        if(TTPLPFC_vBus_sensed_Volts > TTPLPFC_vBus_overVoltage_Volts)
        {
            TTPLPFC_pwm_SwState.enum_pwmSwState = pwmSwState_defaultState;
            TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM1_BASE);
            TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM2_BASE);
            TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM3_BASE);
            EPWM_setActionQualifierContSWForceAction(TTPLPFC_LOW_FREQ_PWM_BASE,
                                                    EPWM_AQ_OUTPUT_A ,
                                                    EPWM_AQ_SW_OUTPUT_LOW);
            EPWM_setActionQualifierContSWForceAction(TTPLPFC_LOW_FREQ_PWM_BASE,
                                                    EPWM_AQ_OUTPUT_B ,
                                                    EPWM_AQ_SW_OUTPUT_LOW);

            if(TTPLPFC_board_Status.enum_boardStatus == boardStatus_NoFault)
            {
                TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
            }
            TTPLPFC_board_Status.enum_boardStatus = boardStatus_OverVoltageTrip;
        }
    #else
        //
        // Overvoltage protection for INV mode
        //
        if(TTPLPFC_ac_volRms_sensed_Volts > TTPLPFC_ac_volRms_overVoltage_Volts)
        {
            TTPLPFC_pwm_SwState.enum_pwmSwState = pwmSwState_defaultState;
            TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM1_BASE);
            TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM2_BASE);
            TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM3_BASE);
            EPWM_setActionQualifierContSWForceAction(TTPLPFC_LOW_FREQ_PWM_BASE,
                                                    EPWM_AQ_OUTPUT_A ,
                                                    EPWM_AQ_SW_OUTPUT_LOW);
            EPWM_setActionQualifierContSWForceAction(TTPLPFC_LOW_FREQ_PWM_BASE,
                                                    EPWM_AQ_OUTPUT_B ,
                                                    EPWM_AQ_SW_OUTPUT_LOW);

            if(TTPLPFC_board_Status.enum_boardStatus == boardStatus_NoFault)
            {
                TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
            }
            TTPLPFC_board_Status.enum_boardStatus = boardStatus_OverVoltageTrip;
        }
    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_underVoltageProtection)
static inline void TTPLPFC_underVoltageProtection()
{
    #if(TTPLPFC_DC_CHECK == 0)
        //
        //Undervoltage protection for PFC
        //
        #if(TTPLPFC_LAB <= 4)
            //
            // If statement is added for ac drop condition (disasble)

            //
            if(TTPLPFC_UVP_disable == 0)
            {
                if(TTPLPFC_ac_volRms_sensed_Volts < TTPLPFC_ac_volRms_underVoltage_Volts)

                {
                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_defaultState;
                    TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                    TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                    TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM3_BASE);
                    EPWM_setActionQualifierContSWForceAction(
                            TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_A,
                            EPWM_AQ_SW_OUTPUT_LOW);
                    EPWM_setActionQualifierContSWForceAction(
                            TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_B ,
                            EPWM_AQ_SW_OUTPUT_LOW);

                    if(TTPLPFC_board_Status.enum_boardStatus
                            == boardStatus_NoFault)
                    {
                        TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
                    }
                    TTPLPFC_board_Status.enum_boardStatus =
                            boardStatus_InputUnderVoltageTrip;
                }
            }


        //
        //Undervoltage protection for INV
        //
        #else
            if(TTPLPFC_vBus_sensed_Volts < TTPLPFC_vBus_underVoltage_Volts)
                {
                    TTPLPFC_pwm_SwState.enum_pwmSwState =
                            pwmSwState_defaultState;
                    TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM1_BASE);
                    TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM2_BASE);
                    TTPLPFC_HAL_forceOSTPWMTrip(TTPLPFC_HIGH_FREQ_PWM3_BASE);
                    EPWM_setActionQualifierContSWForceAction(
                            TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_A,
                            EPWM_AQ_SW_OUTPUT_LOW);
                    EPWM_setActionQualifierContSWForceAction(
                            TTPLPFC_LOW_FREQ_PWM_BASE, EPWM_AQ_OUTPUT_B,
                            EPWM_AQ_SW_OUTPUT_LOW);

                    if(TTPLPFC_board_Status.enum_boardStatus ==
                            boardStatus_NoFault)
                    {
                        TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
                    }
                    TTPLPFC_board_Status.enum_boardStatus =
                            boardStatus_InputUnderVoltageTrip;
                }

            //
            // Waiting for the grid connection after applying high enough
            // dc bus voltage (for grid-connected test)
            //
            if(TTPLPFC_vBus_sensed_Volts >= TTPLPFC_vBus_underVoltage_Volts &&
                    TTPLPFC_ac_volRms_sensed_Volts < TTPLPFC_ac_volRms_underVoltage_Volts)
                    TTPLPFC_board_Status.enum_boardStatus =
                            boardStatus_NoGridConnection;

        #endif
    #endif

}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_acDropDetection)
static inline void TTPLPFC_acDropDetection()
{

    if ( TTPLPFC_ac_vol_State.enum_acVolState >= 2 )
    {

         //
         // Set acDrop detection range larger than acSine_regen > 0.2
         // to avoid zero crossing distortion and sensor noise issues
         //
         if ( fabsf(TTPLPFC_acSine_regen) > 0.2f)
         {
             //
             // If the sensed voltage is less than 10 % of the nominal value
             // ac drop flag is set to 1
             // The instantaneous value is used for the faster response
             //
             if( fabsf(TTPLPFC_ac_vol_sensed_Volts/TTPLPFC_ac_vol_regen_Volts) < 0.1f )
             {
                 TTPLPFC_acDrop_flag = 1;
             }

             else
             {
                 TTPLPFC_acDrop_flag = 0;
             }
         }

         //
         // Set brown out detection when ac line is alive
         // RMS value is used to determine brown-out event
         // and avoid interference with ac drop detection
         //
         if (TTPLPFC_acDrop_flag == 0)
         {
             if (TTPLPFC_ac_volRms_sensed_Volts < TTPLPFC_ac_volRMS_regen_Volts * 0.9f
             && TTPLPFC_ac_volRms_sensed_Volts > TTPLPFC_ac_volRMS_regen_Volts * 0.45f)

             {
                 TTPLPFC_brownOut_flag = 1;

             }

             else
             {
                 TTPLPFC_brownOut_flag = 0;
             }
         }

    }
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_overCurrentProtection)
static inline void TTPLPFC_overCurrentProtection()
{
    if((TTPLPFC_PWM_TRIP_STATUS(TTPLPFC_LOW_FREQ_PWM_BASE) &
            EPWM_TZ_INTERRUPT_DCAEVT1) != 0)
    {
        TTPLPFC_pwm_SwState.enum_pwmSwState = pwmSwState_defaultState;

        if(TTPLPFC_board_Status.enum_boardStatus == boardStatus_NoFault)
        {
            TTPLPFC_ac_volRmsEma_sensed_Volts = 0;
        }

        TTPLPFC_board_Status.enum_boardStatus = boardStatus_OverCurrentTrip;
    }

}



#pragma FUNC_ALWAYS_INLINE(TTPLPFC_instrumentation)
static inline void TTPLPFC_instrumentation()
{

    //
    //Calculate RMS input voltage and input frequency
    //
    TTPLPFC_sine_mains.i = TTPLPFC_ac_cur_sensed_pu;
    TTPLPFC_sine_mains.v = TTPLPFC_ac_vol_sensed_pu;
    POWER_MEAS_SINE_ANALYZER_run(&TTPLPFC_sine_mains);
    TTPLPFC_ac_curRms_sensed_Amps =
            TTPLPFC_sine_mains.iRms * TTPLPFC_I_MAX_SENSE;
    TTPLPFC_ac_volRms_sensed_Volts =
            TTPLPFC_sine_mains.vRms * TTPLPFC_VAC_MAX_SENSE;
    TTPLPFC_powerRms_Watts =
            TTPLPFC_sine_mains.pRms * TTPLPFC_VAC_MAX_SENSE *
            TTPLPFC_I_MAX_SENSE;
    TTPLPFC_powerFactor = TTPLPFC_sine_mains.powerFactor;
    TTPLPFC_apparentPower_VA = TTPLPFC_sine_mains.vaRms *
            TTPLPFC_VAC_MAX_SENSE * TTPLPFC_I_MAX_SENSE;
    TTPLPFC_acFreqAvg_Hz = TTPLPFC_sine_mains.acFreqAvg;
    TTPLPFC_ac_volEma_sensed_Volts = TTPLPFC_sine_mains.vEma *
            TTPLPFC_VAC_MAX_SENSE;
    TTPLPFC_EMAVG_MACRO(
            TTPLPFC_sine_mains.vRms, TTPLPFC_vRmsAvg_pu, (float32_t)0.000528);

}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_rlyOnOff)
static inline void TTPLPFC_rlyOnOff()
{
    #if TTPLPFC_DC_CHECK == 0
        if(fabsf(TTPLPFC_acSine) < 0.05f)
        {
            if(TTPLPFC_rlyConnect == 1)
            {
                TTPLPFC_HAL_closeRelay();
            }
        }

        if(TTPLPFC_rlyConnect == 0)
        {
            TTPLPFC_HAL_openRelay();
        }
    #else
        if(TTPLPFC_rlyConnect == 1)
        {
            TTPLPFC_HAL_closeRelay();
        }
        else
        {
            TTPLPFC_HAL_openRelay();
        }
#endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_phaseShedding)
static inline void TTPLPFC_phaseShedding()
{
    #if TTPLPFC_PHASE_SHEDDING_ENABLED == 1

    //
    //  Phase shedding
    //
        switch(TTPLPFC_interleaving_State.enum_interleavingState)
        {
        case interleavingState_3ph:
            if(TTPLPFC_ac_cur_ref_pu < TTPLPFC_iref2_pu - TTPLPFC_deltaIref_pu)
            {
                TTPLPFC_interleaving_State.enum_interleavingState =
                        interleavingState_2ph;

                //
                // 180 Degree Phase Shift for 2 phase interleaving
                //
                EPWM_setPhaseShift(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                               ((uint16_t)((float32_t)TTPLPFC_PWM_PERIOD /
                                       (float32_t)(2.0))) - 2);
                EPWM_setCountModeAfterSync(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                     EPWM_COUNT_MODE_DOWN_AFTER_SYNC);

                //
                // Set High FREQ PWM 2 On and Set High FREQ PWM 3 Off
                //
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM2_H_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM2_L_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM3_H_PHASE_SHEDDING_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM3_L_PHASE_SHEDDING_GPIO_PIN_CONFIG);
            }

            break;

        case interleavingState_2ph:
            if(TTPLPFC_ac_cur_ref_pu > TTPLPFC_iref2_pu + TTPLPFC_deltaIref_pu)
            {
                TTPLPFC_interleaving_State.enum_interleavingState =
                        interleavingState_3ph;

                //
                // 120 Degree Phase Shift for 2 phase interleaving
                //
                EPWM_setPhaseShift(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                               (2 + (uint16_t)((float32_t)TTPLPFC_PWM_PERIOD /
                                       (float32_t)(3.0))));
                EPWM_setCountModeAfterSync(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                           EPWM_COUNT_MODE_UP_AFTER_SYNC);

                //
                // Set High FREQ PWM 2 and 3 On
                //
                GPIO_setPinConfig(TTPLPFC_HIGH_FREQ_PWM2_H_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(TTPLPFC_HIGH_FREQ_PWM2_L_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(TTPLPFC_HIGH_FREQ_PWM3_H_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(TTPLPFC_HIGH_FREQ_PWM3_L_GPIO_PIN_CONFIG);
            }

            else if(TTPLPFC_ac_cur_ref_pu <
                    TTPLPFC_iref1_pu - TTPLPFC_deltaIref_pu)
            {
                TTPLPFC_interleaving_State.enum_interleavingState =
                        interleavingState_1ph;

                //
                //  Set High FREQ PWM2 and 3 Off
                //
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM2_H_PHASE_SHEDDING_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM2_L_PHASE_SHEDDING_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM3_H_PHASE_SHEDDING_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM3_L_PHASE_SHEDDING_GPIO_PIN_CONFIG);
            }

            break;

        case interleavingState_1ph:

            if(TTPLPFC_ac_cur_ref_pu > TTPLPFC_iref1_pu + TTPLPFC_deltaIref_pu)
            {
                TTPLPFC_interleaving_State.enum_interleavingState
                = interleavingState_2ph;

                //
                //  180 Degree Phase Shift for 2 phase interleaving
                //
                EPWM_setPhaseShift(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                              ((uint16_t)((float32_t)TTPLPFC_PWM_PERIOD /
                                      (float32_t)(2.0))) - 2);
                EPWM_setCountModeAfterSync(TTPLPFC_HIGH_FREQ_PWM2_BASE,
                                          EPWM_COUNT_MODE_DOWN_AFTER_SYNC);

                //
                //  Set High FREQ PWM 2 On and Set High FREQ PWM 3 Off
                //
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM2_H_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM2_L_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM3_H_PHASE_SHEDDING_GPIO_PIN_CONFIG);
                GPIO_setPinConfig(
                       TTPLPFC_HIGH_FREQ_PWM3_L_PHASE_SHEDDING_GPIO_PIN_CONFIG);
            }

           break;
        }
    #else
        TTPLPFC_interleaving_State.enum_interleavingState =
                interleavingState_3ph;
    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runSFRAcollect)
static inline void TTPLPFC_runSFRAcollect(void)
{
    #if(TTPLPFC_SFRA_TYPE == TTPLPFC_SFRA_CURRENT )
        SFRA_F32_collect((float32_t*)&TTPLPFC_gi_out,
                         (float32_t*)&TTPLPFC_ac_cur_sensed_pu);
    #endif
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab1)
static inline void TTPLPFC_runISR1_lab1(void)
{

    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    //
    // PWM Driver
    //
#pragma diag_suppress = 770
#pragma diag_suppress = 173

    #if TTPLPFC_PWM_AC_CHECK == 1
        TTPLPFC_rampGenerate();
        TTPLPFC_dutyPU = TTPLPFC_dutyPU_DC * TTPLPFC_acSine;
        TTPLPFC_pwmDriver();
    #else
        TTPLPFC_dutyPU = TTPLPFC_dutyPU_DC;
        TTPLPFC_pwmDriver_DC();
    #endif

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

#pragma diag_warning = 770
#pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab2)
static inline void TTPLPFC_runISR1_lab2(void)
{
    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    TTPLPFC_runCurrentLoop();

    //
    // PWM Driver
    //
#pragma diag_suppress = 770
#pragma diag_suppress = 173

    TTPLPFC_pwmDriver_DC();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

#pragma diag_warning = 770
#pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_acCurrentRef();

    TTPLPFC_runSFRAcollect();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);

}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab3)
static inline void TTPLPFC_runISR1_lab3(void)
{
    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    TTPLPFC_runCurrentLoop();

    //
    // PWM Driver
    //
    #pragma diag_suppress = 770
    #pragma diag_suppress = 173

    TTPLPFC_pwmDriver();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

    #pragma diag_warning = 770
    #pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_SPLL();

    TTPLPFC_acCurrentRef();

    TTPLPFC_runSFRAcollect();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);

}
#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab4)
static inline void TTPLPFC_runISR1_lab4(void)
{
    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    TTPLPFC_runCurrentLoop();


    //
    // PWM Driver
    //
    #pragma diag_suppress = 770
    #pragma diag_suppress = 173

    TTPLPFC_pwmDriver();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

    #pragma diag_warning = 770
    #pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    //
    // AC drop related functions
    //
    #if TTPLPFC_AC_DROP == 1
    {
        TTPLPFC_acDropDetection();

        TTPLPFC_SPLL_Regen();

        TTPLPFC_acVolMonitor();
    }
    #endif

    TTPLPFC_SPLL();

    TTPLPFC_acCurrentRef();

    TTPLPFC_runSFRAcollect();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab5)
static inline void TTPLPFC_runISR1_lab5(void)
{
    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    //
    //Set duty for open loop test
    //
    TTPLPFC_dutyPU = TTPLPFC_dutyPU_DC;

    //
    // PWM Driver
    //
#pragma diag_suppress = 770
#pragma diag_suppress = 173

    TTPLPFC_pwmDriver_DC();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

#pragma diag_warning = 770
#pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);
}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab6)
static inline void TTPLPFC_runISR1_lab6(void)
{

    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    TTPLPFC_rampGenerate();

    //
    //Set duty for open loop test
    //
    TTPLPFC_dutyPU = TTPLPFC_dutyPU_DC * TTPLPFC_acSine;

    //
    // PWM Driver
    //
#pragma diag_suppress = 770
#pragma diag_suppress = 173

    TTPLPFC_pwmDriver();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

#pragma diag_warning = 770
#pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_SPLL();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);

}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab7)
static inline void TTPLPFC_runISR1_lab7(void)
{

    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    TTPLPFC_rampGenerate();

    TTPLPFC_runCurrentLoop();

    //
    // PWM Driver
    //
#pragma diag_suppress = 770
#pragma diag_suppress = 173

    TTPLPFC_pwmDriver_DC();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

#pragma diag_warning = 770
#pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_SPLL();

    TTPLPFC_acCurrentRef();

    TTPLPFC_runSFRAcollect();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);

}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab8)
static inline void TTPLPFC_runISR1_lab8(void)
{

    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    TTPLPFC_rampGenerate();

    TTPLPFC_runCurrentLoop();

    //
    // PWM Driver
    //
#pragma diag_suppress = 770
#pragma diag_suppress = 173

    TTPLPFC_pwmDriver();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

#pragma diag_warning = 770
#pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_SPLL();

    TTPLPFC_acCurrentRef();

    TTPLPFC_runSFRAcollect();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);

}

#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR1_lab9)
static inline void TTPLPFC_runISR1_lab9(void)
{
    //
    // Read Current and Voltage Measurements
    //
    TTPLPFC_read_acReturnCurrent();
    TTPLPFC_read_acVoltage_separateResistor();

    TTPLPFC_runCurrentLoop();

    //
    // PWM Driver
    //
#pragma diag_suppress = 770
#pragma diag_suppress = 173

    TTPLPFC_pwmDriver();

    TTPLPFC_HAL_updatePWM(TTPLPFC_LOW_FREQ_PWM_BASE,
                          TTPLPFC_HIGH_FREQ_PWM1_BASE,
                          TTPLPFC_HIGH_FREQ_PWM2_BASE,
                          TTPLPFC_HIGH_FREQ_PWM3_BASE,
                          TTPLPFC_dutyPU, TTPLPFC_phase1ScaleFactor,
                          TTPLPFC_phase2ScaleFactor,
                          TTPLPFC_phase3ScaleFactor);

#pragma diag_warning = 770
#pragma diag_warning = 173

    TTPLPFC_adaptiveDeadTime();

    TTPLPFC_SPLL();

    TTPLPFC_acCurrentRef();

    TTPLPFC_runSFRAcollect();

    TTPLPFC_read_individualCurrent();
    TTPLPFC_read_busVoltage();

    TTPLPFC_vBusSensedBuff[TTPLPFC_vBusSensedBuffIndex++] =
            TTPLPFC_vBus_sensed_pu;
    if(TTPLPFC_vBusSensedBuffIndex >= 10)
        TTPLPFC_vBusSensedBuffIndex = 0;

    TTPLPFC_HAL_clearPWMInterruptFlag(
            TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE);

}

//
// Voltage loop plus instrumentation code
//
#pragma FUNC_ALWAYS_INLINE(TTPLPFC_runISR2)
static inline void TTPLPFC_runISR2()
{

    int32_t k = 0;
    #if TTPLPFC_INSTRUMENTATION_ISR_RUNNING_ON == C28x_CORE
        EINT;
    #endif

    TTPLPFC_vBus_sensedFiltered = 0;

    for(k = 0; k < 10; k++)
    {
        TTPLPFC_vBus_sensedFiltered+= TTPLPFC_vBusSensedBuff[k];
    }

    TTPLPFC_vBus_sensedFiltered = TTPLPFC_vBus_sensedFiltered * 0.1f;

    TTPLPFC_vBus_sensedFiltered_notch1 =
            TTPLPFC_NOTCH_2P2Z_RUN(&TTPLPFC_notch1,
                                   TTPLPFC_vBus_sensedFiltered);
    TTPLPFC_vBus_sensedFiltered_notch2 =
            TTPLPFC_NOTCH_2P2Z_RUN(&TTPLPFC_notch2,
                                   TTPLPFC_vBus_sensedFiltered_notch1);

    //
    // Voltage Loop
    //
    #if(TTPLPFC_VOLTAGE_LOOP_CLOSED == 1)
        TTPLPFC_runVoltageLoop();
    #endif

    TTPLPFC_EMAVG_MACRO(TTPLPFC_vBus_sensedFiltered_notch2,
                        TTPLPFC_vBusAvg_pu, (float32_t)0.000528);

    TTPLPFC_EMAVG_MACRO((fabsf(TTPLPFC_ac_vol_sensed_pu)
                        * TTPLPFC_VAC_MAX_SENSE),
                        TTPLPFC_ac_volRmsEma_sensed_Volts, (float32_t)0.00005);


    //
    // Connect inputs of the Datalogger module
    //
    TTPLPFC_dataLogger();

    TTPLPFC_rlyConnectFlag();

    TTPLPFC_vBus_sensed_Volts = TTPLPFC_vBus_sensedFiltered_notch2 *
                                TTPLPFC_VDCBUS_MAX_SENSE;
    TTPLPFC_ac_vol_sensed_Volts = (TTPLPFC_ac_vol_sensed_pu) *
                                  TTPLPFC_VAC_MAX_SENSE;
    TTPLPFC_ac_cur_sensed_Amps = TTPLPFC_ac_cur_sensed_pu *
                                 TTPLPFC_I_MAX_SENSE;

    TTPLPFC_overVoltageProtection();
    TTPLPFC_underVoltageProtection();
    TTPLPFC_overCurrentProtection();

    //
    //Calculate RMS input voltage and input frequency
    //
    TTPLPFC_instrumentation();

    TTPLPFC_rlyOnOff();

    TTPLPFC_phaseShedding();


}

static inline void  TTPLPFC_detectZeroCrossingClearPWMTrip(
        uint32_t base1, uint32_t base2, uint32_t base3, uint32_t base4)
{
    if((TTPLPFC_acSinePrev <= (float32_t)(0.00)) &&
            (TTPLPFC_acSine > (float32_t)(0.00)))
    {
        TTPLPFC_zeroCrossDetectFlag = 1;
    }
    else
    {
        TTPLPFC_zeroCrossDetectFlag = 0;
    }

    if(TTPLPFC_clearTrip == 1 && TTPLPFC_zeroCrossDetectFlag == 1)
    {
        TTPLPFC_pwm_SwState.enum_pwmSwState = pwmSwState_normalOperation;
        TTPLPFC_board_Status.enum_boardStatus = boardStatus_NoFault;
        TTPLPFC_clearTrip = 0;
    }

}


#ifdef __cplusplus
}
#endif


#endif
