//#############################################################################
//
// FILE:   ttplpfc_settings.h
//
// TITLE:  ttplpfc_settings.h
//
//#############################################################################
// $TI Release: TIDM_1007 v1.00.02.00 $
// $Release Date: Tue Mar 23 14:55:26 CDT 2021 $
// Copyright (C) {2015} Texas Instruments Incorporated - http://www.ti.com/
// * ALL RIGHTS RESERVED*
//#############################################################################

#ifndef _PROJSETTINGS_H
#define _PROJSETTINGS_H

#ifdef __cplusplus

extern "C" {
#endif

//
//defines
//

//
//Device Related Defines
//
#define CPU_SYS_CLOCK (100 * 1000000)
#define PWMSYSCLOCK_FREQ (100 * 1000000)
#define ECAPSYSCLOCK_FREQ (100 * 1000000)

//
// Project Options
// Labs for System check-out
// LAB 1:PFC Open Loop Check (DC Input)
// LAB 2:PFC Closed Current Loop Check (DC Input)
// LAB 3:PFC Closed Current Loop Check (AC Input)
// LAB 4:PFC Closed Voltage Loop Check (AC Input)
// LAB 5:INV Open Loop Check (DC Output)
// LAB 6:INV Open Loop Check (AC Output)
// LAB 7:INV Closed Current Loop Check (DC Output)
// LAB 8:INV Closed Current Loop Check (AC Output)
// LAB 9:INV Closed Current Loop Check (Grid Connection)
//
#define TTPLPFC_LAB 4

//
// 1 means control runs on C28x , otherwise it will run on CLA
//
#define C28x_CORE 1
#define CLA_CORE 2
#define TTPLPFC_CONTROL_RUNNING_ON 1

//
//Enable Disable Adaptive Deadtime
//
#define TTPLPFC_ADAPTIVE_DEADTIME 0

//
// set 1 to enable phase shedding 0 to disable
//
#define TTPLPFC_PHASE_SHEDDING_ENABLED 0

//
// set 1 to enable non linear voltage loop 0 to disable
//
#define TTPLPFC_NON_LINEAR_VOLTAGE_LOOP 1

#if TTPLPFC_LAB == 1
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 1
#define TTPLPFC_CURRENT_LOOP_CLOSED 0
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_ADAPTIVE_DEADTIME 0
#define TTPLPFC_PHASE_SHEDDING_ENABLED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 2
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 1
#define TTPLPFC_CURRENT_LOOP_CLOSED 1
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_ADAPTIVE_DEADTIME 0
#define TTPLPFC_PHASE_SHEDDING_ENABLED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 3
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 0
#define TTPLPFC_CURRENT_LOOP_CLOSED 1
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_ADAPTIVE_DEADTIME 0
#define TTPLPFC_PHASE_SHEDDING_ENABLED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 4
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 0
#define TTPLPFC_CURRENT_LOOP_CLOSED 1
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 1
#define TTPLPFC_ADAPTIVE_DEADTIME 0
#define TTPLPFC_PHASE_SHEDDING_ENABLED 0
#define TTPLPFC_NON_LINEAR_VOLTAGE_LOOP 1
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 5
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 1
#define TTPLPFC_CURRENT_LOOP_CLOSED 0
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 6
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 0
#define TTPLPFC_CURRENT_LOOP_CLOSED 0
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 7
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 1
#define TTPLPFC_CURRENT_LOOP_CLOSED 1
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 8
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 0
#define TTPLPFC_CURRENT_LOOP_CLOSED 1
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

#if TTPLPFC_LAB == 9
#define TTPLPFC_CONTROL_RUNNING_ON 1
#define TTPLPFC_DC_CHECK 0
#define TTPLPFC_CURRENT_LOOP_CLOSED 1
#define TTPLPFC_VOLTAGE_LOOP_CLOSED 0
#define TTPLPFC_SFRA_TYPE 1
#endif

//
//Power Stage Related Values
//
#define TTPLPFC_PWM_SWITCHING_FREQUENCY ((float)100*1000)
#define TTPLPFC_PWM_PERIOD ((PWMSYSCLOCK_FREQ) / (TTPLPFC_PWM_SWITCHING_FREQUENCY))

#define TTPLPFC_DEADBAND_RED_HS_US 0.1
#define TTPLPFC_DEADBAND_FED_HS_US 0.1

#define TTPLPFC_HIGH_FREQ_PWM_DEADBAND_FED_COUNT (int)((float32_t)TTPLPFC_DEADBAND_FED_HS_US * (float32_t)PWMSYSCLOCK_FREQ * (float32_t)0.000001)
#define TTPLPFC_HIGH_FREQ_PWM_DEADBAND_RED_COUNT (int)((float32_t)TTPLPFC_DEADBAND_RED_HS_US * (float32_t)PWMSYSCLOCK_FREQ * (float32_t)0.000001)

#define TTPLPFC_VAC_MAX_SENSE       (float32_t) 462.66
#define TTPLPFC_VDCBUS_MAX_SENSE    (float32_t) 462.66
#define TTPLPFC_I_MAX_SENSE         (float32_t) 24.778
#define TTPLPFC_I_TRIP_LIMIT        (float32_t) 24
#define TTPLPFC_VAC_TYPICAL         (float32_t) 120

#define TTPLPFC_VBUS_TYPICAL        (float32_t) 380

#define TTPLPFC_INDUCTOR_VALUE  ((float32_t) 0.481*0.001)

//
// Control Loop Design
//
#define TTPLPFC_CONTROL_ISR_FREQUENCY ((TTPLPFC_PWM_SWITCHING_FREQUENCY) / (TTPLPFC_CNTRL_ISR_FREQ_RATIO))
#define TTPLPFC_CNTRL_ISR_FREQ_RATIO 1
#define TTPLPFC_VOLTAGE_LOOP_RUN_RATIO 1

//
// SFRA Options
//
#define TTPLPFC_SFRA_DISABLED 0
#define TTPLPFC_SFRA_CURRENT 1
#define TTPLPFC_SFRA_VOLTAGE 2

#define TTPLPFC_SFRA_TYPE 1
#if TTPLPFC_SFRA_TYPE == TTPLPFC_SFRA_CURRENT
#define TTPLPFC_SFRA_ISR_FREQ       TTPLPFC_CONTROL_ISR_FREQUENCY
#else
#define TTPLPFC_SFRA_ISR_FREQ       TTPLPFC_INSTRUMENTATION_ISR_FREQUENCY
#endif

#define TTPLPFC_PI_VALUE 3.141592653589

#define TTPLPFC_GI_PI_KP (float) 0.3496503407
#define TTPLPFC_GI_PI_KI (float) 0.0020000510

#define TTPLPFC_GV_PI_KP (float) 0.6004499882
#define TTPLPFC_GV_PI_KI (float) 0.0001000236

//
// User code settings file
//
#include "ttplpfc_user_settings.h"

#ifdef __cplusplus
}
#endif

#endif
