//#############################################################################
//
// FILE:   ttplpfc_user_settings.h
//
// TITLE:  ttplpfc User Settings
//
//#############################################################################
// $TI Release: TIDM_1007 v1.00.02.00 $
// $Release Date: Tue Mar 23 14:55:26 CDT 2021 $
// $Copyright:
// Copyright (C) 2021 Texas Instruments Incorporated - http://www.ti.com/
//
// ALL RIGHTS RESERVED
// $
//#############################################################################

#if TTPLPFC_CONTROL_RUNNING_ON == CLA_CORE
#define TTPLPFC_INSTRUMENTATION_ISR_RUNNING_ON CLA_CORE
#else
#define TTPLPFC_INSTRUMENTATION_ISR_RUNNING_ON C28x_CORE
#endif

//
//#define AVV_TEST 0
//

#define TTPLPFC_C28x_CONTROLISR_INTERRUPT_PIE_GROUP_NO INTERRUPT_ACK_GROUP3
#define TTPLPFC_C28x_TENKHZISR_INTERRUPT_PIE_GROUP_NO INTERRUPT_CPU_INT14

#define TTPLPFC_C28x_CONTROLISR_INTERRUPT_TRIG_PWM_BASE EPWM1_BASE
#define TTPLPFC_C28x_CONTROLISR_INTERRUPT INT_EPWM1
#define TTPLPFC_CLA_CONTROLISR_TRIG  CLA_TRIGGER_EPWM1INT
#define TTPLPFC_CLA_INSTRUMENTATIONISR_TRIG  CLA_TRIGGER_TINT2

#define TTPLPFC_INSTRUMENTATION_ISR_FREQUENCY 10000
#define TTPLPFC_C28x_INSTRUMENTATION_INTERRUPT_TRIG_CPUTIMER_BASE CPUTIMER2_BASE
#define TTPLPFC_C28x_INSTRUMENTATION_INTERRUPT INT_TIMER2

#define TTPLPFC_GI_PI_MAX   ((float32_t)1.0)
#define TTPLPFC_GI_PI_MIN   ((float32_t)-1.0)

#define TTPLPFC_GV_PI_MAX   ((float32_t) 0.7)
#define TTPLPFC_GV_PI_MIN   ((float32_t)-0.02)

#define TTPLPFC_NON_LINEAR_V_LOOP_KP_MULTIPLIER ((float32_t)5.0)

#define TTPLPFC_INPUT_CAP_COMPENSATION 1
#define TTPLPFC_HIGH_LINE_INPUT_CAP_COMP_ADJUST ((float32_t)-0.02)
#define TTPLPFC_LOW_LINE_INPUT_CAP_COMP_ADJUST  ((float32_t)-0.01)

#define TTPLPFC_PWM_AC_CHECK 0
#define TTPLPFC_AC_DROP 1

#define TTPLPFC_SPLL_1PH_NOTCH_SEL 1
#define TTPLPFC_SPLL_1PH_SOGI_SEL 2
#define TTPLPFC_SPLL_1PH_SOGI_FLL_SEL 3
#define TTPLPFC_AC_FREQ 60
#define TTPLPFC_SPLL_METHOD_SELECT TTPLPFC_SPLL_1PH_SOGI_SEL

//
// Dead time optimization
//

#define TTPLPFC_HF_FET_COSS  ((float32_t)0.000000000145)

//
// Set the minimum deadband as 20 ns
//
#define TTPLPFC_PFC_DEADBAND_RED_MIN_US ((float32_t)0.020)

//
// Set the maximum deadband as 200 ns
//
#define TTPLPFC_PFC_DEADBAND_RED_MAX_US ((float32_t)0.200)
#define TTPLPFC_I_INDIVIDUAL_MAX_SENSE         ((float32_t)12.6)
#define TTPLPFC_HIGH_FREQ_PWM_DEADBAND_RED_MAX_COUNT (int32_t)((float32_t)TTPLPFC_PFC_DEADBAND_RED_MAX_US * (float32_t)PWMSYSCLOCK_FREQ * (float32_t)0.000001)
#define TTPLPFC_HIGH_FREQ_PWM_DEADBAND_RED_MIN_COUNT (int32_t)((float32_t)TTPLPFC_PFC_DEADBAND_RED_MIN_US * (float32_t)PWMSYSCLOCK_FREQ * (float32_t)0.000001)
#define TTPLPFC_PHASE_SHEDDING_1PH_2PH_TRANSITION_CURRENT ((float32_t)5.0)
#define TTPLPFC_PHASE_SHEDDING_2PH_3PH_TRANSITION_CURRENT ((float32_t)9.6)
#define TTPLPFC_PHASE_SHEDDING_TRANSITION_CURRENT_HYSTERESIS ((float32_t)0.5)

//
// PWM pin, ADC, SDFM, Relay Selection related variables
//
#define TTPLPFC_LOW_FREQ_PWM_BASE                   EPWM1_BASE

#define TTPLPFC_LOW_FREQ_PWM_H_GPIO                 0
#define TTPLPFC_LOW_FREQ_PWM_H_GPIO_PIN_CONFIG      GPIO_0_EPWM1A


#define TTPLPFC_LOW_FREQ_PWM_L_GPIO                 1
#define TTPLPFC_LOW_FREQ_PWM_L_GPIO_PIN_CONFIG      GPIO_1_EPWM1B

#define TTPLPFC_HIGH_FREQ_PWM1_BASE                 EPWM2_BASE

#define TTPLPFC_HIGH_FREQ_PWM1_H_GPIO               2
#define TTPLPFC_HIGH_FREQ_PWM1_H_GPIO_PIN_CONFIG    GPIO_2_EPWM2A
#define TTPLPFC_HIGH_FREQ_PWM1_H_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_2_GPIO2

#define TTPLPFC_HIGH_FREQ_PWM1_L_GPIO               3
#define TTPLPFC_HIGH_FREQ_PWM1_L_GPIO_PIN_CONFIG    GPIO_3_EPWM2B
#define TTPLPFC_HIGH_FREQ_PWM1_L_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_3_GPIO3

#define TTPLPFC_HIGH_FREQ_PWM2_BASE                 EPWM3_BASE

#define TTPLPFC_HIGH_FREQ_PWM2_H_GPIO               4
#define TTPLPFC_HIGH_FREQ_PWM2_H_GPIO_PIN_CONFIG    GPIO_4_EPWM3A
#define TTPLPFC_HIGH_FREQ_PWM2_H_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_4_GPIO4

#define TTPLPFC_HIGH_FREQ_PWM2_L_GPIO               5
#define TTPLPFC_HIGH_FREQ_PWM2_L_GPIO_PIN_CONFIG    GPIO_5_EPWM3B
#define TTPLPFC_HIGH_FREQ_PWM2_L_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_5_GPIO5

#define TTPLPFC_HIGH_FREQ_PWM3_BASE                 EPWM4_BASE

#define TTPLPFC_HIGH_FREQ_PWM3_H_GPIO               6
#define TTPLPFC_HIGH_FREQ_PWM3_H_GPIO_PIN_CONFIG    GPIO_6_EPWM4A
#define TTPLPFC_HIGH_FREQ_PWM3_H_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_6_GPIO6

#define TTPLPFC_HIGH_FREQ_PWM3_L_GPIO               7
#define TTPLPFC_HIGH_FREQ_PWM3_L_GPIO_PIN_CONFIG    GPIO_7_EPWM4B
#define TTPLPFC_HIGH_FREQ_PWM3_L_PHASE_SHEDDING_GPIO_PIN_CONFIG      GPIO_7_GPIO7

//eCAP Profiling
#define TTPLPFC_PROFILING1_INPUTXBAR          XBAR_INPUT8
#define TTPLPFC_PROFILING2_INPUTXBAR          XBAR_INPUT9

#define TTPLPFC_PROFILING1_ECAP               ECAP2_BASE
#define TTPLPFC_PROFILING2_ECAP               ECAP3_BASE

#define TTPLPFC_PROFILING1_ECAP_XBAR_MUX      ECAP_INPUT_INPUTXBAR8
#define TTPLPFC_PROFILING2_ECAP_XBAR_MUX      ECAP_INPUT_INPUTXBAR9

//
// Uncomment the below line for 100 pin control card
// #define F28004x_64PIN
//
#ifdef F28004x_64PIN

#define TTPLPFC_AC_CUR_ADC_MODULE  ADCC_BASE
#define TTPLPFC_AC_CUR_ADC_SOC_NO  ADC_SOC_NUMBER0
#define TTPLPFC_AC_CUR_ADC_PIN     ADC_CH_ADCIN1
#define TTPLPFC_AC_CUR_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_AC_CUR_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_AC_CUR_ADCRESULTREGBASE ADCCRESULT_BASE

#define TTPLPFC_AC_CUR_ADC_SOC_NO_2  ADC_SOC_NUMBER1
#define TTPLPFC_AC_CUR_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_AC_CUR_ADC_SOC_NO_3  ADC_SOC_NUMBER2
#define TTPLPFC_AC_CUR_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

#define TTPLPFC_AC_L_ADC_MODULE  ADCB_BASE
#define TTPLPFC_AC_L_ADC_SOC_NO  ADC_SOC_NUMBER0
#define TTPLPFC_AC_L_ADC_PIN     ADC_CH_ADCIN8
#define TTPLPFC_AC_L_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_AC_L_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_AC_L_ADCRESULTREGBASE ADCBRESULT_BASE

#define TTPLPFC_AC_L_ADC_SOC_NO2  ADC_SOC_NUMBER1
#define TTPLPFC_AC_L_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_AC_L_ADC_SOC_NO3  ADC_SOC_NUMBER2
#define TTPLPFC_AC_L_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

#define TTPLPFC_AC_N_ADC_MODULE  ADCA_BASE
#define TTPLPFC_AC_N_ADC_SOC_NO  ADC_SOC_NUMBER0
#define TTPLPFC_AC_N_ADC_PIN     ADC_CH_ADCIN2
#define TTPLPFC_AC_N_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_AC_N_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_AC_N_ADCRESULTREGBASE ADCARESULT_BASE

#define TTPLPFC_AC_N_ADC_SOC_NO2  ADC_SOC_NUMBER1
#define TTPLPFC_AC_N_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_AC_N_ADC_SOC_NO3  ADC_SOC_NUMBER2
#define TTPLPFC_AC_N_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

#define TTPLPFC_IL1_ADC_MODULE  ADCC_BASE
#define TTPLPFC_IL1_ADC_SOC_NO  ADC_SOC_NUMBER3
#define TTPLPFC_IL1_ADC_PIN     ADC_CH_ADCIN0
#define TTPLPFC_IL1_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_IL1_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_IL1_ADCRESULTREGBASE ADCCRESULT_BASE

#define TTPLPFC_IL2_ADC_MODULE  ADCC_BASE
#define TTPLPFC_IL2_ADC_SOC_NO  ADC_SOC_NUMBER4
#define TTPLPFC_IL2_ADC_PIN     ADC_CH_ADCIN2
#define TTPLPFC_IL2_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM3_SOCA
#define TTPLPFC_IL2_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_IL2_ADCRESULTREGBASE ADCCRESULT_BASE

#define TTPLPFC_IL3_ADC_MODULE  ADCA_BASE
#define TTPLPFC_IL3_ADC_SOC_NO  ADC_SOC_NUMBER3
#define TTPLPFC_IL3_ADC_PIN     ADC_CH_ADCIN6
#define TTPLPFC_IL3_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM4_SOCA
#define TTPLPFC_IL3_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_IL3_ADCRESULTREGBASE ADCARESULT_BASE

#define TTPLPFC_VBUS_ADC_MODULE  ADCC_BASE
#define TTPLPFC_VBUS_ADC_SOC_NO  ADC_SOC_NUMBER5
#define TTPLPFC_VBUS_ADC_PIN     ADC_CH_ADCIN3
#define TTPLPFC_VBUS_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_VBUS_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_VBUS_ADCRESULTREGBASE ADCCRESULT_BASE

#define TTPLPFC_VBUS_ADC_SOC_NO2  ADC_SOC_NUMBER6
#define TTPLPFC_VBUS_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_VBUS_ADC_SOC_NO3  ADC_SOC_NUMBER7
#define TTPLPFC_VBUS_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

//
// set 1 to enable the appropriate protection scheme
//
#define TTPLPFC_BOARD_PROTECTION_IL1_SENSE 1
#define TTPLPFC_BOARD_PROTECTION_IL2_SENSE 1
#define TTPLPFC_BOARD_PROTECTION_IL3_SENSE 1

#define TTPLPFC_BOARD_PROTECTION_L1 0
#define TTPLPFC_GPIO_BOARD_PROTECTION_L1 12
#define TTPLPFC_GPIO_BOARD_PROTECTION_L1_PIN_CONFIG GPIO_12_GPIO12

#define TTPLPFC_BOARD_PROTECTION_L2 0
#define TTPLPFC_GPIO_BOARD_PROTECTION_L2 13
#define TTPLPFC_GPIO_BOARD_PROTECTION_L2_PIN_CONFIG GPIO_13_GPIO13

#define TTPLPFC_BOARD_PROTECTION_L3 0
#define TTPLPFC_GPIO_BOARD_PROTECTION_L3 18
#define TTPLPFC_GPIO_BOARD_PROTECTION_L3_PIN_CONFIG GPIO_18_GPIO18

#define TTPLPFC_BOARD_PROTECTION_AC_CUR_FAULT 0
#define TTPLPFC_BOARD_PROTECTION_AC_CUR 1

#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_BASE               CMPSS2_BASE
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_2
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_2
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_MUX_VALUE 1

#define TTPLPFC_BOARD_PROTECTION_AC_CUR_XBAR_MUX                 XBAR_MUX02
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_XBAR_MUX_VAL             XBAR_EPWM_MUX02_CMPSS2_CTRIPH_OR_L

#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_BASE               CMPSS1_BASE
#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_1
#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_1
#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_ASYSCTRL_MUX_VALUE 1

#define TTPLPFC_BOARD_PROTECTION_IL1_XBAR_MUX                 XBAR_MUX00
#define TTPLPFC_BOARD_PROTECTION_IL1_XBAR_MUX_VAL             XBAR_EPWM_MUX00_CMPSS1_CTRIPH_OR_L

#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_BASE               CMPSS3_BASE
#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_3
#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_3
#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_ASYSCTRL_MUX_VALUE 1

#define TTPLPFC_BOARD_PROTECTION_IL2_XBAR_MUX                 XBAR_MUX04
#define TTPLPFC_BOARD_PROTECTION_IL2_XBAR_MUX_VAL             XBAR_EPWM_MUX04_CMPSS3_CTRIPH_OR_L

#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_BASE               CMPSS5_BASE
#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_5
#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_5
#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_ASYSCTRL_MUX_VALUE 0

#define TTPLPFC_BOARD_PROTECTION_IL3_XBAR_MUX                 XBAR_MUX08
#define TTPLPFC_BOARD_PROTECTION_IL3_XBAR_MUX_VAL             XBAR_EPWM_MUX08_CMPSS5_CTRIPH_OR_L

#define TTPLPFC_GPIO_RELAY 8
#define TTPLPFC_GPIO_RELAY_PIN_CONFIG GPIO_8_GPIO8

#define TTPLPFC_GPIO_I_SENSE_GAIN_ADJUST 11
#define TTPLPFC_GPIO_I_SENSE_GAIN_ADJUST_PIN_CONFIG GPIO_11_GPIO11

#define TTPLPFC_GPIO_PROFILING1 16
#define TTPLPFC_GPIO_PROFILING1_SET GPIO_GPASET_GPIO16
#define TTPLPFC_GPIO_PROFILING1_CLEAR GPIO_GPACLEAR_GPIO16
#define TTPLPFC_GPIO_PROFILING1_PIN_CONFIG GPIO_16_GPIO16

#define TTPLPFC_GPIO_PROFILING2 17
#define TTPLPFC_GPIO_PROFILING2_SET GPIO_GPASET_GPIO17
#define TTPLPFC_GPIO_PROFILING2_CLEAR GPIO_GPACLEAR_GPIO17
#define TTPLPFC_GPIO_PROFILING2_PIN_CONFIG GPIO_17_GPIO17

//
// I know this is not the correct GPIO on the 64 pin control Card
// we cannot do a LED toggle based on how the mapping is currently
// mapping it to GPIO 37
//
#define TTPLPFC_GPIO_LED1 16
#define TTPLPFC_GPIO_LED1_SET GPIO_GPASET_GPIO16
#define TTPLPFC_GPIO_LED1_CLEAR GPIO_GPACLEAR_GPIO16
#define TTPLPFC_GPIO_LED1_PIN_CONFIG GPIO_16_GPIO16

#define TTPLPFC_GPIO_LED2 33
#define TTPLPFC_GPIO_LED2_SET GPIO_GPASET_GPIO33
#define TTPLPFC_GPIO_LED2_CLEAR GPIO_GPACLEAR_GPIO33
#define TTPLPFC_GPIO_LED2_PIN_CONFIG GPIO_33_GPIO33

#else

#define TTPLPFC_AC_CUR_ADC_MODULE  ADCB_BASE
#define TTPLPFC_AC_CUR_ADC_SOC_NO  ADC_SOC_NUMBER0
#define TTPLPFC_AC_CUR_ADC_PIN     ADC_CH_ADCIN2
#define TTPLPFC_AC_CUR_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_AC_CUR_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_AC_CUR_ADCRESULTREGBASE ADCBRESULT_BASE

#define TTPLPFC_AC_CUR_ADC_SOC_NO_2  ADC_SOC_NUMBER1
#define TTPLPFC_AC_CUR_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_AC_CUR_ADC_SOC_NO_3  ADC_SOC_NUMBER2
#define TTPLPFC_AC_CUR_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

#define TTPLPFC_AC_L_ADC_MODULE  ADCB_BASE
#define TTPLPFC_AC_L_ADC_SOC_NO  ADC_SOC_NUMBER3
#define TTPLPFC_AC_L_ADC_PIN     ADC_CH_ADCIN3
#define TTPLPFC_AC_L_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_AC_L_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_AC_L_ADCRESULTREGBASE ADCBRESULT_BASE

#define TTPLPFC_AC_L_ADC_SOC_NO2  ADC_SOC_NUMBER4
#define TTPLPFC_AC_L_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_AC_L_ADC_SOC_NO3  ADC_SOC_NUMBER5
#define TTPLPFC_AC_L_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

#define TTPLPFC_AC_N_ADC_MODULE  ADCA_BASE
#define TTPLPFC_AC_N_ADC_SOC_NO  ADC_SOC_NUMBER0
#define TTPLPFC_AC_N_ADC_PIN     ADC_CH_ADCIN3
#define TTPLPFC_AC_N_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_AC_N_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_AC_N_ADCRESULTREGBASE ADCARESULT_BASE

#define TTPLPFC_AC_N_ADC_SOC_NO2  ADC_SOC_NUMBER1
#define TTPLPFC_AC_N_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_AC_N_ADC_SOC_NO3  ADC_SOC_NUMBER2
#define TTPLPFC_AC_N_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

#define TTPLPFC_IL1_ADC_MODULE  ADCA_BASE
#define TTPLPFC_IL1_ADC_SOC_NO  ADC_SOC_NUMBER3
#define TTPLPFC_IL1_ADC_PIN     ADC_CH_ADCIN2
#define TTPLPFC_IL1_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA

//
//#define IL1_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCB
//
#define TTPLPFC_IL1_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_IL1_ADCRESULTREGBASE ADCARESULT_BASE

#define TTPLPFC_IL2_ADC_MODULE  ADCA_BASE
#define TTPLPFC_IL2_ADC_SOC_NO  ADC_SOC_NUMBER4
#define TTPLPFC_IL2_ADC_PIN     ADC_CH_ADCIN4
#define TTPLPFC_IL2_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM3_SOCA

//
//#define IL2_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM3_SOCB
//
#define TTPLPFC_IL2_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_IL2_ADCRESULTREGBASE ADCARESULT_BASE

#define TTPLPFC_IL3_ADC_MODULE  ADCA_BASE
#define TTPLPFC_IL3_ADC_SOC_NO  ADC_SOC_NUMBER5
#define TTPLPFC_IL3_ADC_PIN     ADC_CH_ADCIN6
#define TTPLPFC_IL3_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM4_SOCA

//
//#define IL3_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM4_SOCB
//
#define TTPLPFC_IL3_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_IL3_ADCRESULTREGBASE ADCARESULT_BASE

#define TTPLPFC_VBUS_ADC_MODULE  ADCC_BASE
#define TTPLPFC_VBUS_ADC_SOC_NO  ADC_SOC_NUMBER0
#define TTPLPFC_VBUS_ADC_PIN     ADC_CH_ADCIN3
#define TTPLPFC_VBUS_ADC_TRIG_SOURCE ADC_TRIGGER_EPWM2_SOCA
#define TTPLPFC_VBUS_ADC_ACQPS_SYS_CLKS 20
#define TTPLPFC_VBUS_ADCRESULTREGBASE ADCCRESULT_BASE

#define TTPLPFC_VBUS_ADC_SOC_NO2  ADC_SOC_NUMBER1
#define TTPLPFC_VBUS_ADC_TRIG_SOURCE_2 ADC_TRIGGER_EPWM3_SOCA

#define TTPLPFC_VBUS_ADC_SOC_NO3  ADC_SOC_NUMBER2
#define TTPLPFC_VBUS_ADC_TRIG_SOURCE_3 ADC_TRIGGER_EPWM4_SOCA

//
// set 1 to enable the appropriate protection scheme
//
#define TTPLPFC_BOARD_PROTECTION_IL1_SENSE 1
#define TTPLPFC_BOARD_PROTECTION_IL2_SENSE 1
#define TTPLPFC_BOARD_PROTECTION_IL3_SENSE 1

#define TTPLPFC_BOARD_PROTECTION_L1 0
#define TTPLPFC_GPIO_BOARD_PROTECTION_L1 37
#define TTPLPFC_GPIO_BOARD_PROTECTION_L1_PIN_CONFIG GPIO_37_GPIO37

#define TTPLPFC_BOARD_PROTECTION_L2 0
#define TTPLPFC_GPIO_BOARD_PROTECTION_L2 35
#define TTPLPFC_GPIO_BOARD_PROTECTION_L2_PIN_CONFIG GPIO_35_GPIO35

#define TTPLPFC_BOARD_PROTECTION_L3 0
#define TTPLPFC_GPIO_BOARD_PROTECTION_L3 39
#define TTPLPFC_GPIO_BOARD_PROTECTION_L3_PIN_CONFIG GPIO_39_GPIO39

#define TTPLPFC_BOARD_PROTECTION_AC_CUR_FAULT 0
#define TTPLPFC_BOARD_PROTECTION_AC_CUR 1

#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_BASE               CMPSS3_BASE
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_3
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_3
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_CMPSS_ASYSCTRL_MUX_VALUE 0

#define TTPLPFC_BOARD_PROTECTION_AC_CUR_XBAR_MUX                 XBAR_MUX04
#define TTPLPFC_BOARD_PROTECTION_AC_CUR_XBAR_MUX_VAL             XBAR_EPWM_MUX04_CMPSS3_CTRIPH_OR_L

#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_BASE               CMPSS1_BASE
#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_1
#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_1
#define TTPLPFC_BOARD_PROTECTION_IL1_CMPSS_ASYSCTRL_MUX_VALUE 0

#define TTPLPFC_BOARD_PROTECTION_IL1_XBAR_MUX                 XBAR_MUX00
#define TTPLPFC_BOARD_PROTECTION_IL1_XBAR_MUX_VAL             XBAR_EPWM_MUX00_CMPSS1_CTRIPH_OR_L

#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_BASE               CMPSS2_BASE
#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_2
#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_2
#define TTPLPFC_BOARD_PROTECTION_IL2_CMPSS_ASYSCTRL_MUX_VALUE 0

#define TTPLPFC_BOARD_PROTECTION_IL2_XBAR_MUX                 XBAR_MUX02
#define TTPLPFC_BOARD_PROTECTION_IL2_XBAR_MUX_VAL             XBAR_EPWM_MUX02_CMPSS2_CTRIPH_OR_L

#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_BASE               CMPSS5_BASE
#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_ASYSCTRL_CMPHPMUX  ASYSCTL_CMPHPMUX_SELECT_5
#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_ASYSCTRL_CMPLPMUX  ASYSCTL_CMPLPMUX_SELECT_5
#define TTPLPFC_BOARD_PROTECTION_IL3_CMPSS_ASYSCTRL_MUX_VALUE 0

#define TTPLPFC_BOARD_PROTECTION_IL3_XBAR_MUX                 XBAR_MUX08
#define TTPLPFC_BOARD_PROTECTION_IL3_XBAR_MUX_VAL             XBAR_EPWM_MUX08_CMPSS5_CTRIPH_OR_L

#define TTPLPFC_GPIO_RELAY 12
#define TTPLPFC_GPIO_RELAY_SET GPIO_GPASET_GPIO12
#define TTPLPFC_GPIO_RELAY_CLEAR GPIO_GPACLEAR_GPIO12
#define TTPLPFC_GPIO_RELAY_PIN_CONFIG GPIO_12_GPIO12

#define TTPLPFC_GPIO_I_SENSE_GAIN_ADJUST 15
#define TTPLPFC_GPIO_I_SENSE_GAIN_ADJUST_PIN_CONFIG GPIO_15_GPIO15

#define TTPLPFC_GPIO_PROFILING1 9
#define TTPLPFC_GPIO_PROFILING1_SET GPIO_GPASET_GPIO9
#define TTPLPFC_GPIO_PROFILING1_CLEAR GPIO_GPACLEAR_GPIO9
#define TTPLPFC_GPIO_PROFILING1_PIN_CONFIG GPIO_9_GPIO9

#define TTPLPFC_GPIO_PROFILING2 17
#define TTPLPFC_GPIO_PROFILING2_SET GPIO_GPASET_GPIO17
#define TTPLPFC_GPIO_PROFILING2_CLEAR GPIO_GPACLEAR_GPIO17
#define TTPLPFC_GPIO_PROFILING2_PIN_CONFIG GPIO_17_GPIO17

#define TTPLPFC_GPIO_LED1 31
#define TTPLPFC_GPIO_LED1_SET GPIO_GPASET_GPIO31
#define TTPLPFC_GPIO_LED1_CLEAR GPIO_GPACLEAR_GPIO31
#define TTPLPFC_GPIO_LED1_PIN_CONFIG GPIO_31_GPIO31

#define TTPLPFC_GPIO_LED2 34
#define TTPLPFC_GPIO_LED2_SET GPIO_GPASET_GPIO34
#define TTPLPFC_GPIO_LED2_CLEAR GPIO_GPACLEAR_GPIO34
#define TTPLPFC_GPIO_LED2_PIN_CONFIG GPIO_34_GPIO34

#endif

//
// SFRA related
//
#define TTPLPFC_SFRA_GUI_SCI_BASE SCIA_BASE
#define TTPLPFC_SCI_VBUS_CLK 50000000
#define TTPLPFC_SFRA_GUI_SCI_BAUDRATE 57600
#define TTPLPFC_SFRA_GUI_SCIRX_GPIO 28
#define TTPLPFC_SFRA_GUI_SCITX_GPIO 29
#define TTPLPFC_SFRA_GUI_SCIRX_GPIO_PIN_CONFIG GPIO_28_SCIRXDA
#define TTPLPFC_SFRA_GUI_SCITX_GPIO_PIN_CONFIG GPIO_29_SCITXDA
#define TTPLPFC_SFRA_GUI_PLOT_OL_PLANT 1

//
// if the following #define is set to 1 SFRA GUI indicates status on LED
// otherwise LED code is ignored
//
#define TTPLPFC_SFRA_GUI_LED_INDICATOR 1
#define TTPLPFC_SFRA_GUI_LED_GPIO 31
#define TTPLPFC_SFRA_GUI_LED_GPIO_PIN_CONFIG GPIO_31_GPIO31

//
// Timer definitions based on System Clock
// 150 MHz devices
//
#define     mSec0_5     0.5*SYSTEM_FREQUENCY*1000
#define     mSec1       1*SYSTEM_FREQUENCY*1000
#define     mSec2       2.0*SYSTEM_FREQUENCY*1000
#define     mSec5       5*SYSTEM_FREQUENCY*1000
#define     mSec7_5     7.5*SYSTEM_FREQUENCY*1000
#define     mSec10      10*SYSTEM_FREQUENCY*1000
#define     mSec20      20*SYSTEM_FREQUENCY*1000
#define     mSec50      50*SYSTEM_FREQUENCY*1000
#define     mSec100     100*SYSTEM_FREQUENCY*1000
#define     mSec500     500*SYSTEM_FREQUENCY*1000
#define     mSec1000    1000*SYSTEM_FREQUENCY*1000

#ifndef TRUE
#define FALSE 0
#define TRUE  1
#endif

#define TTPLPFC_VBUS_FB     ADC_readResult(TTPLPFC_VBUS_ADCRESULTREGBASE, TTPLPFC_VBUS_ADC_SOC_NO)
#define TTPLPFC_VBUS_FB_2   ADC_readResult(TTPLPFC_VBUS_ADCRESULTREGBASE, TTPLPFC_VBUS_ADC_SOC_NO2)
#define TTPLPFC_VBUS_FB_3   ADC_readResult(TTPLPFC_VBUS_ADCRESULTREGBASE, TTPLPFC_VBUS_ADC_SOC_NO3)

#define TTPLPFC_AC_CUR_FB   ADC_readResult(TTPLPFC_AC_CUR_ADCRESULTREGBASE, TTPLPFC_AC_CUR_ADC_SOC_NO)
#define TTPLPFC_AC_CUR_FB_2 ADC_readResult(TTPLPFC_AC_CUR_ADCRESULTREGBASE, TTPLPFC_AC_CUR_ADC_SOC_NO_2)
#define TTPLPFC_AC_CUR_FB_3 ADC_readResult(TTPLPFC_AC_CUR_ADCRESULTREGBASE, TTPLPFC_AC_CUR_ADC_SOC_NO_3)

#define TTPLPFC_AC_L_FB     ADC_readResult(TTPLPFC_AC_L_ADCRESULTREGBASE, TTPLPFC_AC_L_ADC_SOC_NO)
#define TTPLPFC_AC_L_FB_2   ADC_readResult(TTPLPFC_AC_L_ADCRESULTREGBASE, TTPLPFC_AC_L_ADC_SOC_NO2)
#define TTPLPFC_AC_L_FB_3   ADC_readResult(TTPLPFC_AC_L_ADCRESULTREGBASE, TTPLPFC_AC_L_ADC_SOC_NO3)

#define TTPLPFC_AC_N_FB     ADC_readResult(TTPLPFC_AC_N_ADCRESULTREGBASE, TTPLPFC_AC_N_ADC_SOC_NO)
#define TTPLPFC_AC_N_FB_2   ADC_readResult(TTPLPFC_AC_N_ADCRESULTREGBASE, TTPLPFC_AC_N_ADC_SOC_NO2)
#define TTPLPFC_AC_N_FB_3   ADC_readResult(TTPLPFC_AC_N_ADCRESULTREGBASE, TTPLPFC_AC_N_ADC_SOC_NO3)

#define TTPLPFC_IL1_FB      ADC_readResult(TTPLPFC_IL1_ADCRESULTREGBASE, TTPLPFC_IL1_ADC_SOC_NO)
#define TTPLPFC_IL2_FB      ADC_readResult(TTPLPFC_IL2_ADCRESULTREGBASE, TTPLPFC_IL2_ADC_SOC_NO)
#define TTPLPFC_IL3_FB      ADC_readResult(TTPLPFC_IL3_ADCRESULTREGBASE, TTPLPFC_IL3_ADC_SOC_NO)

#define TTPLPFC_PWM_TRIP_STATUS EPWM_getTripZoneFlagStatus


#define TTPLPFC_ADC_PU_SCALE_FACTOR  (float32_t)(0.000244140625)
#define TTPLPFC_ADC_PU_PPB_SCALE_FACTOR 0.000488281250

#define TTPLPFC_GET_TASK_A_TIMER_OVERFLOW_STATUS CPUTimer_getTimerOverflowStatus(CPUTIMER0_BASE)
#define TTPLPFC_CLEAR_TASK_A_TIMER_OVERFLOW_FLAG CPUTimer_clearOverflowFlag(CPUTIMER0_BASE)

#define TTPLPFC_GET_TASK_B_TIMER_OVERFLOW_STATUS CPUTimer_getTimerOverflowStatus(CPUTIMER1_BASE)
#define TTPLPFC_CLEAR_TASK_B_TIMER_OVERFLOW_FLAG CPUTimer_clearOverflowFlag(CPUTIMER1_BASE)


#define TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_HIGH_PWMxB_LOW(m) HWREGH(m + EPWM_O_AQCSFRC) = 0x06;
#define TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_HIGH(m) HWREGH(m + EPWM_O_AQCSFRC) = 0x09;
#define TTPLPFC_HAL_AQ_SW_FORCE_PWMxA_LOW_PWMxB_LOW(m)  HWREGH(m + EPWM_O_AQCSFRC) = 0x05;
#define TTPLPFC_HAL_SET_PWM_DBRED(m, n)                  HWREGH(m + EPWM_O_DBRED ) = n;
#define TTPLPFC_HAL_SET_PWM_DBFED(m, n)                  HWREGH(m + EPWM_O_DBFED ) = n;

#define TTPLPFC_HAL_ENABLE_SWAP_DEADBAND_OUTPUT(m)      HWREGH(m + EPWM_O_DBCTL) = (HWREGH(m + EPWM_O_DBCTL) | 0x3000);
#define TTPLPFC_HAL_DISABLE_SWAP_DEADBAND_OUTPUT(m)     HWREGH(m + EPWM_O_DBCTL) = (HWREGH(m + EPWM_O_DBCTL) & ~0x3000);



//
//definitions for selecting DACH reference
//
#define REFERENCE_VDDA     0

//
// ADC Configuration
//

//
//internal reference (12-bit only)
//
#define REFERENCE_INTERNAL 0

//
//external reference
//
#define REFERENCE_EXTERNAL 1

#define REFERENCE_VDAC     0
#define REFERENCE_VREF     1

#define HistorySize 8

