--define CODE_ALIGNMENT=8
--define RFFT_ALIGNMENT=8
#if !defined(RFFT_ALIGNMENT)
#error define RFFT_ALIGNMENT under C2000 Linker -> Advanced Options -> Command File Preprocessing -> --define
#endif

MEMORY
{
   /* BEGIN is used for the "boot to Flash" bootloader mode   */
   BEGIN            : origin = 0x080000, length = 0x000002
   BOOT_RSVD        : origin = 0x000002, length = 0x0001AE     /* Part of M0, BOOT rom will use this for stack */
   RAMM0            : origin = 0x0001B0, length = 0x000250
   RAMM1            : origin = 0x000400, length = 0x0003F8     /* on-chip RAM block M1 */
//   RAMM1_RSVD       : origin = 0x0007F8, length = 0x000008     /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */

   RAMD01            : origin = 0x00C000, length = 0x001000

   /*
   RAMD0            : origin = 0x00C000, length = 0x000800
   RAMD1            : origin = 0x00C800, length = 0x000800
*/
   /*
   RAMLS0           : origin = 0x008000, length = 0x000800
   RAMLS1           : origin = 0x008800, length = 0x000800
   RAMLS2           : origin = 0x009000, length = 0x000800
   RAMLS3           : origin = 0x009800, length = 0x000800
   RAMLS4           : origin = 0x00A000, length = 0x000800
   RAMLS5           : origin = 0x00A800, length = 0x000800
   */
  // RAMLS6           : origin = 0x00B000, length = 0x000800
  // RAMLS7           : origin = 0x00B800, length = 0x000800
   RAMLS67           : origin = 0x00B000, length = 0x001000
  // RAMLS05           : origin = 0x008000, length = 0x003000

   RFFT01          : origin = 0x008000, length = 0x000800
   RFFT02          : origin = 0x008800, length = 0x000800
   RFFT03          : origin = 0x009000, length = 0x000800
   RFFT04          : origin = 0x009800, length = 0x000800
   RFFT05          : origin = 0x00A000, length = 0x000800


   RAMGS0           : origin = 0x00D000, length = 0x001000
   RAMGS1           : origin = 0x00E000, length = 0x001000
   RAMGS2           : origin = 0x00F000, length = 0x001000    //bss

  // RAMGS3           : origin = 0x010000, length = 0x001000
   //RAMGS4           : origin = 0x011000, length = 0x001000
  // RAMGS5           : origin = 0x012000, length = 0x001000

   RAMGS6           : origin = 0x0010000, length = 0x002000

  // RAMGS600           : origin = 0x0013000, length = 0x001800
  // RAMGS601           : origin = 0x0013800, length = 0x000800
  // RAMGS602           : origin = 0x0014000, length = 0x000400
 //  RAMGS603           : origin = 0x0014400, length = 0x000400
 //  RAMGS6           : origin = 0x013000, length = 0x002800



   RAMGS6_0         : origin = 0x012000, length = 0x00800
   //RAMGS7           : origin = 0x014000, length = 0x001000
  // RAMGS6_20         : origin = 0x016000, length = 0x0001F4
  // RAMGS6_21         : origin = 0x0161F4, length = 0x0001F4
  // RAMGS6_22         : origin = 0x0163E8, length = 0x0001F4
  // RAMGS6_23         : origin = 0x0165DC, length = 0x0001F4
  // RAMGS6_24         : origin = 0x0167D0, length = 0x0001F4
  // RAMGS6_25         : origin = 0x0169C4, length = 0x0001F4

   RAMGS6_1         : origin = 0x016800, length = 0x001800
   RAMGS8           : origin = 0x018000, length = 0x000400
   //RAMGS9           : origin = 0x016000, length = 0x001000
   RAMGS10          : origin = 0x019000, length = 0x002FF8
   //RAMGS11          : origin = 0x018000, length = 0x001000
   //RAMGS12          : origin = 0x019000, length = 0x003000
  // RAMGS13          : origin = 0x01A000, length = 0x001000
   //RAMGS14          : origin = 0x01B000, length = 0x002000
   //RAMGS15          : origin = 0x01C000, length = 0x000FF8
   //   RAMGS15_RSVD     : origin = 0x01CFF8, length = 0x000008     /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */


   /* Flash sectors */
   FLASH0           : origin = 0x080002, length = 0x001FFE  /* on-chip Flash */
   FLASH1           : origin = 0x082000, length = 0x002000  /* on-chip Flash */
   FLASH2           : origin = 0x084000, length = 0x002000  /* on-chip Flash */
   FLASH3           : origin = 0x086000, length = 0x002000  /* on-chip Flash */
   FLASH4           : origin = 0x088000, length = 0x008000  /* on-chip Flash */
   FLASH5           : origin = 0x090000, length = 0x008000  /* on-chip Flash */
   FLASH6           : origin = 0x098000, length = 0x008000  /* on-chip Flash */
   FLASH7           : origin = 0x0A0000, length = 0x008000  /* on-chip Flash */
   FLASH8           : origin = 0x0A8000, length = 0x008000  /* on-chip Flash */
   FLASH9           : origin = 0x0B0000, length = 0x008000  /* on-chip Flash */
   FLASH10          : origin = 0x0B8000, length = 0x002000  /* on-chip Flash */
   FLASH11          : origin = 0x0BA000, length = 0x002000  /* on-chip Flash */
   FLASH12          : origin = 0x0BC000, length = 0x002000  /* on-chip Flash */
   FLASH13          : origin = 0x0BE000, length = 0x001FF0  /* on-chip Flash */
//   FLASH13_RSVD     : origin = 0x0BFFF0, length = 0x000010  /* Reserve and do not use for code as per the errata advisory "Memory: Prefetching Beyond Valid Memory" */

   CPU1TOCPU2RAM   : origin = 0x03A000, length = 0x000800
   CPU2TOCPU1RAM   : origin = 0x03B000, length = 0x000800
   CPUTOCMRAM      : origin = 0x039000, length = 0x000800
   CMTOCPURAM      : origin = 0x038000, length = 0x000800

   CANA_MSG_RAM     : origin = 0x049000, length = 0x000800
   CANB_MSG_RAM     : origin = 0x04B000, length = 0x000800

   RESET            : origin = 0x3FFFC0, length = 0x000002
}

SECTIONS
{
   codestart           : > BEGIN, ALIGN(CODE_ALIGNMENT)
   .text               : >>FLASH3 | FLASH4, ALIGN(CODE_ALIGNMENT)
   .cinit              : > FLASH4 , ALIGN(CODE_ALIGNMENT)
   .switch             : > FLASH5, ALIGN(CODE_ALIGNMENT)
   .reset              : > RESET, TYPE = DSECT /* not used, */
   .stack              : > RAMD01

#if defined(__TI_EABI__)
   .init_array      : > FLASH5, ALIGN(CODE_ALIGNMENT)
   .bss             : >> RFFT01|RFFT02|RFFT03|RFFT04
   .bss:output      : > RFFT05
   .bss:cio         : > RFFT05
   .data            : > RFFT05
   .sysmem          : > RAMLS67
   /* Initalized sections go in Flash */
   .const           : > FLASH5, ALIGN(CODE_ALIGNMENT)
#else
   .pinit           : > FLASH5, ALIGN(CODE_ALIGNMENT)
   .ebss            : > RAMLS5
   .esysmem         : > RAMLS5
   .cio             : > RAMLS5
   /* Initalized sections go in Flash */
   .econst          : > FLASH5, ALIGN(CODE_ALIGNMENT)
#endif

   ramgs0 : > RAMGS0, type=NOINIT
   ramgs1 : > RAMGS1, type=NOINIT
   
   MSGRAM_CPU1_TO_CPU2 : > CPU1TOCPU2RAM, type=NOINIT
   MSGRAM_CPU2_TO_CPU1 : > CPU2TOCPU1RAM, type=NOINIT
   MSGRAM_CPU_TO_CM    : > CPUTOCMRAM, type=NOINIT
   MSGRAM_CM_TO_CPU    : > CMTOCPURAM, type=NOINIT

   /* The following section definition are for SDFM examples
   Filter_RegsFile  : > RAMGS0
   Filter1_RegsFile : > RAMGS1, fill=0x1111
   Filter2_RegsFile : > RAMGS2, fill=0x2222
   Filter3_RegsFile : > RAMGS3, fill=0x3333
   Filter4_RegsFile : > RAMGS4, fill=0x4444
   Difference_RegsFile : >RAMGS5, fill=0x3333
*/
   #if defined(__TI_EABI__)
       .TI.ramfunc : {} LOAD = FLASH6,
                        RUN = RAMGS10,
                        LOAD_START(RamfuncsLoadStart),
                        LOAD_SIZE(RamfuncsLoadSize),
                        LOAD_END(RamfuncsLoadEnd),
                        RUN_START(RamfuncsRunStart),
                        RUN_SIZE(RamfuncsRunSize),
                        RUN_END(RamfuncsRunEnd),
                        ALIGN(CODE_ALIGNMENT)
   #else
       .TI.ramfunc : {} LOAD = FLASH7,
                        RUN = RAMLS0 | RAMLS1 | RAMLS2 |RAMLS3,
                        LOAD_START(_RamfuncsLoadStart),
                        LOAD_SIZE(_RamfuncsLoadSize),
                        LOAD_END(_RamfuncsLoadEnd),
                        RUN_START(_RamfuncsRunStart),
                        RUN_SIZE(_RamfuncsRunSize),
                        RUN_END(_RamfuncsRunEnd),
                        ALIGN(CODE_ALIGNMENT)
   #endif

   RFFTdata1        : > RFFT01,ALIGN = RFFT_ALIGNMENT
   RFFTdata2        : > RFFT02
   RFFTdata3        : > RFFT03
   RFFTdata4        : > RFFT04
   RFFTdata5        : > RFFT05

   ecat_axe       : > RAMGS6_1,ALIGN = CODE_ALIGNMENT

   motor_speed     : > RFFT01,ALIGN = CODE_ALIGNMENT
   motor_pos       : > RFFT02,ALIGN = CODE_ALIGNMENT
  // motor_cur       : > RAMGS602,ALIGN = CODE_ALIGNMENT
  // motor_cmd       : > RAMGS603,ALIGN = CODE_ALIGNMENT

   //ecat_dic00       : > RAMGS6_20,ALIGN = CODE_ALIGNMENT
   //ecat_dic01       : > RAMGS6_21,ALIGN = CODE_ALIGNMENT
  // ecat_dic02       : > RAMGS6_22,ALIGN = CODE_ALIGNMENT
  // ecat_dic03       : > RAMGS6_23,ALIGN = CODE_ALIGNMENT
  // ecat_dic04       : > RAMGS6_24,ALIGN = CODE_ALIGNMENT
  // ecat_dic05       : > RAMGS6_25,ALIGN = CODE_ALIGNMENT


  // ecat_axe_1       : > RAMGS6_2
  // ecat_axe_2       : > RAMGS6_3
  // ecat_axe_3       : > RAMGS6_4
  // ecat_axe_4       : > RAMGS6_5
  // ecat_axe_5       : > RAMGS6_6

}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
