let $solution = {
    kit                  : {name: "HV_1PH_DCAC", type: "voltagesourceinvlcfltr", device: "F2837x"},
    cpuSysClock          : 200,
    PWMSysClkFreq		 : 100,
    eCAPSysClkFreq		 : 200,
	adcMaxRange			 : 3.3,
    pwmSwitchingFreq     : {min : 20, max : 200, default : 100},
    vInSenseMaxDefault  : 13.3,
    vOutSenseMaxDefault : 9.76,
    iLMaxSensedDefault   : 5.5,
    iLTripLevelDefault   : 4.0,

    /* Control Loop Design */
    KpV_1H : 0.75,
    KiV_1H : 2000.0,
    wrcV_1H : 0.00628,
    KiV_3H : 1000.0,
    wrcV_3H : 0.031415,
    KiV_5H : 1000.0,
    wrcV_5H : 0.031415,
    KiV_7H : 500.0,
    wrcV_7H : 0.031415,

    /* Power Stage Related Values*/
    Fsw : 20,
    PWMDeadband : 0.2,
    P_Rated: 600.0,
    Li : 3.0,
    Ri : 0.2,
    Cf : 20.0,
    Rcf : 0.015,
    Vin_SenseMax : 620.152,
    Vout_SenseMax : 620.152,
    Vin_SenseMax_ADC : 451.65,
    Vout_SenseMax_ADC : 450.15,
    Vin_SenseMax_SDFM : 620.152,
    Vout_SenseMax_SDFM : 620.152,
    I_TripLevel_ADC : 14.0,
    I_TripLevel_SDFM : 14.0,

    I_SenseMax : 15.6,
    I_SenseMax_ADC : 16.968,
    I_SenseMax_SDFM : 15.6,

    /* ADC Sensing Parameters */
    Ra : 3.0,
    Rb : 11.0,
    Rc : 3.001,
    Rd : 11.0,
    Re : 500.0,
    Rf : 330.0,
    ADCSense_Fltr_Cuttoff : 10.644,
    Cfltr : 0.22,
    Rfltr : 68.0,
    Vref : 1.65,
    IsenseNominalOutput : 0.625,
    IsenseNominalRange : 3.0,
    IsenseOffsetOutput : 2.5,

    /* SDFM Sensing Parameters*/
    Rg : 4.0,
    Rh : 2.4,
    Rsh : 0.02,
    sdfmLinearRange : 0.25,
    sdfmMaxRange : 0.312,
    Rdiff : 12.5,
    SDFM_OSR : 128,
    sdfmFltrOrder : 3,
    sdfmCLKFreq : 20.0

};

exports = {
    $solution: $solution
};