//#############################################################################
// FILE:            voltagesourceinvlcfltr.h
//
// System Name:     TIDM_HV_1PH_DCAC R3
//
// Description:
//
//#############################################################################
// $TI Release: HV_1PH_DCAC v3.00.04.00 $
// $Release Date: Thu Jan 26 15:57:53 CST 2023 $
// $Copyright:
// Copyright (C) 2023 Texas Instruments Incorporated - http://www.ti.com/
//
// ALL RIGHTS RESERVED
// $
//#############################################################################

#ifndef VOLTAGE_SOURCE_INV_LC_FLTR_H
#define VOLTAGE_SOURCE_INV_LC_FLTR_H

#ifdef __cplusplus

extern "C" {
#endif

//*****************************************************************************
// the includes
//*****************************************************************************

#include "hv1phdcac_board.h"
//
// this is the file generated by the powerSUITE page for this system
//
#include "voltagesourceinvlcfltr_settings.h"

//
// Library header files
//
#include "dlog_4ch.h"
#include "emavg.h"
#include "rampgen.h"
#include "spll_1ph_sogi.h"
#include "DCLF32.h"

#ifndef __TMS320C28XX_CLA__
#include "power_meas_sine_analyzer.h"
#endif

#include "sfra_f32.h"
#include "sfra_gui_scicomms_driverlib.h"

//*****************************************************************************
// System Settings
//*****************************************************************************

// Add any system specific setting below
#if SFRA_TYPE == 1 // voltage loop
#define SFRA_FREQ_START 10
#define SFRA_FREQ_LENGTH 100
//
// SFRA step Multiply = 10^(1/No of steps per decade(40))
#define FREQ_STEP_MULTIPLY (float32_t)1.045
#define SFRA_AMPLITUDE (float32_t)0.002
#elif SFRA_TYPE == 2 // current loop
#define SFRA_FREQ_START 100
#define SFRA_FREQ_LENGTH 100
//
// SFRA step Multiply = 10^(1/No of steps per decade(40))
#define FREQ_STEP_MULTIPLY (float32_t)1.045
#define SFRA_AMPLITUDE (float32_t)0.01
#endif

#define UNIVERSAL_GRID_MAX_VRMS 240
#define UNIVERSAL_GRID_MIN_VRMS 80
#define UNIVERSAL_GRID_MAX_FREQ 65
#define UNIVERSAL_GRID_MIN_FREQ 45

#define newPWM 1

//*****************************************************************************
//globals
//*****************************************************************************

extern int16_t i;

//
// TODO Inverter Control Variables
// Inverter Variables
// NOTE: Io & Ig are used interchangeably,
// NOTE: Vo and Vg are used Interchangeably
//
// Measurement Variables
// Inverter Side Inductor Current Measurement
//
extern float32_t invIiInst;

//
// Output Voltage measurement
//
extern float32_t invVoInst;

//
// Inverter Side Inductor Current Measurement Offset
//
extern volatile float32_t invIiOffset;

//
// Cap Current SD measurement
//
extern volatile float32_t invIfInst;

//
// Cap Current SD measurement offset
//
extern volatile float32_t invIfSDOffset;

//
// Output current measurement
//
extern float32_t invIoInst;

//
// Output current measurement
//
extern volatile float32_t invIoSDOffset;

//
// Output Voltage measurement Offset
// Vo Offset May not be applicable in real application as Vo may be present 
// always
//
extern volatile float32_t invVoOffset, invVoSDOffset;

//
// Inv DC Bus Voltage Measurement
//
extern volatile float32_t invVbusInst;

//
// Inv DC Bus Voltage Measurement Offset
//
extern volatile float32_t invVbusOffset, invVbusSDOffset;

//
// Inv Filtered DC bus measurement
//
extern volatile float32_t invVbusAvg;

//
// Inv DC Bus measurement by SD Offset
//

//
// Reference variables
// Inverter modulation index, used for open loop check
//
extern volatile float32_t invModIndex;

//
// Peak value of the Ii/ Io current set point
//
extern volatile float32_t invIiRef, invIoRef;

//
// Peak value of the Vo  set point
//
extern volatile float32_t invVoRef;

//
// Instantaneous Ii, Io reference = invIiRef* Angle
//
extern float32_t invIiRefInst, invIoRefInst;

//
// Instantaneous Vo reference = invVoRef* Angle
//
extern volatile float32_t invVoRefInst;

//
// DC bus reference
//
extern volatile float32_t invVbusRef;

//
// Voltage Error
//
extern volatile float32_t voltage_error;

//
// Display Values
//
extern float32_t guiVbus;
extern float32_t guiACFreq;
extern float32_t guiPrms;
extern float32_t guiIrms;
extern volatile float32_t guiVrms;
extern float32_t guiVavg;
extern float32_t guiVo;
extern float32_t guiIi;
extern float32_t guiIo;
extern float32_t guiPowerFactor;
extern float32_t guiVA;
extern float32_t guiFreqAvg;
extern float32_t guiVema;

// Variables used to calibrate measurement offsets
//Offset filter coefficient K1: 0.05/(T+0.05);
extern float32_t k1;
//Offset filter coefficient K2: T/(T+0.05)
extern float32_t k2;
extern int16_t offsetCalCounter;
extern float32_t offset165;

//
// Duty variables for inverter (per unit and compare register values)
// per unit duty value
extern float32_t invDutyPU, invDutyPUPrev;
//
// duty value written into the PWM register
extern int16_t invDuty, invDutyCompl;
// PWM TBPRD Half
extern volatile float32_t halfPWMPeriod;

//
// Flags for clearing trips and closing the loops and the Relay
extern int16_t closeILoopInv, closeVLoopInv, clearInvTrip, rlyConnect;

//
// Flags for detecting ZCD
extern float32_t invSine, invSinePrev;
extern int16_t zeroCrossDetectFlag;

extern volatile int16_t tempChange;
extern volatile int16_t period;

//
// Sine analyzer block for RMS Volt, Curr and Power measurements
extern POWER_MEAS_SINE_ANALYZER sine_mains;

//
// datalogger
extern DLOG_4CH dLog1;
extern float32_t dBuff1[200], dBuff2[200], dBuff3[200], dBuff4[200];
extern float32_t dVal1, dVal2, dVal3, dVal4;

//
// extern to access tables in ROM
extern long FPUsinTable[];

extern SFRA_F32 sfra1;

enum enum_boardStatus {
    boardStatus_Idle = 0,
    boardStatus_NoFault = 1,
    boardStatus_OverCurrentTrip = 2,
    boardStatus_EmulatorStopTrip = 3,
};
extern enum enum_boardStatus boardStatus;

//
// Function prototypes
//

//
// State Machine function prototypes
//------------------------------------
// Alpha states
//
void A0(void);  //state A0
void B0(void);  //state B0
void C0(void);  //state C0

//
// A branch states
//
void A1(void);  //state A1

//
// B branch states
//
void B1(void);  //state B1
void B2(void);  // state B2

//
// C branch states
//
void C1(void);  //state C1

#ifdef _FLASH
#pragma CODE_SECTION(inverterISR, ".TI.ramfunc");
#endif
#pragma INTERRUPT (inverterISR, HPI)
interrupt void inverterISR(void);
static inline void clearInterrupt(void);
static inline void setupInterrupt(void);
void setupSFRA();

void computeDF22_PRcontrollerCoeff(DCL_DF22 *v, float32_t kp, float32_t ki,
                                   float32_t wo, float32_t fs, float32_t wrc);
void computeDF22_PIcontrollerCoeff(DCL_DF22 *v, float32_t gain, float32_t z0,
                                   float32_t fsw);
static inline void detectZeroCrossingClearPWMTrip(uint32_t base1,
                                                  uint32_t base2);

void initGlobalVariables(void);

//TODO detectZeroCrossingClearPWMTrip()
static inline void detectZeroCrossingClearPWMTrip(uint32_t base1,
                                                  uint32_t base2)
{
    if((invSinePrev <= (float32_t)(0.00)) && (invSine > (float32_t)(0.00)))
    {
        zeroCrossDetectFlag = 1;
    }
    else
    {
        zeroCrossDetectFlag = 0;
    }
    if(clearInvTrip == 1 && zeroCrossDetectFlag == 1)
    {
        //
        // clear all the configured trip sources for the PWM module
        EALLOW;
        EPWM_clearTripZoneFlag(base1, EPWM_TZ_FLAG_OST);
        EPWM_clearTripZoneFlag(base2, EPWM_TZ_FLAG_OST);
        EPWM_clearTripZoneFlag(base1, EPWM_TZ_FLAG_CBC);
        EPWM_clearTripZoneFlag(base2, EPWM_TZ_FLAG_CBC);
        EPWM_clearTripZoneFlag(base1, EPWM_TZ_FLAG_DCAEVT1);
        EPWM_clearTripZoneFlag(base2, EPWM_TZ_FLAG_DCAEVT1);
        EDIS;

        clearInvTrip = 0;
        closeILoopInv = 1;
    }

    if(invSinePrev < -0.95f && invSine > -0.95f)
    {
        if(rlyConnect == 1)
        {
            closeRelay();
        }
    }

    if(rlyConnect == 0)
    {
        openRelay();
        invVoRef = 0;
        invIiRef = 0;
    }

    invSinePrev = invSine;
}

#ifdef __cplusplus
}
#endif                                  /* extern "C" */


#endif
