//#############################################################################
//
// FILE:   voltagesourceinvlcfltr_user_settings.h
//
// TITLE:  voltagesourceinvlcfltr User Settings
//
//#############################################################################
// $TI Release: HV_1PH_DCAC v3.00.04.00 $
// $Release Date: Thu Jan 26 15:57:53 CST 2023 $
// $Copyright:
// Copyright (C) 2023 Texas Instruments Incorporated - http://www.ti.com/
//
// ALL RIGHTS RESERVED
// $
//#############################################################################

//
// Defines
//

#define GI_A1 -1.0000000000
#define GI_A2 0.0000000000
#define GI_A3 0.0000000000
#define GI_B0 0.5467500000
#define GI_B1 -0.4252500000
#define GI_B2 0.0000000000
#define GI_B3 0.0000000000
#define GI_MAX 1.0
#define GI_MIN -1.0

#define GI_PI_KP 0.731676332386102
#define GI_PI_KI 0.159424775771266

#define GV_LEAD_LAG_A1 -0.8789881828
#define GV_LEAD_LAG_A2 0.0000000000
#define GV_LEAD_LAG_B0 4.3590034523
#define GV_LEAD_LAG_B1 -4.2308212342
#define GV_LEAD_LAG_B2 0.0000000000
#define GV_LEAD_LAG_IMIN -1.0
#define GV_LEAD_LAG_MAX 1.0
#define GV_LEAD_LAG_MIN -1.0

#define INV_PWM1_BASE               EPWM1_BASE

#define INV_PWM1_H_GPIO             0
#define INV_PWM1_H_GPIO_PIN_CONFIG  GPIO_0_EPWM1A

#define INV_PWM1_L_GPIO             1
#define INV_PWM1_L_GPIO_PIN_CONFIG  GPIO_1_EPWM1B

#define INV_PWM2_BASE               EPWM2_BASE

#define INV_PWM2_H_GPIO             2
#define INV_PWM2_H_GPIO_PIN_CONFIG  GPIO_2_EPWM2A

#define INV_PWM2_L_GPIO             3
#define INV_PWM2_L_GPIO_PIN_CONFIG  GPIO_3_EPWM2B

#define ADC_SOC_TRIG             ADC_TRIGGER_EPWM1_SOCA

#define II_ADC_BASE              ADCA_BASE
#define II_ADCRESULT_BASE        ADCARESULT_BASE
#define II_ADC_PIN               ADC_CH_ADCIN2
#define II_ADC_TRIG_SOURCE       ADC_SOC_TRIG

#define II_1_ADC_SOC_NO          ADC_SOC_NUMBER0
#define II_2_ADC_SOC_NO          ADC_SOC_NUMBER1
#define II_3_ADC_SOC_NO          ADC_SOC_NUMBER2
#define II_4_ADC_SOC_NO          ADC_SOC_NUMBER3

#define VO_ADC_BASE              ADCA_BASE
#define VO_ADCRESULT_BASE        ADCARESULT_BASE
#define VO_ADC_SOC_NO            ADC_SOC_NUMBER4
#define VO_ADC_PIN               ADC_CH_ADCIN14
#define VO_ADC_TRIG_SOURCE       ADC_SOC_TRIG

#define VBUS_ADC_BASE            ADCA_BASE
#define VBUS_ADCRESULT_BASE      ADCARESULT_BASE
#define VBUS_ADC_SOC_NO          ADC_SOC_NUMBER5
#define VBUS_ADC_PIN             ADC_CH_ADCIN5
#define VBUS_ADC_TRIG_SOURCE     ADC_SOC_TRIG

#define IREF_ADC_BASE            ADCA_BASE
#define IREF_ADCRESULT_BASE      ADCARESULT_BASE
#define IREF_ADC_SOC_NO          ADC_SOC_NUMBER6
#define IREF_ADC_PIN             ADC_CH_ADCIN3
#define IREF_ADC_TRIG_SOURCE     ADC_SOC_TRIG

#define II_SENSE_CMPSS_BASE             CMPSS1_BASE
#define II_SENSE_XBAR_MUX               XBAR_MUX00
#define II_SENSE_XBAR_MUX_VAL           XBAR_EPWM_MUX00_CMPSS1_CTRIPH_OR_L

#define IO_SDFM_SENSE_XBAR_MUX_VAL      XBAR_EPWM_MUX18_SD1FLT2_COMPH_OR_COMPL
#define IO_SDFM_SENSE_XBAR_MUX          XBAR_MUX18

#define VBUS_SDFM_FILTER                SDFM_FILTER_4
#define VBUS_SDFM_BASE                  SDFM1_BASE
#define GPIO_VBUS_SDFM_DATA             54
#define GPIO_VBUS_SDFM_DATA_PIN_CONFIG  GPIO_54_SD1_D4
#define GPIO_VBUS_SDFM_CLOCK            55
#define GPIO_VBUS_SDFM_CLOCK_PIN_CONFIG GPIO_55_SD1_C4

#define VO_SDFM_FILTER                  SDFM_FILTER_3
#define VO_SDFM_BASE                    SDFM1_BASE
#define GPIO_VO_SDFM_DATA               52
#define GPIO_VO_SDFM_DATA_PIN_CONFIG    GPIO_52_SD1_D3
#define GPIO_VO_SDFM_CLOCK              53
#define GPIO_VO_SDFM_CLOCK_PIN_CONFIG   GPIO_53_SD1_C3

#define IO_SDFM_FILTER                  SDFM_FILTER_2
#define IO_SDFM_BASE                    SDFM1_BASE
#define GPIO_IO_SDFM_DATA               50
#define GPIO_IO_SDFM_DATA_PIN_CONFIG    GPIO_50_SD1_D2
#define GPIO_IO_SDFM_CLOCK              51
#define GPIO_IO_SDFM_CLOCK_PIN_CONFIG   GPIO_51_SD1_C2

#define IF_SDFM_FILTER                  SDFM_FILTER_1
#define IF_SDFM_BASE                    SDFM1_BASE
#define GPIO_IF_SDFM_DATA               48
#define GPIO_IF_SDFM_DATA_PIN_CONFIG    GPIO_48_SD1_D1
#define GPIO_IF_SDFM_CLOCK              49
#define GPIO_IF_SDFM_CLOCK_PIN_CONFIG   GPIO_49_SD1_C1

#define SDFM_CLK_ECAP1_BASE             ECAP1_BASE
#define GPIO_XBAR1                      4
#define GPIO_XBAR1_PIN_CONFIG           GPIO_4_OUTPUTXBAR3

#define GPIO_XBAR2                      6
#define GPIO_XBAR2_PIN_CONFIG           GPIO_6_OUTPUTXBAR4

#if SENSING_OPTION==ADC_BASED_SENSING
    #define INV_ISR_TRIG_PWM_BASE       EPWM1_BASE
    #define INV_ISR                     INT_EPWM1
#else
    #define INV_ISR_TRIG_PWM_BASE       EPWM11_BASE
    #define INV_ISR                     INT_EPWM11
#endif

#define ONE_KHZ_ISR_TRIG_CPUTIMER_BASE  CPUTIMER2_BASE
#define ONE_KHZ_CPUTIMER_ISR            INT_TIMER2
#define INV_ISR_PIE_GROUP_NO            INTERRUPT_ACK_GROUP3

#define GPIO_RELAY                  5
#define GPIO_RELAY_PIN_CONFIG       GPIO_5_GPIO5

#define GPIO_PROFILING1             40
#define GPIO_PROFILING1_SET         GPIO_GPASET_GPIO40
#define GPIO_PROFILING1_CLEAR       GPIO_GPACLEAR_GPIO40
#define GPIO_PROFILING1_PIN_CONFIG  GPIO_40_GPIO40

#define GPIO_PROFILING2             41
#define GPIO_PROFILING2_SET         GPIO_GPASET_GPIO41
#define GPIO_PROFILING2_CLEAR       GPIO_GPACLEAR_GPIO41
#define GPIO_PROFILING2_PIN_CONFIG  GPIO_41_GPIO41

#define GPIO_LED1                   31
#define GPIO_LED1_SET               GPIO_GPASET_GPIO31
#define GPIO_LED1_CLEAR             GPIO_GPACLEAR_GPIO31
#define GPIO_LED1_PIN_CONFIG        GPIO_31_GPIO31

#define GPIO_LED2                   34
#define GPIO_LED2_SET               GPIO_GPASET_GPIO34
#define GPIO_LED2_CLEAR             GPIO_GPACLEAR_GPIO34
#define GPIO_LED2_PIN_CONFIG        GPIO_34_GPIO34

//
// SFRA related
//
#define SFRA_GUI_SCI_BASE               SCIA_BASE
#define SFRA_GUI_SCIRX_GPIO             28
#define SFRA_GUI_SCIRX_GPIO_PIN_CONFIG  GPIO_28_SCIRXDA
#define SFRA_GUI_SCITX_GPIO             29
#define SFRA_GUI_SCITX_GPIO_PIN_CONFIG  GPIO_29_SCITXDA
#define SCI_VBUS_CLK 50000000
#define SFRA_GUI_SCI_BAUDRATE 57600
// if the following #define is set to 1 SFRA GUI indicates status on an LED
// otherwise LED code is ignored
#define SFRA_GUI_LED_INDICATOR 1
#define SFRA_GUI_LED_GPIO 31
#define SFRA_GUI_LED_GPIO_PIN_CONFIG GPIO_31_GPIO31

//
// End of File
//
