/****************************************************************/
/* File:        main.c                                          */
/****************************************************************/
/* Author:     Data Converter Plug-In Development Team          */
/*             <dcp-support@list.ti.com>                        */
/*                                                              */
/* Created:    2006  By Texas Instruments Deutschland GmbH     */
/*                                                              */
/* Version:    1.0  /  January 2007                             */
/****************************************************************/
/* Description: Demo program for the ADS1256 connected to a     */
/*              C5509A DSK                                      */
/*                                                              */
/*              The program samples BUFFER_SIZE values and      */
/*              places the values into the r_buffer1 and        */
/*              r_buffer2 arrays.                               */
/*              The variable Ads1626_1.xferInProgress can be    */
/*              used to track the progress of the transfer (it  */
/*              will be 1 while a transfer is in progress).     */
/*                                                              */
/*              The H/W interface between the ASD1256 and the   */
/*              DSP is defined using the Data Converter Support */
/*              tool in Code Composer Studio, which creates the */
/*              software driver for the low level data transfer */
/*                                                              */
/*              The following settings are made in the DSP/BIOS */
/*              configuration tool:                             */
/*              - Mapping of the interrupt for the DMA          */
/*                transfer complete interrupt to:               */
/*                    _ADS1256_rblockFinished()                 */
/*                                                              */
/*              The data read can be viewed by setting a probe- */
/*              point at the dc_readblock(); line in the main   */
/*              routine and connecting it to a graph window     */
/*              with r_buffer1 as the start address, a length of*/
/*              BUFFER_SIZE (for both read and display size) and*/
/*              a data size of 32 bit signed integer            */
/****************************************************************/
/* Jumper settings for the 5-6K Interface Board (Rev B):        */
/*              W1: open         W4: 2-3                        */
/*              W2: 2-3          W5: 2-3                        */
/*              W3: 2-3          W6: 1-2                        */
/*              W7: 2-3          W8: 1-2                        */
/*              All others: don't care                          */
/*              J13: INTb        J14: don't care                */
/*                                                              */
/* Power connections on the 5-6K Interface Board:               */
/*              J2: +5V                                         */
/*                                                              */
/* Settings for the ADS1256 EVM Rev. B                          */
/*              J4: 1-2:   Closed                               */
/*                  3-4:   Closed                               */
/*                  5-6:   Open                                 */
/*                  7-8:   Closed                               */
/*                  9-10:  Closed                               */
/*                  11-12: Closed                               */
/*                                                              */
/*              S1: Ext (left)                                  */
/*              S2: Ext (left)                                  */
/*              S3: OBH (middle)                                */
/*                                                              */
/*              Make the following connections:                 */
/*              J3 pin 9 (+3.3V) to J2 pin 19 (SYNC\ / PWDWN\)  */
/*              J3 pin 9 (+3.3V) to J2 pin 14 (RESET)           */
/*                                                              */
/* Analog signal connections on the ADS1256 EVM:                */
/*              Apply signal to J1 pin 1 and 2                  */
/*              Analog signal settings:                         */
/*               - Frequency: 100Hz                             */
/*               - Amplitude: 4.5Vpp                            */
/*               - Offset:    0V                                */
/*                                                              */
/* All the H/W settings above translate to the following        */
/* settings in the data converter support tool:                 */
/*              DSP Tab:     DSP-Type:           TMS320C5510PG2X*/
/*                           DSP Clock:          200 MHz        */
/*              ADS1256 Tab: Clock Source:       Generator      */
/*                           Input Clock:        7.68 MHz       */
/*                           Data Rate:          30000.000 SPS  */
/*                           CLOCKOUT:           7.68 MHz       */
/*                           Serial Port:        McBSP1         */
/*                           Interrupt:          Ext Int 1      */
/*                           DMA Channel:        Channel 2      */
/*                           Positive Channel:   AIN0           */
/*                           Negative Channel:   AIN1           */
/*                           D1 Direction:       Input          */
/*                           D2 Direction:       Input          */
/*                           D3 Direction:       Input          */
/*                           Programmable Gain Amplifier: 1     */
/*                           Sensor Detect Current Source: Off  */
/*                           Buffer Enable:      Unchecked      */
/*                           Auto-Calibration on: Unchecked     */
/****************************************************************/
/* include files for the data converter plug-in                 */
#include "dc_conf.h"
#include "t1256_fn.h"

/* include files for the chip support library                   */
#include <csl.h>
#include <csl_irq.h>

/* miscellaneous include files                                  */
#include <stdlib.h>

/* define the size of the buffer                                */
#define BUFFER_SIZE     (1024)

/* define the buffers to use                                    */
long r_buffer1[BUFFER_SIZE];
long r_buffer2[BUFFER_SIZE];
volatile int iAdsBusy = 0;

/****************************************************************/
/* callback(): Will be called at the end of the transfer and    */
/*             will reset the semaphore for the transfer        */
/****************************************************************/
void callback(void *pDC)
{
   TADS1256 *pADS = pDC;
   volatile unsigned long ulAddress;
   volatile unsigned int uiLength;

   ulAddress = ADS1256_getFinishedBufferAddress(pADS);
   uiLength = ADS1256_getFinishedBufferSize(pADS);

   iAdsBusy--;          /* reset semaphore for transfer        */
}

/****************************************************************/
/* callback(): Will be called at the end of the transfer and    */
/*             will reset the semaphore for the transfer        */
/****************************************************************/
void main(void)
{
    TTIDCSTATUS iStatus;
    long longvalue = 0;
    int value = 0;
    volatile unsigned int i;
    
    /* make the McBSP1 available to the daughterboard connector */
  //  *((unsigned char*)0x300006) |= 0x03;
    
    for (i = 0; i < BUFFER_SIZE; i++)
	 {
	     r_buffer1[i] = 0;
		 r_buffer2[i] = 0;
	 }

    iStatus = dc_configure(&Ads1256_1);

    if (iStatus != TIDC_NO_ERR)
	     abort();
       
    iStatus = dc_readsample(&Ads1256_1, &longvalue);
    if (iStatus != TIDC_NO_ERR)
	     abort();

    value = ADS1256_REG_STATUS;
    iStatus = dc_control(&Ads1256_1, ADS1256_CMD_RREG, &value);
    if (iStatus != TIDC_NO_ERR)
        abort();
        
    IRQ_globalEnable();

    while(1)
    {
        while(iAdsBusy > 0);     /*transfer in progress?        */
        dc_readblock(&Ads1256_1, r_buffer1, BUFFER_SIZE, callback);
        iAdsBusy++;
        dc_readblock(&Ads1256_1, r_buffer2, BUFFER_SIZE, callback);
		iAdsBusy++;
    }
}
