/*{{TIDC_Wizard Auto Code Start                                 */
/****************************************************************/
/* don't change anything here until you know what you are doing!*/
/* the plug-in will change all text between the code marks      */
/* without user interaction!                                    */
/*                                                              */
/****************************************************************/

/****************************************************************/
/* software generated by Data Converter Plug-in (DCP)           */
/* based on <C:\CCSTUD~1.1\PLUGINS\AAP_DEV\c5500\d1256_55.c> */
/****************************************************************/
/****************************************************************/

/* ADS1256 Interface Software Version 1.0 for the TMS320C5500   */

/* Copyright (C) 2007 Texas Instruments Incorporated            */

/* All Rights Reserved                                          */

/*--------------------------------------------------------------*/

/** \file

 * This interface software needs one interrupt to be mapped in

 * either the DSP/BIOS configuration file or the interrupt

 * vector table:

 *    - Interrupt of the used DMA channel:

 *       -  _ADS1256_rblockFinished

 *

 * This interface software uses two peripherals:

 *     - Two DMA channels for the data transfer

 *     - One McBSP for the data transfer

 *     - One timer to create the timebase for the Wait() function

 *

 * Restrictions:

 *    - This software only supports the TMS320C5507, C5509A and

 *      C5510.

 *    - It is only possible to submit two buffers at a time. If

 *      a third buffer needs to be submitted, the application has

 *      to wait until the iXferInProgress member of the data

 *      converter structure is less than two.                   */

/*--------------------------------------------------------------*/

/* $Revision: 2 $                        $JustDate:  1/26/07 $ */

/* $Author: A0746714 $                                          */

/****************************************************************/

#undef _INLINE



/* include the interface files for the data converter software  */

#include "dc_conf.h"

#include "t1256_fn.h"



/* include the interface files for the chip support library     */

#include <csl.h>

#include <csl_irq.h>

#include <csl_timer.h>

#include <string.h>



#if (CHIP_5501 | CHIP_5502)

#error This software does not support the C5501 and C5502 DSP!

#endif



/****************************************************************/

/* define and initialize data converter object(s)               */

/****************************************************************/

TADS1256 Ads1256_1 = {
    &ADS1256_configure,
    &ADS1256_control,
    &ADS1256_readsample,
    &ADS1256_writesample,
    &ADS1256_readblock,
    &ADS1256_writeblock,
    &ADS1256_close,
    0, 0, 3,            /* reserved                              */
    &serial3,                           /* used McBSP port          */
    ADC1_REG_STATUS,                    /* content of STATUS reg    */
    ADC1_REG_MUX,                       /* content of MUX reg       */
    ADC1_REG_ADCON,                     /* content of ADCON reg     */
    ADC1_REG_DRATE,                     /* content of DRATE reg     */
    ADC1_REG_IO,                        /* content of IO reg        */
    ADC1_REG_OFC0,                      /* content of OFC0 reg      */
    ADC1_REG_OFC1,                      /* content of OFC1 reg      */
    ADC1_REG_OFC2,                      /* content of OFC2 reg      */
    ADC1_REG_FSC0,                      /* content of FSC0 reg      */
    ADC1_REG_FSC1,                      /* content of FSC1 reg      */
    ADC1_REG_FSC2,                      /* content of FSC2 reg      */
    ADC1_REG_STATUS,                    /* content of STATUS reg    */
    ADC1_REG_MUX,                       /* content of MUX reg       */
    ADC1_REG_ADCON,                     /* content of ADCON reg     */
    ADC1_REG_DRATE,                     /* content of DRATE reg     */
    ADC1_REG_IO,                        /* content of IO reg        */
    ADC1_REG_OFC0,                      /* content of OFC0 reg      */
    ADC1_REG_OFC1,                      /* content of OFC1 reg      */
    ADC1_REG_OFC2,                      /* content of OFC2 reg      */
    ADC1_REG_FSC0,                      /* content of FSC0 reg      */
    ADC1_REG_FSC1,                      /* content of FSC1 reg      */
    ADC1_REG_FSC2,                      /* content of FSC2 reg      */
    0, 0, 0, 0,                         /* transfer buffer struct 0 */
    0, 0, 0, 0,                         /* transfer buffer struct 1 */
    0, 0,                               /* DMA handles              */
    ADC1_DMACHAN,                       /* Used DMA channel         */
    ADC1_INTNUM,                        /* DSP int used by DRDY#    */
    ADC1_SERDIV,                        /* Divider for McBSP clock  */
    0,                                  /* Transfer-On-Progress var */
    0, 0,                               /* RcvCCR, XmtCCR reg. value*/
    0,                                  /* object index var         */
    ADC1_TIMDIV                         /* Divider for Timer clock  */
};


/****************************************************************/

/* define and initialize the serial port object                 */

/****************************************************************/

DCP_SERIAL serial3 =

{

    0,                                /* McBSP handle            */

    ADC1_SERPORT,                    /* serial port number      */

    0                               /* INT used by serial port */

};



/****************************************************************/

/* DSP function prototypes                                      */

/****************************************************************/

static TTIDCSTATUS InitDevice(TADS1256 *pADS);

static TTIDCSTATUS InitRcvDma(DCP_SERIAL *pSerial,

                              int iChanNum,

                              DMA_Handle *hDma,

                              unsigned int *pCcr);

static TTIDCSTATUS InitXmtDma(MCBSP_Handle hMcbsp,

                              unsigned int uiIrq,

                              DMA_Handle *hDma,

                              unsigned int *pCcr);

static TTIDCSTATUS InitMcbsp(DCP_SERIAL *serial,

                             unsigned int clkdiv);

static unsigned int ReadRegister(TADS1256 *pADS,

                                 unsigned int uiRegister);

static inline TTIDCSTATUS SendCommand(MCBSP_Handle hMcbsp,

                                      unsigned long ulCmdValue);

static TTIDCSTATUS SetWordLength(MCBSP_Handle hMcbsp,

                                 unsigned int uiLength);

static TTIDCSTATUS SubmitBlock(DMA_Handle hDmaIn,

                               DMA_Handle hDmaOut,

                               unsigned int uiCcrIn,

                               unsigned int uiCcrOut,

                               unsigned int uiCnt,

                               unsigned long ulDst,

                               int iIndex);

static TTIDCSTATUS SubmitDummyXfer(DMA_Handle hDma);

static TTIDCSTATUS Wait(TADS1256 *pADS, unsigned int uiWaitCount);

static TTIDCSTATUS WaitDrdy(TADS1256 *pADS);

static TTIDCSTATUS WriteRegister(TADS1256 *pADS,

                                 unsigned int uiRegister,

                                 unsigned int *uiValue);



/****************************************************************/

/* some usefull defines                                         */

/****************************************************************/

#define ADS1256_MAX_XFERS (2)



/****************************************************************/

/* global variables                                             */

/****************************************************************/

/* define a global pointer to the data converter object in use  */

static TADS1256 *pgADS;

static unsigned long ulDummy = 0;   /* needed for the DMA xfer  */



/****************************************************************/

/* definitions used by the code                                 */

/****************************************************************/

#define ADS1256_WORDLENGTH_8BIT   (0x0000u)

#define ADS1256_WORDLENGTH_16BIT  (0x0002u)

#define ADS1256_WORDLENGTH_24BIT  (0x0004u)



/****************************************************************/

/* ADS1256_configure()                                          */

/**

 * Operation:     The following operations are performed:

 *     - Open, configure and start the McBSP the converter is

 *       connected to; return on error

 *     - Open and pre-configure the DMA channels used for the data

 *       transfer; return on error.

 *     - Initialize the registers of he ADS1256 to the values

 *       given in dc_conf.h

 *

 * Parameters:

 *     - void* pDC: Data converter object

 *

 * Return values: Status code of type TTIDCSTATUS

 *     - TIDC_NO_ERR: Call was successful

 *     - TIDC_ERR_NODEVICE: No object was passed to the function

 *     - TIDC_ERR_MCBSP: The McBSP could not be opened

 *     - TIDC_ERR_DMA: The DMA channel could not be opened

 *     - TIDC_ERR_XFERPROG: ADS1256_configure was called during an

 *       ongoing transfer

 *     - TIDC_ERR_BADARGS: An invalid argument was passed to the

 *       function

 *     - TIDC_ERR_REGS: The initialization of the registers failed

 *

 * Globals modified:

 *     - Serial port object in the data converter object

 *     - DMA handles in the data converter object

 *

 * Resources used:

 *     - One McBSP

 *     - Two DMA channels

*/

/****************************************************************/

TTIDCSTATUS ADS1256_configure(void *pDC)

{

    TADS1256 *pADS = (TADS1256 *)pDC;

    TTIDCSTATUS iStatus = TIDC_NO_ERR;



    /* return, if no device object available                    */

    if (pADS == 0)

        return TIDC_ERR_NODEVICE;



    /* be sure no block transfer is in progress                 */

    if (pADS->iXferInProgress != 0)

        return TIDC_ERR_XFERPROG;



    /* open & configure the McBSP needed for the data transfer  */

    iStatus = InitMcbsp(pADS->serial, pADS->uiMcbspPeriod);



    if (iStatus != TIDC_NO_ERR)

        return iStatus;



    /* wait for the serial port to be ready.                    */

    (void)Wait(pADS, 64000);



    /* open the DMA channel for the transmit and receive side   */

    /* and do a basic configuration for them                    */

    iStatus = InitXmtDma(pADS->serial->hMcbsp,

                         pADS->uiDrdyIntNum,

                         &(pADS->hDmaXmt),

                         &(pADS->uiXmtCcrValue));

    if (iStatus != TIDC_NO_ERR)

    {

        (void)ADS1256_close(pADS);

        return iStatus;

    }



    iStatus = InitRcvDma(pADS->serial,

                         pADS->iDmaChanNumber,

                         &(pADS->hDmaRcv),

                         &(pADS->uiRcvCcrValue));

    if (iStatus != TIDC_NO_ERR)

    {

        (void)ADS1256_close(pADS);

        return iStatus;

    }



    /* configure the registers of the device                    */

    iStatus = InitDevice(pADS);

    if (iStatus != TIDC_NO_ERR)

    {

        (void) ADS1256_close(pADS);

        return iStatus;

    }



    return TIDC_NO_ERR;

}





/****************************************************************/

/* ADS1256_control()                                            */

/** Operation:

 *     - Translates the command macros to the proper commands for

 *       the ADS1256.

 *     - Sets the word-length of the McBSP before sending the

 *       command.

 *

 * Parameters:

 *     - void* pDC: Data converter object

 *     - int iCmd:  Action to be performed. Valid are:

 *           - ADS1256_CMD_WAKEUP:

 *                 Sends the wakeup command to the ADS1256, which

 *                 completes the synchronization and exits the

 *                 standby mode.

 *           - ADS1256_CMD_RDATAC:

 *                 Send the read data continuously command, which

 *                 is needed for the ADS1256_readblock() function.

 *           - ADS1256_CMD_SELFCAL:

 *                 Sends the self-calibration command of the

 *                 ADS1256.

 *           - ADS1256_CMD_SELFOCAL:

 *                 Sends the offset self-calibration command of

 *                 the ADS1256.

 *           - ADS1256_CMD_SELFGCAL:

 *                 Sends the gain self-calibration command of the

 *                 ADS1256.

 *           - ADS1256_CMD_SYSOCAL:

 *                 Sends the system offset calibration command of

 *                 the ADS1256.

 *           - ADS1256_CMD_SYSGCAL:

 *                 Sends the system gain calibration command of

 *                 the ADS1256.

 *           - ADS1256_CMD_STANDBY:

 *                 Sends the standby command of the ADS1256.

 *                 Standby can be exited by sending the WAKEUP

 *                 command.

 *           - ADS1256_CMD_RESET:

 *                 Sends the RESET command of the ADS1256.

 *           - ADS1256_CMD_SDATAC:

 *                 Sends the stop read data continuously command.

 *           - ADS1256_CMD_RREG:

 *                 Reads the register specified by the *pValue

 *                 parameter and returns it in *pValue. *pValue

 *                 should point to a variable of type unsigned

 *                 int on the application level.

 *           - ADS1256_CMD_WREG:

 *                 Writes the member of the register structure

 *                 to the register specified in the *pValue

 *                 parameter. If a change in a register is

 *                 necessary, the application needs to change the

 *                 register value first in the data converter

 *                 object. *pValue should point to a variable of

 *                 type unsigned int on the application level.

 *           - ADS1256_CMD_SYNC:

 *                 Sends the command to synchronize the A/D

 *                 conversion.

 *           - ADS1256_CMD_SETDRATE:

 *                 Sets a new data rate by updating the register

 *                 structure of the data converter object and

 *                 modifies the DRATE register on the device. A

 *                 self-calibration is performed afterwards and

 *                 the OFCx and FSCx registers in the data

 *                 converter structure are updated afterwards.

 *           - ADS1256_CMD_SELECTPOSCHANNEL:

 *                 Selects the positive input channel in the MUX

 *                 register. Updates the register structure in the

 *                 data converter as well.

 *           - ADS1256_CMD_SELECTNEGCHANNEL:

 *                 Selects the negative input channel in the MUX

 *                 register. Updates the register structure in the

 *                 data converter as well.

 *           - ADS1256_CMD_SETPGA:

 *                 Sets a new PGA value in the ADCON register and

 *                 updates the register structure in the data

 *                 converter object. A self-calibration is

 *                 performed afterwards and the OFCx and FSCx

 *                 registers in the data converter structure are

 *                 updated afterwards.

  *           - ADS1256_CMD_SETIODIRECTION:

 *                 Sets the general purpose I/O pin passed as

 *                 parameter to either input or output in the IO

 *                 register. The register structure in the data

 *                 converter object is updated as well.

 *           - ADS1256_CMD_SETIOLEVEL:

 *                 Sets the general purpose I/O pin passed as

 *                 parameter to either high or low in the IO

 *                 register. The register structure in the data

 *                 converter object is updated as well.

 *           - ADS1256_CMD_GETIOLEVEL:

 *                 Reads the IO register and returns the level

 *                 of the general purpose I/O pin in the passed

 *                 parameter. The register structure is not

 *                 updated in this case.

 *           - ADS1256_CMD_SETOFC:

 *                 Writes the argument passed in *pValue to the

 *                 OFC registers 0, 1 and 2. The byte ordering has

 *                 to match the order as mentioned in the data

 *                 sheet (lower 8-bit are for OFC0, middle 8-bit

 *                 for OFC1 and the upper 8-bit for OFC2).

 *                 The register structure in the data converter

 *                 object is updated with the new value. pValue

 *                 should point to a variable of type unsigned

 *                 long on the application level.

 *            - ADS1256_CMD_GETOFC:

 *                 Reads the OFC registers 0, 1 and 2 and returns

 *                 the combined value in the passed parameter. The

 *                 register structure of the data converter object

 *                 is not updated in this case. *pValue should

 *                 point to a variable of type unsigned long on

 *                 the application level.

 *           - ADS1256_CMD_SETSFC:

 *                 Writes the passed argument to the SFC registers

 *                 0, 1 and 2. The byte ordering has to match the

 *                 order as mentioned in the data sheet (lower

 *                 8-bit are for SFC0, middle 8-bit for SFC1 and

 *                 the upper 8-bit for SFC2). The register

 *                 structure in the data converter object is

 *                 updated with the new value. *pValue should

 *                 point to a variable of type unsigned long on

 *                 the application level.

 *            - ADS1256_CMD_GETSFC:

 *                 Reads the SFC registers 0, 1 and 2 and returns

 *                 the combined value in the passed parameter. The

 *                 register structure of the data converter object

 *                 is not updated in this case. *pValue should

 *                 point to a variable of type unsigned long on

 *                 the application level.

 *     - void *pValue: Additional parameters for the command

 *                 (see above).

 *

 * Return values: Status code of type TTIDCSTATUS:

 *     - TIDC_NO_ERR:   No problem occurred.

 *     - TIDC_ERR_BADARGS: Either the command or the value has

 *       been invalid.

 *

 * Globals modified:

 *     - The register structure in the data converter object

 *       as mentioned in the description of the commands.

 *

 * Resources used:

 *     - None

 *

 * Notes:

 *     - There is no direct support for the RDATA command

 *       of the device. This functionality is implemented in the

 *       ADS1256_readsample() function.

 */

/****************************************************************/

TTIDCSTATUS ADS1256_control(void *pDc, int iCmd, void *pValue)

{

    TADS1256 *pADS = (TADS1256 *)pDc;

    unsigned int uiRegister;

    unsigned int uiValue;



    /* return, if no device object available                    */

    if (pADS == 0)

        return TIDC_ERR_NODEVICE;



    /* decide on the commend                                    */

    switch (iCmd)

    {

        /********************************************************/

        /* WAKEUP: completes SYNC and exits standby mode        */

        case ADS1256_CMD_WAKEUP:

            (void)SetWordLength(pADS->serial->hMcbsp,

                                ADS1256_WORDLENGTH_8BIT);

            (void)SendCommand(pADS->serial->hMcbsp,

                              (unsigned long)iCmd);

            break;



        /********************************************************/

        /* STANDBY: begin standby mode                          */

        /********************************************************/

        case ADS1256_CMD_STANDBY:

        /* RESET: reset to power-up values                      */

        case ADS1256_CMD_RESET:

        /* SELFCAL: offset and gain self-calibration            */

        case ADS1256_CMD_SELFCAL:

        /* SELFOCAL: offset self-calibration                    */

        case ADS1256_CMD_SELFOCAL:

        /* SELFGCAL: gain self-calibration                      */

        case ADS1256_CMD_SELFGCAL:

        /* SYSOCAL: system offset calibration                   */

        case ADS1256_CMD_SYSOCAL:

        /* SYSGCAL: system gain calibration                     */

        case ADS1256_CMD_SYSGCAL:

            (void)SetWordLength(pADS->serial->hMcbsp,

                                ADS1256_WORDLENGTH_8BIT);

            (void)SendCommand(pADS->serial->hMcbsp,

                              (unsigned long)iCmd);

            (void)WaitDrdy(pADS);

            break;



        /********************************************************/

        /* RDATAC: read data continuously                       */

        /********************************************************/

        case ADS1256_CMD_RDATAC:

            (void)SetWordLength(pADS->serial->hMcbsp,

                                ADS1256_WORDLENGTH_8BIT);

            (void)WaitDrdy(pADS);

            (void)SendCommand(pADS->serial->hMcbsp,

                              (unsigned long)iCmd);

            (void)Wait(pADS, 24);

            break;



        /********************************************************/

        /* SDATAC: stop read data continuously                  */

        /********************************************************/

        case ADS1256_CMD_SDATAC:

            (void)SetWordLength(pADS->serial->hMcbsp,

                                ADS1256_WORDLENGTH_8BIT);

            (void)WaitDrdy(pADS);

            (void)SendCommand(pADS->serial->hMcbsp,

                              (unsigned long)iCmd);

            break;



        /********************************************************/

        /* RREG: read from register                             */

        /********************************************************/

        case ADS1256_CMD_RREG:

            *(unsigned int*)pValue = ReadRegister(pADS,

                                         *(unsigned int *)pValue);

            break;



        /********************************************************/

        /* WREG write to register                               */

        /********************************************************/

        case ADS1256_CMD_WREG:

            uiRegister = *(unsigned int *)pValue;



            switch (uiRegister)

            {

                case ADS1256_REG_STATUS:

                    uiValue = pADS->regs.status.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    if (pADS->regs.status.control_bit.acal == 1)

                        (void)WaitDrdy(pADS);

                    else

                    {

                        (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                        (void)ADS1256_control(pADS, ADS1256_CMD_SELFCAL, 0);

                    }

                    break;

                case ADS1256_REG_MUX:

                    uiValue = pADS->regs.mux.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    break;

                case ADS1256_REG_ADCON:

                    uiValue = pADS->regs.adcon.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    if (pADS->regs.status.control_bit.acal == 1)

                        (void)WaitDrdy(pADS);

                    else

                    {

                        (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                        (void)ADS1256_control(pADS, ADS1256_CMD_SELFCAL, 0);

                    }

                    break;

                case ADS1256_REG_DRATE:

                    uiValue = pADS->regs.drate.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    if (pADS->regs.status.control_bit.acal == 1)

                        (void)WaitDrdy(pADS);

                    else

                    {

                        (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                        (void)ADS1256_control(pADS, ADS1256_CMD_SELFCAL, 0);

                    }

                    break;

                case ADS1256_REG_IO:

                    uiValue = pADS->regs.io.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    break;

                case ADS1256_REG_OFC0:

                    uiValue = pADS->regs.ofc0.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                    break;

                case ADS1256_REG_OFC1:

                    uiValue = pADS->regs.ofc1.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                    break;

                case ADS1256_REG_OFC2:

                    uiValue = pADS->regs.ofc2.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                    break;

                case ADS1256_REG_FSC0:

                    uiValue = pADS->regs.fsc0.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                    break;

                case ADS1256_REG_FSC1:

                    uiValue = pADS->regs.fsc1.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                    break;

                case ADS1256_REG_FSC2:

                    uiValue = pADS->regs.fsc1.value;

                    (void)WriteRegister(pADS, uiRegister, &uiValue);

                    (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                    break;

                default: return TIDC_ERR_BADARGS;

            }

            break;



        /********************************************************/

        /* SYNC: synchronize the A/D conversion                 */

        /* to complete, SYNC must always be followed by WAKEUP  */

        /********************************************************/

        case ADS1256_CMD_SYNC:

            (void)SetWordLength(pADS->serial->hMcbsp,

                                ADS1256_WORDLENGTH_8BIT);

            (void)SendCommand(pADS->serial->hMcbsp, (unsigned int)iCmd);

            (void)Wait(pADS, 24);

            (void)SendCommand(pADS->serial->hMcbsp, ADS1256_CMD_WAKEUP);

            break;



        /********************************************************/

        /* SETDRATE: software command to set the data rate      */

        /********************************************************/

        case ADS1256_CMD_SETDRATE:

            uiRegister = ADS1256_REG_DRATE;

            uiValue = *(unsigned int *)pValue;

            pADS->regs.drate.value = uiValue;



            /* send the new register value to the device        */

            (void)WriteRegister(pADS, uiRegister, &uiValue);



            /* a new drate needs a device recalibration, but    */

            /* only if the autocalibration bit is not set       */

            if (pADS->regs.status.control_bit.acal == 1)

                (void)WaitDrdy(pADS);

            else

            {

                (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                (void)ADS1256_control(pADS, ADS1256_CMD_SELFCAL, 0);

            }



            /* read back the OFC and SFC registers              */

            pADS->regs.ofc0.value =

                            ReadRegister(pADS, ADS1256_REG_OFC0);

            pADS->regs.ofc1.value =

                            ReadRegister(pADS, ADS1256_REG_OFC1);

            pADS->regs.ofc2.value =

                            ReadRegister(pADS, ADS1256_REG_OFC2);

            pADS->regs.fsc0.value =

                            ReadRegister(pADS, ADS1256_REG_FSC0);

            pADS->regs.fsc1.value =

                            ReadRegister(pADS, ADS1256_REG_FSC1);

            pADS->regs.fsc2.value =

                            ReadRegister(pADS, ADS1256_REG_FSC2);



        break;



        /********************************************************/

        /* SELECTPOSCHANNEL: software command to select the     */

        /* positive input channel                               */

        /********************************************************/

        case ADS1256_CMD_SELECTPOSCHANNEL:

            uiRegister = ADS1256_REG_MUX;



            uiValue = *(unsigned int *)pValue

                      | (pADS->regs.mux.value & 0x000Fu);

            pADS->regs.mux.value = uiValue;



            (void)WriteRegister(pADS, uiRegister, &uiValue);



        break;



        /********************************************************/

        /* SELECTNEGCHANNEL: software command to select the     */

        /* negative input channel                               */

        /********************************************************/

        case ADS1256_CMD_SELECTNEGCHANNEL:

            uiRegister = ADS1256_REG_MUX;



            uiValue = *(unsigned int *)pValue

                      | (pADS->regs.mux.value & 0x00F0u);

            pADS->regs.mux.value = uiValue;



            (void)WriteRegister(pADS, uiRegister, &uiValue);



        break;



        /********************************************************/

        /* SETPGA: software command for the programmable gain   */

        /* amplifier setting                                    */

        /********************************************************/

        case ADS1256_CMD_SETPGA:

            uiRegister = ADS1256_REG_ADCON;



            uiValue = *(unsigned int *)pValue

                      | (pADS->regs.adcon.value & 0x00F8u);

            pADS->regs.adcon.value = uiValue;



            /* write the updated register to the device         */

            (void)WriteRegister(pADS, uiRegister, &uiValue);



            /* a new PGA value needs a device recalibration, but*/

            /* only if the autocalibration bit is not set       */

            if (pADS->regs.status.control_bit.acal == 1)

                (void)WaitDrdy(pADS);

            else

            {

                (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

                (void)ADS1256_control(pADS, ADS1256_CMD_SELFCAL, 0);

            }



            /* readback the new values for OFC and FSC          */

            pADS->regs.ofc0.value =

                            ReadRegister(pADS, ADS1256_REG_OFC0);

            pADS->regs.ofc1.value =

                            ReadRegister(pADS, ADS1256_REG_OFC1);

            pADS->regs.ofc2.value =

                            ReadRegister(pADS, ADS1256_REG_OFC2);

            pADS->regs.fsc0.value =

                            ReadRegister(pADS, ADS1256_REG_FSC0);

            pADS->regs.fsc1.value =

                            ReadRegister(pADS, ADS1256_REG_FSC1);

            pADS->regs.fsc2.value =

                            ReadRegister(pADS, ADS1256_REG_FSC2);



        break;



        /********************************************************/

        /* SETIODIRECTION: software command to set the direction*/

        /* of the general purpose I/O pins                      */

        /********************************************************/

        case ADS1256_CMD_SETIODIRECTION:

        /********************************************************/

        /* SETIOLEVEL: software command to set the level of the */

        /* general purpose I/O pins                             */

        /********************************************************/

        case ADS1256_CMD_SETIOLEVEL:

            uiRegister = ADS1256_REG_IO;



            uiValue = pADS->regs.io.value & ~(*(unsigned int *)pValue & 0x00FFu);

            uiValue |= *(unsigned int *)pValue >> 8;

            pADS->regs.io.value = uiValue;



            (void)WriteRegister(pADS, uiRegister, &uiValue);



        break;



        /********************************************************/

        /* GETIOLEVEL: software command to read the level of    */

        /* the general purpose I/O pins                         */

        /********************************************************/

        case ADS1256_CMD_GETIOLEVEL:

            uiRegister = ADS1256_REG_IO;

            uiValue = *(unsigned  int *)pValue;



            *(unsigned int*)pValue =

                       (ReadRegister(pADS, uiRegister) >> uiValue)

                       & 0x0001u;

            break;



        /********************************************************/

        /* SETOFC: software command to write the OFC registers  */

        /* 0, 1, 2                                              */

        /********************************************************/

        case ADS1256_CMD_SETOFC:

            /* send the lower 8 bits of the argument to OFC0    */

            uiRegister = ADS1256_REG_OFC0;

            uiValue = (unsigned int)(*(unsigned long *)pValue & 0x00FFu);

            (void)WriteRegister(pADS, uiRegister, &uiValue);

            pADS->regs.ofc0.value = uiValue;



            /* send the middle 8 bits of the argument to OFC1   */

            uiRegister = ADS1256_REG_OFC1;

            uiValue = (unsigned int)((*(unsigned long *)pValue >> 8) & 0x00FFu);

            (void)WriteRegister(pADS, uiRegister, &uiValue);

            pADS->regs.ofc1.value = uiValue;



            /* send the upper 8 bits of the argument to OFC2   */

            uiRegister = ADS1256_REG_OFC2;

            uiValue = (unsigned int)((*(unsigned long *)pValue >> 16) & 0x00FFu);

            (void)WriteRegister(pADS, uiRegister, &uiValue);

            pADS->regs.ofc2.value = uiValue;



            (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

        break;



        /********************************************************/

        /* GETOFC: software command to read the OFC registers   */

        /* 0, 1, 2                                              */

        /********************************************************/

        case ADS1256_CMD_GETOFC:

            /* read the lower 8 bits from OFC0                  */

            uiRegister = ADS1256_REG_OFC0;

            *(unsigned long *)pValue = ReadRegister(pADS, uiRegister);



            /* read the middle 8 bits from OFC1                 */

            uiRegister = ADS1256_REG_OFC1;

            *(unsigned long *)pValue |= ReadRegister(pADS, uiRegister) << 8;



            /* read the upper 8 bits from OFC2                  */

            uiRegister = ADS1256_REG_OFC2;

            *(unsigned long *)pValue |= (unsigned long)ReadRegister(pADS, uiRegister) << 16;



        break;



        /********************************************************/

        /* SETSFC: software command to write the FSC registers  */

        /* 0, 1, 2                                              */

        /********************************************************/

        case ADS1256_CMD_SETFSC:

            /* send the lower 8 bits of the argument to FSC0    */

            uiRegister = ADS1256_REG_FSC0;

            uiValue = (unsigned int)(*(unsigned long *)pValue & 0x00FFu);

            (void)WriteRegister(pADS, uiRegister, &uiValue);

            pADS->regs.fsc0.value = uiValue;



            /* send the middle 8 bits of the argument to FSC1   */

            uiRegister = ADS1256_REG_FSC1;

            uiValue = (unsigned int)((*(unsigned long *)pValue >> 8) & 0x00FFu);

            (void)WriteRegister(pADS, uiRegister, &uiValue);

            pADS->regs.fsc1.value = uiValue;



            /* send the upper 8 bits of the argument to FSC2   */

            uiRegister = ADS1256_REG_FSC2;

            uiValue = (unsigned int)((*(unsigned long *)pValue >> 16) & 0x00FFu);

            (void)WriteRegister(pADS, uiRegister, &uiValue);

            pADS->regs.fsc2.value = uiValue;



            (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);



        break;



        /********************************************************/

        /* GETFSC: software command to read the FSC registers   */

        /* 0, 1, 2                                              */

        /********************************************************/

        case ADS1256_CMD_GETFSC:

            /* read the lower 8 bits from FSC0                  */

            uiRegister = ADS1256_REG_FSC0;

            *(unsigned long *)pValue = ReadRegister(pADS, uiRegister);



            /* read the middle 8 bits from FSC1                 */

            uiRegister = ADS1256_REG_FSC1;

            *(unsigned long *)pValue |= ReadRegister(pADS, uiRegister) << 8;



            /* read the upper 8 bits from FSC2                  */

            uiRegister = ADS1256_REG_FSC2;

            *(unsigned long *)pValue |= (unsigned long)ReadRegister(pADS, uiRegister) << 16;



            break;



        /********************************************************/

        /* default: if you end up here, something got wrong     */

        /********************************************************/

        default:

            return TIDC_ERR_BADARGS;

    }



    return TIDC_NO_ERR;

}





/****************************************************************/

/* ADS1256_readsample()                                         */

/** Operation:

 *     - Reads a single data word from the converter.

 *     - Waiting for the next word to be received is a blocking

 *       statement, so the code can hang!

 *

 * Parameters:

 *     - void* pDC: Data converter object.

 *     - long *lData: Memory location used to return the

 *                    conversion result (out-parameter).

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_NO_ERR: Call was successfull.

 *     - TIDC_ERR_NODEVICE: No object was passed to the function.

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

TTIDCSTATUS ADS1256_readsample(void *pDC, long *lData)

{

    TADS1256 *pADS = pDC;



    /* return, if no device object available                    */

    if (pADS == 0)

        return TIDC_ERR_NODEVICE;



    (void)SetWordLength(pADS->serial->hMcbsp,

                                ADS1256_WORDLENGTH_8BIT);



    (void)WaitDrdy(pADS);



    /* send read data command to the converter                  */

    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR2, XRDY) != 1) ;

    MCBSP_write16(pADS->serial->hMcbsp, ADS1256_CMD_RDATA);



    /* receive the dummy word from the converter            */

    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR1, RRDY) != 1) ;

    (void)MCBSP_read16(pADS->serial->hMcbsp);



    (void)SetWordLength(pADS->serial->hMcbsp,

                                ADS1256_WORDLENGTH_24BIT);



    (void)Wait(pADS, 60);



    /* send "no command" to read conversion result              */

    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR2, XRDY) != 1) ;

    MCBSP_write32(pADS->serial->hMcbsp, 0x00000000u);



    /* retrieve the conversion result from the converter        */

    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR1, RRDY) != 1) ;

    *lData = MCBSP_read32(pADS->serial->hMcbsp);



    (void)Wait(pADS, 4);



    return TIDC_NO_ERR;

}





/****************************************************************/

/* ADS1256_readblock()                                          */

/** Operation:

 *     - Initializes the transfer of a block of data from the data

 *       converter. Once the transfer is started, the function

 *       returns to the application level.

 *     - It uses two DMA channels for the data transfer: One to

 *       trigger the SPI port and one to collect the conversion

 *       results. The DMA channel for the SPI port trigger will

 *       be selected by the code, while the DMA channel for the

 *       sample-read is fixed and was selected in the GUI of

 *       the DCP

 *     - Once the DMA transfer for the conversion results

 *       finishes, the ADS1256_rblock_finished ISR will be

 *       triggered, which will reset the iXferInProgress

 *       semaphore and will call the callback function, if

 *       requested.

 *     - Enables the interupt of the DMA channel used for the XFER

 *

 * Parameters:

 *     - void* pDC: Data converter object

 *     - void pData: Pointer to the data buffer.

 *           - The type of the buffer must be "long".

 *     - unsigned long ulCount: Size of the buffer in samples.

 *     - void *callback: Optional pointer to the callback function.

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_NO_ERR: Call was successfull.

 *     - TIDC_ERR_NODEVICE: No object was passed to the function.

 *     - TIDC_ERR_BADARGS: An invalid argument was passed to the

 *       function

 *

 * Globals modified:

 *     - In data converter object:

 *           - *lBufPtr

 *           - uiBufSize

 *           - ptrCallBack

 *           - iXferInProgress

 *     - TADS1256* pgADS: File scoped pointer to data converter

 *                        object

 *

 * Remarks:

 *     - Only one data transfer is allowed to be in active at a

 *       time and one additional can be queued.

 *     - The number of samples to be transfered must be more than

 *       0x0002 and less or equal to 0xFFFF.

 *     - No command can be issued while a data transfer is in

 *       progress. Doing so will result in corrupted data and/or

 *       a not executed command.

 *

 * Resources used:

 *     - The two DMA channels opened by ADS1256_configure

 */

/****************************************************************/

TTIDCSTATUS ADS1256_readblock(void *pDC,

                              void *pData,

                              unsigned long ulCount,

                              void (*callback) (void *))

{

    TADS1256 *pADS = (TADS1256 *)pDC;

    TTIDCSTATUS iStatus;



    /* return, if no device object available                    */

    if (pADS == 0)

        return TIDC_ERR_NODEVICE;



    if ((ulCount > (unsigned long)0x0000FFFFu)

      || (ulCount < (unsigned long)0x00000002u))

        return TIDC_ERR_BADARGS;



    /* modify tranfer in progress flag                          */

    if (pADS->iXferInProgress == ADS1256_MAX_XFERS)

        return TIDC_ERR_XFERPROG;

    else

        pADS->iXferInProgress += 1;



    /* set the global data converter object pointer             */

    pgADS = pADS;



    /* select the next free buffer object                       */

    if (pADS->xferBuffer[0].uiStatus == 0)

        pADS->iObjectIndex = 0; /* object 0 is free             */

    else

        pADS->iObjectIndex = 1; /* object 1 is free             */



    pADS->xferBuffer[pADS->iObjectIndex].ptrCallBack = callback;

    pADS->xferBuffer[pADS->iObjectIndex].lBufPtr = (long *)pData;

    pADS->xferBuffer[pADS->iObjectIndex].uiBufSize =

                                            (unsigned int)ulCount;

    pADS->xferBuffer[pADS->iObjectIndex].uiStatus = 1;



    if (pADS->iXferInProgress == 1)

    {

        /* set the continous conversion mode                    */

        iStatus = ADS1256_control(pADS, ADS1256_CMD_RDATAC, 0);

        if (iStatus != TIDC_NO_ERR)

        {

            pADS->iXferInProgress -= 1;

            return iStatus;

        }



        (void)SetWordLength(pADS->serial->hMcbsp,

                                    ADS1256_WORDLENGTH_24BIT);



        /* configure the DMA channels for the transfer          */

        iStatus = SubmitBlock(pADS->hDmaRcv,

                              pADS->hDmaXmt,

                              pADS->uiRcvCcrValue,

                              pADS->uiXmtCcrValue,

                              (unsigned int)ulCount,

                              (unsigned long)pData,

                              pADS->iXferInProgress);



        if (iStatus != TIDC_NO_ERR)

        {

            (void)ADS1256_control(pADS, ADS1256_CMD_SDATAC, 0);

            pADS->iXferInProgress -= 1;

            return iStatus;

        }



        /* start the DMA channel                                */

        DMA_start(pADS->hDmaRcv);

        DMA_start(pADS->hDmaXmt);



        (void)IRQ_enable(DMA_getEventId(pADS->hDmaRcv));

    }



    if (pADS->iXferInProgress == 2)

    {

        iStatus = SubmitBlock(pADS->hDmaRcv,

                              pADS->hDmaXmt,

                              pADS->uiRcvCcrValue,

                              pADS->uiXmtCcrValue,

                              (unsigned int)ulCount,

                              (unsigned long)pData,

                              pADS->iXferInProgress);



        if (iStatus != TIDC_NO_ERR)

        {

            (void)ADS1256_control(pADS, ADS1256_CMD_SDATAC, 0);

            pADS->iXferInProgress -= 1;

            return iStatus;

        }

    }



    return TIDC_NO_ERR;

}





/****************************************************************/

/* ADS1256_writesample()                                        */

/** Operation:     Not implemented. This function just returns.

 *

 * Parameters:

 *     - void* pDC: Data converter object

 *     - long lData: Data to be written to the converter

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_ERR_FXNNULL: This function is not implemented

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

TTIDCSTATUS ADS1256_writesample(void *pDC, long lData)

{

    return TIDC_ERR_FXNNULL;

}





/****************************************************************/

/**

 * ADS1256_writeblock()

 * Operation:     Not implemented. This function just returns.

 *

 * Parameters:

 *     - void* pDC: Data converter object

 *     - void* lData: Pointer to the block of data to be written

 *     - unsigned long ulCount: Number of words

 *     - void (*callback): Pointer to the callback function

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_ERR_FXNNULL: This function is not implemented

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

TTIDCSTATUS ADS1256_writeblock(void *pDC, void *pData,

                              unsigned long ulCount,

                              void (*callback) (void *))

{

    return TIDC_ERR_FXNNULL;

}





/****************************************************************/

/* ADS1256_close()                                              */

/** Operation:

 *     - Closes all the resources used on the DSP.

 *     - Resets the converter and initializes the register array

 *       back to the original values to ensure that the converter

 *       can be re-opened again.

 *

 * Parameters:

 *     - void* pDC: Data converter object

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_NO_ERR: No problem occurred

 *

 * Globals modified: The following items are modified inside

 *                   data converter object:

 *     - Handle to the serial port (set to zero)

 *     - Handle to the DMA channel for the data xfer (set to zero)

 *     - Handle to the DMA channel for the SCLK generation (set

 *       to zero)

 *     - The register structure for the data converter

 *     - iXferInProgress (set to zero)

 *     - iObjectIndex (set to zero)

 *     - uiStatus of the transfer buffer objects (set to unused)

 *

 * Resources used:

 *     - Two DMA channels (closed)

 *     - One McBSP channel (closed)

 */

/****************************************************************/

TTIDCSTATUS ADS1256_close(void *pDC)

{

    TADS1256 *pADS = (TADS1256 *)pDC;



    /* return, if no device object available                    */

    if (pADS == 0)

        return TIDC_ERR_NODEVICE;



    /* reset the device and stop conversions                    */

    (void)ADS1256_control(pADS, ADS1256_CMD_RESET, 0);



    /* close the transmit side DMA channel, if it was open      */

    if ((pADS->hDmaXmt != 0) && (pADS->hDmaXmt != INV))

    {

        DMA_close(pADS->hDmaXmt);

        pADS->hDmaXmt = 0;

    }



    /* close the receive side DMA channel, if it was open      */

    if ((pADS->hDmaRcv != 0) && (pADS->hDmaRcv != INV))

    {

        DMA_close(pADS->hDmaRcv);

        pADS->hDmaRcv = 0;

    }



    /* close the McBSP, if it was open                          */

    if ((pADS->serial->hMcbsp != 0) && (pADS->serial->hMcbsp != INV))

    {

        MCBSP_close(pADS->serial->hMcbsp);

        pADS->serial->hMcbsp = 0;

    }



    /* try to close the timer                                   */

    (void)Wait(0,0);



    /* copy the original register values back to the working    */

    /* register set                                             */

    pADS->regs.status.value = pADS->initRegs.status.value;

    pADS->regs.mux.value = pADS->initRegs.mux.value;

    pADS->regs.adcon.value = pADS->initRegs.adcon.value;

    pADS->regs.drate.value = pADS->initRegs.drate.value;

    pADS->regs.io.value = pADS->initRegs.io.value;

    pADS->regs.ofc0.value = pADS->initRegs.ofc0.value;

    pADS->regs.ofc1.value = pADS->initRegs.ofc1.value;

    pADS->regs.ofc2.value = pADS->initRegs.ofc2.value;

    pADS->regs.fsc0.value = pADS->initRegs.fsc0.value;

    pADS->regs.fsc1.value = pADS->initRegs.fsc1.value;

    pADS->regs.fsc2.value = pADS->initRegs.fsc2.value;



    /* reset the transfer in progress semaphore                 */

    pADS->iXferInProgress = 0;



    /* reset the buffer objects                                 */

    pADS->xferBuffer[0].uiStatus = 0;

    pADS->xferBuffer[1].uiStatus = 0;

    pADS->iObjectIndex = 0;



    return TIDC_NO_ERR;

}





/****************************************************************/

/* ADS1256_getFinishedBufferAddress()                           */

/**Operation:

 *     - Returns the address of the just finished buffer

 *     - This function can be used inside the callback function

 *       to obtain the address of the buffer just finished.

 *

 * Parameters:

 *     - TADS1256 *pADS: Data converter object

 *

 * Return value:

 *     - Address of the finished buffer

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

unsigned long ADS1256_getFinishedBufferAddress(TADS1256 *pADS)

{

    int iIndex;



    iIndex = pADS->iObjectIndex;

    if (pADS->iXferInProgress == 2)

        iIndex = (pADS->iObjectIndex + 1) & 0x0001u;



    return (unsigned long)pADS->xferBuffer[iIndex].lBufPtr;

}





/****************************************************************/

/* ADS1256_getFinishedBufferSize()                              */

/**Operation:

 *     - Returns the size of the just finished buffer

 *     - This function can be used inside the callback function

 *       to obtain the size of the buffer just finished.

 *

 * Parameters:

 *     - TADS1256 *pADS: Data converter object

 *

 * Return value:

 *     - Size of the finished buffer

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

unsigned int ADS1256_getFinishedBufferSize(TADS1256 *pADS)

{

    int iIndex;



    iIndex = pADS->iObjectIndex;

    if (pADS->iXferInProgress == 2)

        iIndex = (pADS->iObjectIndex + 1) & 0x0001u;



    return pADS->xferBuffer[iIndex].uiBufSize;

}





/****************************************************************/

/* InitDevice()                                                 */

/** Operation:

 *     - Initializes the registers of the ADS1256 and verifies

 *       the settings. The sequence follows the recommendation in

 *       the data sheet.

 *     - The OFCx and FSX registers in are initialized by the

 *       means of a self-calibration of the device and the so

 *       obtained calibration values are put into the register

 *       field of the data converter object.

 *

 * Parameter:

 *     - void* pDC: Data converter object

 *     - iRegAddress: Address of the register to initialize

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_NO_ERR:   No problem occurred

 *     - TIDC_ERR_REGS: Register initialization failed

 *

 * Globals modified:

 *     - OFC 0,1,2 and FSC 0,1,2 in the register structure.

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

static TTIDCSTATUS InitDevice(TADS1256 *pADS)

{

    unsigned long ulCalReadBack;

    unsigned int uiParam;



    /* stop and reset the converter                             */

    (void)ADS1256_control(pADS, ADS1256_CMD_SDATAC, 0);

    (void)ADS1256_control(pADS, ADS1256_CMD_RESET, 0);



    /* send and verify the register values                      */

    /* IO register                                              */

    uiParam = ADS1256_REG_IO;

    (void)ADS1256_control(pADS, ADS1256_CMD_WREG, (void *)&uiParam);

    (void)ADS1256_control(pADS, ADS1256_CMD_RREG, (void *)&uiParam);

    if ((uiParam & 0x00F0u) != (pADS->regs.io.value & 0x00F0u))

        return TIDC_ERR_REGS;



    /* DRATE register                                           */

    uiParam = ADS1256_REG_DRATE;

    (void)ADS1256_control(pADS, ADS1256_CMD_WREG, (void *)&uiParam);

    (void)ADS1256_control(pADS, ADS1256_CMD_RREG, (void *)&uiParam);

    if (uiParam != pADS->regs.drate.value)

        return TIDC_ERR_REGS;



    /* ADCON register                                           */

    uiParam = ADS1256_REG_ADCON;

    (void)ADS1256_control(pADS, ADS1256_CMD_WREG, (void *)&uiParam);

    (void)ADS1256_control(pADS, ADS1256_CMD_RREG, (void *)&uiParam);

    if (uiParam != pADS->regs.adcon.value)

        return TIDC_ERR_REGS;



    /* MUX register                                             */

    uiParam = ADS1256_REG_MUX;

    (void)ADS1256_control(pADS, ADS1256_CMD_WREG, (void *)&uiParam);

    (void)ADS1256_control(pADS, ADS1256_CMD_RREG, (void *)&uiParam);

    if (uiParam != pADS->regs.mux.value)

        return TIDC_ERR_REGS;



    /* STATUS register                                          */

    uiParam = ADS1256_REG_STATUS;

    (void)ADS1256_control(pADS, ADS1256_CMD_WREG, (void *)&uiParam);

    (void)ADS1256_control(pADS, ADS1256_CMD_RREG, (void *)&uiParam);

    if ((uiParam & 0x001Eu) != (pADS->regs.status.value & 0x001Eu))

        return TIDC_ERR_REGS;



    /* end the programming with a SYNC command and a self-      */

    /* calibration of the device                                */

    (void)ADS1256_control(pADS, ADS1256_CMD_SYNC, 0);

    (void)ADS1256_control(pADS, ADS1256_CMD_SELFCAL, 0);



    /* read the values for the offset and full scale calibration*/

    (void)ADS1256_control(pADS,ADS1256_CMD_GETOFC, &ulCalReadBack);



    pADS->regs.ofc0.value = ulCalReadBack & 0x000000FF;

    pADS->regs.ofc1.value = (ulCalReadBack >> 8) & 0x000000FF;

    pADS->regs.ofc2.value = (ulCalReadBack >> 16) & 0x000000FF;



    (void)ADS1256_control(pADS, ADS1256_CMD_GETFSC, &ulCalReadBack);



    pADS->regs.fsc0.value = ulCalReadBack & 0x000000FF;

    pADS->regs.fsc1.value = (ulCalReadBack >> 8) & 0x000000FF;

    pADS->regs.fsc2.value = (ulCalReadBack >> 16) & 0x000000FF;



    return TIDC_NO_ERR;

}





/****************************************************************/

/* InitRcvDma()                                                 */

/**Operation:

 *     - Opens the DMA channel needed for reading words from the

 *       converter; returns on error.

 *     - Pre-initializes the DMA configuration with the values

 *       which are not dependend on the buffer-address and the

 *       buffer size.

 *     - The final configuration will be done by the

 *       SubmitBlock() function.

 *     - This function does not touch the DMA Global Control

 *       Register and does not enable the interrupts associated

 *       with the channels.

 *     - It also does not start the DMA channel. This is the task

 *       of the ADS1256_readblock() function.

 *

 * Parameters:

 *     - DCP_SERIAL serial: Serial port object.

 *     - int iChanNum: The number of the channel to be used

 *     - DMA_Handle: Pointer to the hDmaRcv handle in the data

 *              converter structure

 *     - unsigned int *pCcr: Pointer to the DMA control register

 *              variable in the data converter object.

 *

 * Return value:

 *     - TIDC_NO_ERR in case everything was OK

 *     - TIDC_ERR_DMA if the DMA channel could not be opened.

 *     - TIDC_ERR_BADARGS if the handle of the McBSP is invalid.

 *

 * Globals modified: Inside the data converter object:

 *     - hDmaRcv

 *     - uiRcvCcrValue

 *

 * Resources used:

 *     - One DMA channel

 */

/****************************************************************/

static TTIDCSTATUS InitRcvDma(DCP_SERIAL *pSerial,

                              int iChanNum,

                              DMA_Handle *hDma,

                              unsigned int *pCcr)

{

    DMA_Config cfgDma;                /* defined in the CSL     */

    unsigned long ulSrc;              /* holds source address   */

    unsigned int uiIrq;               /* sync-event ID          */



    *hDma = DMA_open(iChanNum, 0);

    if (*hDma == INV)

        return TIDC_ERR_DMA;



    /* set the default values of the channel registers          */

    memset(&cfgDma, 0x0000, sizeof(cfgDma));



    /* DMACCR (channel control register) setup                  */

    /* First, select the synchronization event; as they are not */

    /* linear, they cannot be used directly.                    */

    /* The macros of the events are based on the event ID's from*/

    /* the chip support library                                 */

    switch (pSerial->intnum)

    {

        case IRQ_EVT_RINT0: uiIrq = 1;    /* IRQ_EVT_RINT0 = 5  */

                            break;

        case IRQ_EVT_RINT1: uiIrq = 5;    /* IRQ_EVT_RINT1 = 6  */

                            break;

        case IRQ_EVT_RINT2: uiIrq = 9;    /* IRQ_EVT_RINT2 = 12 */

                            break;        /* not C5501          */

        default:            return TIDC_ERR_BADARGS;

    }



    /* now create the correct settings for the DMACCR register  */

    *pCcr = ADS1256_DMACCR_INPUT_VALUE | uiIrq;



    /* DMACICR (channel interrupt control) setup                */

    cfgDma.dmacicr = ADS1256_DMACICR_INPUT_VALUE;



    /* DMACSSAL/AU (channel source start address low/high) setup*/

    /* type DMA_AdrPtr is defined in the CSL                    */

    ulSrc = ((unsigned long)MCBSP_ADDRH(pSerial->hMcbsp, DRR2)) << 1;

    cfgDma.dmacssal = (DMA_AdrPtr)(ulSrc);

    cfgDma.dmacssau = (Uint16)((ulSrc >> 16));



    /* DMACFN (channel frame number) setup                      */

    cfgDma.dmacfn = 1; /* we will only transfer a single frame  */



    /* Now that all registers are set-up, to the actual         */

    /* configuration of the DMA channel                         */

    DMA_config(*hDma, &cfgDma);



    return TIDC_NO_ERR;

}





/****************************************************************/

/* InitXmtDma()                                                 */

/**Operation:

 *     - Opens the DMA channel needed for triggering the SCLK;

 *       returns on error.

 *     - Pre-initializes the DMA configuration with the values

 *       which are not dependend on the buffer-address and the

 *       buffer size.

 *     - The final configuration will be done by the

 *       SubmitBlock() function.

 *     - This function does not touch the DMA Global control

 *       register and does not enable the interrupts associated

 *       with the channels.

 *     - It also does not start the DMA channel. This is the task

 *       of the ADS1256_readblock() function.

 *

 * Parameters:

 *     - MCBSP_Handle hMcbsp: Handle for the McBSP used

 *     - unsigned int uiIrq: Interrupt number for the DRDY signal

 *     - DMA_Handle: Pointer to the hDmaXmt handle in the data

 *              converter structure

 *     - unsigned int *pCcr: Pointer to the DMA control register

 *              variable in the data converter object.

 *

 * Return value:

 *     - TIDC_NO_ERR in case everything was OK

 *     - TIDC_ERR_DMA if the DMA channel could not be opened.

 *     - TIDC_ERR_BADARGS if the interrupt number passed is

 *       invalid.

 *

 * Globals modified: Inside the data converter object:

 *     - hDmaRcv

 *     - uiXmtCcrValue

 *

 * Resources used:

 *     - One DMA channel

 */

/****************************************************************/

static TTIDCSTATUS InitXmtDma(MCBSP_Handle hMcbsp,

                              unsigned int uiIrq,

                              DMA_Handle *hDma,

                              unsigned int *pCcr)

{

    DMA_Config cfgDma;                /* defined in the CSL     */

    unsigned int uiSrcPort;           /* holds the memory type  */

    unsigned long ulDst;

    unsigned long ulSrc;



    *hDma = DMA_open(DMA_CHA_ANY, 0);

    if (*hDma == INV)

        return TIDC_ERR_DMA;



    /* set the default values of the channel registers          */

    memset(&cfgDma, 0x0000, sizeof(cfgDma));



    /* DMACCR (channel control register) setup                  */

    /* First, select the synchronization event; as they are not */

    /* linear, they cannot be used directly.                    */

    /* The macros of the events are based on the event ID's from*/

    /* the chip support library                                 */

    switch (uiIrq)

    {

        case IRQ_EVT_INT0:  uiIrq = 15;   /* IRQ_EVT_INT0 = 2   */

                            break;

        case IRQ_EVT_INT1:  uiIrq = 16;   /* IRQ_EVT_INT1 = 16  */

                            break;

        case IRQ_EVT_INT2:  uiIrq = 17;   /* IRQ_EVT_INT2 = 3   */

                            break;

        case IRQ_EVT_INT3:  uiIrq = 18;   /* IRQ_EVT_INT3 = 11  */

                            break;

        case IRQ_EVT_INT4:  uiIrq = 19;   /* IRQ_EVT_INT4 = 19  */

                            break;        /* only C5509 & C5510 */

        case IRQ_EVT_INT5:  uiIrq = 20;   /* IRQ_EVT_INT5 = 23  */

                            break;        /* only C5510         */

        default:            return TIDC_ERR_BADARGS;

    }



    /* now create the correct settings for the DMACCR register  */

    *pCcr = ADS1256_DMACCR_OUTPUT_VALUE | uiIrq;



    /* DMACSDP (channel source destination paramter setup       */

    ulSrc = (unsigned long)&ulDummy << 1;

    uiSrcPort = ADS1256_DMACSDP_EMIF_SRC;

    /* is the address in DARAM ?                            */

    if (ulSrc < DCP_DARAM_END)

        uiSrcPort = ADS1256_DMACSDP_DARAM_SRC;

    /* is the address in SARAM                              */

    if (ulSrc >= DCP_SARAM_START && ulSrc <= DCP_SARAM_END)

        uiSrcPort = ADS1256_DMACSDP_SARAM_SRC;



    cfgDma.dmacsdp = ADS1256_DMACSDP_OUTPUT_VALUE

                     | uiSrcPort;         /* src memory type    */



    /* DMACICR (channel interrupt control) setup                */

    /* modify value according to requested end of xfer interrupt*/

    cfgDma.dmacicr = ADS1256_DMACICR_OUTPUT_VALUE;



    /* DMACSSAL/AU (channel source start address low/high) setup*/

    /* type DMA_AdrPtr is defined in the CSL                    */

    cfgDma.dmacssal = (DMA_AdrPtr)(ulSrc);

    cfgDma.dmacssau = (Uint16)((ulSrc >> 16));



    /* DMACDSAL/AU (channel dest. start address low/high) setup */

    ulDst = ((unsigned long)MCBSP_ADDRH(hMcbsp, DXR2)) << 1;

    cfgDma.dmacdsal = (DMA_AdrPtr)(ulDst);

    cfgDma.dmacdsau = (unsigned short)(ulDst >> 16);



    /* DMACFN (channel frame number) setup                      */

    cfgDma.dmacfn = 1; /* we will only transfer a single frame  */



    /* Now that all registers are set-up, to the actual         */

    /* configuration of the DMA channel                         */

    DMA_config(*hDma, &cfgDma);



    return TIDC_NO_ERR;

}





/****************************************************************/

/* InitMcbsp()                                                  */

/** Operation:

 *     - Opens, initializes and starts the McBSP given by the port

 *       variable in the serial port structure.

 *

 * Parameters:

 *     - DCP_SERIAL serial: Serial port object.

 *     - unsigned int clkdiv: Divider for the sample rate

 *       generator.

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_NO_ERR:   No problem occurred.

 *     - TIDC_ERR_MCBSP: The serial port couldn't be opened.

 *

 * Globals modified:

 *     - Handle in the serial port structure.

 *     - Interrupt number in the serial port structure.

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

static TTIDCSTATUS InitMcbsp(DCP_SERIAL *pSerial,

                             unsigned int clkdiv)

{

    /* open the port and return on fail                         */

    pSerial->hMcbsp = MCBSP_open((int)pSerial->port,

                                MCBSP_OPEN_RESET);

    if (pSerial->hMcbsp == INV)

        return TIDC_ERR_MCBSP;



    /* clear the serial port structure                          */

    memset(&pSerial->sConfig, 0, sizeof(pSerial->sConfig));



    /* initialize the serial port structure                     */

    /*  Serial Port Control Register 1                          */

    pSerial->sConfig.spcr1 =

          MCBSP_FMK(SPCR1, DLB, MCBSP_SPCR1_DLB_OFF)

        | MCBSP_FMK(SPCR1, RJUST, MCBSP_SPCR1_RJUST_RSE)

        | MCBSP_FMK(SPCR1, CLKSTP, MCBSP_SPCR1_CLKSTP_NODELAY)

        | MCBSP_FMK(SPCR1, DXENA, MCBSP_SPCR1_DXENA_OFF)

        | MCBSP_FMK(SPCR1, ABIS, MCBSP_SPCR1_ABIS_DISABLE)

        | MCBSP_FMK(SPCR1, RINTM, MCBSP_SPCR1_RINTM_RRDY)

        | MCBSP_FMK(SPCR1, RSYNCERR, MCBSP_SPCR1_RSYNCERR_NO)

        | MCBSP_FMK(SPCR1, RFULL, MCBSP_SPCR1_RFULL_NO)

        | MCBSP_FMK(SPCR1, RRDY, MCBSP_SPCR1_RRDY_NO)

        | MCBSP_FMK(SPCR1, RRST, MCBSP_SPCR1_RRST_DISABLE);



    /*  Serial Port Control Register 2                          */

    pSerial->sConfig.spcr2 =

        MCBSP_FMK(SPCR2, FREE, MCBSP_SPCR2_FREE_YES)

        | MCBSP_FMK(SPCR2, SOFT, MCBSP_SPCR2_SOFT_YES)

        | MCBSP_FMK(SPCR2, FRST, MCBSP_SPCR2_FRST_RESET)

        | MCBSP_FMK(SPCR2, GRST, MCBSP_SPCR2_GRST_RESET)

        | MCBSP_FMK(SPCR2, XINTM, MCBSP_SPCR2_XINTM_XRDY)

        | MCBSP_FMK(SPCR2, XSYNCERR, MCBSP_SPCR2_XSYNCERR_NO)

        | MCBSP_FMK(SPCR2, XEMPTY, MCBSP_SPCR2_XEMPTY_NO)

        | MCBSP_FMK(SPCR2, XRDY, MCBSP_SPCR2_XRDY_NO)

        | MCBSP_FMK(SPCR2, XRST, MCBSP_SPCR2_XRST_DISABLE);



    /*  Receive Control Register 1                              */

    pSerial->sConfig.rcr1 =

        MCBSP_FMK(RCR1, RFRLEN1, MCBSP_RCR1_RFRLEN1_OF(0))

        | MCBSP_FMK(RCR1, RWDLEN1, MCBSP_RCR1_RWDLEN1_8BIT);



    /*  Receive Control Register 2                              */

    pSerial->sConfig.rcr2 =

        MCBSP_FMK(RCR2, RPHASE, MCBSP_RCR2_RPHASE_SINGLE)

        | MCBSP_FMK(RCR2, RFRLEN2, MCBSP_RCR2_RFRLEN2_OF(0))

        | MCBSP_FMK(RCR2, RWDLEN2, MCBSP_RCR2_RWDLEN2_8BIT)

        | MCBSP_FMK(RCR2, RCOMPAND, MCBSP_RCR2_RCOMPAND_MSB)

        | MCBSP_FMK(RCR2, RFIG, MCBSP_RCR2_RFIG_NO)

        | MCBSP_FMK(RCR2, RDATDLY, MCBSP_RCR2_RDATDLY_1BIT);



    /*  Transmit Control Register 1                             */

    pSerial->sConfig.xcr1 =

        MCBSP_FMK(XCR1, XFRLEN1, MCBSP_XCR1_XFRLEN1_OF(0))

        | MCBSP_FMK(XCR1, XWDLEN1, MCBSP_XCR1_XWDLEN1_8BIT);



    /*  Transmit Control Register 2                             */

    pSerial->sConfig.xcr2 =

        MCBSP_FMK(XCR2, XPHASE, MCBSP_XCR2_XPHASE_SINGLE)

        | MCBSP_FMK(XCR2, XFRLEN2, MCBSP_XCR2_XFRLEN2_OF(0))

        | MCBSP_FMK(XCR2, XWDLEN2, MCBSP_XCR2_XWDLEN2_8BIT)

        | MCBSP_FMK(XCR2, XCOMPAND, MCBSP_XCR2_XCOMPAND_MSB)

        | MCBSP_FMK(XCR2, XFIG, MCBSP_XCR2_XFIG_NO)

        | MCBSP_FMK(XCR2, XDATDLY, MCBSP_XCR2_XDATDLY_1BIT);



    /*  Sample Rate Generator Register 1                        */

    pSerial->sConfig.srgr1 =

        MCBSP_FMK(SRGR1, FWID, MCBSP_SRGR1_FWID_OF(0))

        | MCBSP_FMK(SRGR1, CLKGDV, MCBSP_SRGR1_CLKGDV_OF(clkdiv));





    /*  Sample Rate Generator Register 2                        */

    pSerial->sConfig.srgr2 =

        MCBSP_FMK(SRGR2, GSYNC, MCBSP_SRGR2_GSYNC_FREE)

        | MCBSP_FMK(SRGR2, CLKSP, MCBSP_SRGR2_CLKSP_RISING)

        | MCBSP_FMK(SRGR2, CLKSM, MCBSP_SRGR2_CLKSM_INTERNAL)

        | MCBSP_FMK(SRGR2, FSGM, MCBSP_SRGR2_FSGM_DXR2XSR)

        | MCBSP_FMK(SRGR2, FPER, MCBSP_SRGR2_FPER_OF(0));



    /*  Pin Control Register                                    */

    pSerial->sConfig.pcr =

        MCBSP_FMK(PCR, IDLEEN, MCBSP_PCR_IDLEEN_RESET)

        | MCBSP_FMK(PCR, XIOEN, MCBSP_PCR_XIOEN_SP)

        | MCBSP_FMK(PCR, RIOEN, MCBSP_PCR_RIOEN_SP)

        | MCBSP_FMK(PCR, FSXM, MCBSP_PCR_FSXM_INTERNAL)

        | MCBSP_FMK(PCR, FSRM, MCBSP_PCR_FSRM_EXTERNAL)

        | MCBSP_FMK(PCR, SCLKME, MCBSP_PCR_SCLKME_NO)

        | MCBSP_FMK(PCR, CLKSSTAT, MCBSP_PCR_CLKSSTAT_0)

        | MCBSP_FMK(PCR, DXSTAT, MCBSP_PCR_DXSTAT_0)

        | MCBSP_FMK(PCR, DRSTAT, MCBSP_PCR_DRSTAT_0)

        | MCBSP_FMK(PCR, CLKXM, MCBSP_PCR_CLKXM_OUTPUT)

        | MCBSP_FMK(PCR, CLKRM, MCBSP_PCR_CLKRM_INPUT)

        | MCBSP_FMK(PCR, FSXP, MCBSP_PCR_FSXP_ACTIVELOW)

        | MCBSP_FMK(PCR, FSRP, MCBSP_PCR_FSRP_ACTIVELOW)

        | MCBSP_FMK(PCR, CLKXP, MCBSP_PCR_CLKXP_RISING)

        | MCBSP_FMK(PCR, CLKRP, MCBSP_PCR_CLKRP_FALLING);



    MCBSP_config(pSerial->hMcbsp, &(pSerial->sConfig));



    pSerial->intnum = MCBSP_getRcvEventId(pSerial->hMcbsp);



    /* and start it                                             */

    (void)MCBSP_start(pSerial->hMcbsp,

                      MCBSP_XMIT_START

                      | MCBSP_RCV_START

                      | MCBSP_SRGR_START

                      | MCBSP_SRGR_FRAMESYNC,

                      0xE000u);



    return TIDC_NO_ERR;

}





/****************************************************************/

/* ReadRegister()                                              */

/** Operation:

 *      - Reads the register specified by the parameter uiRegister

 *        and returns it.

 *

 * Parameters:

 *      - TADS1256 *pADS:Data converter object

 *      - unsigned int uiRegister: The address of the register to

 *        read.

 *

 * Return value:

 *      - The contents of the read register.

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

static unsigned int ReadRegister(TADS1256 *pADS,

                                 unsigned int uiRegister)

{

    unsigned int iReadValue;



    /* change the McBSP mode to 16 bits                         */

    (void)SetWordLength(pADS->serial->hMcbsp,

                        ADS1256_WORDLENGTH_16BIT);

    (void)SendCommand(pADS->serial->hMcbsp,

                      uiRegister | ADS1256_CMD_RREG);



    /* change the McBSP mode to 8 bits                          */

    (void)SetWordLength(pADS->serial->hMcbsp,

                        ADS1256_WORDLENGTH_8BIT);

    /* wait the necessary number of cycles                      */

    (void)Wait(pADS, 60);



    /* send a dummy word to trigger 8 SCLKs                     */

    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR2, XRDY) != 1) ;

    MCBSP_write16(pADS->serial->hMcbsp, 0);



    /* and get the data                                         */

    while (MCBSP_FGETH(pADS->serial->hMcbsp, SPCR1, RRDY) != 1) ;

    iReadValue = MCBSP_read16(pADS->serial->hMcbsp) & 0x00FFu;



    (void)Wait(pADS, 4);



    return iReadValue;

}





/****************************************************************/

/* ADS1256_rblock_finished()                                    */

/**Operation:

 *     - Disables any further conversions by sending the stop

 *       continuous conversion command to the converter, if this

 *       was the last transfer in a chain.

 *     - Clears the DMA channel control register of the two

 *       channels used, if this was the last transfer in a chain.

 *     - Disables the DMA interrupt, if this was the last transfer

 *       in a chain.

 *     - Sets the status flag of the finished buffer to finished

 *     - Calls the callback-routine, if wished

 *     - Resets the status flag of the finished buffer to empty.

 *

 * Parameters:

 *     - None

 *

 * Return value:

 *     - None

 *

 * Globals modified:

 *     - iXferInProgress in the dc object

 *     - uiStatus inside the buffer object

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

interrupt void ADS1256_rblockFinished(void)

{

    int iIndex;



    if (pgADS->iXferInProgress == 1)

    {

        /* avoid additional synchronization events to the DMA   */

        /* by clearing the DMACCR register                      */

        DMA_RSETH(pgADS->hDmaXmt, DMACCR, 0);

        DMA_RSETH(pgADS->hDmaRcv, DMACCR, 0);

        (void)IRQ_disable(DMA_getEventId(pgADS->hDmaRcv));



        /* avoid any additional conversion by sending the stop  */

        /* continuous conversion command                        */

        (void)ADS1256_control(pgADS, ADS1256_CMD_SDATAC, 0);



        iIndex = pgADS->iObjectIndex;

    }

    else

        iIndex = (pgADS->iObjectIndex + 1) & 0x0001u;



    (void)DMA_RGETH(pgADS->hDmaRcv, DMACSR);

    (void)DMA_RGETH(pgADS->hDmaXmt, DMACSR);



    IRQ_clear(DMA_getEventId(pgADS->hDmaRcv));



    /* if there is a callback function requested, call it       */

    if (pgADS->xferBuffer[iIndex].ptrCallBack)

    {

        pgADS->xferBuffer[iIndex].uiStatus = 2;

        pgADS->xferBuffer[iIndex].ptrCallBack(pgADS);

    }

    pgADS->xferBuffer[iIndex].uiStatus = 0;



    /* signal that the transfer was successful                  */

    pgADS->iXferInProgress -= 1;

}





/****************************************************************/

/* SendCommand()                                                */

/** Operation:

 *      - Waits until the McBSP is ready to transmit a new word

 *        and send the command to the device.

 *      - Waits until the dummy word is received and discards it.

 *

 * Parameters:

 *      - MCBSP_Handle hMcbsp: The handle to the serial port

 *        in use.

 *        int iCmdValue: The binary opcode for the command to send

 *

 * Return value:

 *     - TIDC_NO_ERR in case everything was OK

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

static inline TTIDCSTATUS SendCommand(MCBSP_Handle hMcbsp,

                                      unsigned long ulCmdValue)

{

    unsigned int uiCmdWidth;



    /* get the width of the command                             */

    uiCmdWidth = MCBSP_FGETH(hMcbsp, XCR1, XWDLEN1);



    /* wait until the McBSP is ready to send data               */

    while (MCBSP_FGETH(hMcbsp,SPCR2, XRDY) != 1) ;

    /* send the command to the converter                        */

    if (uiCmdWidth == ADS1256_WORDLENGTH_24BIT)

        MCBSP_write32(hMcbsp, ulCmdValue);

    else

        MCBSP_write16(hMcbsp, (unsigned int)ulCmdValue);



    /* wait until the McBSP is ready to receive data            */

    while (MCBSP_FGETH(hMcbsp,SPCR1, RRDY) != 1) ;

    /* discard the received word, as it is meaningless          */

    if (uiCmdWidth == ADS1256_WORDLENGTH_24BIT)

        (void)MCBSP_read32(hMcbsp);

    else

        (void)MCBSP_read16(hMcbsp);



    return TIDC_NO_ERR;

}





/****************************************************************/

/* SetWordLength()                                              */

/** Operation:

 *     - Changes the receive and transmit wordlength of the serial

 *       port in use, if the paremeter length does not match the

 *       current setting.

 *

 * Parameters:

 *     - MCBSP_Handle hMcbsp: Handle to the McBSP

 *     - unsigned int uiLength: Desired wordlength

 *

 * Return value:  Status code of type TTIDCSTATUS

 *     - TIDC_NO_ERR:   No problem occurred

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

static TTIDCSTATUS SetWordLength(MCBSP_Handle hMcbsp,

                                 unsigned int uiLength)

{

    /* only change the word-length, if it is not already set    */

    if (MCBSP_FGETH(hMcbsp, RCR1, RWDLEN1) != uiLength)

    {

        /* if no, make sure the port is inactive                */

        while(MCBSP_FGETH(hMcbsp, SPCR2, XEMPTY) == 1) ;



        /* place receiver and transmitter in reset              */

        MCBSP_FSETH(hMcbsp, SPCR1, RRST, MCBSP_SPCR1_RRST_DISABLE);

        MCBSP_FSETH(hMcbsp, SPCR2, XRST, MCBSP_SPCR2_XRST_DISABLE);



        /* set the new word-length                              */

        MCBSP_FSETH(hMcbsp, RCR1, RWDLEN1, uiLength);

        MCBSP_FSETH(hMcbsp, XCR1, XWDLEN1, uiLength);



        /* re-enable the receiver and transmitter               */

        MCBSP_FSETH(hMcbsp, SPCR1, RRST, MCBSP_SPCR1_RRST_ENABLE);

        MCBSP_FSETH(hMcbsp, SPCR2, XRST, MCBSP_SPCR2_XRST_ENABLE);

    }



    return TIDC_NO_ERR;

}





/****************************************************************/

/* SubmitBlock()                                                */

/**Operation:

 *     - Initializes the DMA channels which have been opened and

 *       pre-configured by the InitRcvDma() and InitXmtDma()

 *       functions with the correct values for the DMA channel

 *       control registers and the transfer count register.

 *     - Initializes the destination address register of the

 *       receive channel to match the buffer passed into the

 *       fucntion.

 *

 * Parameters:

 *     - DMA_Handle hDmaRcv: Handle for the receive DMA channel

 *     - DMA_Handle hDmaXmt: Handle for the transit DMA channel

 *     - unsigned int uiCcrRcv: DMA control register value for the

 *              receive channel.

 *     - unsigned int uiCcrXmt: DMA control register value for the

 *              transmit channel

 *     - unsigned int uiCnt: Number of words to be transferred.

 *     - unsigned long ulDst: Address of the buffer to be filled.

 *     - int iIndex: Number of the transfer.

 *

 * Return value:

 *     - TIDC_NO_ERR in case everything was OK

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - DMA channels opened by ADS1256_configure()

 */

/****************************************************************/

static TTIDCSTATUS SubmitBlock(DMA_Handle hDmaRcv,

                               DMA_Handle hDmaXmt,

                               unsigned int uiCcrRcv,

                               unsigned int uiCcrXmt,

                               unsigned int uiCnt,

                               unsigned long ulDst,

                               int iIndex)

{

    unsigned int uiDstPort;



    /* the DMA controller needs byte addresses                  */

    ulDst = ulDst << 1;



    /* decide, in which memory area the buffer is located       */

    uiDstPort = ADS1256_DMACSDP_EMIF_DST;

    if (ulDst <= DCP_DARAM_END)

        uiDstPort = ADS1256_DMACSDP_DARAM_DST;

    if (ulDst >= DCP_SARAM_START && ulDst <= DCP_SARAM_END)

        uiDstPort = ADS1256_DMACSDP_SARAM_DST;



    /* wait until the channel is ready to program               */

    while ((DMA_RGETH(hDmaRcv, DMACCR) & ADS1256_DMA_ENDPROG) != 0);



    /* set the DMA Channel Source & Destination Parameter reg.  */

    DMA_RSETH(hDmaRcv,

              DMACSDP,

              ADS1256_DMACSDP_INPUT_VALUE | uiDstPort);



    /* set the DMA Channel Element Register (DMACEN)            */

    DMA_RSETH(hDmaRcv, DMACEN, uiCnt);



    /* set the DMA Channel Destination Start Address register   */

    DMA_RSETH(hDmaRcv, DMACDSAL,  (unsigned int)ulDst);

    DMA_RSETH(hDmaRcv, DMACDSAU, ((unsigned int)(ulDst >> 16)));



    /* if it is the first transfer, submit the dummy transfer   */

    /* and set the AUTOINIT bit                                 */

    if (iIndex == 1)

    {

        (void)SubmitDummyXfer(hDmaXmt);

        DMA_FSETH(hDmaXmt, DMACCR, AUTOINIT, 1);

    }



    /* set the DMA Channel Element Number (DMACEN) register     */

    DMA_RSETH(hDmaXmt, DMACEN, uiCnt);



    /* set the Dma Channel Control Register (DMACCR)            */

    /* if it is the first transfer, program the DMACCR and set  */

    /* the ENABLE bit to one, but leave the ENDPROG bit set to 0*/

    if (iIndex == 1)

    {

        DMA_RSETH(hDmaRcv, DMACCR, uiCcrRcv);

        DMA_RSETH(hDmaXmt, DMACCR, uiCcrXmt);

        DMA_FSETH(hDmaRcv, DMACCR, EN, 1);

        DMA_FSETH(hDmaXmt, DMACCR, EN, 1);

    }

    /* if it is the second transfer, set the ENBALE bit to 1    */

    /* and the ENDPROG bit to 1                                 */

    else

    {

        DMA_FSETH(hDmaRcv, DMACCR, EN, 1);

        DMA_FSETH(hDmaXmt, DMACCR, EN, 1);

        DMA_FSETH(hDmaRcv, DMACCR, ENDPROG, 1);

        DMA_FSETH(hDmaXmt, DMACCR, ENDPROG, 1);

    }



   return TIDC_NO_ERR;

}





/****************************************************************/

/* SubmitDummyXfer()                                            */

/* Operation:                                                   */

/*     - Starts a dummy transfer without synchronization        */

/*     - Waits for the transfer to complete                     */

/*     - Clears the control status register                     */

/*     - Clears the channel control register                    */

/*                                                              */

/* Parameters:                                                  */

/*     - DMA_Handle hDma: This is the handle to the DMA channel */

/*                                                              */

/* Return value (of type TTIDCSTATUS):                          */

/*     - TIDC_NO_ERR: No error occurred                         */

/*                                                              */

/* Globals modified: in DC object:                              */

/*     - None                                                   */

/*                                                              */

/* Resources used:                                              */

/*     - None                                                   */

/****************************************************************/

static TTIDCSTATUS SubmitDummyXfer(DMA_Handle hDma)

{



    unsigned long ulDst;

    unsigned int uiDstPort;

    unsigned int uiSaveCsdp;

    unsigned int uiSaveDstLow;

    unsigned int uiSaveDstHigh;



    /* the DMA controller needs byte addresses                  */

    ulDst = ((unsigned long)&ulDummy) << 1;



    /* decide, in which memory area the buffer is located       */

    uiDstPort = ADS1256_DMACSDP_EMIF_DST;



    /* is the address in DARAM?                                 */

    if (ulDst <= DCP_DARAM_END)

        uiDstPort = ADS1256_DMACSDP_DARAM_DST;



    /* is the address in SARAM?                                 */

    if (ulDst >= DCP_SARAM_START && ulDst <= DCP_SARAM_END)

        uiDstPort = ADS1256_DMACSDP_SARAM_DST;



    /* set the DMA Channel Source & Destination Parameter reg.  */

    /* but save the old value first                             */

    uiSaveCsdp = DMA_RGETH(hDma, DMACSDP);

    DMA_RSETH(hDma,

              DMACSDP,

              ADS1256_DMACSDP_VALUE_DUMMY

                  | uiDstPort

                  | (uiDstPort >> 7));



    /* set the DMA Channel Element Number register (DMACEN)     */

    DMA_RSETH(hDma, DMACEN, 1);



    /* set the DMA Channel Destination Start Address register   */

    /* but save the old values first                            */

    uiSaveDstLow = DMA_RGETH(hDma, DMACDSAL);

    uiSaveDstHigh = DMA_RGETH(hDma, DMACDSAU);

    DMA_RSETH(hDma, DMACDSAL,  (unsigned int)ulDst);

    DMA_RSETH(hDma, DMACDSAU, ((unsigned int)(ulDst >> 16)));



    /* set the Dma Channel Interrupt Control Register (DMACICR) */

    DMA_RSETH(hDma, DMACICR, 0x0020);



    /* set the Dma Channel Control Register (DMACCR)            */

    DMA_RSETH(hDma, DMACCR, ADS1256_DMACCR_VALUE_DUMMY);



    /* wait for the dummy transfer to finish                    */

    while (DMA_FGETH(hDma, DMACSR, BLOCK) != 1);



    DMA_RGETH(hDma, DMACSR); /* clear event */

    DMA_RSETH(hDma, DMACCR, 0); /* clear CCR */



    /* restore the old values                                   */

    DMA_RSETH(hDma, DMACSDP, uiSaveCsdp);

    DMA_RSETH(hDma, DMACDSAL, uiSaveDstLow);

    DMA_RSETH(hDma, DMACDSAU, uiSaveDstHigh);

    DMA_RSETH(hDma, DMACICR, 0x0000);



    IRQ_clear(DMA_getEventId(hDma)); /* clear int flag */



   return TIDC_NO_ERR;

}





/****************************************************************/

/* Wait()                                                       */

/** Operation:

 *      - Opens a DSP timer and configures it for the correct

 *        wait time on the first call. Otherwise, just reprograms

 *        the timer period register.

 *      - Waits the number of tosc periods specified in

 *        uiWaitCount

 *

 * Parameters:

 *      - TADS1256 *pADS:Data converter object

 *      - unsigned int uiWaitCount: Number of tosc, which should

 *        be waited

 *

 * Return value:

 *     - TIDC_NO_ERR in case everything was OK

 *     - TIDC_ERR_TIMER if the timer could not be opened

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - One timer

 *

 * Note:

 *     - This routine is a blocking one. That means it waits for

 *       the timer to complete before it returns

 */

/****************************************************************/

static TTIDCSTATUS Wait(TADS1256 *pADS, unsigned int uiWaitCount)

{



    static TIMER_Handle hTimer;

    static int iTimerConfigured = 0;

    static unsigned int uiTimerEventId;

    unsigned long ulTimerPeriod;



    /* if a null object was passed and the timer was configured */

    /* close it                                                 */

    if((pADS==0) && (iTimerConfigured))

    {

        iTimerConfigured = 0;

        TIMER_close(hTimer);

        hTimer = 0;

        return TIDC_NO_ERR;

    }



    /* setup the timer; is needed as the ADS1256 needs some     */

    /* delay between the commands. Configuration is only done   */

    /* at the very first time                                   */

    if (iTimerConfigured == 0 )

    {

        hTimer = TIMER_open(TIMER_DEV_ANY, TIMER_OPEN_RESET);

        if (hTimer == INV)

            return TIDC_ERR_TIMER;



        uiTimerEventId = TIMER_getEventId(hTimer);



        ulTimerPeriod = (unsigned long)pADS->uiClockDivision

                        * (unsigned long)uiWaitCount + 1;



        TIMER_configArgs(hTimer,

            TIMER_FMK(TCR, IDLEEN, TIMER_TCR_IDLEEN_DISABLE)

          | TIMER_FMK(TCR, FUNC, TIMER_TCR_FUNC_OF(0))

          | TIMER_FMK(TCR, TLB, TIMER_TCR_TLB_RESET)

          | TIMER_FMK(TCR, SOFT, TIMER_TCR_SOFT_DEFAULT)

          | TIMER_FMK(TCR, FREE, TIMER_TCR_FREE_DEFAULT)

          | TIMER_FMK(TCR, PWID, TIMER_TCR_PWID_DEFAULT)

          | TIMER_FMK(TCR, ARB, TIMER_TCR_ARB_RESET)

          | TIMER_FMK(TCR, TSS, TIMER_TCR_TSS_STOP)

          | TIMER_FMK(TCR, CP, TIMER_TCR_CP_CLOCK)

          | TIMER_FMK(TCR, POLAR, TIMER_TCR_POLAR_DEFAULT)

          | TIMER_FMK(TCR, DATOUT, TIMER_TCR_DATOUT_DEFAULT),

          (unsigned int)ulTimerPeriod,

          0);



        iTimerConfigured = 1;

    }

    else

    {

        ulTimerPeriod = (unsigned long)pADS->uiClockDivision

                        * (unsigned long)uiWaitCount + 1;



        TIMER_RSETH(hTimer, PRD, ulTimerPeriod);

        TIMER_RSETH(hTimer, TIM, 0);

    }



    /* start the timer and wait for the interrupt               */

    IRQ_clear(uiTimerEventId);

    TIMER_FSETH(hTimer, TCR, TSS, TIMER_TCR_TSS_START);

    while(!IRQ_test(uiTimerEventId)) ;

    TIMER_FSETH(hTimer, TCR, TSS, TIMER_TCR_TSS_STOP);



    return TIDC_NO_ERR;

}





/****************************************************************/

/* WaitDrdy()                                                   */

/** Operation:

 *      - Waits for the next falling edge of DRDY\, but first

 *        waits until the command causing the rising edge of DRDY\

 *        has finished.

 *

 * Parameters:

 *      - TADS1256 pADS: Data converter object.

 *

 * Return value:

 *     - TIDC_NO_ERR in case everything was OK

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 *

 * Note:

 *     - This routine is a blocking one. That means it waits for

 *       the DRDY\ signal to occur.                             */

/****************************************************************/

static TTIDCSTATUS WaitDrdy(TADS1256 *pADS)

{

    (void)Wait(pADS, 1);



    IRQ_clear(pADS->uiDrdyIntNum);

    while (IRQ_test(pADS->uiDrdyIntNum) == 0) ;



    return TIDC_NO_ERR;

}





/****************************************************************/

/* WriteRegister()                                              */

/** Operation:

 *      - Writes a new value to a register.

 *

 * Parameters:

 *      - TADS1256 *pADS:Data converter object

 *      - unsigned int uiRegister: The address of the register to

 *        write.

 *      - unsigned long *ulValue: The register contents to be

 *        written.

 *

 * Return value:

 *     - TIDC_NO_ERR in case everything was OK

 *

 * Globals modified:

 *     - None

 *

 * Resources used:

 *     - None

 */

/****************************************************************/

static TTIDCSTATUS WriteRegister (TADS1256 *pADS,

                                  unsigned int uiRegister,

                                  unsigned int *uiValue)

{

    (void)SetWordLength(pADS->serial->hMcbsp, ADS1256_WORDLENGTH_24BIT);



    /* send the register write command to the converter */

    (void)SendCommand(pADS->serial->hMcbsp,

                      (unsigned long)uiRegister << 0x0008u

                      | *uiValue

                      | (unsigned long)ADS1256_CMD_WREG << 0x0008);



    (void)Wait(pADS, 4);



    return TIDC_NO_ERR;

}


/****************************************************************/
/* END OF t1256_ob.c                                             */
/****************************************************************/
/*TIDC_Wizard Auto Code End}}*/
