#include <board.h>
#include <utility/trace.h>
#include <stdio.h>
#include <systick/systick.h>
#include <irq/irq.h>

#include "tsd.h"
#include "tsc2046.h"
#include "uart.h"

#define UART0_BAUDRATE   115200
//#define UART0_BAUDRATE   230400

/// Global timestamp in milliseconds since start of application.
volatile unsigned int timestamp = 0;

void SysTick_Handler(void)
{
    timestamp++;

    // Call TSD_TimerHandler per 10ms
    if ((timestamp % 10) == 0) 
    {    
        TSD_TimerHandler();
    }
}

int main(void)
{
    // DBGU output configuration
    TRACE_CONFIGURE(DBGU_STANDARD, UART0_BAUDRATE, BOARD_MCK);
    printf("-- Compiled: %s %s --\n\r", __DATE__, __TIME__);
    
    uart1_init();
  
    SysTick_Configure(1, BOARD_MCK / 1000, SysTick_Handler);
 
    TSD_Initialize();
     
    while(1);
}

