#define RTP   0xFFFFFA00
#define PMU_INT 22
/***********************RTI*************************/
#define RTI1                       0xFFFFFC00                         /*RTI Memory Map Address*/
#define RTI1_DWD                   1                                  /*Digital WatchDog Available*/
#define RTI1_DWD_ENB               0
#define NUM_RTI1_COUNTERS_2        1                                  /*No of FRC OverFlow Interrupts is 2*/
#define NUM_RTI1_CMP_INT_4         1                                  /*No of Compare Units is 4*/
#define DWWD_NMI_INT               0                                  /*Interrupt channel for NMI of DWWD*/
#define RTI1_COMP0_INT             2                                  /*Interrupt Channel For Compare 0*/
#define RTI1_COMP1_INT             3                                  /*Interrupt Channel For Compare 1*/
#define RTI1_COMP2_INT             4                                  /*Interrupt Channel For Compare 2*/
#define RTI1_COMP3_INT             5                                  /*Interrupt Channel For Compare 3*/
#define RTI1_OVL0_INT              6                                  /*Interrupt Channel For FRC0*/
#define RTI1_OVL1_INT              7                                  /*Interrupt Channel For FRC1*/
#define RTI1_TBASE_INT             8                                  /*Timebase Interrupt Channel*/
#define RTI1_DMA_REQ0              12                                 /*DMAREQ number for Compare 0*/
#define RTI1_DMA_REQ1              13                                 /*DMAREQ number for Compare 1*/
#define RTI1_DMA_REQ2              18                                 /*DMAREQ number for Compare 2*/
#define RTI1_DMA_REQ3              19                                 /*DMAREQ number for Compare 3*/


/***********************DCAN1*************************/
#define DCAN1                      0xFFF7DC00                         /*DCAN1 Peripheral Select Memory Map: Base Address*/
#define DCAN1_END                  0xFFF7DDFF                         /*DCAN1 Peripheral Select Memory Map: Ending Address*/
#define DCAN1_RAM                  0xFF1E0000                         /*DCAN1 Peripheral RAM: Base Address*/
#define DCAN1_LVL0_INT              16                                /*DCAN1 Request Assignment For Level 0 Interrupt*/
#define DCAN1_LVL1_INT              29                                /*DCAN1 Request Assignment For Level 1 Interrupt*/
#define DCAN1_IF3_INT               44                                /*DCAN1 Request Assignment For Interface Register 3 Interrupt*/
#define DCAN1_IF1_DMA_REQ           8                                 /*DCAN1 DMA request assignment For Interface Register 1*/
#define DCAN1_IF2_DMA_REQ           6                                 /*DCAN1 DMA request assignment For Interface Register 2*/
#define DCAN1_IF3_DMA_REQ           16                                /*DCAN1 DMA request assignment For Interface Register 3*/
#define DCAN1_RAM_INIT              5                                 /*DCAN1 RAM Select (Memory Initialization)*/
#define MEM_CH_DCAN1RAM            0x0020                             /*DCAN1 Bitmap representation of DCAN RAM Select*/
#define NUM_DCAN1_MESSAGES          64                                /*DCAN1 Total Number of Mailboxes/CAN Messages*/
#define DCAN1_PCR_PS                8                                 /*DCAN1 Peripheral Select */
#define NUM_DCAN1_PCR_QUAD          0                                 /*DCAN1 Quadrant In PS Frame*/


/***********************DCAN2*************************/
#define DCAN2                      0xFFF7DE00                         /*DCAN2 Peripheral Select Memory Map: Base Address*/
#define DCAN2_END                  0xFFF7DFFF                         /*DCAN2 Peripheral Select Memory Map: Ending Address*/
#define DCAN2_RAM                  0xFF1C0000                         /*DCAN2 Peripheral RAM: Base Address*/
#define DCAN2_LVL0_INT              35                                /*DCAN2 Request Assignment For Level 0 Interrupt*/
#define DCAN2_LVL1_INT              42                                /*DCAN2 Request Assignment For Level 1 Interrupt*/
#define DCAN2_IF3_INT               46                                /*DCAN2 Request Assignment For Interface Register 3 Interrupt*/
#define DCAN2_IF1_DMA_REQ           9                                 /*DCAN2 DMA request assignment For Interface Register 1*/
#define DCAN2_IF2_DMA_REQ           5                                 /*DCAN2 DMA request assignment For Interface Register 2*/
#define DCAN2_IF3_DMA_REQ           4                                 /*DCAN2 DMA request assignment For Interface Register 3*/
#define DCAN2_RAM_INIT              6                                 /*DCAN2 RAM Select (Memory Initialization)*/
#define MEM_CH_DCAN2RAM            0x0040                             /*DCAN2 Bitmap representation of DCAN RAM Select*/
#define NUM_DCAN2_MESSAGES          64                                /*DCAN2 Total Number of Mailboxes/CAN Messages*/
#define DCAN2_PCR_PS                8                                 /*DCAN2 Peripheral Select */
#define NUM_DCAN2_PCR_QUAD          2                                 /*DCAN2 Quadrant In PS Frame*/


/***********************DCAN3*************************/
#define DCAN3                      0xFFF7E000                         /*DCAN3 Peripheral Select Memory Map: Base Address*/
#define DCAN3_END                  0xFFF7E1FF                         /*DCAN3 Peripheral Select Memory Map: Ending Address*/
#define DCAN3_RAM                  0xFF1A0000                         /*DCAN3 Peripheral RAM: Base Address*/
#define DCAN3_LVL0_INT              45                                /*DCAN3 Request Assignment For Level 0 Interrupt*/
#define DCAN3_LVL1_INT              55                                /*DCAN3 Request Assignment For Level 1 Interrupt*/
#define DCAN3_IF3_INT               60                                /*DCAN3 Request Assignment For Interface Register 3 Interrupt*/
#define DCAN3_IF1_DMA_REQ           17                                /*DCAN3 DMA request assignment For Interface Register 1*/
#define DCAN3_IF2_DMA_REQ           20                                /*DCAN3 DMA request assignment For Interface Register 2*/
#define DCAN3_IF3_DMA_REQ           21                                /*DCAN3 DMA request assignment For Interface Register 3*/
#define DCAN3_RAM_INIT              10                                /*DCAN3 RAM Select (Memory Initialization)*/
#define MEM_CH_DCAN3RAM            0x0400                             /*DCAN3 Bitmap representation of DCAN RAM Select*/
#define NUM_DCAN3_MESSAGES          64                                /*DCAN3 Total Number of Mailboxes/CAN Messages*/
#define DCAN3_PCR_PS                7                                 /*DCAN3 Peripheral Select */
#define NUM_DCAN3_PCR_QUAD          0                                 /*DCAN3 Quadrant In PS Frame*/


/***********************DMA*************************/
#define DMA1                        0xFFFFF000                         /*DMA Memory Map Address*/
#define DMA_RAM                    0xFFF80000                         /*DMA RAM Memory Map Address*/
#define DMA_FTC_INT                 33                                /*Interrupt for FTC (Frame Transfer Complete)*/
#define DMA_LFS_INT                 34                                /*Interrupt for LFS (Last Frame Transfer Started)*/
#define DMA_HBC_INT                 39                                /*Interrupt for HBC (First Half of Block Complete)*/
#define DMA_BTC_INT                 40                                /*Interrupt for BTC (Block Transfer Complete)*/
#define NUM_DMA_CHANNELS            16                                /*Total Number of DMA Channels Available*/
#define NUM_DMA_REQUESTS            32                                /*Total Number of DMA Requests*/
#define DMA_RAM_INIT                1                                 /*Memory Initialization Channel Number*/
#define MEM_CH_DMARAM              0x0002                             /*Memory Initialization Channel Hex Bit Mapped*/
#define DMA_MASTER_ID              3                                  /*DMA Master ID*/


/***********************AWM1*************************/
#define AWM1                       0xFFF7C000                         /*AWM1 Peripheral Select Memory Map: Base Address*/
#define AWM1_END                   0xFFF7C1FF                         /*AWM1 Peripheral Select Memory Map: Ending Address*/
#define AWM1_RAM                   0xFF3E0000                         /*AWM1 Peripheral RAM: Base Address*/
#define AWM1_EV_INT                 14                                /*AWM1 Event Group Interrupt*/
#define AWM1_GP1_INT                15                                /*AWM1 SW Group1 Interrupt*/
#define AWM1_GP2_INT                28                                /*AWM1 SW Group2 Interrupt*/
#define AWM1_MTCI_INT               31                                /*AWM1 Magnitude Threshold Interrupt*/
#define AWM1_EV_DMA_REQ             7                                 /*AWM1 DMA request assignment For Event Group*/
#define AWM1_G1_DMA_REQ             10                                /*AWM1 DMA request assignment For Group 1*/
#define AWM1_G2_DMA_REQ             11                                /*AWM1 DMA request assignment For Group 2*/
#define AWM1_RAM_INIT               8                                 /*AWM1 RAM Select (Memory Initialization)*/
#define AWM1_NUM_OF_CHAN            24                                /*AWM1 Number Of Channels*/
#define AWM1_NUM_OF_MAGTHR          3                                 /*AWM1 Number of Magnitude Threshold registers*/
#define AWM1_RAM_WORDS              64                                /*AWM1 Number of Words Per Channel*/


/***********************AWM2*************************/
#define AWM2                       0xFFF7C200                         /*AWM2 Peripheral Select Memory Map: Base Address*/
#define AWM2_END                   0xFFF7C3FF                         /*AWM2 Peripheral Select Memory Map: Ending Address*/
#define AWM2_RAM                   0xFF3A0000                         /*AWM2 Peripheral RAM: Base Address*/
#define AWM2_EV_INT                 50                                /*AWM2 Event Group Interrupt*/
#define AWM2_GP1_INT                51                                /*AWM2 SW Group1 Interrupt*/
#define AWM2_GP2_INT                57                                /*AWM2 SW Group2 Interrupt*/
#define AWM2_MTCI_INT               59                                /*AWM2 Magnitude Threshold Interrupt*/
#define AWM2_EV_DMA_REQ             14                                /*AWM2 DMA request assignment For Event Group*/
#define AWM2_G1_DMA_REQ             16                                /*AWM2 DMA request assignment For Group 1*/
#define AWM2_G2_DMA_REQ             17                                /*AWM2 DMA request assignment For Group 2*/
#define AWM2_RAM_INIT               14                                /*AWM2 RAM Select (Memory Initialization)*/
#define AWM2_NUM_OF_CHAN            16                                /*AWM2 Number Of Channels*/
#define AWM2_NUM_OF_MAGTHR          3                                 /*AWM2 Number of Magnitude Threshold registers*/
#define AWM2_RAM_WORDS              64                                /*AWM2 Number of Words Per Channel*/


/***********************SYS*************************/
#define SYSTEM                     0xFFFFFF00                         /*SYS Base Address*/
#define SRAM_LB                    0x00001000                         /*SRAM Lower Boundary*/
#define SRAM_UB                    0x0003FFFC                         /*SRAM Upper Boundary*/
//#define DEVICE_ID                  0x802AAD05                         /*Device ID (rev A)*/
#define DEVICE_ID                  0x802AAD15                         /*Device ID (rev B)*/
#define ALL_channels               0x0001FDFE                         /*BitMap For RAM Mem Init(ALL_channels)*/
#define RAM_ILL_ADDRESS            0x00040000                         /*RAM Illegal Address*/
#define VBUS_ILL_ADDRESS           0xFD000000                         /*VBUS Illegal Address*/
#define FLASH_ILLEGAL              0x00300000                         /*Flash Illegal Address*/
#define PCR                        0xFFFFE000                         /*Base Address for PCR region*/
#define PLLCTL1                    0x2F025F00                         /*PLLCTL1 Register Value*/
#define PLLCTL2                    0x7FC07200                         /*PLLCTL2 Register Value*/
#define PLLCTL3					   0x2F025F00						  /*Added Manually-- Test value*/	
#define CSVSTAT                    0x00000073                         /*Value for CSVSTAT Register*/
#define CSDIS_VALUE                0x00000D7D                         /*CSDIS_VALUE*/
#define CLK_SRC_CHANNELS           0x00000073                         /*Value for CLK Sources (ORed)*/
#define SYS_SW_INT                  21                                /*VIM Line for System SW Interrupt*/
#define ECLK_PULL                   0                                 /*Default ECLK State(1-Pull Up 0-Pull Down)*/
#define RAM_SIL3                                                      /*RAM SIL3 Support Available in Device*/
#define BTRMSEL					   0xDEFA0005						  /*Added Manually -- boot ROM select register */
#define ECPCNTL1				   0x00000000						  /*Added MAnually - Test Value*/
#define ECPCNTL2				   0x00000000						  /*Added MAnually - Test Value*/
#define ECPCNTL3				   0x00000000						  /*Added MAnually - Test Value*/

/***********************VIM1*************************/
#define VIM                        0xFFFFFE00                         /*VIM Address In Memory Map*/
#define VIM_RAM                    0xFFF82000                         /*VIM RAM Address*/
#define VIM_PARITY                 0xFFFFFDEC                         /*VIM PARITY Address*/
#define VIM_CHANNELS                96                                /*Total Number of VIM Channels*/
#define PHANTOM_INT                -1                                 /*To be used in VIM_FIQ/VIM_IRQ functions as (PHANTOM_INT + 1)*/
#define VIM_RAM_MEM_INIT            2                                 /*VIM RAM Initialisation line*/
#define NO_NMI_RESV                 2                                 /*Total number of Reserved NMIs*/
#define VIM_NMI_DEFINE              2                                 /*Total number of Reserved NMIs*/
#define VIM_RAM_SIZE               VIM_CHANNELS                       /*Size of VIM RAM Implemented*/
#define INT_REMAP_CH1              12                                 /*VIM Channel 1 Re-mapping*/
#define INT_REMAP_CH2              13                                 /*VIM Channel 2 Re-mapping*/
#define INT_REMAP_CH3              14                                 /*VIM Channel 3 Re-mapping*/
#define INT_REMAP_CH4              15                                 /*VIM Channel 4 Re-mapping*/


/***********************ESM*************************/
#define ESM1                        0xFFFFF500                         /*ESM Memory Map Address*/
#define ESM_HIGH_PRIORITY_INT      0                                  /*VIM Line for ESM High Priority Interrupt*/
#define ESM_LOW_PRIORITY_INT       20                                 /*VIM Line for ESM Low Priority Interrupt*/

//CHANNEL MAPPING FOR ESM GROUP 1
#define ESM_G1_CHAN_1		     1    					    /*ESM Chan Reserved For MibADC2 parity*/
#define ESM_G1_CHAN_2              2                                  /*ESM Chan Reserved For DMA Memory Protection*/
#define ESM_G1_CHAN_3              3                                  /*ESM Chan Reserved For DMA PARITY*/
#define ESM_G1_CHAN_5              5                                  /*ESM Chan Reserved For DMA AHB-AP Imprecise Abort*/
#define ESM_G1_CHAN_6		     6					    /*ESM chan Reserved For FMC correctable error*/	
#define ESM_G1_CHAN_7              7                                  /*ESM Chan Reserved For NHET Parity*/
#define ESM_G1_CHAN_8		     8 					    /*ESM Chan Reserved	For HTU1/HTU2 parity*/
#define ESM_G1_CHAN_9		     9					    /*ESM Chan Reserved For HTU1/HTU2 MPU*/	
#define ESM_G1_CHAN_10             10                                 /*ESM Chan Reserved For PLL slip*/
#define ESM_G1_CHAN_11             11                                 /*ESM Chan Reserved For Clock Monitor*/
#define ESM_G1_CHAN_12		     12					    /*ESM Chan Reserved For FRAY parity*/		
#define ESM_G1_CHAN_13		     13					    /*ESM Chan Reserved For DMA-DMM Imprecise write error*/		
#define ESM_G1_CHAN_14		     14					    /*ESM Chan Reserved For FTU parity*/		
#define ESM_G1_CHAN_15             15                                 /*ESM Chan Reserved For VIM Ram Parity*/
#define ESM_G1_CHAN_16             16                                 /*ESM Chan Reserved For FTU Memory protection*/
#define ESM_G1_CHAN_17             17                                 /*ESM Chan Reserved For MiBSPI1 Parity*/
#define ESM_G1_CHAN_18             18                                 /*ESM Chan Reserved For MiBSPI3 Parity*/
#define ESM_G1_CHAN_19             19                                 /*ESM Chan Reserved For MibADC1 Parity*/
#define ESM_G1_CHAN_21             21                                 /*ESM Chan Reserved For DCAN1 Parity*/
#define ESM_G1_CHAN_22             22                                 /*ESM Chan Reserved For DCAN3 Parity*/
#define ESM_G1_CHAN_23             23                                 /*ESM Chan Reserved For DCAN2 Parity*/
#define ESM_G1_CHAN_24             24                                 /*ESM Chan Reserved For MiBSPI5 Parity*/
#define ESM_G1_CHAN_26             26                                 /*ESM Chan Reserved For RAM ECC single Error -EVEN*/
#define ESM_G1_CHAN_27             27                                 /*ESM Chan Reserved For CPU SELF Test*/
#define ESM_G1_CHAN_28             28                                 /*ESM Chan Reserved For RAM ECC single Error -ODD*/
#define ESM_G1_CHAN_30             30                                 /*ESM Chan Reserved For DCC*/
#define ESM_G1_CHAN_31             31                                 /*ESM Chan Reserved For CCMR4 Selftest*/
#define ESM_G1_CHAN_35             35                                 /*ESM Chan Reserved For FMC correctable*/
#define ESM_G1_CHAN_36             36                                 /*ESM Chan Reserved For FMC uncorrectable*/
#define ESM_G1_CHAN_37             37                                 /*ESM Chan Reserved For IOMM-Mux confuguration error*/
#define ESM_G1_CHAN_38             38                                 /*ESM Chan Reserved For Power domain compare error*/
#define ESM_G1_CHAN_39             39                                 /*ESM Chan Reserved For Power domain Selftest error*/
#define ESM_G1_CHAN_40             40                                 /*ESM Chan Reserved For e-FUSE Farm single bit error*/
#define ESM_G1_CHAN_41             41                                 /*ESM Chan Reserved For e-FUSE Farm Selftest error*/
#define ESM_G1_CHAN_42             42                                 /*ESM Chan Reserved For PLL#2 slip*/
#define ESM_G1_CHAN_62             62                                 /*ESM Chan Reserved For DCC2 error*/

//CHANNEL MAPPING FOR ESM GROUP 2
#define ESM_G2_CHAN_2              2                                  /*ESM Chan Reserved For CCMR4 Compare*/
#define ESM_G2_CHAN_4		     4					    /*ESM Chan Reserved For FMC uncorrectable error*/	
#define ESM_G2_CHAN_6              6                                  /*ESM Chan Reserved For RAM ECC Double error-EVEN*/
#define ESM_G2_CHAN_8              8                                  /*ESM Chan Reserved For RAM ODD Bank uncorrectable*/
#define ESM_G2_CHAN_10             10                                 /*ESM Chan Reserved For RAM ECC -Address Bus Parity - EVEN*/
#define ESM_G2_CHAN_12             12                                 /*ESM Chan Reserved For RAM ECC -Address Bus Parity - ODD*/
#define ESM_G2_CHAN_16             16                                 /*ESM Chan Reserved For ECC LiveLock*/

//CHANNEL MAPPING FOR ESM GROUP 3
#define ESM_G3_CHAN_1			1					    /*ESM Chan Reserved For eFUSE FARM autoload error */	
#define ESM_G3_CHAN_3			3					    /*ESM Chan Reserved For RAM even bank(B0TCM) ECC uncorrectable error*/
#define ESM_G3_CHAN_5			5					    /*ESM Chan Reserved For RAM odd bank(B1TCM) ECC uncorrectable error*/
#define ESM_G3_CHAN_7			7					    /*ESM Chan Reserved For FMC uncorrectable error bus1 abd bus2 interfaces*/

			

/***********************MCRC1*************************/
#define CRC1                      0xFE000000                         /*MCRC Memory Map Address*/
#define NUM_CRC1_CHANNELS_2                                           /*Two Channels : Assumption Chan 0 must be 'All Modes' and Chan 1 must be 'FULL+SEMI+AUTO'*/
#define CRC1_LVL0_INT               19                                /*MCRC Level 0 Interrupt*/
#define CRC1_DMA_REQ0               26                                /*MCRC DMA Request For Channel 0*/
#define CRC1_DMA_REQ1               27                                /*MCRC DMA Request For Channel 1*/


/***********************DMM*************************/
#define DMM                        0xFFFFF700                         /*DMM Memory Map Address*/
#define DMM_LVL0_INT                36                                /*DMM Level 0 Interrupt*/
#define DMM_LVL1_INT                43                                /*DMM Level 1 Interrupt*/
#define NUM_DMMDATA_PINS            16                                /*No Of DMM Data Pins*/


/***********************NHET1*************************/
#define NHET1                      0xFFF7B800                         /*NHET Base Address*/
#define NHET1_END                  0xFFF7B8FF                         /*NHET End Address (Calculated: 0xFF From NHET Base Address) */
#define NHET1_RAM                  0xFF460000                         /*NHET RAM Base Address*/
#define NHET1_LVL0_INT              10                                /*VIM Line NHET Level 0 Interrupt*/
#define NHET1_LVL1_INT              24                                /*VIM Line NHET Level 1 interrupt*/
#define NHET1_RAM_INIT              3                                 /*NHET Auto-initialization Line*/
#define MEM_CH_NHET1_RAM           0x0008                             /*NHET Auto-initialization Line*/
#define NHET1_RAM_NUMWORDS          159                               /*Implemented NHET RAM*/
#define NUM_NHET1_PINS              32                                /*Number of NHET pins*/
#define NHET1_DMA_REQ4              20                                /*Channel ID for NHET DMA Request(4)*/
#define NHET1_DMA_REQ5              21                                /*Channel ID for NHET DMA Request(5)*/
#define NHET1_DMA_REQ6              24                                /*Channel ID for NHET DMA Request(6)*/
#define NHET1_DMA_REQ7              25                                /*Channel ID for NHET DMA Request(7)*/


/***********************NHET2*************************/
#define NHET2                      0xFFF7B900                         /*NHET Base Address*/
#define NHET2_END                  0xFFF7B9FF                         /*NHET End Address (Calculated: 0xFF From NHET Base Address) */
#define NHET2_RAM                  0xFF440000                         /*NHET RAM Base Address*/
#define NHET2_LVL0_INT              63                                /*VIM Line NHET Level 0 Interrupt*/
#define NHET2_LVL1_INT              73                                /*VIM Line NHET Level 1 interrupt*/
#define NHET2_RAM_INIT              15                                /*NHET Auto-initialization Line*/
#define MEM_CH_NHET2_RAM           0x8000                             /*NHET Auto-initialization Line*/
#define NHET2_RAM_NUMWORDS          159                               /*Implemented NHET RAM*/
#define NUM_NHET2_PINS              20                                /*Number of NHET pins*/
#define NHET2_DMA_REQ4              20                                /*Channel ID for NHET DMA Request(4)*/
#define NHET2_DMA_REQ5              21                                /*Channel ID for NHET DMA Request(5)*/
#define NHET2_DMA_REQ6              24                                /*Channel ID for NHET DMA Request(6)*/
#define NHET2_DMA_REQ7              25                                /*Channel ID for NHET DMA Request(7)*/


/***********************HTU1*************************/
#define HTU1                       0xFFF7A400                         /*HTU Base Address*/
#define HTU1_RAM                   0xFF4E0000                         /*HTU RAM Base Address*/
#define HTU1_LVL0_INT               11                                /*VIM Line for HTU Level 0 Interrupt*/
#define HTU1_LVL1_INT               25                                /*VIM Line for HTU Level 1 Interrupt*/
#define HTU1_RAM_INIT               4                                 /*HTU RAM Memory Auto-initialization Line*/
#define HTU1_END                   0xFFF7A4FF                         /*HTU End Address (Calculated: 0xFF From HTU Base Address) */
#define HTU1_RAM_PARITY            0xFF4E0200                         /*HTU Parity Memory (Calculated: 0x200 From HTU RAM Base Address) */
#define HTU1_DCP_PCKTS			    8								  /*Added Manually*/

/***********************HTU2*************************/
#define HTU2                       0xFFF7A500                         /*HTU Base Address*/
#define HTU2_RAM                   0xFF4C0000                         /*HTU RAM Base Address*/
#define HTU2_LVL0_INT               65                                /*VIM Line for HTU Level 0 Interrupt*/
#define HTU2_LVL1_INT               75                                /*VIM Line for HTU Level 1 Interrupt*/
#define HTU2_RAM_INIT               16                                /*HTU RAM Memory Auto-initialization Line*/
#define HTU2_END                   0xFFF7A5FF                         /*HTU End Address (Calculated: 0xFF From HTU Base Address) */
#define HTU2_RAM_PARITY            0xFF4C0200                         /*HTU Parity Memory (Calculated: 0x200 From HTU RAM Base Address) */
#define HTU2_DCP_PCKTS   			8  
/*************************************************GIO1***********************************************/
#define GIO1                                      0xFFF7BC00                              /*GIO Address*/
#define GIO1_LVL0_INT                              9                                      /*VIM channel number for Level 0 Interrupt*/
#define GIO1_LVL1_INT                              23                                     /*VIM channel number for Level 1 Interrupt*/
#define GIO1_Pins_on_PortA                         8                                      /*Number of Pins Port A*/
#define GIO1_Pins_on_PortB                         8                                      /*Number of Pins Port B*/
#define GIO1_Interrupt_capable_pins_on_PortA       8                                      /*Number of Intr Capable Pins Port A*/
#define GIO1_Interrupt_capable_pins_on_PortB       8                                      /*Number of Intr Capable Pins Port B*/


/***********************LIN*************************/
#define LIN1                       0xFFF7E400                         /*LIN Base Address*/
#define LIN1_LVL0_INT               13                                /*VIM Line LIN Level 0 Interrupt*/
#define LIN1_LVL1_INT               27                                /*VIM Line LIN Level 1 interrupt*/
#define LIN1_RX_DMA_REQ             28                                /*Channel ID for LIN RX DMA Request*/
#define LIN1_TX_DMA_REQ             29                                /*Channel ID for LIN TX DMA Request*/


/***********************SCI*************************/
#define SCI1                       0xFFF7E400                         /*SCI Base Address*/
#define SCI1_LVL0_INT               13                               /*VIM Line SCI Level 0 Interrupt*/
#define SCI1_LVL1_INT               27                                /*VIM Line SCI Level 1 interrupt*/
#define SCI1_RX_DMA_REQ             28                                /*Channel ID for SCI RX DMA Request*/
#define SCI1_TX_DMA_REQ             29                                /*Channel ID for SCI TX DMA Request*/


/***********************SCI*************************/
#define SCI2                       0xFFF7E500                         /*SCI Base Address*/
#define SCI2_LVL0_INT               64                                /*VIM Line SCI Level 0 Interrupt*/
#define SCI2_LVL1_INT               74                                /*VIM Line SCI Level 1 interrupt*/
#define SCI2_RX_DMA_REQ             30                                /*Channel ID for SCI RX DMA Request*/
#define SCI2_TX_DMA_REQ             31                                /*Channel ID for SCI TX DMA Request*/


/***********************DCC*************************/
#define DCC1                        0xFFFFEC00                         /*Base Address of DCC Registers*/


/***********************DCC*************************/
#define DCC2                        0xFFFFF400                         /*Base Address of DCC Registers*/

/************************* FRAY *************************/
/*			Added manually				  */
#define FRAY1            	0xFFF7C800
#define FRAY1_T1C_INT		62						/*FLEXRAY LINES*/
#define FRAY1_TOC_INT		52
#define FRAY1_LVL1_INT      32
#define FRAY1_LVL0_INT      18
#define FRAY1_PARITY_INT    ESM_G1_CHAN_12

/***********************FTU*************************/
#define FRAYTU1                    0xFFF7A000                         /*FTU Base Address*/
#define FRAYTU1_END                0xFFF7A1FF                         /*FTU End Address (Calculated: 0x1FF From HET Base Address) */
#define FRAYTU1_RAM                0xFF500000                         /*FTU RAM Base Address*/
#define FRAYTU1_ERR_INT             58                                /*VIM Line for Flexray TU Error Interrupt*/
#define FRAYTU1_TRSFR_ST_INT        48                                /*VIM Line for Flexray TU Transfer Status Interrupt*/
#define FRAYTU1_RAM_INIT            13                                /*Flexray TU RAM Memory Auto-initialization*/
#define FRAYTU1_RAM_WORDS           128                               /*Number of FTU RAM words*/
		

/***********************POM*************************/
#define POM                        0xFFA04000                         /*POM Base Address*/
#define POM_ADDRMAP_START          0x60000000                         /*POM Address Mapping Start*/
#define POM_ADDRMAP_END            0x603FFFFF                         /*POM Address Mapping End*/
#define NUM_POM_REG                 32                                /*No Of POM Regions Supported*/


/***********************CCM1*************************/
#define CCM1                       0xFFFFF600                         /*CCM Memory Map Address*/


/***********************EMIF*************************/
#define EMIF1                      0xFCFFE800                         /*EMIF Base Address*/
//#define NUM_EMIF1_CS                4                                 /*No of Chip Select(s)*/
#define NUM_EMIF1_CS                3 	//modified for Async Memory only                                /*No of Chip Select(s)*/
#define EMIF1_CS0_ADDRMAP_START    0x80000000                         /*Start Address Of CS0*/
#define EMIF1_CS0_ADDRMAP_END      0x9FFFFFFF                         /*End Address Of CS0*/
#define EMIF1_CS1_ADDRMAP_START    0x60000000                         /*Start Address Of CS1*/
#define EMIF1_CS1_ADDRMAP_END      0x63FFFFFF                         /*End Address Of CS1*/
#define EMIF1_CS2_ADDRMAP_START    0x64000000                         /*Start Address Of CS2*/
#define EMIF1_CS2_ADDRMAP_END      0x67FFFFFF                         /*End Address Of CS2*/
#define EMIF1_CS3_ADDRMAP_START    0x68000000                         /*Start Address Of CS3*/
#define EMIF1_CS3_ADDRMAP_END      0x6BFFFFFF                         /*End Address Of CS3*/

#if 0
#define EMIF1_CS1_ADDRMAP_START    0x60000000                         /*Start Address Of CS1*/
#define EMIF1_CS1_ADDRMAP_END      0x63FFFFFF                         /*End Address Of CS1*/
#define EMIF1_CS2_ADDRMAP_START    0x64000000                         /*Start Address Of CS2*/
#define EMIF1_CS2_ADDRMAP_END      0x67FFFFFF                         /*End Address Of CS2*/
#define EMIF1_CS3_ADDRMAP_START    0x68000000                         /*Start Address Of CS3*/
#define EMIF1_CS3_ADDRMAP_END      0x6BFFFFFF                         /*End Address Of CS3*/
#endif	

#if 1

	#define ASYNC_MEM_CONF SELECT_STROBE_MODE_DISABLE | EXTEND_WAIT_MODE_DISABLE | ASIZE_16BIT_DATA

	#define READ_STROBE_SETUP_TIME 		0xF	
	#define READ_STROBE_DURATION_TIME 	0x3F		
	#define READ_STROBE_HOLD_TIME 		0x7	

	#define WRITE_STROBE_SETUP_TIME 	0xF		
	#define WRITE_STROBE_DURATION_TIME 	0x3F		
	#define WRITE_STROBE_HOLD_TIME 		0x7

	#define ASYNC_MEM_TURN_ARND_CYC 0x3

//	#define ASYNC_MEM_TURN_ARND_CYC 0x0

	#define	ASYNC_MEM_READ_CONF  (READ_STROBE_HOLD_TIME |(READ_STROBE_DURATION_TIME <<3)|(READ_STROBE_SETUP_TIME <<9))			
	#define ASYNC_MEM_WRITE_CONF (WRITE_STROBE_HOLD_TIME |(WRITE_STROBE_DURATION_TIME <<3)|(WRITE_STROBE_SETUP_TIME <<9))	

#endif

#define PM_EMIF_START 0x60000000
			
#define EMIF_START 0x64000000
#define EMIF_END   0x64800000

/***********************F021_ECC*************************/
/*			Added manually				  */
//#define FLASH                      0xFFF87000                         /*FWM ECC Base Address In Memory Map*/
#define  SPLIT			     1


/***********************I2C*************************/
#define I2C1                       0xFFF7D400                         /*I2C Base Address*/
#define I2C1_LVL0_INT               66                                /*VIM Line I2C Level 0 Interrupt*/
#define I2C1_RX_DMA_REQ             10                                /*Channel ID for I2C RX DMA Request*/
#define I2C1_TX_DMA_REQ             11                                /*Channel ID for I2C TX DMA Request*/


/***********************TCRAMW*************************/
#define RAM_ECC_ODD                0xFFFFF900                         /*Base Address of RAM ECC ODD*/
#define RAM_ECC_EVN                0xFFFFF800                         /*Base Address of RAM ECC EVN*/


/***********************RTP1*************************/
#define RTP                        0xFFFFFA00                         /*RTP Base Address In Memory Map*/
#define RTP_RAM_MEM                0xFFF83000                         /*RTP RAM Address In Memory Map*/
#define NUM_RTPDATA_PINS            16                                /*Number of RTP Transmit Data Pins*/
#define RTP_DMM_RAM_REG1                0x2800
#define RTP_DMM_RAM_REG2                0x2C00
#define RTP_DMM_DMA_RAM_REG1    0x4000
#define RTP_DMM_DMA_RAM_REG2    0x4400
 
/*****************************************************************************/


/***********************SPI1*************************/
#define SPI1                       0xFFF7F400                         /*SPI Memory Map : Base Address*/
#define SPI1_LVL0_INT               12                                /*SPI Level 0 interrupt*/
#define SPI1_LVL1_INT               26                                /*SPI Level 1 interrupt*/
#define SPI1_RX_DMA_REQ             0                                 /*SPI RX DMA Request Line*/
#define SPI1_TX_DMA_REQ             1                                 /*SPI TX DMA Request Line*/
#define NUM_SPI1_SIMO_PINS          2                                 /*No of SPI SIMO Pins*/
#define NUM_SPI1_SOMI_PINS          2                                 /*No of SPI SOMI Pins*/
#define NUM_SPI1_CS_PINS            6                                 /*No of SPI Chip Select Pins*/
#define NUM_SPI1_ENA_PINS           1                                 /*Is Enable Pin Available*/
#define SPI1_PULLDIS_TIEOFF        0x00000000                         /*Reset SPI PULL Disable Value*/
#define SPI1_PULLSEL_TIEOFF        0x03030F3F                         /*Reset SPI PULL Select Value*/


/***********************SPI2*************************/
#define SPI2                       0xFFF7F600                         /*SPI Memory Map : Base Address*/
#define SPI2_LVL0_INT               17                                /*SPI Level 0 interrupt*/
#define SPI2_LVL1_INT               30                                /*SPI Level 1 interrupt*/
#define SPI2_RX_DMA_REQ             2                                 /*SPI RX DMA Request Line*/
#define SPI2_TX_DMA_REQ             3                                 /*SPI TX DMA Request Line*/
#define NUM_SPI2_SIMO_PINS          1                                 /*No of SPI SIMO Pins*/
#define NUM_SPI2_SOMI_PINS          1                                 /*No of SPI SOMI Pins*/
#define NUM_SPI2_CS_PINS            2                                 /*No of SPI Chip Select Pins*/
#define NUM_SPI2_ENA_PINS           1                                 /*Is Enable Pin Available*/
#define SPI2_PULLDIS_TIEOFF        0x00000000                         /*Reset SPI PULL Disable Value*/
#define SPI2_PULLSEL_TIEOFF        0x01010F03                         /*Reset SPI PULL Select Value*/


/***********************SPI3*************************/
#define SPI3                       0xFFF7F800                         /*SPI Memory Map : Base Address*/
#define SPI3_LVL0_INT               37                                /*SPI Level 0 interrupt*/
#define SPI3_LVL1_INT               38                                /*SPI Level 1 interrupt*/
#define SPI3_RX_DMA_REQ             14                                /*SPI RX DMA Request Line*/
#define SPI3_TX_DMA_REQ             15                                /*SPI TX DMA Request Line*/
#define NUM_SPI3_CS_PINS            6                                 /*No of SPI Chip Select Pins*/
#define NUM_SPI3_ENA_PINS           1                                 /*Is Enable Pin Available*/
#define SPI3_PULLDIS_TIEOFF        0x00000000                         /*Reset SPI PULL Disable Value*/
#define SPI3_PULLSEL_TIEOFF        0x01010F3F                         /*Reset SPI PULL Select Value*/


/***********************SPI4*************************/
#define SPI4                       0xFFF7FA00                         /*SPI Memory Map : Base Address*/
#define SPI4_LVL0_INT               49                                /*SPI Level 0 interrupt*/
#define SPI4_LVL1_INT               54                                /*SPI Level 1 interrupt*/
#define SPI4_RX_DMA_REQ             24                                /*SPI RX DMA Request Line*/
#define SPI4_TX_DMA_REQ             25                                /*SPI TX DMA Request Line*/
#define NUM_SPI4_CS_PINS            1                                 /*No of SPI Chip Select Pins*/
#define NUM_SPI4_ENA_PINS           1                                 /*Is Enable Pin Available*/
#define SPI4_PULLDIS_TIEOFF        0x00000000                         /*Reset SPI PULL Disable Value*/
#define SPI4_PULLSEL_TIEOFF        0x01010F01                         /*Reset SPI PULL Select Value*/


/***********************SPI5*************************/
#define SPI5                       0xFFF7FC00                         /*SPI Memory Map : Base Address*/
#define SPI5_LVL0_INT               53                                /*SPI Level 0 interrupt*/
#define SPI5_LVL1_INT               56                                /*SPI Level 1 interrupt*/
#define SPI5_RX_DMA_REQ             30                                /*SPI RX DMA Request Line*/
#define SPI5_TX_DMA_REQ             31                                /*SPI TX DMA Request Line*/
#define NUM_SPI5_SIMO_PINS          4                                 /*No of SPI SIMO Pins*/
#define NUM_SPI5_SOMI_PINS          4                                 /*No of SPI SOMI Pins*/
#define NUM_SPI5_CS_PINS            4                                 /*No of SPI Chip Select Pins*/
#define NUM_SPI5_ENA_PINS           1                                 /*Is Enable Pin Available*/
#define SPI5_PULLDIS_TIEOFF        0x00000000                         /*Reset SPI PULL Disable Value*/
#define SPI5_PULLSEL_TIEOFF        0x0F0F0F0F                         /*Reset SPI PULL Select Value*/



/***********************MIBSPI1*************************/
#define MIBSPI1                    0xFFF7F400                         /*MIBSPI Memory Map : Base Address*/
#define MIBSPI1_LVL0_INT            12                                /*MIBSPI Level 0 interrupt*/
#define MIBSPI1_LVL1_INT            26                                /*MIBSPI Level 1 interrupt*/
#define MIBSPI1_RAM                0xFF0E0000                         /*MIBSPI RAM Base Address*/
#define MIBSPI1_RAM_WORDS           128                               /*Number of MIBSPI RAM words*/
#define NUM_MIBSPI1_DMA_SOURCES     16                                /*No of MIBSPI DMA Sources Supported*/
#define MIBSPI1_SRC0_DMA_REQ        1                                 /*MIBSPI DMA Source 0 Request line*/
#define MIBSPI1_SRC1_DMA_REQ        0                                 /*MIBSPI DMA Source 1 Request line*/
#define MIBSPI1_SRC2_DMA_REQ        4                                 /*MIBSPI DMA Source 2 Request line*/
#define MIBSPI1_SRC3_DMA_REQ        5                                 /*MIBSPI DMA Source 3 Request line*/
#define MIBSPI1_SRC4_DMA_REQ        8                                 /*MIBSPI DMA Source 4 Request line*/
#define MIBSPI1_SRC5_DMA_REQ        9                                 /*MIBSPI DMA Source 5 Request line*/
#define MIBSPI1_SRC6_DMA_REQ        12                                /*MIBSPI DMA Source 6 Request line*/
#define MIBSPI1_SRC7_DMA_REQ        13                                /*MIBSPI DMA Source 7 Request line*/
#define MIBSPI1_SRC8_DMA_REQ        16                                /*MIBSPI DMA Source 8 Request line*/
#define MIBSPI1_SRC9_DMA_REQ        17                                /*MIBSPI DMA Source 9 Request line*/
#define MIBSPI1_SRC10_DMA_REQ       22                                /*MIBSPI DMA Source 10 Request line*/
#define MIBSPI1_SRC11_DMA_REQ       23                                /*MIBSPI DMA Source 11 Request line*/
#define MIBSPI1_SRC12_DMA_REQ       26                                /*MIBSPI DMA Source 12 Request line*/
#define MIBSPI1_SRC13_DMA_REQ       27                                /*MIBSPI DMA Source 13 Request line*/
#define MIBSPI1_SRC14_DMA_REQ       30                                /*MIBSPI DMA Source 14 Request line*/
#define MIBSPI1_SRC15_DMA_REQ       31                                /*MIBSPI DMA Source 15 Request line*/
#define SPI1_RX_DMA_REQ             0                                 /*MIBSPI(Compatibility Mode) RX DMA Request line*/
#define SPI1_TX_DMA_REQ             1                                 /*MIBSPI(Compatibility Mode) TX DMA Request line*/
#define MIBSPI1_RAM_INIT            7                                 /*MIBSPI RAM memory auto-initialization*/
#define NUM_MIBSPI1_SIMO_PINS       2                                 /*No of MIBSPI SIMO Pins*/
#define NUM_MIBSPI1_SOMI_PINS       2                                 /*No of MIBSPI SOMI Pins*/
#define NUM_MIBSPI1_CS_PINS         6                                 /*No of MIBSPI Chip Select Pins*/
#define NUM_MIBSPI1_ENA_PINS        1                                 /*Is Enable Pin Available*/
#define NUM_MIBSPI1_TRNSFR_GROUPS   8                                 /*No of Transfer Groups Supported*/


/***********************MIBSPI3*************************/
#define MIBSPI3                    0xFFF7F800                         /*MIBSPI Memory Map : Base Address*/
#define MIBSPI3_LVL0_INT            37                                /*MIBSPI Level 0 interrupt*/
#define MIBSPI3_LVL1_INT            38                                /*MIBSPI Level 1 interrupt*/
#define MIBSPI3_RAM                0xFF0C0000                         /*MIBSPI RAM Base Address*/
#define MIBSPI3_RAM_WORDS           128                               /*Number of MIBSPI RAM words*/
#define NUM_MIBSPI3_DMA_SOURCES     16                                /*No of MIBSPI DMA Sources Supported*/
#define MIBSPI3_SRC0_DMA_REQ        15                                /*MIBSPI DMA Source 0 Request line*/
#define MIBSPI3_SRC1_DMA_REQ        14                                /*MIBSPI DMA Source 1 Request line*/
#define MIBSPI3_SRC2_DMA_REQ        4                                 /*MIBSPI DMA Source 2 Request line*/
#define MIBSPI3_SRC3_DMA_REQ        5                                 /*MIBSPI DMA Source 3 Request line*/
#define MIBSPI3_SRC4_DMA_REQ        8                                 /*MIBSPI DMA Source 4 Request line*/
#define MIBSPI3_SRC5_DMA_REQ        9                                 /*MIBSPI DMA Source 5 Request line*/
#define MIBSPI3_SRC6_DMA_REQ        12                                /*MIBSPI DMA Source 6 Request line*/
#define MIBSPI3_SRC7_DMA_REQ        13                                /*MIBSPI DMA Source 7 Request line*/
#define MIBSPI3_SRC8_DMA_REQ        16                                /*MIBSPI DMA Source 8 Request line*/
#define MIBSPI3_SRC9_DMA_REQ        17                                /*MIBSPI DMA Source 9 Request line*/
#define MIBSPI3_SRC10_DMA_REQ       22                                /*MIBSPI DMA Source 10 Request line*/
#define MIBSPI3_SRC11_DMA_REQ       23                                /*MIBSPI DMA Source 11 Request line*/
#define MIBSPI3_SRC12_DMA_REQ       26                                /*MIBSPI DMA Source 12 Request line*/
#define MIBSPI3_SRC13_DMA_REQ       27                                /*MIBSPI DMA Source 13 Request line*/
#define MIBSPI3_SRC14_DMA_REQ       30                                /*MIBSPI DMA Source 14 Request line*/
#define MIBSPI3_SRC15_DMA_REQ       31                                /*MIBSPI DMA Source 15 Request line*/
#define SPI3_RX_DMA_REQ             14                                /*MIBSPI(Compatibility Mode) RX DMA Request line*/
#define SPI3_TX_DMA_REQ             15                                /*MIBSPI(Compatibility Mode) TX DMA Request line*/
#define MIBSPI3_RAM_INIT            11                                /*MIBSPI RAM memory auto-initialization*/
#define NUM_MIBSPI3_SIMO_PINS       1                                 /*No of MIBSPI SIMO Pins*/
#define NUM_MIBSPI3_SOMI_PINS       1                                 /*No of MIBSPI SOMI Pins*/
#define NUM_MIBSPI3_CS_PINS         6                                 /*No of MIBSPI Chip Select Pins*/
#define NUM_MIBSPI3_ENA_PINS        1                                 /*Is Enable Pin Available*/
#define NUM_MIBSPI3_TRNSFR_GROUPS   8                                 /*No of Transfer Groups Supported*/


/***********************MIBSPI5*************************/
#define MIBSPI5                    0xFFF7FC00                         /*MIBSPI Memory Map : Base Address*/
#define MIBSPI5_LVL0_INT            53                                /*MIBSPI Level 0 interrupt*/
#define MIBSPI5_LVL1_INT            56                                /*MIBSPI Level 1 interrupt*/
#define MIBSPI5_RAM                0xFF0A0000                         /*MIBSPI RAM Base Address*/
#define MIBSPI5_RAM_WORDS           128                               /*Number of MIBSPI RAM words*/
#define NUM_MIBSPI5_DMA_SOURCES     16                                /*No of MIBSPI DMA Sources Supported*/
#define MIBSPI5_SRC0_DMA_REQ        31                                /*MIBSPI DMA Source 0 Request line*/
#define MIBSPI5_SRC1_DMA_REQ        30                                /*MIBSPI DMA Source 1 Request line*/
#define MIBSPI5_SRC2_DMA_REQ        6                                 /*MIBSPI DMA Source 2 Request line*/
#define MIBSPI5_SRC3_DMA_REQ        7                                 /*MIBSPI DMA Source 3 Request line*/
#define MIBSPI5_SRC4_DMA_REQ        10                                /*MIBSPI DMA Source 4 Request line*/
#define MIBSPI5_SRC5_DMA_REQ        11                                /*MIBSPI DMA Source 5 Request line*/
#define MIBSPI5_SRC6_DMA_REQ        14                                /*MIBSPI DMA Source 6 Request line*/
#define MIBSPI5_SRC7_DMA_REQ        15                                /*MIBSPI DMA Source 7 Request line*/
#define MIBSPI5_SRC8_DMA_REQ        18                                /*MIBSPI DMA Source 8 Request line*/
#define MIBSPI5_SRC9_DMA_REQ        19                                /*MIBSPI DMA Source 9 Request line*/
#define MIBSPI5_SRC10_DMA_REQ       22                                /*MIBSPI DMA Source 10 Request line*/
#define MIBSPI5_SRC11_DMA_REQ       23                                /*MIBSPI DMA Source 11 Request line*/
#define MIBSPI5_SRC12_DMA_REQ       24                                /*MIBSPI DMA Source 12 Request line*/
#define MIBSPI5_SRC13_DMA_REQ       25                                /*MIBSPI DMA Source 13 Request line*/
#define MIBSPI5_SRC14_DMA_REQ       28                                /*MIBSPI DMA Source 14 Request line*/
#define MIBSPI5_SRC15_DMA_REQ       29                                /*MIBSPI DMA Source 15 Request line*/
#define SPI5_RX_DMA_REQ             30                                /*MIBSPI(Compatibility Mode) RX DMA Request line*/
#define SPI5_TX_DMA_REQ             31                                /*MIBSPI(Compatibility Mode) TX DMA Request line*/
#define MIBSPI5_RAM_INIT            12                                /*MIBSPI RAM memory auto-initialization*/
#define NUM_MIBSPI5_SIMO_PINS       4                                 /*No of MIBSPI SIMO Pins*/
#define NUM_MIBSPI5_SOMI_PINS       4                                 /*No of MIBSPI SOMI Pins*/
#define NUM_MIBSPI5_CS_PINS         4                                 /*No of MIBSPI Chip Select Pins*/
#define NUM_MIBSPI5_ENA_PINS        1                                 /*Is Enable Pin Available*/
#define NUM_MIBSPI5_TRNSFR_GROUPS   8                                 /*No of Transfer Groups Supported*/

/***********************PBIST***********************************************************************************************/


#define PBIST 				0xFFFFE500  	/*Base Address*/

#define PBIST_CH1_ALGO 			0x03			/*PBIST  ROM */
#define PBIST_CH1 			0x0001

#define PBIST_CH2_ALGO 			0x03			/* STC MEM  - ROM*/	
#define PBIST_CH2 			0x0002

#define PBIST_CH3_ALGO 			0x001554		/* DCAN1	- Two port*/
#define PBIST_CH3 			0x0004

#define PBIST_CH4_ALGO 			0x001554     	/* DCAN2	- Two port */
#define PBIST_CH4 			0x0008

#define PBIST_CH5_ALGO 			0x001554		/* DCAN3 	- Two port */
#define PBIST_CH5 			0x00010

#define PBIST_CH6_ALGO 			0x2AA8			/* ESRAM 	- single Port*/
#define PBIST_CH6 			0x0020

#define PBIST_CH7_ALGO 			0x001554		/* MIBSPI1  - Two port*/
#define PBIST_CH7 			0x0040

#define PBIST_CH8_ALGO 			0x001554		/* MIBSPI3 	- Two port */
#define PBIST_CH8 			0x0080

#define PBIST_CH9_ALGO 			0x001554		/* MIBSPI5 	- Two port*/
#define PBIST_CH9 			0x0100

#define PBIST_CH10_ALGO 		0x000554 		/* VIM		- Two port Only sliced algo */
#define PBIST_CH10 			0x0200

#define PBIST_CH11_ALGO 		0x001554		/* MIBADC1  - Two port */
#define PBIST_CH11 			0x0400

#define PBIST_CH12_ALGO 		0x000554		/* DMA		-  Two port */
#define PBIST_CH12 			0x0800

#define PBIST_CH13_ALGO 		0x000554		/* NHET1	- Two port*/
#define PBIST_CH13 			0x1000

#define PBIST_CH14_ALGO			0x001554		/* HTU1		- Two port */
#define PBIST_CH14			0x2000	

#define PBIST_CH15_ALGO			0x001554		/* RTP 		- Two Port */
#define PBIST_CH15			0x4000	

#define PBIST_CH16_ALGO			0x001554		/* Flexray - Two Port */
#define PBIST_CH16			0x8000	

#define PBIST_CH17_ALGO		0x2AA8				/* Flexray - Single port */
#define PBIST_CH17			0x10000			


#define PBIST_CH18_ALGO			0x001554		/* ADM2  - Two Port */
#define PBIST_CH18			0x20000		


#define PBIST_CH19_ALGO			0x0554			/* NHET2 - Single Port */
#define PBIST_CH19			0x40000


#define PBIST_CH20_ALGO			0x1554			/* HTU2 - Single Port */
#define PBIST_CH20			0x80000


#define PBIST_CH21_ALGO			0x2AA8	 		/*  ESRAMW - Single Port */
#define PBIST_CH21			0x100000


#define PBIST_CH22_ALGO			0x2AA8			/* ESRAMW - Single Port */
#define PBIST_CH22			0x200000


#define PBIST_CH23_ALGO			0x00554			/* EMAC - Two Port */
#define PBIST_CH23			0x400000


#define PBIST_CH24_ALGO			0x1554			/* EMAC - Single Port */
#define PBIST_CH24			0x800000


#define PBIST_CH25_ALGO			0x2AA8			/* EMAC- Single Port */
#define PBIST_CH25			0x1000000

#define PBIST_CH26_ALGO			0x1554			/* USB - Two Port */
#define PBIST_CH26			0x2000000

#define PBIST_CH27_ALGO			0x2AA8			/* USB - Single Port */
#define PBIST_CH27			0x4000000

#define PBIST_CH28_ALGO			0x2AA8			/* ESRAMW - Single Port */
#define PBIST_CH28			0x8000000






		
/***********************BMM1*************************/
#define RAM_DMA_CH                  2                                 /*RAM DMA Channel Number*/


/***********************STC1*************************/
#define STC1                 0xFFFFE600                                 /*STC Base Address*/


#define AWM_SWITCH_MODE 0x1


/*************************************************eMAC1***********************************************/
#define EMAC1                                      0xFCF78000                              /*EMAC1 register Address*/
#define EMAC1_CPPI_RAM                     0xFC520000                              /* CPPI RAM */
#define EMAC1_RX_THRESH_INT          		78                                            /* VIM channel for receive threshold Interrupt*/
#define EMAC1_RX_INT                        79                                            /* VIM channel for receive  Interrupt*/
#define EMAC1_TX_INT                        77                                            /* VIM channel for transmit Interrupt*/
#define EMAC1_MISC_INT                      76                                            /* VIM channel for MISC Interrupt*/

#define MDIO1                                      0xFCF78900                              /*MDIO1 register Address*/
#define CPGMACSS_WRAPPER1              0xFCF78800                              /*EMAC1 Wrapper register Address*/

/****************************************EMAC**************************************************************/
#define EMAC_MDIO_CLKDIV    44
#define EMAC_REGS_NUMSTATS  36         /* Number of statistics regs */
#define EMAC_INT_NONE        0
#define EMAC_INT_LEVEL       1
#define EMAC_INT_PULSE       2
#define EMAC_INT_BOTH        3
#define EMAC_INT_NUM         4   // Number of interrupts for EMAC: Tx, Rx, RxThresh, Misc

#define EMAC_LOOP_NONE       0   // No loopback (can use this for TB loopback too)
#define EMAC_LOOP_INT        1   // Use internal built-in loopback
#define EMAC_LOOP_TB         2   // Use TB loopback (transparent to testcase/module)
#define EMAC_LOOP_PHY        3   // Use physical RJ45 loopback
#define EMAC_LOOP_DEFAULT    EMAC_LOOP_TB

#define EMAC_RMII_10MBIT        0
#define EMAC_RMII_100MBIT       1
#define EMAC_RMIISPEED_DEFAULT  EMAC_RMII_100MBIT

#define EMAC_IPG_NORM           0
#define EMAC_IPG_SHORT          1

#define EMAC_INIT_ERR              (0x100u)
#define EMAC_INTC_INIT_ERR         (0x200u)
#define EMAC_INTC_INIT_CORE_ERR    (0x210u)
#define EMAC_ISR_ERR               (0x300u)
#define EMAC_ISR_RX_ERR            (0x310u)
#define EMAC_ISR_TX_ERR            (0x320u)
#define EMAC_ISR_RXTHRESH_ERR      (0x330u)
#define EMAC_ISR_HOSTPEND_ERR      (0x340u)
#define EMAC_ISR_STATPEND_ERR      (0x350u)
#define EMAC_ISR_CORE_ERR          (0x360u)
#define EMAC_ISR_RX_OWN_ERR        (0x370u)
#define EMAC_ISR_RX_TDWN_ERR       (0x380u)
#define EMAC_ISR_RX_DESC_ERR       (0x390u)
#define EMAC_ISR_TX_OWN_ERR        (0x3A0u)
#define EMAC_ISR_TX_TDWN_ERR       (0x3B0u)
#define EMAC_ISR_TX_DESC_ERR       (0x3C0u)
#define EMAC_ISR_RXTHRESH_OWN_ERR  (0x3D0u)
#define EMAC_ISR_RXTHRESH_DESC_ERR (0x3E0u)
#define EMAC_UTIL_ERR              (0x400u)

#define EMAC_MAX_ERR               20

#define PCR2_PSPWRDWNCLR3      0xFCFFE0AC


/* ------------------------ */
/* DESCRIPTOR ACCESS MACROS */
/* ------------------------ */

/* Packet Flags */
#define EMAC_DSC_FLAG_SOP                       0x80000000u
#define EMAC_DSC_FLAG_EOP                       0x40000000u
#define EMAC_DSC_FLAG_OWNER                     0x20000000u
#define EMAC_DSC_FLAG_EOQ                       0x10000000u
#define EMAC_DSC_FLAG_TDOWNCMPLT                0x08000000u
#define EMAC_DSC_FLAG_PASSCRC                   0x04000000u

/* The following flags are RX only */
#define EMAC_DSC_FLAG_JABBER                    0x02000000u
#define EMAC_DSC_FLAG_OVERSIZE                  0x01000000u
#define EMAC_DSC_FLAG_FRAGMENT                  0x00800000u
#define EMAC_DSC_FLAG_UNDERSIZED                0x00400000u
#define EMAC_DSC_FLAG_CONTROL                   0x00200000u
#define EMAC_DSC_FLAG_OVERRUN                   0x00100000u
#define EMAC_DSC_FLAG_CODEERROR                 0x00080000u
#define EMAC_DSC_FLAG_ALIGNERROR                0x00040000u
#define EMAC_DSC_FLAG_CRCERROR                  0x00020000u
#define EMAC_DSC_FLAG_NOMATCH                   0x00010000u

/********************EMAC*******************************************************************************/

/*********************************************Pin Mux reg******************************************/
#define MCR_ETM_EMIF_TIM0 0xFFFFEF00
#define MCR_RMII_MII0 0xFFFFEF04
#define MCR_PERI_EMIF0 0xFFFFEF08


/*************************************************USB1 - Slave***********************************************/
#define USB1_REV_NB		0x0061
#define USB1 			0xFCF78A00

#define USB1_NO_OF_ENDP			15

#define USB1_IRQ_ISO_ON			68
#define USB1_GENI_ON			69
#define USB1_NON_ISO_ON			70
#define USB1_DS_WAKE_REQ_ON		71
#define USB1_RESETO				72

#define 	 USB1_RX0_REQ			15
#define 	 USB1_TX0_REQ			14

#define 	USB1_RX1_REQ			19
#define 	USB1_TX1_REQ			18

#define 	USB1_RX2_REQ			29
#define 	USB1_TX2_REQ			28

/**************************************************  HWAG   *************************************************/
#define   HWAG1_LVL0_INT       88
#define   HWAG1_LVL1_INT       80
#define   HWAG2_LVL0_INT       89
#define   HWAG2_LVL1_INT       81


/**************************************************  PinMux   *************************************************/
#define IOMM1	0xFFFFEA00



/**************************************************  OHCI  ****************************************************/
#define OHCI1										0xFCF78B00						/* Base Address of OHCI Module */
#define OHCI1_INT									67								/* Interrupt line mapped to VIM */
#define ESM_G1_CHAN_44								44								/* OHCI Interface interrupt mapped to ESM Group 1 */

#define FPU_INT  47


/******************* added for system validation manually *************************/
#define CRC0_DMA_CH         12
#define CRC1_DMA_CH      	13
#define CRC1_CRC_CH      	14
#define CRCDMA1             27

#define NUM_OF_PBIST_CHANNELS  28

#define LIN1_RX_DMA_CH   	8
#define LIN1_TX_DMA_CH	 	9

#define SPI1_RX_DMA_CH   0
#define SPI1_TX_DMA_CH	 1


#define SPI2_RX_DMA_CH   6
#define SPI2_TX_DMA_CH	 7


#define SPI3_RX_DMA_CH   10
#define SPI3_TX_DMA_CH	 11


#define SPI4_RX_DMA_CH   4
#define SPI4_TX_DMA_CH	 5

/*----------- DCC parameters -------------------------*/
#define DCC_100us_16MHZ 1600
#define DCC_100us_20MHZ 2000
#define DCC_20us_20MHZ 400
#define DCC_120us_20MHZ 2400  

#define DCC_20us_16MHZ	320

#define DCC_120us_16MHZ 1920

#define DCC_1000us_16MHZ 16000

#define DCC_50000us_16MHZ 800000

#define DCC_CLK_PLL 0
#define DCC_LFLPO 2
#define DCC_HFLPO 3

/*----------- HCLK source -------------------------*/
#define HCLK_OSC 0
#define HCLK_PLL 1
#define HCLK_LFLPO 4
#define HCLK_HFLPO 5
#define HCLK_FRAY  6

/*----------- Clock Test Mode Source -------------------------*/
#define CLKTST_NORMAL 0
#define CLKTST_TEST 1
#define CLKTST_OSC 0
#define CLKTST_PLL 1
#define CLKTST_LFLPO 4
#define CLKTST_HFLPO 5
#define CLKTST_FRAY  6
#define CLKTST_GCLK  8

#define ADM1			AWM1	




/*-----------Parameters for Flash Random Read test -------------------------*/
#define NUM_FLASH_BANKS 2      //number of flash main banks

#define EEPROM_BOOK_START     0xF020c000 
#define EEPROM_BOOK_SIZE     0x4000 

#ifdef FLASH
#define BANK0_START   0x010000 
#define BANK0_END     0x180000 
#define BANK1_START   0x190000 
#define BANK1_END     0x300000
#ifndef REVA
	#define EEPROM_START  0xF0200000 
	#define EEPROM_END     0xF020c000 
#endif
#else
#define BANK0_START  0x8010000 
#define BANK0_END    0x8180000 
#define BANK1_START  0x8190000 
#define BANK1_END    0x8300000 
#ifndef REVA
	#define EEPROM_START  0xF0200000 
	#define EEPROM_END    0xF020c000
#endif
#endif


/*-----------parameters for pull up and down test -------------------------*/

#define TMR1_NUM_PINS 6
#define TMR2_NUM_PINS 6

#define GIO_Pins_on_PortA                         3                                      /*Number of Pins Port A*/
#define GIO_Pins_on_PortB                         8                                      /*Number of Pins Port B*/
#define GIO_Pins_on_PortC                         8                                      /*Number of Pins Port C*/
#define GIO_Pins_on_PortD                         8                                      /*Number of Pins Port D*/
#define GIO_Pins_on_PortE                         8  


/*----------- DCC parameters -------------------------*/
#define DCC_100us_16MHZ 1600
#define DCC_100us_20MHZ 2000
#define DCC_20us_20MHZ 400
#define DCC_120us_20MHZ 2400  

#define DCC_20us_16MHZ	320

#define DCC_120us_16MHZ 1920

#define DCC_1000us_16MHZ 16000

#define DCC_50000us_16MHZ 800000

#define DCC_CLK_PLL 0
#define DCC_LFLPO 2
#define DCC_HFLPO 3

/*----------- HCLK source -------------------------*/
#define HCLK_OSC 0
#define HCLK_PLL 1
#define HCLK_LFLPO 4
#define HCLK_HFLPO 5
#define HCLK_FRAY  6

/*----------- Clock Test Mode Source -------------------------*/
#define CLKTST_NORMAL 0
#define CLKTST_TEST 1
#define CLKTST_OSC 0
#define CLKTST_PLL 1
#define CLKTST_LFLPO 4
#define CLKTST_HFLPO 5
#define CLKTST_FRAY  6
#define CLKTST_GCLK  8

/*------------- Test set up information -----------------------*/
#define TESTUPDATE 300
#define NUM_OF_TEST 18	//17	//19

#define DEVICE_ID_ERR 0
#define PULL_ERR 1
#define VIM_RESET_VALUE_ERR 2
#define ESM_RESET_VALUE_ERR 3
#define PLLSLIP_RESET_ERR 4
#define OSC_RESET_ERR 5
#define PBIST_ESRAM_ERR 6
#define PBIST_ERR 7
#define OTP_CHECKSUM_ERR 8
#define EFUSE_CHECK_ERR 9
#define FSF_ERR 10
#define FLASH_RANDOM_READ_ERR 11

#define PLL_FREQ_ERR  12
#define PLL_DISABLE_TIMEOUT 13
#define PLL_DISABLE_SLIP_ERR 14
#define PLL_ENABLE_TIMEOUT 15
#define PLL_ENABLE_SLIP_ERR 16
#define PLLSLIP_ERR 17
#define OSCFAIL_ERR 18
#define PLL_CYCLE_ERR_ENABLE_TIMEOUT 19
#define PLL_CYCLE_ERR_ENABLE_OSCFAIL 20
#define PLL_CYCLE_ERR_ENABLE_SLIP 21
#define PLL_CYCLE_ERR_DISABLE_TIMEOUT 22
#define PLL_CYCLE_ERR_DISABLE_OSCFAIL 23
#define PLL_CYCLE_ERR_DISABLE_SLIP 24
#define PLL_CYCLE_ERR_FREQ 25
#define PLL_FREQ_ERR1  26
#define FLASH_UERR1 27
#define FLASH_UERR2 28
#define PLL_RST_ERR 29
#define CLK_SRC_VALID_ERR 30
#define SYSRST_ERR 31


#define FLASH_WRAPPER                      0xFFF87000                         /*FWM ECC Base Address In Memory Map*/

#define PBIST_CHANNEL_DCAN1RAM			   2 



/*-----------DCAN1 RAM for temperory data storage -------------------------*/
#define TempSave (*(unsigned int *)0xFF1E0008)
#define TempSave1 (*(unsigned int *)0xFF1E000C)
#define DCAN1_TestModeEnable (*(unsigned int *)0xFFF7DC00)




#define PBIST_CHANNEL_ESRAM		5
#define PBIST_CHANNEL_ESRAM_2	20   //19
#define PBIST_CHANNEL_ESRAM_3	21   //20
#define PBIST_CHANNEL_ESRAM_4	27





/************** PMM Definitions *************************/
#define PMM1 				 0xFFFF0000
#define No_LGC_PDS  		 0x4
#define No_MEM_PDS 			 0x3 
#define PD2_REG 			 POM
#define PD3_REG 		     AWM2
#define PD4_REG 			 ((FRAYTU1) + 0x10)
#define PD5_REG 			 ((EMIF1) + 0x4)
#define PD1_RAM 			 0x10000
#define PD1_RAM_END 		 0x1FFFC
#define PD2_RAM 			 0x20000
#define PD2_RAM_END 		 0x2FFFC
#define PD3_RAM 			 0x30000
#define PD3_RAM_END 	 	 0x3FFFC