/*******************************************************************************************/
/* file:dma.c                                                                              */
/*                                                                                         */
/*      DMA configuration functions                                                        */
/*                                                                                         */
/*                                                                                         */
/*******************************************************************************************/

#include <stdio.h>
#include "dma.h"

#ifdef	DEVICE_MODEL
	#include "device.h"
#endif


 
void DMA_Enable(void)
{ 
//release DMA from reset   
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif  
  ptr->GCTRL_UN.GCTRL_ST.DMA_EN=1;
  ptr->GCTRL_UN.GCTRL_UL |=0x300;
}

void DMA_ChannelEnable(unsigned int channel,unsigned int trigger_type)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
	register unsigned int temp;
	temp = 1 << channel;
	if(trigger_type == DMA_HW) 
	{
		ptr->HWCHENAS_UL = temp;
		while(!(ptr->HWCHENAS_UL & temp))  // S/W workaround 
		{
			ptr->HWCHENAS_UL = temp;
        }
    }    
	else ptr->SWCHENAS_UL = temp;
}

void DMA_ChannelDisable(unsigned int channel, unsigned int trigger_type)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
	if(trigger_type == DMA_HW)ptr->HWCHENAR_UL = (1 << channel);
	else ptr->SWCHENAR_UL = (1 << channel);
}

void DMA_REQConfig(unsigned int channel, unsigned int event)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 

#if 0
	#if	defined(_TMS470_BIG) || defined(__big_endian__)
		ptr->DREQASI_ST[channel].CHNASI = event;
	#else
		 register unsigned int i, j;

		i = channel >> 2; //find the register to confiure
		j = channel - (i<<2);  // find the offset of the byte
		j = 3-j;               // reverse the byte order
		j = j<<3;              // find the bit location.

		ptr->DREQASI_UL[i] &= ~(0xff<<j);	
		ptr->DREQASI_UL[i] |= (event<<j);
	#endif						  
#endif

    register unsigned int i, j;

	i = channel >> 2; //find the register to confiure
	j = channel - (i<<2);  // find the offset of the byte
	j = 3-j;               // reverse the byte order
	j = j<<3;              // find the bit location.

	ptr->DREQASI_UL[i] &= ~(0xff<<j);	
	ptr->DREQASI_UL[i] |= (event<<j);

} 
 
unsigned int DMA_Status()
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
	return ( ptr->BTCFLAG_UL);
}	
	
void DMA_IntEnable(unsigned int channel, unsigned int interrupt_type)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
	// Enabling Global DMA Interrupt Enable
 	ptr->GCHIENAS_UL = 1<< channel;
 	
 	if (interrupt_type == DMA_FTC) ptr->FTCINTENAS_UL = (1<< channel); // Enabling FTC Interrupt
 	  else if (interrupt_type == DMA_LFS) ptr->LFSINTENAS_UL = (1<< channel); // Enabling LFS Interrupt
 	    else if (interrupt_type == DMA_HBC) ptr->HBCINTENAS_UL = (1<< channel); // Enabling HBC Interrupt
          else if (interrupt_type == DMA_BTC) ptr->BTCINTENAS_UL = (1<< channel); // Enabling BTC Interrupt
}

void DMA_IntDisable(unsigned int channel, unsigned int interrupt_type)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
	// Disabling Global DMA Interrupt Enable
 	ptr->GCHIENAR_UL = 1<< channel;
 	
 	if (interrupt_type == DMA_FTC) ptr->FTCINTENAR_UL = (1<< channel); // disabling FTC Interrupt
 	  else if (interrupt_type == DMA_LFS) ptr->LFSINTENAR_UL = (1<< channel); // disabling LFS Interrupt
 	    else if (interrupt_type == DMA_HBC) ptr->HBCINTENAR_UL = (1<< channel); // disabling HBC Interrupt
          else if (interrupt_type == DMA_BTC) ptr->BTCINTENAR_UL = 1<< channel; // disabling BTC Interrupt
}

void DMA_IntClr(unsigned int channel, unsigned int interrupt_type)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
	if (interrupt_type == DMA_BTC)ptr->BTCFLAG_UL = 1<<channel;
		else if (interrupt_type == DMA_FTC)ptr->FTCFLAG_UL = 1<<channel;
	  		else if (interrupt_type == DMA_LFS)ptr->LFSFLAG_UL = 1<<channel;
	    		else if (interrupt_type == DMA_HBC)ptr->HBCFLAG_UL = 1<<channel;
}	      

unsigned int DMA_IntPending (unsigned int channel, unsigned int interrupt_type)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
	if (interrupt_type == DMA_FTC) return (ptr->FTCFLAG_UL & (1<<channel));
	  else if (interrupt_type == DMA_LFS) return(ptr->LFSFLAG_UL & (1<<channel));
	    else if (interrupt_type == DMA_HBC)return (ptr->HBCFLAG_UL & (1<<channel));
	      else if (interrupt_type == DMA_BTC)return(ptr->BTCFLAG_UL & (1<<channel));
}
	
// Setting the DMA Control Packet

void DMA_CPConfig(unsigned int n,
unsigned int Src_Addr,
unsigned int Dst_Addr,
unsigned short Frame_Cnt,
unsigned short Elmnt_Cnt,
unsigned char Read_Size,
unsigned char Write_Size,
unsigned char Trans_Type,
unsigned char Addr_Mode_Read,
unsigned char Addr_Mode_Write,
unsigned char Autoinit,
unsigned short Elmnt_Dst_Offst,
unsigned short Elmnt_Src_Offst,
unsigned short Frame_Dst_Offst,
unsigned short Frame_Src_Offst,
unsigned short Port_Assign)
{
 
#ifdef	DEVICE_MODEL
	register DMA_RAM_ST *ramptr = (DMA_RAM_ST *)DMA_RAM;
#else	
  register DMA_RAM_ST *ramptr = &e_DMA_RAM_ST;
#endif 

#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif 
  
  register unsigned int i, j;
  
  ramptr->PCP_ST[n].ISADDR_UL = Src_Addr;
  ramptr->PCP_ST[n].IDADDR_UL = Dst_Addr;
  
  ramptr->PCP_ST[n].ITCOUNT_UN.ITCOUNT_ST.IFTCOUNT = Frame_Cnt;
  ramptr->PCP_ST[n].ITCOUNT_UN.ITCOUNT_ST.IETCOUNT = Elmnt_Cnt;

  ramptr->PCP_ST[n].ITCOUNT_UN.ITCOUNT_UL = (Frame_Cnt<<16)|Elmnt_Cnt;
  
  ramptr->PCP_ST[n].CHCTRL_UN.CHCTRL_ST.RES = Read_Size;
  ramptr->PCP_ST[n].CHCTRL_UN.CHCTRL_ST.WES = Write_Size;
  ramptr->PCP_ST[n].CHCTRL_UN.CHCTRL_ST.TTYPE = Trans_Type;
  ramptr->PCP_ST[n].CHCTRL_UN.CHCTRL_ST.ADDMR = Addr_Mode_Read;
  ramptr->PCP_ST[n].CHCTRL_UN.CHCTRL_ST.ADDMW = Addr_Mode_Write;
  ramptr->PCP_ST[n].CHCTRL_UN.CHCTRL_ST.AIM = Autoinit;

  ramptr->PCP_ST[n].CHCTRL_UN.CHCTRL_UL = Autoinit|(Addr_Mode_Write<<1)|(Addr_Mode_Read<<3)|(Trans_Type<<8)|(Write_Size<<12)|(Read_Size<<14);

  
  ramptr->PCP_ST[n].EIOFF_UN.EIOFF_ST.EIDXD = Elmnt_Dst_Offst;
  ramptr->PCP_ST[n].EIOFF_UN.EIOFF_ST.EIDXS = Elmnt_Src_Offst;

  ramptr->PCP_ST[n].EIOFF_UN.EIOFF_UL = (Elmnt_Dst_Offst<<16) | Elmnt_Src_Offst;
  
  ramptr->PCP_ST[n].FIOFF_UN.FIOFF_ST.FIDXD = Frame_Dst_Offst;
  ramptr->PCP_ST[n].FIOFF_UN.FIOFF_ST.FIDXS = Frame_Src_Offst;
  
  ramptr->PCP_ST[n].FIOFF_UN.FIOFF_UL= (Frame_Dst_Offst<<16) | Frame_Src_Offst;

#if 0
	#if	defined(_TMS470_BIG) || defined(__big_endian__)
	  if(n%2) ptr->PAR_ST[(n/2)].CHNPAO = Port_Assign; */
	//  i = (n % 2);
	  //if(i > 0)
	//	ptr->PAR_ST[(n/2)].CHNPAO = Port_Assign; 
	  else 
	  	ptr->PAR_ST[(n/2)].CHNPAE = Port_Assign;
	#else
	    i = n >> 3;    //find the register to access
		j = n - (i<<3);  // find the offset of the 4 bit
		j = 7-j;         // reverse the order of the 4 bit offset
		j = j<<2;       // find the bit location of the 4 bit to write
		ptr->PAR_UL[i] &= ~(0xf<<j);	
		ptr->PAR_UL[i] |= (Port_Assign<<j);
	#endif
#endif

    i = n >> 3;    //find the register to access
	j = n - (i<<3);  // find the offset of the 4 bit
	j = 7-j;         // reverse the order of the 4 bit offset
	j = j<<2;       // find the bit location of the 4 bit to write
	ptr->PAR_UL[i] &= ~(0xf<<j);	
	ptr->PAR_UL[i] |= (Port_Assign<<j);
 
}



// Resetting the DMA

void DMA_Reset(void)
{
#ifdef	DEVICE_MODEL
	register DMA_ST *ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *ptr = &e_DMA_ST;  
#endif  
//put DMA to reset state  
   ptr->GCTRL_UN.GCTRL_ST.DMA_RESET=1;  
}

void DMA_CPClear(void)
{   
	int i=0;
//clean the DMA command packet   
   
#ifdef	DEVICE_MODEL
	    int *DMA_PTR32 =(int *)DMA_RAM;
#else	
	   	int *DMA_PTR32 = (int*)DMA_CP_RAM;
#endif  

  /*Initialize DMA Control Packet RAM */
  	for(i=0;i<0x10;i++)                     /*modified for testing prev 0x200*/
  	{
    	*DMA_PTR32++ = 0x00000000;
//    	DMA_PTR32++;
  	} 
}  	


void DMA_SetChPri(unsigned int channel , unsigned int pri,unsigned mode) 

{
#ifdef	DEVICE_MODEL
	register DMA_ST *DMA_Ptr = (DMA_ST *)DMA1;
#else	
	register DMA_ST *DMA_Ptr = &e_DMA_ST;  
#endif    
	if(pri)
	{
		DMA_Ptr->CHPRIOS_UL = (0x01<<channel);
		if(mode)
			DMA_Ptr->PTCRL_UN.PTCRL_ST.PSFRHQPB = 1;
		else
			DMA_Ptr->PTCRL_UN.PTCRL_ST.PSFRHQPB = 0;	
	}
	else
	{
		DMA_Ptr->CHPRIOR_UL = (0x01<<channel);
		if(mode)
			DMA_Ptr->PTCRL_UN.PTCRL_ST.PSFRLQPB = 1;
		else
			DMA_Ptr->PTCRL_UN.PTCRL_ST.PSFRLQPB = 0;	
	}
}	
