/* ------------------------------------------------------------------------- */
/* lin.h : SCI/LIN Module Definitions                                        */
/*   	                                                                     */
/* Copyright (c) Texas Instruments 1997, All right reserved.                 */
/*                                                                           */
/* History:                                                                  */
/*    Rev 1.0  10.27.03  Rejith Kunnummal   - rejith@ti.com                  */
/*                                                                           */
/*                       Definition of SCI/LIN register set                  */
/*                                                                           */
/*    Rev 2.0  07.15.03  Ruppert Schick  -  r-schick@ti.com                  */
/*                                                                           */
/*                       Revised relating to BLIN module / 2.0 protocol      */
/* ------------------------------------------------------------------------- */
/*                                                                           */
/* ------------------------------------------------------------------------- */

/* ------------------------------------------------------------------------- */
/* Define the standard types                                                 */

#if defined(_TMS470_BIG) || defined(__big_endian__)
#ifndef BOOL
#define BOOL  unsigned char
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef UBYTE
#define UBYTE unsigned char
#endif

#ifndef UWORD
#define UWORD unsigned short
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

#ifndef NULL
#define NULL  (void *)0
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

typedef enum 
{
	TRANSMIT =0,
	RECEIVE
}Data_Direction;

typedef enum 
{
	SLAVE =0,
	MASTER
	
}LIN_Mode;

typedef enum 
{
	ONE_BYTES =0,
	TWO_BYTES,
	THREE_BYTES,
	FOUR_BYTES,
	FIVE_BYTES,
	SIX_BYTES,
	SEVEN_BYTES,
	EIGHT_BYTES	
	
}Date_Bytes;

typedef enum 
{
	FAIL = 0,
	PASS = 1,
	RESET = 0xDEADBEEF
}Status;

typedef struct
{	
	unsigned char 	LIN_ID;
	LIN_Mode		Master_Or_Slave;
	Data_Direction  Direction;
	Date_Bytes 		No_Of_Data_Bytes;
	Status 			Packet_Status;	
	unsigned int  	Baud;
	unsigned int  	MBR;
	unsigned int  	Transmit_Data_UL[2];
	unsigned int  	Receive_Data_UL[2];

}LIN_Packet_ST;


/* ------------------------------------------------------------------------- */
/* LINn                                                                      */
/*      The driver supports up to four LIN's which are specified by using    */
/*      pointers to the external names defined in the linker command file    */
/*      See the definition of e_LINn_ST below.                               */

#define Lin0 (LIN_Ptr)
#define Lin1 (LIN1_Ptr)
#define Lin2 (LIN2_Ptr)
#define Lin3 (LIN3_Ptr)

/* ------------------------------------------------------------------------- */
/* DONTCARE values                                                           */
/*      Unique values passed to the LIN_Init_V routine to inhibit setup with */
/*      respect to a given parameter.                                        */

#define LinNOMODE      0xFFFFFFFF
#define LinNOPORT      0xFFFFFFFF
#define LinNOBAUD      0
#define LinNOSIZE      0
#define LinNOADDRESS   0xFFFF
#define NoInterrupt    0x00000000
#define NoInterruptLvl 0x00000000

typedef unsigned LINMODE;

#define LINTxEN        0x02000000
#define LINRxEN        0x01000000
#define LINContinue    0x00020000
#define LINHgenCtrl    0x00001000
#define LINCtype       0x00000000
#define LINBufMode     0x00000400
#define LINAdapt       0x00000200
#define LINSWnRST      0x00000080
#define LINModeEn      0x00000040
#define LINModeDis     0x00000000
#define LINMaster      0x00000020
#define LINSlave       0x00000000
#define LINStopBits    0x00000010
#define LINParity      0x00000004
#define LINOddParity   0x00000004
#define LINEvenParity  0x0000000C
#define LINLengthOp    0x00000001

typedef unsigned LININTEN;

#define BEINT          0x80000000
#define PBEINT         0x40000000
#define CEINT          0x20000000
#define ISFEINT        0x10000000
#define NREINT         0x08000000
#define FEINT          0x04000000
#define OEINT          0x02000000
#define PEINT          0x01000000
#define RXALL          0x00040000
#define RXDMA          0x00020000
#define TXDMA          0x00010000
#define INCBRINT       0x00008000
#define IDINT          0x00002000
#define RXINT          0x00000200
#define TXINT          0x00000100
#define TOA3WUSINT     0x00000080
#define TOAWUSINT      0x00000040
#define TIMEOUTINT     0x00000010
#define WAKEUPINT      0x00000002
#define BRKDTINT       0x00000001

typedef unsigned LININT_LVL1;

#define BEINTLVL       0x80000000
#define PBEINTLVL      0x40000000
#define CEINTLVL       0x20000000
#define ISFEINTLVL     0x10000000
#define NREINTLVL      0x08000000
#define FEINTLVL       0x04000000
#define OEINTLVL       0x02000000
#define PEINTLVL       0x01000000
#define INCBRINTLVL    0x00008000
#define IDINTLVL       0x00002000
#define RXINTLVL       0x00000200
#define TXINTLVL       0x00000100
#define TOA3WUSINTLVL  0x00000080
#define TOAWUSINTLVL   0x00000040
#define TIMEOUTINTLVL  0x00000010
#define WAKEUPINTLVL   0x00000002
#define BRKDTINTLVL    0x00000001

typedef unsigned LINPORT;

#define LINClkPinEN 0x00020000
#define LINClkOut   0x00010000
#define LINClkHigh  0x00040000
#define LINClkLow   0x00000000
#define LINRxPinEN  0x00000200
#define LINRxOut    0x00000100
#define LINRxHigh   0x00000400
#define LINRxLow    0x00000000
#define LINTxPinEN  0x00000002
#define LINTxOut    0x00000001
#define LINTxHigh   0x00000004
#define LINTxLow    0x00000000




typedef volatile struct
{
    union                                      /* 0x00      */
    {
     unsigned int SCIGR0_UL;
     struct
     {
     unsigned int : 31;
     unsigned int RESET_B1: 1;
     }SCIGR0_ST;
    }SCIGR0_UN;

    union                                      /* 0x04      */
    {
     unsigned int SCIGR1_UL; 
     struct
     {
     unsigned int : 6;
     unsigned int TX_ENA_B1: 1;
     unsigned int RX_ENA_B1: 1;
     unsigned int : 5;
     unsigned int NOSTART_STOP_B1: 1;
     unsigned int CONT_B1: 1;
     unsigned int LOOP_BACK_B1: 1;
     unsigned int : 2;
	 unsigned int STOP_Ext_Frame_B1: 1;     
     unsigned int HGEN_Ctrl_B1: 1;
     unsigned int CTYPE_B1: 1;
     unsigned int MBUF_MODE_B1: 1;
     unsigned int ADAPT_B1: 1;
     unsigned int SLEEP_B1: 1;
     unsigned int SWnRST_B1: 1;
     unsigned int LINMODE_B1: 1;
     unsigned int CLOCK_B1: 1;
     unsigned int STOP_B1: 1;
     unsigned int PARITY_B1: 1;
     unsigned int PARITY_ENA_B1: 1;
     unsigned int TIMING_MODE_B1: 1;
     unsigned int COMM_MODE_B1: 1;
     }SCIGR1_ST;
    }SCIGR1_UN;

    union                                      /* 0x08      */
    {
     unsigned int SCIGR2_UL;
     struct
     {
     unsigned int : 14;
     unsigned int CC_B1: 1;
     unsigned int SC_B1: 1;
     unsigned int : 7;
     unsigned int GENWU_B1: 1;
     unsigned int : 7;
     unsigned int POWERDOWN_B1: 1;
     }SCIGR2_ST;
    }SCIGR2_UN;

	union                                      /* 0x0C      */
    {
     unsigned int SCISETINT_UL;
     struct
     {
     unsigned int SET_BE_INT_B1: 1;
     unsigned int SET_PBE_INT_B1: 1;
     unsigned int SET_CE_INT_B1: 1;
     unsigned int SET_ISFE_INT_B1: 1;
     unsigned int SET_NRE_INT_B1: 1;
     unsigned int SET_FE_INT_B1: 1;
     unsigned int SET_OE_INT_B1: 1;
     unsigned int SET_PE_INT_B1: 1;
     unsigned int : 5;
     unsigned int SET_RX_DMA_ALL_B1: 1;
     unsigned int SET_RX_DMA_B1: 1;
     unsigned int SET_TX_DMA_B1: 1;
     unsigned int SET_INC_BR_B1: 1;
     unsigned int : 1;
     unsigned int SET_ID_INT_B1: 1;
     unsigned int : 3;
     unsigned int SET_RX_INT_B1: 1;
     unsigned int SET_TX_INT_B1: 1;
     unsigned int SET_TOA3WUS_INT_B1: 1;
     unsigned int SET_TOAWUS_INT_B1: 1;
     unsigned int : 1;
     unsigned int SET_TIMEOUT_INT_B1: 1;
     unsigned int : 2;
     unsigned int SET_WAKUP_INT_B1: 1;
     unsigned int SET_BRKDT_INT_B1: 1;
     }SCISETINT_ST;
    }SCISETINT_UN;

    union                                      /* 0x10      */
    {
     unsigned int SCICLRINT_UL;
     struct
     {
     unsigned int CLR_BE_INT_B1: 1;
     unsigned int CLR_PBE_INT_B1: 1;
     unsigned int CLR_CE_INT_B1: 1;
     unsigned int CLR_ISFE_INT_B1: 1;
     unsigned int CLR_NRE_INT_B1: 1;
     unsigned int CLR_FE_INT_B1: 1;
     unsigned int CLR_OE_INT_B1: 1;
     unsigned int CLR_PE_INT_B1: 1;
     unsigned int : 5;
     unsigned int CLR_RX_DMA_ALL_B1: 1;
     unsigned int CLR_RX_DMA_B1: 1;
     unsigned int CLR_TX_DMA_B1: 1;
     unsigned int CLR_INC_BR_B1: 1;
     unsigned int : 1;
     unsigned int CLR_ID_INT_B1: 1;
     unsigned int : 3;
     unsigned int CLR_RX_INT_B1: 1;
     unsigned int CLR_TX_INT_B1: 1;
     unsigned int CLR_TOA3WUS_INT_B1: 1;
     unsigned int CLR_TOAWUS_INT_B1: 1;
     unsigned int : 1;
     unsigned int CLR_TIMEOUT_INT_B1: 1;
     unsigned int : 2;
     unsigned int CLR_WAKUP_INT_B1: 1;
     unsigned int CLR_BRKDT_INT_B1: 1;
     }SCICLRINT_ST;
    }SCICLRINT_UN;

    union                                      /* 0x14      */
    {
     unsigned int SCISETINTLVL_UL;
     struct
     {
     unsigned int SET_BE_INT_LVL_B1: 1;
     unsigned int SET_PBE_INT_LVL_B1: 1;
     unsigned int SET_CE_INT_LVL_B1: 1;
     unsigned int SET_ISFE_INT_LVL_B1: 1;
     unsigned int SET_NRE_INT_LVL_B1: 1;
     unsigned int SET_FE_INT_LVL_B1: 1;
     unsigned int SET_OE_INT_LVL_B1: 1;
     unsigned int SET_PE_INT_LVL_B1: 1;
     unsigned int : 5;
     unsigned int SET_RX_DMA_ALL_LVL_B1: 1;
     unsigned int : 2;
     unsigned int SET_INC_BR_INT_LVL_B1: 1;
     unsigned int : 1;
     unsigned int SET_ID_INT_LVL_B1: 1;
     unsigned int : 3;
     unsigned int SET_RX_INT_LVL_B1: 1;
     unsigned int SET_TX_INT_LVL_B1: 1;
     unsigned int SET_TOA3WUS_INT_LVL_B1: 1;
     unsigned int SET_TOAWUS_INT_LVL_B1: 1;
     unsigned int : 1;
     unsigned int SET_TIMEOUT_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int SET_WAKUP_INT_LVL_B1: 1;
     unsigned int SET_BRKDT_INT_LVL_B1: 1;
     }SCISETINTLVL_ST;
    }SCISETINTLVL_UN;

    union                                      /* 0x18      */
    {
     unsigned int SCICLRINTLVL_UL;
     struct
     {
     unsigned int CLR_BE_INT_LVL_B1: 1;
     unsigned int CLR_PBE_INT_LVL_B1: 1;
     unsigned int CLR_CE_INT_LVL_B1: 1;
     unsigned int CLR_ISFE_INT_LVL_B1: 1;
     unsigned int CLR_NRE_INT_LVL_B1: 1;
     unsigned int CLR_FE_INT_LVL_B1: 1;
     unsigned int CLR_OE_INT_LVL_B1: 1;
     unsigned int CLR_PE_INT_LVL_B1: 1;
     unsigned int : 5;
     unsigned int CLR_RX_DMA_ALL_LVL_B1: 1;
     unsigned int : 2;
     unsigned int CLR_INC_BR_INT_LVL_B1: 1;
     unsigned int : 1;
     unsigned int CLR_ID_INT_LVL_B1: 1;
     unsigned int : 3;
     unsigned int CLR_RX_INT_LVL_B1: 1;
     unsigned int CLR_TX_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int CLR_BAUD_INT_LVL_B1: 1;
     unsigned int CLR_TIMEOUT_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int CLR_WAKUP_INT_LVL_B1: 1;
     unsigned int CLR_BRKDT_INT_LVL_B1: 1;
     }SCICLRINTLVL_ST;
    }SCICLRINTLVL_UN;

    union                                      /* 0x1C      */
    {
     unsigned int SCIFLR_UL;
     struct
     {
     unsigned int BE_B1: 1;
     unsigned int PBE_B1: 1;
     unsigned int CE_B1: 1;
     unsigned int ISFE_B1: 1;
     unsigned int NRE_B1: 1;
     unsigned int FE_B1: 1;
     unsigned int OE_B1: 1;
     unsigned int PE_B1: 1;
     unsigned int : 8;
     unsigned int INC_BR_B1: 1;
     unsigned int ID_RX_B1: 1;
     unsigned int ID_TX_B1: 1;
     unsigned int RXWAKE_B1: 1;
     unsigned int TX_EMPTY_B1: 1;
     unsigned int TXWAKE_B1: 1;
     unsigned int RXRDY_B1: 1;
     unsigned int TXRDY_B1: 1;
     unsigned int TOA3WUS_B1: 1;
     unsigned int TOAWUS_B1: 1;
     unsigned int BAUD_UPDATE_B1: 1;
     unsigned int TIMEOUT_B1: 1;
     unsigned int BUSY_B1: 1;
     unsigned int IDLE_B1: 1;
     unsigned int WAKEUP_B1: 1;
     unsigned int BRKDT_B1: 1;
     }SCIFLR_ST;
    }SCIFLR_UN;

    union                                      /* 0x20      */
    {
     unsigned int SCIINTVECT0_UL;
     struct
     {
     unsigned int : 27;
     unsigned int INTVECT0_B5: 5;
     }SCIINTVECT0_ST;
    }SCIINTVECT0_UN;

    union                                      /* 0x24      */
    {
     unsigned int SCIINTVECT1_UL;
     struct
     {
     unsigned int : 27;
     unsigned int INTVECT1_B5: 5;
     }SCIINTVECT1_ST;
    }SCIINTVECT1_UN;

    union                                      /* 0x28     */
    {
     unsigned int SCIFORMAT_UL; 
     struct
     {
     unsigned int : 13;                        
     unsigned int LENGTH_B3: 3;
     unsigned int : 13;                        
     unsigned int CHAR_B3: 3;
     }SCIFORMAT_ST;
    }SCIFORMAT_UN;

    union                                      /* 0x2C      */
    {
     unsigned int SCIBRSR_UL;
     struct
     {
     unsigned int : 1;
     unsigned int U_B3: 3;
     unsigned int M_B4: 4;
     unsigned int P_B24: 24;
     }SCIBRSR_ST;
    }SCIBRSR_UN;

    union                                      /* 0x30     */
    {
     unsigned int SCIED_UL;
     struct
     {
     unsigned int : 24;
     unsigned char ED_UC;
     }SCIED_ST;
    }SCIED_UN;

    union                                      /* 0x34      */
    {
     unsigned int SCIRD_UL;
     struct
     {
     unsigned int : 24;
     unsigned char RD_UC;
     }SCIRD_ST;
    }SCIRD_UN;

    union                                      /* 0x38      */
    {
     unsigned int SCITD_UL;
     struct
     {
     unsigned int : 24;
     unsigned char TD_UC;
     }SCITD_ST;
    }SCITD_UN;

    union                                      /* 0x3C     */
    {
     unsigned int SCIPIO0_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXFUNC_B1: 1;
     unsigned int RXFUNC_B1: 1;
     unsigned int CLKFUNC_B1: 1;
     }SCIPIO0_ST;
    }SCIPIO0_UN;

    union                                      /* 0x40      */
    {
     unsigned int SCIPIO1_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXDIR_B1: 1;
     unsigned int RXDIR_B1: 1;
     unsigned int CLKDIR_B1: 1;
     }SCIPIO1_ST;
    }SCIPIO1_UN;

    union                                      /* 0x44      */
    {
     unsigned int SCIPIO2_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXIN_B1: 1;
     unsigned int RXIN_B1: 1;
     unsigned int CLKIN_B1: 1;
     }SCIPIO2_ST;
    }SCIPIO2_UN;

    union                                      /* 0x48      */
    {
     unsigned int SCIPIO3_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXOUT_B1: 1;
     unsigned int RXOUT_B1: 1;
     unsigned int CLKOUT_B1: 1;
     }SCIPIO3_ST;
    }SCIPIO3_UN;

    union                                      /* 0x4C      */
    {
     unsigned int SCIPIO4_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXSET_B1: 1;
     unsigned int RXSET_B1: 1;
     unsigned int CLKSET_B1: 1;
     }SCIPIO4_ST;
    }SCIPIO4_UN;

    union                                      /* 0x50      */
    {
     unsigned int SCIPIO5_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXCLR_B1: 1;
     unsigned int RXCLR_B1: 1;
     unsigned int CLKCLR_B1: 1;
     }SCIPIO5_ST;
    }SCIPIO5_UN;

    union                                      /* 0x54      */
    {
     unsigned int SCIPIO6_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXPDR_B1: 1;
     unsigned int RXPDR_B1: 1;
     unsigned int CLKPDR_B1: 1;
     }SCIPIO6_ST;
    }SCIPIO6_UN;

    union                                      /* 0x58      */
    {
     unsigned int SCIPIO7_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXPE_B1: 1;
     unsigned int RXPE_B1: 1;
     unsigned int CLKPE_B1: 1;
     }SCIPIO7_ST;
    }SCIPIO7_UN;

    union                                      /* 0x5C      */
    {
     unsigned int SCIPIO8_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXPSL_B1: 1;
     unsigned int RXPSL_B1: 1;
     unsigned int CLKPSL_B1: 1;
     }SCIPIO8_ST;
    }SCIPIO8_UN;

    union                                      /* 0x60      */
    {
     unsigned int LINCOMPARE_UL;
     struct
     {
     unsigned int : 22;
     unsigned int SDEL_B2: 2;
     unsigned int : 5;
     unsigned int SBREAK_B3: 3;
     }LINCOMPARE_ST;
    }LINCOMPARE_UN;

    union                                      /* 0x64      */
    {
     unsigned int LINRD0_UL;
     struct
     {
     unsigned char RD0_UC;
     unsigned char RD1_UC;
     unsigned char RD2_UC;
     unsigned char RD3_UC;
     }LINRD0_ST;
    }LINRD0_UN;

    union                                      /* 0x68      */
    {
     unsigned int LINRD1_UL;
     struct
     {
     unsigned char RD4_UC;
     unsigned char RD5_UC;
     unsigned char RD6_UC;
     unsigned char RD7_UC;
     }LINRD1_ST;
    }LINRD1_UN;

    union                                      /* 0x6C      */
    {
     unsigned int LINMASK_UL;
     struct
     {
     unsigned int : 8;
     unsigned char RXIDMASK_UC;
     unsigned int : 8;
     unsigned char TXIDMASK_UC;
     }LINMASK_ST;
    }LINMASK_UN;

    union                                      /* 0x70      */
    {
     unsigned int LINID_UL;
     struct
     {
     unsigned int : 8;
     unsigned char Received_ID;
     unsigned char ID_Slave_BYTE_UC;
     unsigned char IDBYTE_UC;
     }LINID_ST;
    }LINID_UN;
    
    union                                      /* 0x74      */
    {
     unsigned int LINTD0_UL;
     struct
     {
     unsigned char TD0_UC;
     unsigned char TD1_UC;
     unsigned char TD2_UC;
     unsigned char TD3_UC;
     }LINTD0_ST;
    }LINTD0_UN;

    union                                      /* 0x78      */
    {
     unsigned int LINTD1_UL;
     struct
     {
     unsigned char TD4_UC;
     unsigned char TD5_UC;
     unsigned char TD6_UC;
     unsigned char TD7_UC;
     }LINTD1_ST;
    }LINTD1_UN;

   union                                      /* 0x7C      */
    {
    	unsigned int MBRSR_UL;
    	struct
    	{
    	unsigned int : 19;
        unsigned int MBR : 13;
     	}MBRSR_ST;
    }MBRSR_UN;  

    
     union                                      /* 0x80      */
    {
     unsigned int SCIPIO9_UL;
     struct
     {
     unsigned int : 29;
     unsigned int TXSL_B1: 1;
     unsigned int RXSL_B1: 1;
     unsigned int CLKSL_B1: 1;
     }SCIPIO9_ST;
    }SCIPIO9_UN;
    
    unsigned int : 32;                        /* 0x84      */
   
    unsigned int : 32; 						  /* 0x88      */
    
    unsigned int : 32; 						  /* 0x8C		*/
    
    union                                      /* 0x90      */
    {
     unsigned int IODFT_UL;
     struct
     {
     unsigned int BEN_B1: 1;
     unsigned int PBEN_B1: 1;
     unsigned int CEN_B1: 1;
     unsigned int ISFEN_B1: 1;
     unsigned int : 1;
     unsigned int FEN_B1: 1;
     unsigned int PEN_B1: 1;
     unsigned int BRKDTEN_B1: 1;
     unsigned int : 3;
     unsigned int PIN_SAMPLE_MASK_B2: 2;
     unsigned int TX_SHIFT_B3: 3;
     unsigned int : 4;
     unsigned int IODFTENA_B4: 4;
     unsigned int : 6;
     unsigned int LPBENA_B1: 1;
     unsigned int RXPENA_B1: 1;
      }IODFT_ST;
    }IODFT_UN;

} LIN_ST;

/* ------------------------------------------------------------------------- */
/* e_LINn_ST                                                                 */
/*      pointers to the LIN/SCI registers, this is defined in the linker     */
/*      command file.                                                        */

extern LIN_ST e_LIN0_ST, e_LIN1_ST, e_LIN2_ST, e_LIN3_ST;
extern LIN_ST* LIN_Ptr;
extern LIN_ST* LIN1_Ptr;
extern LIN_ST* LIN2_Ptr;
extern LIN_ST* LIN3_Ptr;


#elif defined(_TMS470_LITTLE) || defined(__little_endian__)
#ifndef BOOL
#define BOOL  unsigned char
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef UBYTE
#define UBYTE unsigned char
#endif

#ifndef UWORD
#define UWORD unsigned short
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

#ifndef NULL
#define NULL  (void *)0
#endif

#ifndef ULONG
#define ULONG unsigned long
#endif

typedef enum 
{
	TRANSMIT =0,
	RECEIVE
}Data_Direction;

typedef enum 
{
	SLAVE =0,
	MASTER
	
}LIN_Mode;

typedef enum 
{
	ONE_BYTES =0,
	TWO_BYTES,
	THREE_BYTES,
	FOUR_BYTES,
	FIVE_BYTES,
	SIX_BYTES,
	SEVEN_BYTES,
	EIGHT_BYTES	
	
}Date_Bytes;

typedef enum 
{
	FAIL = 0,
	PASS = 1
//	RESET = 0xDEADBEEF
}Status;

typedef struct
{	
	unsigned char 	LIN_ID;
	LIN_Mode		Master_Or_Slave;
	Data_Direction  Direction;
	Date_Bytes 		No_Of_Data_Bytes;
	Status 			Packet_Status;	
	unsigned int  	Baud;
	unsigned int  	MBR;
	unsigned int  	Transmit_Data_UL[2];
	unsigned int  	Receive_Data_UL[2];

}LIN_Packet_ST;


/* ------------------------------------------------------------------------- */
/* LINn                                                                      */
/*      The driver supports up to four LIN's which are specified by using    */
/*      pointers to the external names defined in the linker command file    */
/*      See the definition of e_LINn_ST below.                               */

#define Lin0 (LIN_Ptr)
#define Lin1 (LIN1_Ptr)
#define Lin2 (LIN2_Ptr)
#define Lin3 (LIN3_Ptr)

/* ------------------------------------------------------------------------- */
/* DONTCARE values                                                           */
/*      Unique values passed to the LIN_Init_V routine to inhibit setup with */
/*      respect to a given parameter.                                        */

#define LinNOMODE      0xFFFFFFFF
#define LinNOPORT      0xFFFFFFFF
#define LinNOBAUD      0
#define LinNOSIZE      0
#define LinNOADDRESS   0xFFFF
#define NoInterrupt    0x00000000
#define NoInterruptLvl 0x00000000

typedef unsigned LINMODE;

#define LINTxEN        0x02000000
#define LINRxEN        0x01000000
#define LINContinue    0x00020000
#define LINHgenCtrl    0x00001000
#define LINCtype       0x00000000
#define LINBufMode     0x00000400
#define LINAdapt       0x00000200
#define LINSWnRST      0x00000080
#define LINModeEn      0x00000040
#define LINModeDis     0x00000000
#define LINMaster      0x00000020
#define LINSlave       0x00000000
#define LINStopBits    0x00000010
#define LINParity      0x00000004
#define LINOddParity   0x00000004
#define LINEvenParity  0x0000000C
#define LINLengthOp    0x00000001

typedef unsigned LININTEN;

#define BEINT          0x80000000
#define PBEINT         0x40000000
#define CEINT          0x20000000
#define ISFEINT        0x10000000
#define NREINT         0x08000000
#define FEINT          0x04000000
#define OEINT          0x02000000
#define PEINT          0x01000000
#define RXALL          0x00040000
#define RXDMA          0x00020000
#define TXDMA          0x00010000
#define INCBRINT       0x00008000
#define IDINT          0x00002000
#define RXINT          0x00000200
#define TXINT          0x00000100
#define TOA3WUSINT     0x00000080
#define TOAWUSINT      0x00000040
#define TIMEOUTINT     0x00000010
#define WAKEUPINT      0x00000002
#define BRKDTINT       0x00000001

typedef unsigned LININT_LVL1;

#define BEINTLVL       0x80000000
#define PBEINTLVL      0x40000000
#define CEINTLVL       0x20000000
#define ISFEINTLVL     0x10000000
#define NREINTLVL      0x08000000
#define FEINTLVL       0x04000000
#define OEINTLVL       0x02000000
#define PEINTLVL       0x01000000
#define INCBRINTLVL    0x00008000
#define IDINTLVL       0x00002000
#define RXINTLVL       0x00000200
#define TXINTLVL       0x00000100
#define TOA3WUSINTLVL  0x00000080
#define TOAWUSINTLVL   0x00000040
#define TIMEOUTINTLVL  0x00000010
#define WAKEUPINTLVL   0x00000002
#define BRKDTINTLVL    0x00000001

typedef unsigned LINPORT;

#define LINClkPinEN 0x00020000
#define LINClkOut   0x00010000
#define LINClkHigh  0x00040000
#define LINClkLow   0x00000000
#define LINRxPinEN  0x00000200
#define LINRxOut    0x00000100
#define LINRxHigh   0x00000400
#define LINRxLow    0x00000000
#define LINTxPinEN  0x00000002
#define LINTxOut    0x00000001
#define LINTxHigh   0x00000004
#define LINTxLow    0x00000000




typedef volatile struct
{
    union                                      /* 0x00      */
    {
     unsigned int SCIGR0_UL;
     struct
     {
     unsigned int RESET_B1: 1;
     unsigned int : 31;
     }SCIGR0_ST;
    }SCIGR0_UN;

    union                                      /* 0x04      */
    {
     unsigned int SCIGR1_UL; 
     struct
     {
     unsigned int COMM_MODE_B1: 1;
     unsigned int TIMING_MODE_B1: 1;
     unsigned int PARITY_ENA_B1: 1;
     unsigned int PARITY_B1: 1;
     unsigned int STOP_B1: 1;
     unsigned int CLOCK_B1: 1;
     unsigned int LINMODE_B1: 1;
     unsigned int SWnRST_B1: 1;
     unsigned int SLEEP_B1: 1;
     unsigned int ADAPT_B1: 1;
     unsigned int MBUF_MODE_B1: 1;
     unsigned int CTYPE_B1: 1;
     unsigned int HGEN_Ctrl_B1: 1;
	 unsigned int STOP_Ext_Frame_B1: 1;     
     unsigned int : 2;
     unsigned int LOOP_BACK_B1: 1;
     unsigned int CONT_B1: 1;
     unsigned int NOSTART_STOP_B1: 1;
     unsigned int : 5;
     unsigned int RX_ENA_B1: 1;
     unsigned int TX_ENA_B1: 1;
     unsigned int : 6;
     }SCIGR1_ST;
    }SCIGR1_UN;

    union                                      /* 0x08      */
    {
     unsigned int SCIGR2_UL;
     struct
     {
     unsigned int POWERDOWN_B1: 1;
     unsigned int : 7;
     unsigned int GENWU_B1: 1;
     unsigned int : 7;
     unsigned int SC_B1: 1;
     unsigned int CC_B1: 1;
     unsigned int : 14;
     }SCIGR2_ST;
    }SCIGR2_UN;

	union                                      /* 0x0C      */
    {
     unsigned int SCISETINT_UL;
     struct
     {
     unsigned int SET_BRKDT_INT_B1: 1;
     unsigned int SET_WAKUP_INT_B1: 1;
     unsigned int : 2;
     unsigned int SET_TIMEOUT_INT_B1: 1;
     unsigned int : 1;
     unsigned int SET_TOAWUS_INT_B1: 1;
     unsigned int SET_TOA3WUS_INT_B1: 1;
     unsigned int SET_TX_INT_B1: 1;
     unsigned int SET_RX_INT_B1: 1;
     unsigned int : 3;
     unsigned int SET_ID_INT_B1: 1;
     unsigned int : 1;
     unsigned int SET_INC_BR_B1: 1;
     unsigned int SET_TX_DMA_B1: 1;
     unsigned int SET_RX_DMA_B1: 1;
     unsigned int SET_RX_DMA_ALL_B1: 1;
     unsigned int : 5;
     unsigned int SET_PE_INT_B1: 1;
     unsigned int SET_OE_INT_B1: 1;
     unsigned int SET_FE_INT_B1: 1;
     unsigned int SET_NRE_INT_B1: 1;
     unsigned int SET_ISFE_INT_B1: 1;
     unsigned int SET_CE_INT_B1: 1;
     unsigned int SET_PBE_INT_B1: 1;
     unsigned int SET_BE_INT_B1: 1;
     }SCISETINT_ST;
    }SCISETINT_UN;

    union                                      /* 0x10      */
    {
     unsigned int SCICLRINT_UL;
     struct
     {
     unsigned int CLR_BRKDT_INT_B1: 1;
     unsigned int CLR_WAKUP_INT_B1: 1;
     unsigned int : 2;
     unsigned int CLR_TIMEOUT_INT_B1: 1;
     unsigned int : 1;
     unsigned int CLR_TOAWUS_INT_B1: 1;
     unsigned int CLR_TOA3WUS_INT_B1: 1;
     unsigned int CLR_TX_INT_B1: 1;
     unsigned int CLR_RX_INT_B1: 1;
     unsigned int : 3;
     unsigned int CLR_ID_INT_B1: 1;
     unsigned int : 1;
     unsigned int CLR_INC_BR_B1: 1;
     unsigned int CLR_TX_DMA_B1: 1;
     unsigned int CLR_RX_DMA_B1: 1;
     unsigned int CLR_RX_DMA_ALL_B1: 1;
     unsigned int : 5;
     unsigned int CLR_PE_INT_B1: 1;
     unsigned int CLR_OE_INT_B1: 1;
     unsigned int CLR_FE_INT_B1: 1;
     unsigned int CLR_NRE_INT_B1: 1;
     unsigned int CLR_ISFE_INT_B1: 1;
     unsigned int CLR_CE_INT_B1: 1;
     unsigned int CLR_PBE_INT_B1: 1;
     unsigned int CLR_BE_INT_B1: 1;
     }SCICLRINT_ST;
    }SCICLRINT_UN;

    union                                      /* 0x14      */
    {
     unsigned int SCISETINTLVL_UL;
     struct
     {
     unsigned int SET_BRKDT_INT_LVL_B1: 1;
     unsigned int SET_WAKUP_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int SET_TIMEOUT_INT_LVL_B1: 1;
     unsigned int : 1;
     unsigned int SET_TOAWUS_INT_LVL_B1: 1;
     unsigned int SET_TOA3WUS_INT_LVL_B1: 1;
     unsigned int SET_TX_INT_LVL_B1: 1;
     unsigned int SET_RX_INT_LVL_B1: 1;
     unsigned int : 3;
     unsigned int SET_ID_INT_LVL_B1: 1;
     unsigned int : 1;
     unsigned int SET_INC_BR_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int SET_RX_DMA_ALL_LVL_B1: 1;
     unsigned int : 5;
     unsigned int SET_PE_INT_LVL_B1: 1;
     unsigned int SET_OE_INT_LVL_B1: 1;
     unsigned int SET_FE_INT_LVL_B1: 1;
     unsigned int SET_NRE_INT_LVL_B1: 1;
     unsigned int SET_ISFE_INT_LVL_B1: 1;
     unsigned int SET_CE_INT_LVL_B1: 1;
     unsigned int SET_PBE_INT_LVL_B1: 1;
     unsigned int SET_BE_INT_LVL_B1: 1;
     }SCISETINTLVL_ST;
    }SCISETINTLVL_UN;

    union                                      /* 0x18      */
    {
     unsigned int SCICLRINTLVL_UL;
     struct
     {
     unsigned int CLR_BRKDT_INT_LVL_B1: 1;
     unsigned int CLR_WAKUP_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int CLR_TIMEOUT_INT_LVL_B1: 1;
     unsigned int CLR_BAUD_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int CLR_TX_INT_LVL_B1: 1;
     unsigned int CLR_RX_INT_LVL_B1: 1;
     unsigned int : 3;
     unsigned int CLR_ID_INT_LVL_B1: 1;
     unsigned int : 1;
     unsigned int CLR_INC_BR_INT_LVL_B1: 1;
     unsigned int : 2;
     unsigned int CLR_RX_DMA_ALL_LVL_B1: 1;
     unsigned int : 5;
     unsigned int CLR_PE_INT_LVL_B1: 1;
     unsigned int CLR_OE_INT_LVL_B1: 1;
     unsigned int CLR_FE_INT_LVL_B1: 1;
     unsigned int CLR_NRE_INT_LVL_B1: 1;
     unsigned int CLR_ISFE_INT_LVL_B1: 1;
     unsigned int CLR_CE_INT_LVL_B1: 1;
     unsigned int CLR_PBE_INT_LVL_B1: 1;
     unsigned int CLR_BE_INT_LVL_B1: 1;
     }SCICLRINTLVL_ST;
    }SCICLRINTLVL_UN;

    union                                      /* 0x1C      */
    {
     unsigned int SCIFLR_UL;
     struct
     {
     unsigned int BRKDT_B1: 1;
     unsigned int WAKEUP_B1: 1;
     unsigned int IDLE_B1: 1;
     unsigned int BUSY_B1: 1;
     unsigned int TIMEOUT_B1: 1;
     unsigned int BAUD_UPDATE_B1: 1;
     unsigned int TOAWUS_B1: 1;
     unsigned int TOA3WUS_B1: 1;
     unsigned int TXRDY_B1: 1;
     unsigned int RXRDY_B1: 1;
     unsigned int TXWAKE_B1: 1;
     unsigned int TX_EMPTY_B1: 1;
     unsigned int RXWAKE_B1: 1;
     unsigned int ID_TX_B1: 1;
     unsigned int ID_RX_B1: 1;
     unsigned int INC_BR_B1: 1;
     unsigned int : 8;
     unsigned int PE_B1: 1;
     unsigned int OE_B1: 1;
     unsigned int FE_B1: 1;
     unsigned int NRE_B1: 1;
     unsigned int ISFE_B1: 1;
     unsigned int CE_B1: 1;
     unsigned int PBE_B1: 1;
     unsigned int BE_B1: 1;
     }SCIFLR_ST;
    }SCIFLR_UN;

    union                                      /* 0x20      */
    {
     unsigned int SCIINTVECT0_UL;
     struct
     {
     unsigned int INTVECT0_B5: 5;
     unsigned int : 27;
     }SCIINTVECT0_ST;
    }SCIINTVECT0_UN;

    union                                      /* 0x24      */
    {
     unsigned int SCIINTVECT1_UL;
     struct
     {
     unsigned int INTVECT1_B5: 5;
     unsigned int : 27;
     }SCIINTVECT1_ST;
    }SCIINTVECT1_UN;

    union                                      /* 0x28      */
    {
     unsigned int SCIFORMAT_UL; 
     struct
     {
     unsigned int CHAR_B3 : 3;
     unsigned int : 13;
     unsigned int LENGTH_B3 : 3;
     unsigned int : 13;
     }SCIFORMAT_ST;
    }SCIFORMAT_UN;

    union                                      /* 0x2C      */
    {
     unsigned int SCIBRSR_UL;
     struct
     {
     unsigned int P_B24: 24;
     unsigned int M_B4: 4;
     unsigned int U_B3: 3;
     unsigned int : 1;
     }SCIBRSR_ST;
    }SCIBRSR_UN;

    union                                      /* 0x30     */
    {
     unsigned int SCIED_UL;
     struct
     {
     unsigned char ED_UC;
     unsigned int : 24;
     }SCIED_ST;
    }SCIED_UN;

    union                                      /* 0x34      */
    {
     unsigned int SCIRD_UL;
     struct
     {
     unsigned char RD_UC;
     unsigned int : 24;
     }SCIRD_ST;
    }SCIRD_UN;

    union                                      /* 0x38      */
    {
     unsigned int SCITD_UL;
     struct
     {
     unsigned char TD_UC;
     unsigned int : 24;
     }SCITD_ST;
    }SCITD_UN;

    union                                      /* 0x3C     */
    {
     unsigned int SCIPIO0_UL;
     struct
     {
     unsigned int CLKFUNC_B1: 1;
     unsigned int RXFUNC_B1: 1;
     unsigned int TXFUNC_B1: 1;
     unsigned int : 29;
     }SCIPIO0_ST;
    }SCIPIO0_UN;

    union                                      /* 0x40      */
    {
     unsigned int SCIPIO1_UL;
     struct
     {
     unsigned int CLKDIR_B1: 1;
     unsigned int RXDIR_B1: 1;
     unsigned int TXDIR_B1: 1;
     unsigned int : 29;
     }SCIPIO1_ST;
    }SCIPIO1_UN;

    union                                      /* 0x44      */
    {
     unsigned int SCIPIO2_UL;
     struct
     {
     unsigned int CLKIN_B1: 1;
     unsigned int RXIN_B1: 1;
     unsigned int TXIN_B1: 1;
     unsigned int : 29;
     }SCIPIO2_ST;
    }SCIPIO2_UN;

    union                                      /* 0x48      */
    {
     unsigned int SCIPIO3_UL;
     struct
     {
     unsigned int CLKOUT_B1: 1;
     unsigned int RXOUT_B1: 1;
     unsigned int TXOUT_B1: 1;
     unsigned int : 29;
     }SCIPIO3_ST;
    }SCIPIO3_UN;

    union                                      /* 0x4C      */
    {
     unsigned int SCIPIO4_UL;
     struct
     {
     unsigned int CLKSET_B1: 1;
     unsigned int RXSET_B1: 1;
     unsigned int TXSET_B1: 1;
     unsigned int : 29;
     }SCIPIO4_ST;
    }SCIPIO4_UN;

    union                                      /* 0x50      */
    {
     unsigned int SCIPIO5_UL;
     struct
     {
     unsigned int CLKCLR_B1: 1;
     unsigned int RXCLR_B1: 1;
     unsigned int TXCLR_B1: 1;
     unsigned int : 29;
     }SCIPIO5_ST;
    }SCIPIO5_UN;

    union                                      /* 0x54      */
    {
     unsigned int SCIPIO6_UL;
     struct
     {
     unsigned int CLKPDR_B1: 1;
     unsigned int RXPDR_B1: 1;
     unsigned int TXPDR_B1: 1;
     unsigned int : 29;
     }SCIPIO6_ST;
    }SCIPIO6_UN;

    union                                      /* 0x58      */
    {
     unsigned int SCIPIO7_UL;
     struct
     {
     unsigned int CLKPE_B1: 1;
     unsigned int RXPE_B1: 1;
     unsigned int TXPE_B1: 1;
     unsigned int : 29;
     }SCIPIO7_ST;
    }SCIPIO7_UN;

    union                                      /* 0x5C      */
    {
     unsigned int SCIPIO8_UL;
     struct
     {
     unsigned int CLKPSL_B1: 1;
     unsigned int RXPSL_B1: 1;
     unsigned int TXPSL_B1: 1;
     unsigned int : 29;
     }SCIPIO8_ST;
    }SCIPIO8_UN;

    union                                      /* 0x60      */
    {
     unsigned int LINCOMPARE_UL;
     struct
     {
     unsigned int SBREAK_B3: 3;
     unsigned int : 5;
     unsigned int SDEL_B2: 2;
     unsigned int : 22;
     }LINCOMPARE_ST;
    }LINCOMPARE_UN;

    union                                      /* 0x64      */
    {
     unsigned int LINRD0_UL;
     struct
     {
     unsigned char RD3_UC;
     unsigned char RD2_UC;
     unsigned char RD1_UC;
     unsigned char RD0_UC;
     }LINRD0_ST;
    }LINRD0_UN;

    union                                      /* 0x68      */
    {
     unsigned int LINRD1_UL;
     struct
     {
     unsigned char RD7_UC;
     unsigned char RD6_UC;
     unsigned char RD5_UC;
     unsigned char RD4_UC;
     }LINRD1_ST;
    }LINRD1_UN;

    union                                      /* 0x6C      */
    {
     unsigned int LINMASK_UL;
     struct
     {
     unsigned char TXIDMASK_UC;
     unsigned int : 8;
     unsigned char RXIDMASK_UC;
     unsigned int : 8;
     }LINMASK_ST;
    }LINMASK_UN;

    union                                      /* 0x70      */
    {
     unsigned int LINID_UL;
     struct
     {
     unsigned char IDBYTE_UC;
     unsigned char ID_Slave_BYTE_UC;
     unsigned char Received_ID;
     unsigned int : 8;
     }LINID_ST;
    }LINID_UN;
    
    union                                      /* 0x74      */
    {
     unsigned int LINTD0_UL;
     struct
     {
     unsigned char TD3_UC;
     unsigned char TD2_UC;
     unsigned char TD1_UC;
     unsigned char TD0_UC;
     }LINTD0_ST;
    }LINTD0_UN;

    union                                      /* 0x78      */
    {
     unsigned int LINTD1_UL;
     struct
     {
     unsigned char TD7_UC;
     unsigned char TD6_UC;
     unsigned char TD5_UC;
     unsigned char TD4_UC;
     }LINTD1_ST;
    }LINTD1_UN;

     union                                      /* 0x7C      */
    {
    	unsigned int MBRSR_UL;
    	struct
    	{
    	    unsigned int MBR : 13;
	    unsigned int : 19;
     	}MBRSR_ST;
    }MBRSR_UN;  
    
     union                                      /* 0x80      */
    {
     unsigned int SCIPIO9_UL;
     struct
     {
     unsigned int CLKSL_B1: 1;
     unsigned int RXSL_B1: 1;
     unsigned int TXSL_B1: 1;
     unsigned int : 29;
     }SCIPIO9_ST;
    }SCIPIO9_UN;
    
    unsigned int : 32;                        /* 0x84      */
   
    unsigned int : 32; 						  /* 0x88      */
    
    unsigned int : 32; 						  /* 0x8C		*/
    
    union                                      /* 0x90      */
    {
     unsigned int IODFT_UL;
     struct
     {
     unsigned int RXPENA_B1: 1;
     unsigned int LPBENA_B1: 1;
     unsigned int : 6;
     unsigned int IODFTENA_B4: 4;
     unsigned int : 4;
     unsigned int TX_SHIFT_B3: 3;
     unsigned int PIN_SAMPLE_MASK_B2: 2;
     unsigned int : 3;
     unsigned int BRKDTEN_B1: 1;
     unsigned int PEN_B1: 1;
     unsigned int FEN_B1: 1;
     unsigned int : 1;
     unsigned int ISFEN_B1: 1;
     unsigned int CEN_B1: 1;
     unsigned int PBEN_B1: 1;
     unsigned int BEN_B1: 1;
      }IODFT_ST;
    }IODFT_UN;

} LIN_ST;

/* ------------------------------------------------------------------------- */
/* e_LINn_ST                                                                 */
/*      pointers to the LIN/SCI registers, this is defined in the linker     */
/*      command file.                                                        */

extern LIN_ST e_LIN0_ST, e_LIN1_ST, e_LIN2_ST, e_LIN3_ST;
extern LIN_ST* LIN_Ptr;
extern LIN_ST* LIN1_Ptr;
extern LIN_ST* LIN2_Ptr;
extern LIN_ST* LIN3_Ptr;


#endif


/* ------------------------------------------------------------------------- */
/* e_LIN_n_ST                                                                 */
/*      pointers to the SPI registers, this is defined in the linker command */
/*      file.                                                                */

extern LIN_ST e_LIN1_ST, e_LIN2_ST, e_LIN3_ST, e_LIN4_ST;

#define LIN1 (&e_LIN1_ST)
#define LIN2 (&e_LIN2_ST)
#define LIN3 (&e_LIN3_ST)
#define LIN4 (&e_LIN4_ST)

/* ------------------------------------------------------------------------- */


void LIN_Reset(LIN_ST *ptr);

unsigned int LIN_Init(	LIN_ST *ptr,
						unsigned int LIN_GCR1_uL,
						unsigned int LIN_INT0_uL, 
						unsigned int FrameSize,
						unsigned int CharSize,
						unsigned int BaudRate);

void LIN_Setup(	LIN_ST *ptr,
						unsigned char RxMask,
						unsigned char TxMask, 
						unsigned char LINID);
/* ------------------------------------------------------------------------- */

typedef unsigned LIN_MODE;
    
#define LIN_TwoStopBits 0x00000010  //LIN_GCR1
#define LIN_OneStopBit  0x00000000
#define LIN_EvenParity  0x0000000C
#define LIN_OddParity   0x00000004
#define LIN_Async       0x00000002
#define LIN_IsoSync     0x00000000
#define LIN_AddrBit     0x00000001
#define LIN_IdleLine    0x00000000
#define LIN_RxEN        0x01000000
#define LIN_TxEN        0x02000000
#define LIN_Continue    0x00020000
#define LIN_LoopBack    0x00010000
#define LIN_IntClock    0x00000020
#define LIN_ExtClock    0x00000000

#define LIN_LINMode     0x00000040
#define LIN_Adapt       0x00000200
#define LIN_MbufMode    0x00000400
#define LIN_CType       0x00000800



#define LIN_RxDmaEN     0x00020000  //LIN_SETINT
#define LIN_RxDmaAll    0x00040000
#define LIN_TxDmaEN     0x00010000
#define LIN_TxIntEN     0x00000100
#define LIN_RxIntEN     0x00000200
#define LIN_SetIDInt    0x00002000


typedef unsigned LIN_PORT;

#define LIN_ClkPinEN 0x00000001
#define LIN_ClkOut   0x00000010
#define LIN_ClkHigh  0x00000100
#define LIN_ClkLow   0x00000000
#define LIN_ClkSet   0x00001000
#define LIN_ClkClr   0x00010000
#define LIN_ClkPdr   0x00100000
#define LIN_ClkPe    0x01000000

#define LIN_RxPinEN  0x00000002
#define LIN_RxOut    0x00000020
#define LIN_RxHigh   0x00000200
#define LIN_RxLow    0x00000000
#define LIN_RxSet    0x00002000
#define LIN_RxClr    0x00020000
#define LIN_RxPdr    0x00200000
#define LIN_RxPe     0x02000000

#define LIN_TxPinEN  0x00000004
#define LIN_TxOut    0x00000040
#define LIN_TxHigh   0x00000400
#define LIN_TxLow    0x00000000
#define LIN_TxSet    0x00004000
#define LIN_TxClr    0x00040000
#define LIN_TxPdr    0x00400000
#define LIN_TxPe     0x04000000

typedef unsigned LIN_DMAPRI;

#define LIN_DmaHigh  0x00
#define LIN_DmaLow   0x08

typedef enum
{
    LIN_ClkPin,
    LIN_RxPin,
    LIN_TxPin
} LIN_PINID;

typedef enum
{
    LIN_Functional,
    LIN_IoIn,
    LIN_IoOut,
    LIN_IoOutHigh,
    LIN_IoOutLow
} LIN_QUAL;

typedef enum
{
    LIN_NoError,
    LIN_Pending,
    LIN_Overrun,
    LIN_Parity,
    LIN_Frame,
    LIN_Break,
    LIN_BusBusy,
    LIN_Timeout,
    LIN_DmaError,
    LIN_ModeError
} LIN_EXPT;

