/*******************************************************************************************/
/* file:SCI63.c                                                                            */
/*                                                                                         */
/*      SCI test routine #63 SCI DMA DATA TRANSFER TEST             				       */
/*                                                                                         */
/*      Purposes   : Test the SCI data transfer using DMA                                  */
/*      Conditions : PowerOnReset must be applied prior to run test                        */
/*                                                                                         */
/*      Settings   : Connect the SCI TX to RX line                                         */
/*                   To check for Asynch or Isosynch comment the SCIGCR1 initialization    */
/*                   RX_INT_ENA - 1,RX_DMA_ENA - 1, RX_DMA_ALL - 1                         */
/*                                                                                         */
/*      Results    : 0  return code, test passes                                           */
/*                 : -1 return code, test fails                                            */
/*                                                                                         */
/*******************************************************************************************/

#include <stdio.h>
#include "lin.h"
//#include "vim.h"
#include "dma.h"

#include "sci_test.h"


#ifdef	DEVICE_MODEL
	#include "device.h"
#else
    #include "dma_req.h"
#endif


#ifdef CORTEX_M3
#pragma INTERRUPT (LIN1_ISR)
#else
#pragma INTERRUPT (LIN1_ISR,IRQ)
#endif


#ifdef CORTEX_R4
  #pragma CODE_STATE (LIN1_ISR,32)
#endif

#ifdef ARM7
  #pragma CODE_STATE (LIN1_ISR,32)
#endif




unsigned char LIN1_TxData[100];
unsigned char LIN1_RxData[100];
unsigned int LIN1_TestFlag = 0; 
unsigned int LIN1_BlockSize =36;
unsigned int LIN1_Started = 0;

void LIN1_TestInit()
{
	register unsigned int i;
	register unsigned char *src_address;
	register unsigned char *dst_address;

#ifdef	DEVICE_MODEL
	register LIN_ST *lin_ptr = (LIN_ST *)LIN1;
#else	
	register LIN_ST *lin_ptr = &e_LIN1_ST;
#endif

    LIN1_TestFlag = 0; 
   
    LIN1_BlockSize++;
    if(LIN1_BlockSize > 100) LIN1_BlockSize = 16;

    dst_address = LIN1_RxData;
 
	for(i=0;i<100 /* LIN1_BlockSize */;i++)
	{
 		*dst_address++ = 0xff;
	}

    if (LIN1_Started == 0)
	{
// 		LIN1_Started  = 1;
 		src_address = LIN1_TxData;
 
 		for(i=0;i<100;i++) 
 		{
 			*src_address++ = (unsigned char)i;
 		}
    

		LIN_Reset(lin_ptr);
		LIN_Init(	lin_ptr,
 				LIN_TxEN | LIN_RxEN | LIN_LoopBack | LIN_Continue | LIN_IntClock |LIN_Async,
 				LIN_RxDmaEN | LIN_RxDmaAll | LIN_TxDmaEN ,  
 				0,
 				8, 
 			    115200 );			
 					
 		DMA_REQConfig(LIN1_RX_DMA_CH,LIN1_RX_DMA_REQ);                         /* DMA ch 3: DMA Request line 8 - SCI RX */
		DMA_REQConfig(LIN1_TX_DMA_CH,LIN1_TX_DMA_REQ);							/* DMA ch 2: DMA Request line 9 - SCI TX */
///////////////////////////////////////////////////////////
 //       Enable DMA Interrupts for Channel 2             //
 ///////////////////////////////////////////////////////////
		DMA_IntEnable(LIN1_RX_DMA_CH,DMA_BTC);
 	}
 			
 //////////////////////////////////
 // DMA Initialization ////////////
 //////////////////////////////////

 
	DMA_CPConfig(	LIN1_TX_DMA_CH, 						/* channel number */
              		(unsigned int)&LIN1_TxData[1], 	/* SRCADDR  */
					(unsigned int)&(lin_ptr->SCITD_UN.SCITD_ST.TD_UC), 				/* DSTADDR  */
					LIN1_BlockSize - 1,					/* FRM_CNT  */
					1,						/* ELM_CNT  */
					ACCESS_8_BIT,			/* RD_SIZE  */
					ACCESS_8_BIT, 			/* WR_SIZE  */
					FRAME_TRANSFER,			/* TRANSFER_TYPE */
					ADDR_INC1,				/* RD_ADDR_MODE  */
					ADDR_FIXED,				/* WR_ADDR_MODE  */
					AUTOINIT_OFF,			/* AUTOINIT */
					0,						/* ELM_DST_OFFST */
					0,						/* ELM_SRC_OFFST */
					0,						/* FRM_DST_OFFST */
					0,						/* FRM_SRC_OFFST */
					PORTB					/* PORT     */
				);					/* For SCI TX */
   
	DMA_CPConfig(   LIN1_RX_DMA_CH,                      /* channel number */
					(unsigned int)&(lin_ptr->SCIRD_UN.SCIRD_ST.RD_UC),					/* SRCADDR */
					(unsigned int)&LIN1_RxData[0],		/* DSTADDR */
					LIN1_BlockSize,					/* FRM_CNT */
					1,						/* ELM_CNT */
					ACCESS_8_BIT,			/* RD_SIZE */
					ACCESS_8_BIT,			/* WR_SIZE */
					FRAME_TRANSFER,			/* TRANSFER_TYPE */
					ADDR_FIXED,				/* RD_ADDR_MODE  */
					ADDR_INC1,				/* WR_ADDR_MODE  */
					AUTOINIT_OFF,			/* AUTOINIT      */
					0,						/* ELM_DST_OFFST */
					0,						/* ELM_SRC_OFFST */
					0,						/* FRM_DST_OFFST */
					0,						/* FRM_SRC_OFFST */
					PORTB 					/* PORT    */
					);					/* For SCI RX */
				
 /* Enabling DMA Channel 2 and 3 */ 
 
	DMA_ChannelEnable(LIN1_TX_DMA_CH,DMA_HW);
	DMA_ChannelEnable(LIN1_RX_DMA_CH,DMA_HW);
	
	lin_ptr->SCITD_UN.SCITD_ST.TD_UC = LIN1_TxData[0];    //manually send the first data
	LIN1_Started++;
	
}

unsigned int LIN1_TestVerify()
{
	register unsigned int i, error;
	register unsigned char *dst_address;
	
    error = 0;
	dst_address = LIN1_RxData;
 
	for(i=0;i<LIN1_BlockSize;i++)
	{ 
 		if(*dst_address++ != i)
 		{
 			error = 1;
 		}
 	}
	return error;
}


void  LIN1_ISR()
{
}

void  LIN1_RXDMA_ISR()
{
 	LIN1_TestFlag = 1;
}  

